/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.parttime.web.batch;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hdm.business.domain.parttime.PerChgBizUtils;
import kd.hr.hdm.business.domain.parttime.repository.ParttimeBatchRepository;
import kd.hr.hdm.business.domain.service.hssc.IHSSCService;
import kd.hr.hdm.business.repository.ParttimeApplyRepository;
import kd.hr.hpfs.common.perchg.PerChgBizOperateType;

public class BatchParttimeTerminateConfirmEdit
extends HRCoreBaseBillEdit
implements ClickListener {
    private static final String BTNOK = "btnok";
    private static final Set<String> INPROCESS_BILLSTATUS = Arrays.stream(new String[]{"B", "G", "D"}).collect(Collectors.toSet());
    private static final Log LOGGER = LogFactory.getLog(BatchParttimeTerminateConfirmEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button button = (Button)evt.getSource();
        if (BTNOK.equals(button.getKey())) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object pkvalue = formShowParameter.getCustomParam("id");
            this.validateAndTerminateParttime(pkvalue);
        }
    }

    private void validateAndTerminateParttime(Object pkvalue) {
        DynamicObject parttimeBill = ParttimeBatchRepository.getInstance().queryOne("id, billno,billstatus, auditstatus, modifytime, termuser, termdate, termreason, entryentity, entryentity.parttimestatus", pkvalue);
        QFilter qFilter = new QFilter("mid", "=", (Object)parttimeBill.getLong("id"));
        DynamicObject[] entryBills = ParttimeApplyRepository.getInstance().query("id, billno, parttimestatus, auditstatus, billstatus, affaction,person,primaryemployee,primarycmpemp,primarydepemp,effectdate,modifytime", qFilter.toArray(), null);
        switch (parttimeBill.getString("billstatus")) {
            case "A": {
                this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\uff0c\u65e0\u9700\u7ec8\u6b62\u6d41\u7a0b\u3002", (String)"BatchParttimeTerminateEdit_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "E": {
                this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5ba1\u6279\u4e0d\u901a\u8fc7\u201d\uff0c\u4e0d\u53ef\u7ec8\u6b62\u6d41\u7a0b\u3002", (String)"BatchParttimeTerminateEdit_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "F": {
                this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u5e9f\u5f03\u201d\uff0c\u4e0d\u53ef\u7ec8\u6b62\u6d41\u7a0b\u3002", (String)"BatchParttimeTerminateEdit_3", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "B": 
            case "D": 
            case "G": {
                this.terminateParttime(parttimeBill, entryBills);
                break;
            }
            case "C": {
                DynamicObjectCollection dynamicObjectCollection = parttimeBill.getDynamicObjectCollection("entryentity");
                boolean flag = true;
                for (DynamicObject dy : dynamicObjectCollection) {
                    String parttimestatus = dy.getString("parttimestatus");
                    if (!"0".equals(parttimestatus)) continue;
                    this.terminateParttime(parttimeBill, entryBills);
                    flag = false;
                    break;
                }
                if (!flag) break;
                this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5ba1\u6279\u901a\u8fc7\u201d\uff0c\u4e14\u517c\u804c\u4eba\u5458\u7684\u517c\u804c\u6d41\u7a0b\u72b6\u6001\u5747\u4e3a\u201c\u5df2\u517c\u804c\u201d\u6216\u201c\u517c\u804c\u6d41\u7a0b\u7ec8\u6b62\u201d\uff0c\u4e0d\u53ef\u7ec8\u6b62\u6d41\u7a0b\u3002", (String)"BatchParttimeTerminateEdit_5", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
        this.getView().sendFormAction(this.getView().getParentView());
        this.getView().close();
    }

    private void terminateParttime(DynamicObject parttimeBill, DynamicObject[] entryBills) {
        this.discardWorkFlow(parttimeBill);
        Date date = new Date();
        if (!"C".equals(parttimeBill.getString("billstatus"))) {
            parttimeBill.set("billstatus", (Object)"F");
        }
        parttimeBill.set("auditstatus", (Object)"F");
        parttimeBill.set("modifytime", (Object)date);
        parttimeBill.set("termreason", this.getModel().getValue("termreason"));
        parttimeBill.set("termuser", (Object)RequestContext.get().getCurrUserId());
        parttimeBill.set("termdate", (Object)date);
        for (DynamicObject entryBill : entryBills) {
            entryBill.set("modifytime", (Object)date);
            if (!"C".equals(entryBill.getString("billstatus"))) {
                entryBill.set("billstatus", (Object)"F");
            }
            if (!"C".equals(entryBill.getString("auditstatus"))) {
                entryBill.set("auditstatus", (Object)"F");
            } else if (!"1".equals(entryBill.getString("parttimestatus"))) {
                entryBill.set("auditstatus", (Object)"F");
            }
            if (!"0".equals(entryBill.getString("parttimestatus"))) continue;
            entryBill.set("parttimestatus", (Object)"-1");
        }
        try (TXHandle required = TX.required();){
            try {
                ParttimeApplyRepository.getInstance().update(parttimeBill);
                ParttimeApplyRepository.getInstance().update(entryBills);
                PerChgBizUtils.personChangeRecord((DynamicObject[])entryBills, (PerChgBizOperateType)PerChgBizOperateType.CHGOPERATION_DISCARDSCHEDULE);
            }
            catch (Exception ex) {
                required.markRollback();
                LOGGER.error("batch parttime termanate exception:", (Throwable)ex);
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u6d41\u7a0b\u5931\u8d25\u3002", (String)"BatchParttimeTerminateEdit_6", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            }
        }
        this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u6d41\u7a0b\u6210\u529f\u3002", (String)"BatchParttimeTerminateEdit_4", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
    }

    private void discardWorkFlow(DynamicObject partTimeBill) {
        String billId;
        Long instanceId;
        String billStatus = partTimeBill.getString("billstatus");
        if (INPROCESS_BILLSTATUS.contains(billStatus) && !Objects.isNull(instanceId = WorkflowServiceHelper.getProcessInstanceIdByBusinessKey((String)(billId = partTimeBill.get("id").toString()))) && !instanceId.equals(0L)) {
            try (TXHandle txHandle = TX.notSupported();){
                LOGGER.info("PartBill terminate work flow , instanceid : [{}]", (Object)instanceId);
                IHSSCService.getInstance().terminateSSCTask(partTimeBill);
                WorkflowServiceHelper.abandon((Long)instanceId);
            }
            catch (Exception exception) {
                LOGGER.error("batchparttime terminate exception:", (Throwable)exception);
            }
        }
    }
}

