/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.common;

import java.util.HashMap;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.reg.validator.RegCommonValidatorHelper;
import kd.hr.hdm.business.repository.RegKeyEventRepository;
import kd.hr.hdm.common.reg.constants.ProbationKeyEventConstants;

public class ProbationKeyEventService {
    private static final ProbationKeyEventService instance = new ProbationKeyEventService();
    private static final String BAR_ADDKEYEVENT = "bar_addkeyevent";
    private static final String FLEX_APPRANNOTHING = "flexappranothing";
    private static final String FLEX_ADDPANELAP = "clickaddflex";
    private static final String PROBATION_VIEW_FLEX_ADDPANELAP = "flexpanelap";
    private static final String LABEL_NOTHING = "nothinglab";
    private static final String PROBATION_VIEW_LABEL_NOTHING = "labelap6";
    private static final String FORMID_CARDVIEW = "hdm_cardviewtpl";
    private static final String KEYEVENT_PAGEID = "keyevent_pageid";

    public static ProbationKeyEventService getInstance() {
        return instance;
    }

    public void loadKeyEventPanel(IFormView parentView, String targetKey, Map<String, Object> paramMap) {
        long employeeId = (Long)paramMap.get("employee");
        String importSource = String.valueOf(paramMap.get("importsource"));
        QFilter qFilter = new QFilter("bemployee", "=", (Object)employeeId);
        if ("2".equals(importSource)) {
            qFilter.and(new QFilter("importsource", "=", (Object)importSource));
        }
        String regStatus = String.valueOf(paramMap.get("regstatus"));
        boolean exists = RegKeyEventRepository.getInstance().isExists(new QFilter[]{qFilter});
        if (!exists) {
            parentView.setVisible(Boolean.FALSE, new String[]{BAR_ADDKEYEVENT});
            parentView.setVisible(Boolean.TRUE, new String[]{FLEX_APPRANNOTHING});
            this.noRecordStyleSetVisibleForHr(parentView, importSource, regStatus);
            this.noRecordStyleSetVisibleForEmployee(parentView, importSource);
            String keyEventPageId = parentView.getPageCache().get(KEYEVENT_PAGEID);
            if (HRStringUtils.isNotEmpty((String)keyEventPageId)) {
                parentView.getPageCache().remove(KEYEVENT_PAGEID);
                ListShowParameter listShowParameter = this.buildListShowParameter(targetKey, paramMap, qFilter);
                parentView.showForm((FormShowParameter)listShowParameter);
            }
        } else {
            parentView.setVisible(Boolean.FALSE, new String[]{FLEX_APPRANNOTHING});
            this.styleSetVisibleForHr(parentView, importSource, regStatus);
            this.styleSetVisibleForEmployee(parentView, importSource);
            ListShowParameter listShowParameter = this.buildListShowParameter(targetKey, paramMap, qFilter);
            listShowParameter.setHasRight(true);
            parentView.showForm((FormShowParameter)listShowParameter);
            parentView.getView(listShowParameter.getPageId());
            parentView.getPageCache().put(KEYEVENT_PAGEID, listShowParameter.getPageId());
        }
    }

    private ListShowParameter buildListShowParameter(String targetKey, Map<String, Object> paramMap, QFilter qFilter) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.getOpenStyle().setTargetKey(targetKey);
        listShowParameter.setFormId(FORMID_CARDVIEW);
        listShowParameter.setBillFormId("hdm_regevent");
        listShowParameter.setCustomParams(paramMap);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(qFilter);
        listShowParameter.setListFilterParameter(listFilterParameter);
        listShowParameter.setMultiSelect(false);
        return listShowParameter;
    }

    private void noRecordStyleSetVisibleForHr(IFormView parentView, String importSource, String regStatus) {
        if ("1".equals(importSource)) {
            if (HRStringUtils.equals((String)"1010", (String)regStatus)) {
                parentView.setVisible(Boolean.TRUE, new String[]{PROBATION_VIEW_FLEX_ADDPANELAP});
                parentView.setVisible(Boolean.FALSE, new String[]{PROBATION_VIEW_LABEL_NOTHING});
            } else {
                parentView.setVisible(Boolean.FALSE, new String[]{PROBATION_VIEW_FLEX_ADDPANELAP});
                parentView.setVisible(Boolean.TRUE, new String[]{PROBATION_VIEW_LABEL_NOTHING});
            }
        }
    }

    private void noRecordStyleSetVisibleForEmployee(IFormView parentView, String importSource) {
        if ("2".equals(importSource)) {
            OperationStatus status = parentView.getFormShowParameter().getStatus();
            if (OperationStatus.VIEW.equals((Object)status)) {
                parentView.setVisible(Boolean.FALSE, new String[]{FLEX_ADDPANELAP});
                parentView.setVisible(Boolean.TRUE, new String[]{LABEL_NOTHING});
            } else {
                parentView.setVisible(Boolean.TRUE, new String[]{FLEX_ADDPANELAP});
                parentView.setVisible(Boolean.FALSE, new String[]{LABEL_NOTHING});
            }
        }
    }

    private void styleSetVisibleForHr(IFormView parentView, String importSource, String regStatus) {
        if ("1".equals(importSource)) {
            if (HRStringUtils.equals((String)"1010", (String)regStatus)) {
                parentView.setVisible(Boolean.TRUE, new String[]{BAR_ADDKEYEVENT});
            } else {
                parentView.setVisible(Boolean.FALSE, new String[]{BAR_ADDKEYEVENT});
            }
        }
    }

    private void styleSetVisibleForEmployee(IFormView parentView, String importSource) {
        if ("2".equals(importSource)) {
            OperationStatus status = parentView.getFormShowParameter().getStatus();
            if (OperationStatus.VIEW.equals((Object)status)) {
                parentView.setVisible(Boolean.FALSE, new String[]{BAR_ADDKEYEVENT});
            } else {
                parentView.setVisible(Boolean.TRUE, new String[]{BAR_ADDKEYEVENT});
            }
        }
    }

    private void openKeyEvent(AbstractFormPlugin plugin, IFormView parentView, FormShowParameter billShowParameter, Map<String, Object> paramMap, String callBackId) {
        billShowParameter.setFormId("hdm_regevent");
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (billShowParameter instanceof MobileBillShowParameter) {
            billShowParameter.setFormId("hdm_regevent_mob");
            billShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        }
        billShowParameter.setCustomParams(paramMap);
        billShowParameter.setPermissionItemId("47156aff000000ac");
        billShowParameter.setStatus(OperationStatus.ADDNEW);
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, callBackId));
        parentView.showForm(billShowParameter);
    }

    public void openKeyEventByWeb(AbstractFormPlugin plugin, IFormView parentView, Map<String, Object> paramMap, String callBackId) {
        boolean pass;
        String importSource = String.valueOf(paramMap.get("importsource"));
        if ("1".equals(importSource) && !(pass = this.validateByHr(parentView, (Long)paramMap.get("employee")))) {
            return;
        }
        this.openKeyEvent(plugin, parentView, (FormShowParameter)new BaseShowParameter(), paramMap, callBackId);
    }

    public void openKeyEventByMob(AbstractFormPlugin plugin, IFormView parentView, Map<String, Object> paramMap, String callBackId) {
        this.openKeyEvent(plugin, parentView, (FormShowParameter)new MobileBillShowParameter(), paramMap, callBackId);
    }

    public void showFormKeyEventListByMob(IFormView parentView, DynamicObject regBill) {
        MobileListShowParameter listShowParameter = new MobileListShowParameter();
        listShowParameter.setBillFormId("hdm_regevent");
        listShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        QFilter qFilter = new QFilter("bemployee", "=", (Object)regBill.getLong("bemployee.id"));
        qFilter.and(new QFilter("importsource", "=", (Object)"2"));
        listFilterParameter.setFilter(qFilter);
        listShowParameter.setListFilterParameter(listFilterParameter);
        Map<String, Object> paramMap = this.buildParamMap(parentView, regBill);
        listShowParameter.setCustomParams(paramMap);
        parentView.showForm((FormShowParameter)listShowParameter);
    }

    public boolean validateByHr(IFormView parentView, long employeeId) {
        Map validate = RegCommonValidatorHelper.getInstance().validateKeyEvent(Long.valueOf(employeeId));
        boolean pass = Boolean.parseBoolean((String)validate.get("validateResult"));
        if (!pass) {
            String msg = (String)validate.get("msg");
            parentView.showErrorNotification(msg);
            return false;
        }
        return true;
    }

    public Map<String, Object> buildParamMap(IFormView view, DynamicObject regBill) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        BillShowParameter formShowParameter = (BillShowParameter)view.getFormShowParameter();
        BillOperationStatus status = formShowParameter.getBillStatus();
        if (BillOperationStatus.VIEW.equals((Object)status)) {
            paramMap.put("isvisible", ProbationKeyEventConstants.INVISIBLE);
        } else {
            paramMap.put("isvisible", ProbationKeyEventConstants.VISIBLE);
        }
        paramMap.put("employee", regBill.getLong("bemployee.id"));
        paramMap.put("person", regBill.getLong("person.id"));
        paramMap.put("entrydate", regBill.getDate("entrydate"));
        paramMap.put("importsource", "2");
        return paramMap;
    }
}

