/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.mobile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hdm.common.reg.enums.RegFeedbackTabEnum;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class RegAskDetailsMobPlugin
extends AbstractMobBillPlugIn {
    public static final String ASK_LIST_EXISTS = "askListExists";

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "askdown": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"askpanel", "askup"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"askdown"});
                String askListExists = this.getPageCache().get(ASK_LIST_EXISTS);
                if (!"0".equals(askListExists)) break;
                this.getView().setVisible(Boolean.FALSE, new String[]{"askpanel"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexaskfilenodata"});
                break;
            }
            case "askup": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"askpanel", "askup", "flexaskfilenodata"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"askdown"});
                break;
            }
            case "askenter": {
                this.showMobAskDetail("ask_billlistap_all");
                break;
            }
            case "askenter_had": {
                this.showMobAskDetail("ask_billlistap");
                break;
            }
        }
    }

    private void showMobAskDetail(String ctlKey) {
        Long detailsId = this.getDetailsId(ctlKey);
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setFormId("hdm_askdetail_layout");
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("detailsId", (Object)detailsId);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private Long getDetailsId(String ctlKey) {
        BillList billList = (BillList)this.getView().getControl(ctlKey);
        Object focusRowPkId = billList.getFocusRowPkId();
        if (ObjectUtils.isNotEmpty((Object)focusRowPkId)) {
            return (Long)focusRowPkId;
        }
        throw new KDBizException("can not find focusRowPkId,please contact the administrator");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Vector askDown = (Vector)this.getControl("askdown");
        Vector askUp = (Vector)this.getControl("askup");
        Vector askEnter = (Vector)this.getControl("askenter");
        Vector askEnterHad = (Vector)this.getControl("askenter_had");
        askDown.addClickListener((ClickListener)this);
        askUp.addClickListener((ClickListener)this);
        askEnter.addClickListener((ClickListener)this);
        askEnterHad.addClickListener((ClickListener)this);
    }

    private void registerAskList(Long employeeId) {
        QFilter employeeFilter = new QFilter("bemployee", "=", (Object)employeeId);
        for (RegFeedbackTabEnum feedbackTabEnum : RegFeedbackTabEnum.values()) {
            this.initTabData(employeeFilter, feedbackTabEnum);
        }
    }

    private void initTabData(QFilter employeeFilter, RegFeedbackTabEnum feedbackTabEnum) {
        BillList askBillList = (BillList)this.getView().getControl(feedbackTabEnum.getAskNumber());
        ArrayList<String> list = new ArrayList<String>();
        list.add("1");
        list.add("0");
        askBillList.addSetFilterListener(setFilterEvent -> {
            QFilter isNew = new QFilter("isnewest", "=", (Object)Boolean.TRUE);
            setFilterEvent.getQFilters().add(employeeFilter);
            setFilterEvent.getQFilters().add(isNew);
            if (feedbackTabEnum.getAskNumber().equals("ask_billlistap_no")) {
                QFilter opinionFilter = new QFilter("opinion", "not in", (Object)list);
                setFilterEvent.getQFilters().add(opinionFilter);
            } else if (feedbackTabEnum.getAskNumber().equals("ask_billlistap")) {
                QFilter opinionFilter = new QFilter("opinion", "in", (Object)list);
                setFilterEvent.getQFilters().add(opinionFilter);
            }
        });
        askBillList.addListRowClickListener(new ListRowClickListener(){

            public void listRowClick(ListRowClickEvent evt) {
                super.listRowClick(evt);
                RegAskDetailsMobPlugin.this.getView().getPageCache().put("CURRENT_SELECT_ROW_ID", evt.getCurrentListSelectedRow().getPrimaryKeyValue().toString());
            }
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setTabName();
    }

    private void setTabName() {
        TabPage allFeedbackTab = (TabPage)this.getView().getControl("tab_allfeedback");
        LocaleString allName = new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8", (String)"RegAskDetailsMobPlugin_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        BillList billlistapAll = (BillList)this.getView().getControl("ask_billlistap_all");
        int allDataCount = billlistapAll.getListModel().getDataCount();
        if (allDataCount <= 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"defaultpanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"ask_billlistap_all"});
        }
        allFeedbackTab.setText(this.getTabPageName(allName, allDataCount));
        TabPage noFeedbackTab = (TabPage)this.getView().getControl("tab_nofeedback");
        LocaleString noName = new LocaleString(ResManager.loadKDString((String)"\u672a\u53cd\u9988", (String)"RegAskDetailsMobPlugin_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        BillList billlistapNo = (BillList)this.getView().getControl("ask_billlistap_no");
        int noDataCount = billlistapNo.getListModel().getDataCount();
        noFeedbackTab.setText(this.getTabPageName(noName, noDataCount));
        if (noDataCount <= 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"defaultpanel1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"ask_billlistap_no"});
        }
        TabPage feedbackTab = (TabPage)this.getView().getControl("tab_feedback");
        LocaleString name = new LocaleString(ResManager.loadKDString((String)"\u5df2\u53cd\u9988", (String)"RegAskDetailsMobPlugin_3", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        BillList billlistap = (BillList)this.getView().getControl("ask_billlistap");
        int dataCount = billlistap.getListModel().getDataCount();
        if (dataCount <= 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"defaultpanel2"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"ask_billlistap"});
        }
        feedbackTab.setText(this.getTabPageName(name, dataCount));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setDefaultControl();
        this.showAskList();
        this.showAskResult();
    }

    private void setDefaultControl() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"defaultpanel", "defaultpanel1", "defaultpanel2"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"askpanel", "askup", "flexaskfilenodata", "lbaskresult0", "lbaskresult1"});
    }

    private LocaleString getTabPageName(LocaleString name, int count) {
        return new LocaleString(String.format("%s(%s)", name, count));
    }

    private void showAskResult() {
        HRBaseServiceHelper resultHelper = new HRBaseServiceHelper("hdm_regaskresult");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long employeeId = (Long)customParams.get("employee");
        QFilter employeeFilter = new QFilter("bemployee", "=", (Object)employeeId);
        DynamicObject[] results = resultHelper.loadDynamicObjectArray(new QFilter[]{employeeFilter});
        if (results.length > 0) {
            DynamicObject dynamicObject = Arrays.stream(results).findFirst().get();
            String result = dynamicObject.getString("askresult");
            if (StringUtils.isNotBlank((String)result) && "1".equals(result)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"lbaskresult1"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"lbaskresult0"});
            } else if (StringUtils.isNotBlank((String)result) && "0".equals(result)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"lbaskresult0"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"lbaskresult1"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"lbaskresult0", "lbaskresult1"});
            }
        }
    }

    private void showAskList() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long employeeId = (Long)customParams.get("employee");
        HRBaseServiceHelper detailHelper = new HRBaseServiceHelper("hdm_regaskdetails");
        QFilter employeeFilter = new QFilter("bemployee", "=", (Object)employeeId);
        QFilter isNew = new QFilter("isnewest", "=", (Object)Boolean.TRUE);
        boolean askList = detailHelper.isExists(new QFilter[]{employeeFilter, isNew});
        if (askList) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexaskfilenodata"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexaskfile", "advcontoolbarap"});
            this.registerAskList(employeeId);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"askpanel", "lbaskresult0", "lbaskresult1"});
            this.getPageCache().put(ASK_LIST_EXISTS, "0");
        }
    }
}

