/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.mobile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.LabelAp;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegInitService;
import kd.hr.hdm.common.reg.enums.RegBillServiceEnum;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.hdm.common.reg.util.RegDirectUtil;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;
import kd.hr.hdm.formplugin.reg.mobile.RegBaseBillMobUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class RegBaseBillMobPlugin
extends AbstractMobBillPlugIn
implements UploadListener {
    private static final String KEY_EFFECTDATE = "effectdate";
    private static final String KEY_WORKSUM = "worksum";
    private static final String PANEL_VIEW = "viewpanel";
    private static final String PANEL_NEW = "editpanel";

    public void createNewData(BizDataEventArgs e) {
        BillEntityType type = (BillEntityType)this.getModel().getDataEntityType();
        DynamicObject newData = (DynamicObject)type.createInstance();
        e.setDataEntity((Object)newData);
        DynamicObject ermanFile = IRegInitService.getInstance().getErmanFileBySysId();
        IRegInitService.getInstance().initDynamicObjectByErmanFile(newData, ermanFile);
        newData.set("ismobile", (Object)Boolean.TRUE);
        DynamicObject employeeObject = newData.getDynamicObject("bemployee");
        this.getView().getFormShowParameter().getCustomParams().put("person", employeeObject.getLong("person.id"));
        this.getView().getFormShowParameter().getCustomParams().put("employee", employeeObject.getLong("id"));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label lblDown = (Label)this.getControl("lbl_down");
        Vector vectorapDown = (Vector)this.getControl("vectorap_down");
        Label lblUp = (Label)this.getControl("lbl_up");
        Vector vectorapUp = (Vector)this.getControl("vectorap_up");
        Container panelDown = (Container)this.getControl("paneldown");
        Container panelUp = (Container)this.getControl("panelup");
        Container workSumPanel = (Container)this.getControl("worksumpanel");
        Container worksumpanelap = (Container)this.getControl("worksumpanelap");
        lblDown.addClickListener((ClickListener)this);
        vectorapDown.addClickListener((ClickListener)this);
        lblUp.addClickListener((ClickListener)this);
        vectorapUp.addClickListener((ClickListener)this);
        panelDown.addClickListener((ClickListener)this);
        panelUp.addClickListener((ClickListener)this);
        workSumPanel.addClickListener((ClickListener)this);
        worksumpanelap.addClickListener((ClickListener)this);
    }

    public void afterLoadData(EventObject e) {
        e.getSource();
        Object probation = this.getModel().getValue("probation");
        String periodUnit = (String)this.getModel().getValue("probationunit");
        String periodUnitName = RegDirectUtil.getProbationUnit((String)periodUnit);
        this.getModel().setValue("probationtext", (Object)(probation + periodUnitName));
    }

    public void afterCreateNewData(EventObject e) {
        e.getSource();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Label statusLab = (Label)this.getControl("status");
        String auditStatus = (String)this.getModel().getValue("billstatus");
        statusLab.setText(RegBillStatusEnum.getName((String)auditStatus));
        Label title = (Label)this.getControl("title");
        DynamicObject person = (DynamicObject)this.getModel().getValue("person");
        title.setText(ResManager.loadKDString((String)"%s\u7684\u8f6c\u6b63\u7533\u8bf7\u5355", (String)"RegBaseBillMobPlugin_1", (String)"hr-hdm-formplugin", (Object[])new Object[]{person.getString("name")}));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        MobileBillShowParameter formShowParameter = (MobileBillShowParameter)this.getView().getFormShowParameter();
        BillOperationStatus status = formShowParameter.getBillStatus();
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (StringUtils.equals((String)billStatus, (String)RegBillStatusEnum.TEMPSTORAGE.getCode())) {
            if (BillOperationStatus.EDIT.equals((Object)status)) {
                this.switchViewAndEditStatus(false);
            } else if (BillOperationStatus.ADDNEW.equals((Object)status)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_VIEW, "bar_edit", "bar_delete"});
            } else if (BillOperationStatus.VIEW.equals((Object)status)) {
                this.switchViewAndEditStatus(true);
            }
        } else {
            this.setAttachmentPanel();
            this.getView().setVisible(Boolean.FALSE, new String[]{"worksumflexpanel", "worksumpanelap", "attachmentpanel", "panelup"});
        }
        this.buildViewAttachment();
        this.setAuditStatusLabelWithColorful(billStatus);
        this.setControlOfWaitRepeatSubmit();
    }

    private void setControlOfWaitRepeatSubmit() {
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!StringUtils.equals((String)billStatus, (String)RegBillStatusEnum.WAITRESUBMIT.getCode())) {
            return;
        }
        this.changeMetaBillStatusFromMessageCenter();
        MobileBillShowParameter formShowParameter = (MobileBillShowParameter)this.getView().getFormShowParameter();
        BillOperationStatus status = formShowParameter.getBillStatus();
        if (StringUtils.equals((String)billStatus, (String)RegBillStatusEnum.WAITRESUBMIT.getCode())) {
            if (BillOperationStatus.VIEW.equals((Object)status)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "regtitle", PANEL_NEW, "attachment"});
            }
            if (BillOperationStatus.EDIT.equals((Object)status)) {
                this.switchViewAndEditStatus(false);
            }
        }
    }

    private void changeMetaBillStatusFromMessageCenter() {
        boolean auditView = TransferCommonUtil.isAuditView((IFormView)this.getView());
        if (auditView) {
            String billStatus = this.getModel().getDataEntity().getString("billstatus");
            String formId = this.getView().getFormShowParameter().getFormId();
            if (RegBillStatusEnum.WAITRESUBMIT.getCode().equals(billStatus) && "hdm_regselfhelpbill_mob".equals(formId)) {
                MobileBillShowParameter formShowParameter = (MobileBillShowParameter)this.getView().getFormShowParameter();
                formShowParameter.setBillStatus(BillOperationStatus.VIEW);
            }
        }
    }

    private void setAuditStatusLabelWithColorful(String labelValue) {
        LabelAp statusLabel = new LabelAp();
        statusLabel.setKey("status");
        statusLabel.setName(new LocaleString(RegBillStatusEnum.getName((String)labelValue)));
        Style style = new Style();
        Border border = new Border();
        String borderColor = "";
        style.setBorder(border);
        switch (labelValue) {
            case "A": 
            case "F": {
                statusLabel.setForeColor("#666666");
                statusLabel.setBackColor("#F5F5F5");
                borderColor = "#CCCCCC";
                break;
            }
            case "G": {
                statusLabel.setForeColor("#276FF5");
                statusLabel.setBackColor("#F2F9FF");
                borderColor = "#85B8FF";
                break;
            }
            case "B": {
                statusLabel.setForeColor("#1BA854");
                statusLabel.setBackColor("#F2FFF5");
                borderColor = "#6DD18E";
                break;
            }
            case "D": {
                statusLabel.setForeColor("#276FF5");
                statusLabel.setBackColor("#F2F9FF");
                borderColor = "#85B8FF";
                break;
            }
            case "C": {
                statusLabel.setForeColor("#1BA854");
                statusLabel.setBackColor("#F2FFF5");
                borderColor = "#6DD18E";
                break;
            }
            case "E": {
                statusLabel.setForeColor("#FB2323");
                statusLabel.setBackColor("#FFF2F4");
                borderColor = "#FF8088";
                break;
            }
        }
        String borderType = "1px_solid_" + borderColor;
        border.setTop(borderType);
        border.setBottom(borderType);
        border.setLeft(borderType);
        border.setRight(borderType);
        style.setBorder(border);
        Padding padding = new Padding();
        padding.setTop("2px");
        padding.setBottom("2px");
        padding.setLeft("14px");
        padding.setRight("14px");
        style.setPadding(padding);
        statusLabel.setRadius("2px");
        statusLabel.setStyle(style);
        this.getView().updateControlMetadata(statusLabel.getKey(), statusLabel.createControl());
    }

    private void buildViewAttachment() {
        AttachmentPanel attachment = (AttachmentPanel)this.getView().getControl("attachment");
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        attachmentPanel.bindData(attachment.getAttachmentData());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "lbl_down": 
            case "vectorap_down": 
            case "paneldown": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"paneldown"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"worksumpanelap", "attachmentpanel", "panelup"});
                break;
            }
            case "lbl_up": 
            case "vectorap_up": 
            case "panelup": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"panelup", "worksumpanelap", "attachmentpanel"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"paneldown"});
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        switch (e.getProperty().getName()) {
            case "effectdate": {
                HashMap errorMap = new HashMap();
                errorMap.put(RegBillServiceEnum.ERROR.getCode(), new ArrayList());
                IRegBillService.getInstance().doValidateEffectDateAfterEntryDate(this.getModel().getDataEntity(), errorMap, RegBillServiceEnum.ERROR);
                List errors = (List)errorMap.get(RegBillServiceEnum.ERROR.getCode());
                if (!CollectionUtils.isNotEmpty((Collection)errors)) break;
                this.getView().showErrorNotification((String)errors.get(0));
                break;
            }
            case "worksum": {
                this.getView().getModel().setDataChanged(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        OperationResult operationResult = e.getOperationResult();
        if (!Objects.isNull(operationResult) && operationResult.isSuccess()) {
            switch (e.getOperateKey()) {
                case "save_mobile": {
                    operationResult.setShowMessage(false);
                    this.getView().showMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"RegBaseBillMobPlugin_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]), "", MessageTypes.ImageWithText_m);
                    Label statusLab = (Label)this.getControl("status");
                    String auditStatus = (String)this.getModel().getValue("billstatus");
                    statusLab.setText(RegBillStatusEnum.getName((String)auditStatus));
                    this.switchViewAndEditStatus(true);
                    this.buildViewAttachment();
                    break;
                }
                case "modify": {
                    this.switchViewAndEditStatus(false);
                    break;
                }
                case "selfsubmit": {
                    this.showSubmitSuccess();
                    this.getView().invokeOperation("refresh");
                    break;
                }
                case "delete": {
                    MobileFormShowParameter showParameter = new MobileFormShowParameter();
                    showParameter.setFormId("hrobs_mob_portalhome");
                    showParameter.getOpenStyle().setShowType(ShowType.Floating);
                    this.getView().showForm((FormShowParameter)showParameter);
                    break;
                }
            }
        }
    }

    private void switchViewAndEditStatus(boolean isView) {
        this.setAttachmentPanel();
        this.getView().setVisible(Boolean.valueOf(isView), new String[]{PANEL_VIEW, "bar_edit", "bar_delete", "approvalap"});
        this.getView().setVisible(Boolean.valueOf(!isView), new String[]{"bar_save", PANEL_NEW, "worksumflexpanel", "regtitle", "attachment"});
    }

    private void showSubmitSuccess() {
        RegBaseBillMobUtils regBaseBillMobUtils = RegBaseBillMobUtils.getInstance();
        regBaseBillMobUtils.showPage("hdm_self_submited", (AbstractFormPlugin)this, null);
    }

    private void setAttachmentPanel() {
        AttachmentPanel attachment = (AttachmentPanel)this.getView().getControl("attachment");
        List attachmentData = attachment.getAttachmentData();
        if (attachmentData != null && attachmentData.size() > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"defaultattachment"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"attachmentpanelap"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"defaultattachment"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"attachmentpanelap"});
        this.setAttachmentDefaultImage();
    }

    private void setAttachmentDefaultImage() {
        Image image = (Image)this.getView().getControl("attachmentdefaultimage");
        if (image == null) {
            return;
        }
        image.setUrl("/images/mobile/emotion/hr_wsjcard_112_64.png");
        Label defaultData = (Label)this.getControl("noattachment");
        defaultData.setText(ResManager.loadKDString((String)"\u6682\u65e0\u9644\u4ef6", (String)"RegBaseBillMobPlugin_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
    }
}

