/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.mobile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hdm.common.reg.enums.RegFeedbackTabEnum;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class RegExamDetailsMobPlugin
extends AbstractMobBillPlugIn {
    public static final String EXAMSCORE = "examscore";
    public static final String EXAM_LIST_EXISTS = "examListExists";
    public static final String TEMPLATE = "template";
    public static final String CALCULATETYPE = "calculatetype";

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "examdown": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"exampanel", "examup", "flexexaminfo"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"examdown"});
                String examListExists = this.getPageCache().get(EXAM_LIST_EXISTS);
                if (!"0".equals(examListExists)) break;
                this.getView().setVisible(Boolean.FALSE, new String[]{"exampanel", "flexexaminfo"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexexamfilenodata"});
                break;
            }
            case "examup": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"exampanel", "examup", "flexexamfilenodata", "flexexaminfo"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"examdown"});
                break;
            }
            case "examenter": {
                this.showMobExamDetail("exam_billlistap_all");
                break;
            }
            case "examenter_had": {
                this.showMobExamDetail("exam_billlistap");
                break;
            }
        }
    }

    private void showMobExamDetail(String ctlKey) {
        Long detailsId = this.getDetailsId(ctlKey);
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setFormId("hdm_mob_regexam");
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("detailsId", (Object)detailsId);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private Long getDetailsId(String ctlKey) {
        BillList billList = (BillList)this.getView().getControl(ctlKey);
        Object focusRowPkId = billList.getFocusRowPkId();
        if (ObjectUtils.isNotEmpty((Object)focusRowPkId)) {
            return (Long)focusRowPkId;
        }
        throw new KDBizException("can not find focusRowPkId,please contact the administrator");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Vector examDown = (Vector)this.getControl("examdown");
        Vector examUp = (Vector)this.getControl("examup");
        Vector examEnter = (Vector)this.getControl("examenter");
        Vector examEnterHad = (Vector)this.getControl("examenter_had");
        examDown.addClickListener((ClickListener)this);
        examUp.addClickListener((ClickListener)this);
        examEnter.addClickListener((ClickListener)this);
        examEnterHad.addClickListener((ClickListener)this);
    }

    private void registerExamList(Long employeeId) {
        QFilter employeeFilter = new QFilter("bemployee", "=", (Object)employeeId);
        for (RegFeedbackTabEnum feedbackTabEnum : RegFeedbackTabEnum.values()) {
            this.initTabData(employeeFilter, feedbackTabEnum);
        }
    }

    private void initTabData(QFilter employeeFilter, RegFeedbackTabEnum feedbackTabEnum) {
        BillList examBillList = (BillList)this.getView().getControl(feedbackTabEnum.getExamNumber());
        ArrayList<String> list = new ArrayList<String>();
        list.add("1");
        list.add("0");
        examBillList.addSetFilterListener(setFilterEvent -> {
            QFilter isNew = new QFilter("isnewest", "=", (Object)Boolean.TRUE);
            setFilterEvent.getQFilters().add(employeeFilter);
            setFilterEvent.getQFilters().add(isNew);
            if (feedbackTabEnum.getExamNumber().equals("exam_billlistap_no")) {
                QFilter opinionFilter = new QFilter("opinion", "not in", (Object)list);
                setFilterEvent.getQFilters().add(opinionFilter);
            } else if (feedbackTabEnum.getExamNumber().equals("exam_billlistap")) {
                QFilter opinionFilter = new QFilter("opinion", "in", (Object)list);
                setFilterEvent.getQFilters().add(opinionFilter);
            }
        });
        examBillList.addListRowClickListener(new ListRowClickListener(){

            public void listRowClick(ListRowClickEvent evt) {
                super.listRowClick(evt);
                RegExamDetailsMobPlugin.this.getView().getPageCache().put("CURRENT_SELECT_ROW_ID", evt.getCurrentListSelectedRow().getPrimaryKeyValue().toString());
            }
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setTabName();
    }

    private void setTabName() {
        TabPage allFeedbackTab = (TabPage)this.getView().getControl("tab_allfeedback");
        LocaleString allName = new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8", (String)"RegExamDetailsMobPlugin_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        BillList billlistapAll = (BillList)this.getView().getControl("exam_billlistap_all");
        int allDataCount = billlistapAll.getListModel().getDataCount();
        if (allDataCount <= 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"defaultpanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"exam_billlistap_all"});
        }
        allFeedbackTab.setText(this.getTabPageName(allName, allDataCount));
        TabPage noFeedbackTab = (TabPage)this.getView().getControl("tab_nofeedback");
        LocaleString noName = new LocaleString(ResManager.loadKDString((String)"\u672a\u53cd\u9988", (String)"RegExamDetailsMobPlugin_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        BillList billlistapNo = (BillList)this.getView().getControl("exam_billlistap_no");
        int noDataCount = billlistapNo.getListModel().getDataCount();
        noFeedbackTab.setText(this.getTabPageName(noName, noDataCount));
        if (noDataCount <= 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"defaultpanel1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"exam_billlistap_no"});
        }
        TabPage feedbackTab = (TabPage)this.getView().getControl("tab_feedback");
        LocaleString name = new LocaleString(ResManager.loadKDString((String)"\u5df2\u53cd\u9988", (String)"RegExamDetailsMobPlugin_3", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        BillList billlistap = (BillList)this.getView().getControl("exam_billlistap");
        int dataCount = billlistap.getListModel().getDataCount();
        if (dataCount <= 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"defaultpanel2"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"exam_billlistap"});
        }
        feedbackTab.setText(this.getTabPageName(name, dataCount));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setDefaultControl();
        this.showExamList();
        this.showExamResult();
    }

    private void setDefaultControl() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"defaultpanel", "defaultpanel1", "defaultpanel2"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"exampanel", "examup", "flexexamfilenodata", "flexexaminfo", "lbexamresult0", "lbexamresult1"});
    }

    private LocaleString getTabPageName(LocaleString name, int count) {
        return new LocaleString(String.format("%s(%s)", name, count));
    }

    private void showExamResult() {
        HRBaseServiceHelper resultHelper = new HRBaseServiceHelper("hdm_regexamresult");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long employeeId = (Long)customParams.get("employee");
        QFilter employeeFilter = new QFilter("bemployee", "=", (Object)employeeId);
        DynamicObject[] results = resultHelper.loadDynamicObjectArray(new QFilter[]{employeeFilter});
        if (results.length > 0) {
            DynamicObject dynamicObject = Arrays.stream(results).findFirst().get();
            String result = dynamicObject.getString("examresult");
            this.getModel().setValue(TEMPLATE, dynamicObject.get(TEMPLATE));
            this.getModel().setValue(CALCULATETYPE, dynamicObject.get(CALCULATETYPE));
            this.getModel().setValue(EXAMSCORE, dynamicObject.get(EXAMSCORE));
            if (StringUtils.isNotBlank((String)result) && "1".equals(result)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"lbexamresult0"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"lbexamresult1"});
            } else if (StringUtils.isNotBlank((String)result) && "0".equals(result)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"lbexamresult1"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"lbexamresult0"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"lbexamresult0", "lbexamresult1"});
            }
        }
    }

    private void showExamList() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long employeeId = (Long)customParams.get("employee");
        HRBaseServiceHelper detailHelper = new HRBaseServiceHelper("hdm_regexamdetails");
        QFilter employeeFilter = new QFilter("bemployee", "=", (Object)employeeId);
        QFilter isNew = new QFilter("isnewest", "=", (Object)Boolean.TRUE);
        boolean examList = detailHelper.isExists(new QFilter[]{employeeFilter, isNew});
        if (examList) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexexamfilenodata", "flexexaminfo"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexexamfile", "advcontoolbarap"});
            this.registerExamList(employeeId);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"exampanel", "flexexaminfo", "lbexamresult0", "lbexamresult1"});
            this.getPageCache().put(EXAM_LIST_EXISTS, "0");
        }
    }
}

