/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.mobile;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hdm.business.personnelchange.servicehelper.PersonnelChangeServiceHelper;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegProbationService;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.hdm.common.reg.enums.RegCategoryEnum;
import kd.hr.hdm.common.reg.enums.RegCommentEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.formplugin.reg.mobile.RegAuditMobPlugin;
import kd.hr.hdm.formplugin.reg.web.applybill.RegularBaseUtils;

public class RegSelfAuditMobPlugin
extends RegAuditMobPlugin
implements BeforeF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label lblDown = (Label)this.getControl("lbl_down");
        Vector vectorapDown = (Vector)this.getControl("vectorap_down");
        Label lblUp = (Label)this.getControl("lbl_up");
        Vector vectorapUp = (Vector)this.getControl("vectorap_up");
        Container panelDown = (Container)this.getControl("paneldown");
        Container panelUp = (Container)this.getControl("panelup");
        lblDown.addClickListener((ClickListener)this);
        vectorapDown.addClickListener((ClickListener)this);
        lblUp.addClickListener((ClickListener)this);
        vectorapUp.addClickListener((ClickListener)this);
        panelDown.addClickListener((ClickListener)this);
        panelUp.addClickListener((ClickListener)this);
        BasedataEdit regCateGory = (BasedataEdit)this.getView().getControl("regcategory");
        if (regCateGory != null) {
            regCateGory.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterLoadData(EventObject e) {
        IRegBillService.getInstance().setLaborrelStatusByRegComment(this.getModel().getDataEntity());
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "lbl_down": 
            case "vectorap_down": 
            case "paneldown": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"paneldown"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"worksumpanelap", "attachmentpanellap", "panelup"});
                break;
            }
            case "lbl_up": 
            case "vectorap_up": 
            case "panelup": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"panelup", "worksumpanelap", "attachmentpanellap"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"paneldown"});
                break;
            }
        }
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setDefaultControl();
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setHrAttachment();
        this.setPostponeInfoByRegCategory();
        this.showAskPage();
        this.showExamPage();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("regcomment".equals(e.getProperty().getName())) {
            DynamicObject regComment = this.getModel().getDataEntity().getDynamicObject("regcomment");
            if (regComment == null || regComment.getLong("id") == 1020L) {
                this.getModel().setValue("laborrelstatus", null);
            } else if (regComment.getLong("id") == 1010L) {
                DynamicObject affaction = this.getModel().getDataEntity().getDynamicObject("affaction");
                if (affaction == null) {
                    return;
                }
                List laborrelStatusList = PersonnelChangeServiceHelper.getLaborrelstatusDyByAffaction((DynamicObject)affaction);
                if (HRCollUtil.isNotEmpty((Collection)laborrelStatusList)) {
                    this.getModel().setValue("laborrelstatus", laborrelStatusList.get(0));
                }
            }
        }
    }

    private void showExamPage() {
        DynamicObject employeeOjb;
        Long employeeId;
        DynamicObject personOjb = (DynamicObject)this.getView().getModel().getValue("person");
        Long personId = null == personOjb ? null : Long.valueOf(personOjb.getLong("id"));
        IFormView view = RegularBaseUtils.showPageNoAuth((AbstractFormPlugin)this, "panelexam", "hdm_examresult_layout_m", personId, employeeId = null == (employeeOjb = (DynamicObject)this.getView().getModel().getValue("bemployee")) ? null : Long.valueOf(employeeOjb.getLong("id")));
        if (view != null) {
            this.getView().sendFormAction(view);
        }
    }

    private void showAskPage() {
        DynamicObject employeeOjb;
        Long employeeId;
        DynamicObject personOjb = (DynamicObject)this.getView().getModel().getValue("person");
        Long personId = null == personOjb ? null : Long.valueOf(personOjb.getLong("id"));
        IFormView view = RegularBaseUtils.showPageNoAuth((AbstractFormPlugin)this, "panelask", "hdm_askdetails_layout_m", personId, employeeId = null == (employeeOjb = (DynamicObject)this.getView().getModel().getValue("bemployee")) ? null : Long.valueOf(employeeOjb.getLong("id")));
        if (view != null) {
            this.getView().sendFormAction(view);
        }
    }

    private void setPostponeInfoByRegCategory() {
        DateEdit effectDate = (DateEdit)this.getView().getControl("effectdate");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long regCommentId = dataEntity.getLong("regcomment.id");
        if (RegCommentEnum.AGREE.getId().equals(regCommentId)) {
            effectDate.setMustInput(true);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"effectdate"});
            effectDate.setMustInput(false);
        }
        DecimalEdit postponeProbation = (DecimalEdit)this.getView().getControl("postponeprobation");
        long regCategoryId = dataEntity.getLong("regcategory.id");
        if (RegCategoryEnum.POSTPHONE.getId().equals(regCategoryId)) {
            postponeProbation.setMustInput(true);
            this.getView().setEnable(Boolean.FALSE, new String[]{"postponeprobationunit"});
        } else {
            postponeProbation.setMustInput(false);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (result != null && result.isSuccess()) {
            switch (afterDoOperationEventArgs.getOperateKey()) {
                case "viewworksum": {
                    this.showWorkSum(OperationStatus.VIEW);
                    break;
                }
            }
        }
    }

    private void showWorkSum(OperationStatus status) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("hdm_regworksum_edit");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCustomParam("message", this.getModel().getValue("worksum"));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hdm_regworksum_edit"));
        parameter.setStatus(status);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void setDefaultControl() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"worksumpanelap", "attachmentpanellap", "panelup"});
        this.setAttachmentPanel();
        boolean canEdit = this.isCanEdit();
        this.setRegInfoPanel(canEdit);
        this.setPostponeProbationPanel(canEdit);
    }

    private boolean isCanEdit() {
        boolean fieldModified = IRegProbationService.getInstance().fieldModifiedOfWorkFlow(this.getView());
        return fieldModified;
    }

    private void setPostponeProbationPanel(boolean canEdit) {
        if (canEdit) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"postponeinfoview"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"postponeinfopanel"});
        }
    }

    private void setHrAttachment() {
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if (RegBillStatusEnum.ALREADYSUBMIT.getCode().equals(billStatus) || RegBillStatusEnum.WAITRESUBMIT.getCode().equals(billStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"hrattachmentpanelap"});
        } else {
            AttachmentPanel attachment = (AttachmentPanel)this.getView().getControl("attachmentpanel");
            List attachmentData = attachment.getAttachmentData();
            if (ObjectUtils.isEmpty((Collection)attachmentData)) {
                return;
            }
            AttachmentPanel hrAttachment = (AttachmentPanel)this.getView().getControl("hrattachment");
            hrAttachment.bindData(attachmentData);
        }
    }

    private void setRegInfoPanel(boolean canEdit) {
        if (canEdit) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"reginfoview"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"reginfopanel", "affactionpanel", "hrattachmentpanellab"});
        }
    }

    private void setAttachmentPanel() {
        AttachmentPanel attachment = (AttachmentPanel)this.getView().getControl("attachment");
        List attachmentData = attachment.getAttachmentData();
        if (attachmentData != null && attachmentData.size() > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"defaultattachment"});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"attachment"});
        this.setAttachmentDefaultImage();
    }

    private void setAttachmentDefaultImage() {
        Image image = (Image)this.getView().getControl("attachmentdefaultimage");
        if (image == null) {
            return;
        }
        image.setUrl("/images/mobile/emotion/hr_wsjcard_112_64.png");
        Label defaultData = (Label)this.getControl("noattachment");
        defaultData.setText(ResManager.loadKDString((String)"\u6682\u65e0\u9644\u4ef6", (String)"RegSelfAuditMobPlugin_6", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name;
        switch (name = beforeF7SelectEvent.getProperty().getName()) {
            case "regcategory": {
                if (ObjectUtils.isEmpty((Object)this.getModel().getValue("regcomment"))) {
                    return;
                }
                Object regComment = ((DynamicObject)this.getModel().getValue("regcomment")).getPkValue();
                QFilter qFilter = new QFilter("group", "=", regComment);
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
        }
    }
}

