/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.mobile;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hdm.business.common.PermissionValidateUtil;
import kd.hr.hdm.business.reg.RegPeronalBillHelper;
import kd.hr.hdm.business.reg.domain.repository.bill.HDMRegBaseBillRepository;
import kd.hr.hdm.business.reg.domain.service.bill.IPersonAboutService;
import kd.hr.hdm.common.reg.constants.LabRelConstants;
import kd.hr.hdm.common.reg.constants.RegBillTypeEnum;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.hdm.common.reg.enums.RegBusinessStatusEnum;
import kd.hr.hdm.common.reg.enums.RegCategoryEnum;
import kd.hr.hdm.common.reg.enums.RegNewAuditStatusEnum;
import kd.hr.hdm.formplugin.reg.web.applybill.RegPageUtils;
import org.apache.commons.lang.StringUtils;

public class RegSelfHelpEntryPlugin
extends AbstractFormPlugin {
    private static final Log LOG = LogFactory.getLog(RegSelfHelpEntryPlugin.class);
    private static final String HSSC_APP_ID = "hssc";
    private static final String CHECK_RIGHT_APP_ID = "checkRightAppId";

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        MobileFormShowParameter parameter = (MobileFormShowParameter)args.getSource();
        parameter.setCaption(ResManager.loadKDString((String)"\u8f6c\u6b63\u7533\u8bf7", (String)"RegSelfHelpEntryPlugin_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        Map map = RegPeronalBillHelper.getInstance().queryHRPersonMap();
        Long personId = (Long)map.get("person");
        DynamicObject regBill = this.getRegBillByPersonId(personId);
        String permItemId = "47156aff000000ac";
        String errorMessage = ResManager.loadKDString((String)"\u65e0\u201c\u5458\u5de5\u8f6c\u6b63\u7533\u8bf7\u5355\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RegSelfHelpEntryPlugin_3", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
        if (regBill != null) {
            permItemId = "47150e89000000ac";
            errorMessage = ResManager.loadKDString((String)"\u65e0\u201c\u5458\u5de5\u8f6c\u6b63\u7533\u8bf7\u5355\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RegSelfHelpEntryPlugin_4", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
        }
        this.checkPermission(permItemId, errorMessage);
    }

    private void checkPermission(String permItemId, String errorMessage) {
        boolean isPermission = PermissionValidateUtil.checkPermission((String)HSSC_APP_ID, (String)"hdm_regselfhelpbill", (String)permItemId);
        if (!isPermission) {
            throw new KDBizException(errorMessage);
        }
    }

    private DynamicObject getRegBillByPersonId(Long personId) {
        DynamicObject ermanFile = null;
        try {
            ermanFile = (DynamicObject)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getPrimaryErmanfFile", (Object[])new Object[]{personId});
        }
        catch (Exception exception) {
            LOG.error("RegSelfHelpEntryPlugin.beforeBindData error: ", (Throwable)exception);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4eba\u5458\u6863\u6848\u4fe1\u606f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RegSelfHelpEntryPlugin_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
        QFilter employeeFilter = new QFilter("bemployee", "in", (Object)ermanFile.getLong("employee.id"));
        DynamicObject regBill = HDMRegBaseBillRepository.getInstance().queryOne("id,regbilltype,auditstatus,billstatus,regcategory_id,isviewflow", new QFilter[]{employeeFilter}, "createtime desc");
        if (regBill != null) {
            String billStatus = regBill.getString("billstatus");
            String auditStatus = regBill.getString("auditstatus");
            Long regCategory = (Long)regBill.get("regcategory_id");
            if (this.supportRemakeBill(billStatus, auditStatus) || this.delayRegAndApprovePassed(billStatus, regCategory)) {
                return null;
            }
        }
        return regBill;
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        Map map = RegPeronalBillHelper.getInstance().queryHRPersonMap();
        Long personId = (Long)map.get("person");
        DynamicObject ermanfile = null;
        try {
            ermanfile = (DynamicObject)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getPrimaryErmanfFile", (Object[])new Object[]{personId});
        }
        catch (Exception exception) {
            LOG.error("RegSelfHelpEntryPlugin.beforeBindData error: ", (Throwable)exception);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4eba\u5458\u6863\u6848\u4fe1\u606f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RegSelfHelpEntryPlugin_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
        long employeeId = ermanfile.getLong("employee_id");
        QFilter employeeFilter = new QFilter("bemployee", "in", (Object)employeeId);
        DynamicObject bill = HDMRegBaseBillRepository.getInstance().queryOne("id,regbilltype,auditstatus,billstatus,regcategory_id,isviewflow,regstatus", new QFilter[]{employeeFilter}, "createtime desc");
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put("person", personId);
        customParam.put("employee", employeeId);
        MobileBillShowParameter showParameter = new MobileBillShowParameter();
        showParameter.setFormId("hdm_regselfhelpbill_mob");
        showParameter.getOpenStyle().setTargetKey("content");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getCustomParams().putAll(customParam);
        showParameter.setCustomParam(CHECK_RIGHT_APP_ID, (Object)HSSC_APP_ID);
        if (!Objects.isNull(bill)) {
            String billType = bill.getString("regbilltype");
            String billStatus = bill.getString("billstatus");
            String auditStatus = bill.getString("auditstatus");
            Long regCategory = (Long)bill.get("regcategory_id");
            if (!this.supportRemakeBill(billStatus, auditStatus)) {
                if (this.delayRegAndApprovePassed(billStatus, regCategory)) {
                    this.getView().showForm((FormShowParameter)showParameter);
                    return;
                }
                boolean isViewFlow = bill.getBoolean("isviewflow");
                if (StringUtils.equals((String)RegBillTypeEnum.EMP.getStatus(), (String)billType) || !StringUtils.equals((String)RegBillTypeEnum.EMP.getStatus(), (String)billType) && isViewFlow) {
                    showParameter.setPkId(bill.get("id"));
                    showParameter.setBillStatus(BillOperationStatus.VIEW);
                    this.getView().showForm((FormShowParameter)showParameter);
                } else if (RegBusinessStatusEnum.ALREADY_REGED.getCode().equals(bill.getString("regstatus"))) {
                    this.switchToNewForm("hdm_regular_view", customParam);
                } else {
                    this.switchToNewForm("hdm_reging_view", customParam);
                }
                return;
            }
        }
        Long laborrelStatus = RegPeronalBillHelper.getInstance().queryLabRelStatusCls(Long.valueOf(employeeId));
        if (!RegPageUtils.haveLicence(personId, this.getView()) || this.executeForNoneProbation(laborrelStatus, customParam)) {
            return;
        }
        if (IPersonAboutService.getInstance().isExistQuiting(ermanfile)) {
            this.switchToNewForm("hdm_quiting_view", customParam);
            return;
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private boolean delayRegAndApprovePassed(String billStatus, Long regCategory) {
        return RegCategoryEnum.POSTPHONE.getId().equals(regCategory) && StringUtils.equals((String)RegBillStatusEnum.APPROVEPASSED.getCode(), (String)billStatus);
    }

    private boolean supportRemakeBill(String billStatus, String auditStatus) {
        return StringUtils.equals((String)RegBillStatusEnum.APPROVEREJECTED.getCode(), (String)billStatus) || StringUtils.equals((String)RegBillStatusEnum.ABANDONED.getCode(), (String)billStatus) || StringUtils.equals((String)RegBillStatusEnum.APPROVEPASSED.getCode(), (String)billStatus) && StringUtils.equals((String)RegNewAuditStatusEnum.ABANDONED.getCode(), (String)auditStatus);
    }

    private boolean executeForNoneProbation(Long laborrelStatus, Map<String, Object> customParam) {
        if (!LabRelConstants.PROBATION.equals(laborrelStatus)) {
            if (LabRelConstants.QUIT.equals(laborrelStatus)) {
                this.switchToNewForm("hdm_quit_view", customParam);
            } else {
                this.switchToNewForm("hdm_regular_view", customParam);
            }
            return true;
        }
        return false;
    }

    private void switchToNewForm(String formId, Map<String, Object> message) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getCustomParams().putAll(message);
        showParameter.getOpenStyle().setTargetKey("content");
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

