/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.mobile;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.control.HRLabelAp;
import kd.hr.hbp.common.control.HRVectorAp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.reg.RegExamServiceHelper;
import kd.hr.hdm.formplugin.reg.web.exam.RegExamCommon;

public class RegexamMobPlugin
extends AbstractMobBillPlugIn {
    private static final String VECTOR_CLOSE = "vector_close";
    private static final String VECTOR_ACKUP = "vector_ackup";
    private static final String VECTOR_ACKDOWN = "vector_ackdown";
    private static final String VECTOR_DETUP = "vector_detup";
    private static final String VECTOR_DETDOWN = "vector_detdown";
    private static final String LABEL_DEPRECATED = "label_deprecated";
    private static final String LABEL_SUGGEST = "label_suggest";
    private static final String LABEL_SCORE = "label_score";
    private static final String LABEL_ACKCONTENT = "label_ackcontent";
    private static final String FLEXPANEL_ACKCONT = "flexpanel_ackcont";
    private static final String FLEXPANEL_ACKCONTNONE = "flexpanel_ackcontnone";
    private static final String FLEXPANEL_DETCONT = "flexpanel_detcont";
    private static final Integer STAR_NUM = 5;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Vector close = (Vector)this.getControl(VECTOR_CLOSE);
        close.addClickListener((ClickListener)this);
        Vector ackup = (Vector)this.getControl(VECTOR_ACKUP);
        ackup.addClickListener((ClickListener)this);
        Vector ackdown = (Vector)this.getControl(VECTOR_ACKDOWN);
        ackdown.addClickListener((ClickListener)this);
        Vector detup = (Vector)this.getControl(VECTOR_DETUP);
        detup.addClickListener((ClickListener)this);
        Vector detdown = (Vector)this.getControl(VECTOR_DETDOWN);
        detdown.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "vector_close": {
                this.getView().close();
                break;
            }
            case "vector_ackup": {
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANEL_ACKCONT, VECTOR_ACKUP});
                this.getView().setVisible(Boolean.TRUE, new String[]{VECTOR_ACKDOWN});
                break;
            }
            case "vector_ackdown": {
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANEL_ACKCONT, VECTOR_ACKUP});
                this.getView().setVisible(Boolean.FALSE, new String[]{VECTOR_ACKDOWN});
                break;
            }
            case "vector_detup": {
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANEL_DETCONT, VECTOR_DETUP});
                this.getView().setVisible(Boolean.TRUE, new String[]{VECTOR_DETDOWN});
                break;
            }
            case "vector_detdown": {
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANEL_DETCONT, VECTOR_DETUP});
                this.getView().setVisible(Boolean.FALSE, new String[]{VECTOR_DETDOWN});
                break;
            }
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        MobileFormShowParameter formShowParameter = (MobileFormShowParameter)e.getSource();
        Long detailsId = (Long)formShowParameter.getCustomParam("detailsId");
        DynamicObject detailsObject = RegExamServiceHelper.DETAILS_SERVICE_HELPER.queryOne("entryentity.examtype,entryentity.examitem,entryentity.entryscore", (Object)detailsId);
        DynamicObjectCollection scoreObjects = detailsObject.getDynamicObjectCollection("entryentity");
        List<Map<String, Object>> examTypeList = RegExamCommon.parseEntryEntityData(scoreObjects);
        FlexPanelAp evaluatePanelAp = this.createDetcontentPanelAp(examTypeList);
        HashMap<String, String> paramsMap = new HashMap<String, String>(16);
        paramsMap.put("id", evaluatePanelAp.getKey());
        paramsMap.put("items", (String)evaluatePanelAp.createControl().get("items"));
        e.getItems().add(paramsMap);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        MobileFormShowParameter formShowParameter = (MobileFormShowParameter)this.getView().getFormShowParameter();
        Long detailsId = (Long)formShowParameter.getCustomParam("detailsId");
        DynamicObject detailsObject = RegExamServiceHelper.DETAILS_SERVICE_HELPER.queryOne("opinion,score,comment", (Object)detailsId);
        String opinion = detailsObject.getString("opinion");
        BigDecimal score = detailsObject.getBigDecimal("score");
        String comment = detailsObject.getString("comment");
        this.showEva(opinion, score);
        this.showAck(comment);
        this.showDet();
    }

    private FlexPanelAp createDetcontentPanelAp(List<Map<String, Object>> examTypeList) {
        FlexPanelAp detcontentAp = new FlexPanelAp();
        detcontentAp.setWrap(false);
        detcontentAp.setKey(FLEXPANEL_DETCONT);
        for (int i = 0; i < examTypeList.size(); ++i) {
            Map<String, Object> examTypeMap = examTypeList.get(i);
            FlexPanelAp detcontentItemAp = this.createDetcontentItemAp(FLEXPANEL_DETCONT + i, examTypeMap);
            detcontentAp.getItems().add(detcontentItemAp);
        }
        return detcontentAp;
    }

    private FlexPanelAp createDetcontentItemAp(String apKey, Map<String, Object> examTypeMap) {
        FlexPanelAp detcontentItemAp = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(apKey).setGrow(1).setShrink(0).setWrap(false).setDirection("column").setJustifyContent("flex-start").setAlignItems("stretch").setMarginBottom("16px")).build();
        List examItemList = (List)examTypeMap.get("examitemlist");
        FlexPanelAp detcontentItemNameAp = this.createDetcontentItemNameAp(apKey + "name", examTypeMap);
        detcontentItemAp.getItems().add(detcontentItemNameAp);
        FlexPanelAp detcontentItemContAp = this.createDetcontentItemContAp(apKey + "cont", examItemList);
        detcontentItemAp.getItems().add(detcontentItemContAp);
        return detcontentItemAp;
    }

    private FlexPanelAp createDetcontentItemNameAp(String apKey, Map<String, Object> examTypeMap) {
        FlexPanelAp detcontentItemNameAp = new HRFlexPanelAp.Builder(apKey).setGrow(1).setShrink(0).setWrap(false).setDirection("row").setJustifyContent("flex-start").setAlignItems("center").setFontSize(14).setHeight("20px").build();
        String examTypeName = String.valueOf(examTypeMap.get("examtypename"));
        LabelAp examTypeNameAp = ((HRLabelAp.Builder)new HRLabelAp.Builder(apKey + "lab").setGrow(0).setShrink(0).setName(examTypeName).setFontSize(14).setForeColor("#666666").setMarginLeft("12px")).build();
        detcontentItemNameAp.getItems().add(examTypeNameAp);
        return detcontentItemNameAp;
    }

    private FlexPanelAp createDetcontentItemContAp(String apKey, List<Map<String, Object>> examItemList) {
        FlexPanelAp detcontentItemContAp = ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(apKey).setGrow(0).setShrink(0).setWrap(false).setDirection("column").setJustifyContent("flex-start").setAlignItems("stretch").setRadius("4px").setMarginTop("8px")).setMarginLeft("12px")).setMarginRight("12px")).build();
        for (int j = 0; j < examItemList.size(); ++j) {
            Map<String, Object> examItemMap = examItemList.get(j);
            FlexPanelAp detcontentItemContdetAp = this.createDetcontentItemContdetAp(apKey + j, examItemMap);
            detcontentItemContAp.getItems().add(detcontentItemContdetAp);
        }
        return detcontentItemContAp;
    }

    private FlexPanelAp createDetcontentItemContdetAp(String apkey, Map<String, Object> examItemMap) {
        FlexPanelAp detcontentItemContdetAp = ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(apkey).setGrow(0).setShrink(0).setWrap(false).setDirection("row").setBackColor("#FAFAFA").setPaddingTop("6px")).setPaddingBottom("6px")).build();
        String examItemId = String.valueOf(examItemMap.get("examitemid"));
        String examItemName = String.valueOf(examItemMap.get("examitemname"));
        Integer score = (Integer)examItemMap.get("examscore");
        if (score == null) {
            score = 0;
        }
        FlexPanelAp itemPanelAp = this.createItemPanelAp(examItemId, examItemName);
        detcontentItemContdetAp.getItems().add(itemPanelAp);
        FlexPanelAp starListPanelAp = this.createStarListPanelAp(score, examItemId);
        detcontentItemContdetAp.getItems().add(starListPanelAp);
        String grade = RegExamCommon.getGradeText(score);
        FlexPanelAp gradePanelAp = this.createGradePanelAp(grade, examItemId);
        detcontentItemContdetAp.getItems().add(gradePanelAp);
        return detcontentItemContdetAp;
    }

    private FlexPanelAp createItemPanelAp(String itemId, String examItemName) {
        FlexPanelAp detcontentItemContdetNameAp = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("flexitem" + itemId).setGrow(0).setShrink(0).setWrap(false).setDirection("row").setWidth("48%").setFontSize(12).setMarginLeft("12px")).build();
        LabelAp itemNameLabelAp = new HRLabelAp.Builder("itemlabel" + itemId).setName(examItemName).setForeColor("#404040").setFontSize(14).setGrow(0).setShrink(1).setAutoTextWrap(true).build();
        detcontentItemContdetNameAp.getItems().add(itemNameLabelAp);
        return detcontentItemContdetNameAp;
    }

    private FlexPanelAp createStarListPanelAp(int score, String itemId) {
        FlexPanelAp starListPanelAp = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("flexstarlist" + itemId).setGrow(0).setShrink(0).setWrap(false).setDirection("row").setJustifyContent("flex-start").setAlignItems("center").setMarginRight("12px")).build();
        for (int j = 0; j < score; ++j) {
            VectorAp starVectorAp = this.customStarVectorAp("star" + itemId + j, "#FFA834");
            starListPanelAp.getItems().add(starVectorAp);
        }
        for (int k = score; k < STAR_NUM; ++k) {
            VectorAp greyStarVectorAp = this.customStarVectorAp("greystar" + itemId + k, "#E5E5E5");
            starListPanelAp.getItems().add(greyStarVectorAp);
        }
        return starListPanelAp;
    }

    private VectorAp customStarVectorAp(String apKey, String foreColor) {
        return new HRVectorAp.Builder(apKey).setFontSize(14).setForeColor(foreColor).setfontClass("kdfont kdfont-xingxing_shixin").setWidth(new LocaleString("20px")).setHeight(new LocaleString("20px")).setClickable(false).setNeedHoverClass(false).build();
    }

    private FlexPanelAp createGradePanelAp(String grade, String itemId) {
        FlexPanelAp gradePanelAp = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("flexgrade" + itemId).setGrow(0).setShrink(0).setWrap(false).setDirection("row").setJustifyContent("flex-end").setAlignItems("center").setMarginRight("12px")).build();
        LabelAp gradeLabelAp = new HRLabelAp.Builder("gradelabel" + itemId).setName(grade).setFontSize(12).setForeColor("#999999").setShrink(0).build();
        gradePanelAp.getItems().add(gradeLabelAp);
        return gradePanelAp;
    }

    private void showEva(String opinion, BigDecimal score) {
        if (!HRStringUtils.isEmpty((String)opinion)) {
            boolean isRegAgree = HRStringUtils.equals((String)opinion, (String)"1");
            if (isRegAgree) {
                this.getView().setVisible(Boolean.TRUE, new String[]{LABEL_SUGGEST});
                this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_DEPRECATED});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{LABEL_DEPRECATED});
                this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_SUGGEST});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_SUGGEST, LABEL_DEPRECATED});
        }
        if (score != null) {
            if (score.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_SCORE});
            } else {
                Label label = (Label)this.getControl(LABEL_SCORE);
                label.setText(String.format("%1$s%2$s", score.setScale(2, RoundingMode.HALF_EVEN).toString(), ResManager.loadKDString((String)"\u5206", (String)"RegexamMobPlugin_0", (String)"hr-hdm-formplugin", (Object[])new Object[0])));
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_SCORE});
        }
    }

    private void showAck(String comment) {
        this.getView().setVisible(Boolean.FALSE, new String[]{VECTOR_ACKDOWN});
        if (HRStringUtils.isNotEmpty((String)comment)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANEL_ACKCONTNONE});
            Label label = (Label)this.getControl(LABEL_ACKCONTENT);
            label.setText(comment);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_ACKCONTENT});
        }
    }

    private void showDet() {
        this.getView().setVisible(Boolean.FALSE, new String[]{VECTOR_DETDOWN});
    }
}

