/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.PictureProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeQueryOfExportEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.query.QueryListPlugin;
import kd.hr.hdm.business.reg.RegProcessServiceHelper;
import kd.hr.hdm.common.reg.constants.LabRelConstants;
import kd.hr.hdm.common.reg.enums.RegResultEnum;
import kd.hr.hdm.common.reg.util.RegDirectUtil;
import kd.hr.hdm.common.transfer.util.TransferPageUtil;
import kd.hr.hdm.formplugin.reg.web.applybill.RegularBaseUtils;
import org.apache.commons.collections.CollectionUtils;

public class RegProbationList
extends QueryListPlugin {
    private static final String PAGE_HDM_TOREGASK = "hdm_toregask";
    private static final String PAGE_HDM_TOREGEXAM = "hdm_toregexam";
    private static final String DEFAULT_STATUS = "1010";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List filters = e.getQFilters();
        for (int i = 0; i < filters.size(); ++i) {
            QFilter filter = (QFilter)filters.get(i);
            this.wrapStatusQFilter(filter);
        }
        QFilter statusFilter = new QFilter("businessstatus", "=", (Object)"1");
        QFilter datastatusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter isProbationFilter = new QFilter("hdm_empentrel.isprobation", "=", (Object)"1");
        QFilter fileTypeFilter = new QFilter("filetype.erfiletypeassign", "in", (Object)new Long[]{LabRelConstants.FILE_TYPE_EMP, LabRelConstants.FILE_TYPE_QUIT});
        QFilter isPrimaryFilterand = new QFilter("hdm_empposorgrel.isprimary", "=", (Object)"1");
        QFilter isCurrentVersionFilter1 = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter isCurrentVersionFilter2 = new QFilter("hdm_empentrel.iscurrentversion", "=", (Object)"1");
        QFilter isCurrentVersionFilter3 = new QFilter("hdm_empposorgrel.iscurrentversion", "=", (Object)"1");
        QFilter isCurrentVersionFilter4 = new QFilter("hdm_trialperiod.iscurrentversion", "=", (Object)"1");
        QFilter datastatusFilter1 = new QFilter("hdm_trialperiod.datastatus", "=", (Object)"1");
        QFilter datastatusFilter2 = new QFilter("hdm_empposorgrel.datastatus", "=", (Object)"1");
        QFilter dataStatusFilter3 = new QFilter("hdm_empentrel.datastatus", "=", (Object)"1");
        e.getQFilters().add(statusFilter);
        e.getQFilters().add(datastatusFilter);
        e.getQFilters().add(isProbationFilter);
        e.getQFilters().add(fileTypeFilter);
        e.getQFilters().add(isPrimaryFilterand);
        e.getQFilters().add(isCurrentVersionFilter1);
        e.getQFilters().add(isCurrentVersionFilter2);
        e.getQFilters().add(isCurrentVersionFilter3);
        e.getQFilters().add(isCurrentVersionFilter4);
        e.getQFilters().add(datastatusFilter1);
        e.getQFilters().add(datastatusFilter2);
        e.getQFilters().add(dataStatusFilter3);
        ListView view = (ListView)this.getView();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"hdm_probationquery");
        dataEntityType.setDBRouteKey("hr");
        MainEntityType ermanfile = EntityMetadataCache.getDataEntityType((String)"hdm_ermanfile");
        ermanfile.setDBRouteKey("hr");
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        List orgList = (List)formShowParameter.getCustomParam("orgQFilter");
        List adminList = (List)formShowParameter.getCustomParam("adminQFilter");
        if (CollectionUtils.isNotEmpty((Collection)adminList)) {
            QFilter adminFilter = new QFilter("affiliateadminorg.id", "in", (Object)adminList);
            e.getQFilters().add(adminFilter);
        }
        if (CollectionUtils.isNotEmpty((Collection)orgList)) {
            QFilter orgFilter = new QFilter("org.id", "in", (Object)orgList);
            e.getQFilters().add(orgFilter);
        }
        e.setOrderBy("hdm_trialperiod.regstatus,hdm_trialperiod.preregulardate,hdm_trialperiod.id asc");
    }

    private void wrapStatusQFilter(QFilter filter) {
        List nests;
        String prop = filter.getProperty();
        if (StringUtils.equals((CharSequence)prop, (CharSequence)"hdm_trialperiod.regstatus") || StringUtils.equals((CharSequence)prop, (CharSequence)"hdm_trialperiod.askstatus") || StringUtils.equals((CharSequence)prop, (CharSequence)"hdm_trialperiod.examstatus")) {
            String status;
            Object value = filter.getValue();
            if (value instanceof List) {
                ArrayList<String> valueList = new ArrayList<String>((List)value);
                for (int k = 0; k < valueList.size(); ++k) {
                    if (!HRObjectUtils.equals((Object)DEFAULT_STATUS, valueList.get(k))) continue;
                    valueList.add("");
                    valueList.add(" ");
                }
                filter.__setValue(valueList);
            } else if (value instanceof String && StringUtils.equals((CharSequence)DEFAULT_STATUS, (CharSequence)(status = (String)value))) {
                List<String> valueList = Arrays.asList(status, "", " ");
                filter.__setCP("in");
                filter.__setValue(valueList);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(nests = filter.getNests(true)))) {
            for (QFilter.QFilterNest nest : nests) {
                this.wrapStatusQFilter(nest.getFilter());
            }
        }
    }

    public void beforeQueryOfExport(BeforeQueryOfExportEvent e) {
        MainEntityType ermanfile = EntityMetadataCache.getDataEntityType((String)"hdm_ermanfile");
        ermanfile.setDBRouteKey("hr");
        MainEntityType empentrel = EntityMetadataCache.getDataEntityType((String)"hdm_empentrel");
        empentrel.setDBRouteKey("hr");
        MainEntityType empposorgrel = EntityMetadataCache.getDataEntityType((String)"hdm_empposorgrel");
        empposorgrel.setDBRouteKey("hr");
        MainEntityType trialperiod = EntityMetadataCache.getDataEntityType((String)"hdm_trialperiod");
        trialperiod.setDBRouteKey("hr");
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List columns = args.getListColumns();
        for (IListColumn column : columns) {
            String key = column.getListFieldKey();
            if (!StringUtils.equals((CharSequence)key, (CharSequence)"person.headsculpture") && !StringUtils.equals((CharSequence)key, (CharSequence)"name")) continue;
            column.setFixed(true);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldKey = args.getHyperLinkClickEvent().getFieldName();
        args.setCancel(true);
        if (StringUtils.equals((CharSequence)"name", (CharSequence)fieldKey)) {
            BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
            Map<String, Object> customParams = RegularBaseUtils.getFocusRowId((Long)billList.getFocusRowPkId());
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("hdm_personregview");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            String name = (String)customParams.get("person_name");
            String caption = ResManager.loadKDString((String)"\u8bd5\u7528\u671f\u4fe1\u606f\u5355 - %s", (String)"RegProbationList_0", (String)"hr-hdm-formplugin", (Object[])new Object[]{name});
            formShowParameter.setCaption(caption);
            formShowParameter.setCustomParams(customParams);
            this.getView().showForm(formShowParameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (!Objects.isNull(operate)) {
            switch (operate.getOperateKey()) {
                case "btnregularask": 
                case "regexam": 
                case "regapply": {
                    MainEntityType ermanfile = EntityMetadataCache.getDataEntityType((String)"hdm_ermanfile");
                    ermanfile.setDBRouteKey("hr");
                    MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"hdm_probationquery");
                    dataEntityType.setDBRouteKey("hr");
                    break;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (result != null && result.isSuccess()) {
            switch (operateKey) {
                case "btnregularask": {
                    this.regAskOrExam(PAGE_HDM_TOREGASK);
                    break;
                }
                case "regexam": {
                    this.regAskOrExam(PAGE_HDM_TOREGEXAM);
                    break;
                }
                case "regapply": {
                    RegularBaseUtils.batchRegApply((AbstractFormPlugin)this);
                }
            }
        }
    }

    private void regAskOrExam(String page) {
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        Object[] selectedRowIds = selectedRows.getPrimaryKeyValues();
        boolean isAskPage = HRStringUtils.equals((String)page, (String)PAGE_HDM_TOREGASK);
        if (selectedRowIds.length == 0) {
            String meaasge = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"RegProbationList_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(meaasge);
            return;
        }
        if (selectedRowIds.length > 1) {
            String message = isAskPage ? ResManager.loadKDString((String)"\u4ec5\u80fd\u4e3a\u5355\u4e2a\u8bd5\u7528\u4eba\u5458\u53d1\u8d77\u8f6c\u6b63\u95ee\u8be2\u3002", (String)"RegProbationList_4", (String)"hr-hdm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ec5\u80fd\u4e3a\u5355\u4e2a\u8bd5\u7528\u4eba\u5458\u53d1\u8d77\u8f6c\u6b63\u8003\u8bc4\u3002", (String)"RegProbationList_3", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(message);
            return;
        }
        ArrayList<Long> erManFileIdList = new ArrayList<Long>();
        erManFileIdList.add((Long)selectedRowIds[0]);
        List ermanfileList = (List)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getCardFields", (Object[])new Object[]{erManFileIdList});
        Map erManFile = (Map)ermanfileList.get(0);
        Long employee = (Long)erManFile.get("employee_id");
        Long person = (Long)erManFile.get("person_id");
        String formId = isAskPage ? "hdm_askperson" : "hdm_examperson";
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("employee", (Object)employee);
        showParameter.setCustomParam("person", (Object)person);
        showParameter.setCustomParam("ermanfile", selectedRowIds[0]);
        showParameter.setCustomParam("superior", erManFile.get("superiorinfo"));
        List tutorList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listBatchPropEmployeeAttachs", (Object[])new Object[]{Collections.singletonList(employee), "tutor.name,tutor.headsculpture,tutor_id", "hrpi_emptutor"});
        List filterTutor = tutorList.stream().filter(item -> (Long)item.get("tutor_id") != 0L).collect(Collectors.toList());
        showParameter.setCustomParam("tutor", filterTutor);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        showParameter.setHasRight(true);
        String regStatus = RegProcessServiceHelper.getRegStatusByEmployee((Long)employee);
        if (!HRStringUtils.equals((String)"1040", (String)regStatus) && !HRStringUtils.equals((String)"1050", (String)regStatus)) {
            this.getView().showForm(showParameter);
        } else {
            String errorMessage = isAskPage ? ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u8f6c\u6b63\u72b6\u6001\u4e3a\u201c\u5f85\u8f6c\u6b63\u201d\u201c\u8f6c\u6b63\u6d41\u7a0b\u4e2d\u201d\u201c\u8f6c\u6b63\u5f85\u751f\u6548\u201d\u7684\u5458\u5de5\u53d1\u8d77\u201c\u8f6c\u6b63\u95ee\u8be2\u201d\u64cd\u4f5c\u3002", (String)"RegProbationList_7", (String)"hr-hdm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u8f6c\u6b63\u72b6\u6001\u4e3a\u201c\u5f85\u8f6c\u6b63\u201d\u201c\u8f6c\u6b63\u6d41\u7a0b\u4e2d\u201d\u201c\u8f6c\u6b63\u5f85\u751f\u6548\u201d\u7684\u5458\u5de5\u53d1\u8d77\u201c\u8f6c\u6b63\u8003\u8bc4\u201d\u64cd\u4f5c\u3002", (String)"RegProbationList_8", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMessage);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        switch (closedCallBackEvent.getActionId()) {
            case "hdm_askperson": 
            case "hdm_examperson": {
                Boolean isSuccess = (Boolean)closedCallBackEvent.getReturnData();
                if (isSuccess == null || !isSuccess.booleanValue()) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u9001\u6210\u529f", (String)"RegProbationList_13", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "hdm_batchregmulconfirm": {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                if (returnData == null) {
                    return;
                }
                int successNum = (Integer)returnData.get("successNum");
                if (successNum == 0) {
                    return;
                }
                if (successNum > 1) {
                    String caption = ResManager.loadKDString((String)"\u65b0\u589e\u6279\u91cf\u8f6c\u6b63\u7533\u8bf7", (String)"BatchRegList_4", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
                    TransferPageUtil.showBillPage((IFormView)this.getView(), (String)"hdm_batchregbill", (Map)returnData, (Object)"", (String)caption);
                    break;
                }
                JSONArray data = (JSONArray)returnData.get("data");
                JSONObject jsonObject = (JSONObject)data.get(0);
                JSONObject regInfo = (JSONObject)jsonObject.get((Object)"data");
                JSONObject ermanfileMap = (JSONObject)regInfo.get((Object)"ermanfileMap");
                long id = (Long)ermanfileMap.get((Object)"id");
                RegularBaseUtils.btnRegApply((AbstractFormPlugin)this, id);
                break;
            }
        }
    }

    public void packageData(PackageDataEvent e) {
        String key;
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        switch (key = columnDesc.getKey()) {
            case "probation": {
                String probation = e.getRowData().getString("probation");
                e.setFormatValue((Object)probation);
                break;
            }
            case "askresult": {
                String askResult = e.getRowData().getString("askresult");
                e.setFormatValue((Object)askResult);
                break;
            }
            case "examresult": {
                String examResult = e.getRowData().getString("examresult");
                e.setFormatValue((Object)examResult);
                break;
            }
        }
    }

    public void afterExportFile(ExportFileEvent e) {
        String formatTime = HRDateTimeUtils.format((Date)new Date(), (String)"MMdd");
        e.setFileName(ResManager.loadKDString((String)"\u5bfc\u51fa\u5217\u8868_\u8bd5\u7528\u671f\u4eba\u5458_%s", (String)"RegProbationList_9", (String)"hr-hdm-formplugin", (Object[])new Object[]{formatTime}));
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection collection = e.getPageData();
        ArrayList employeeIdList = Lists.newArrayListWithExpectedSize((int)collection.size());
        collection.forEach(object -> employeeIdList.add(object.getLong("employee_id")));
        HRBaseServiceHelper askHelper = new HRBaseServiceHelper("hdm_regaskresult");
        QFilter filter = new QFilter("bemployee", "in", (Object)employeeIdList);
        DynamicObject[] askResults = askHelper.query("person,askresult", new QFilter[]{filter});
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)askResults.length);
        for (int i = 0; i < askResults.length; ++i) {
            resultMap.put(askResults[i].getLong("person"), askResults[i].getString("askresult"));
        }
        HRBaseServiceHelper examHelper = new HRBaseServiceHelper("hdm_regexamresult");
        DynamicObject[] examResults = examHelper.query("person,examresult", new QFilter[]{filter});
        HashMap examResultMap = Maps.newHashMapWithExpectedSize((int)examResults.length);
        for (int i = 0; i < examResults.length; ++i) {
            examResultMap.put(examResults[i].getLong("person"), examResults[i].getString("examresult"));
        }
        this.registerCommonProp(collection);
        collection.forEach(object -> {
            Long personId = object.getLong("person_id");
            object.set("askresult", (Object)RegResultEnum.getNameByNumber((String)((String)resultMap.get(personId))));
            object.set("examresult", (Object)RegResultEnum.getNameByNumber((String)((String)examResultMap.get(personId))));
            String periodUnit = object.getString("hdm_trialperiod.probationunit");
            String periodUnitName = RegDirectUtil.getProbationUnit((String)periodUnit);
            String probation = object.getString("hdm_trialperiod.probation");
            object.set("probation", (Object)(probation + periodUnitName));
            this.setDefaultValue((DynamicObject)object);
            this.setDefaultHead((DynamicObject)object);
        });
    }

    private void setDefaultValue(DynamicObject object) {
        String examStatus;
        String askStatus;
        String regStatus = object.getString("hdm_trialperiod.regstatus");
        if (StringUtils.isEmpty((CharSequence)regStatus)) {
            object.set("hdm_trialperiod.regstatus", (Object)DEFAULT_STATUS);
        }
        if (StringUtils.isEmpty((CharSequence)(askStatus = object.getString("hdm_trialperiod.askstatus")))) {
            object.set("hdm_trialperiod.askstatus", (Object)DEFAULT_STATUS);
        }
        if (StringUtils.isEmpty((CharSequence)(examStatus = object.getString("hdm_trialperiod.examstatus")))) {
            object.set("hdm_trialperiod.examstatus", (Object)DEFAULT_STATUS);
        }
    }

    private void setDefaultHead(DynamicObject object) {
        DynamicObject person = object.getDynamicObject("person");
        if (person != null && StringUtils.isEmpty((CharSequence)person.getString("headsculpture"))) {
            RefEntityType type = (RefEntityType)person.getDataEntityType();
            PictureProp prop = (PictureProp)type.findProperty("headsculpture");
            person.set("headsculpture", (Object)prop.getDefaultImgKey());
        }
    }

    private void registerCommonProp(DynamicObjectCollection collection) {
        DynamicObjectType type = collection.getDynamicObjectType();
        if (Objects.isNull(type.getProperty("askresult"))) {
            DynamicSimpleProperty ask = new DynamicSimpleProperty("askresult", String.class, (Object)"");
            type.registerSimpleProperty(ask);
        }
        if (Objects.isNull(type.getProperty("examresult"))) {
            DynamicSimpleProperty exam = new DynamicSimpleProperty("examresult", String.class, (Object)"");
            type.registerSimpleProperty(exam);
        }
        if (Objects.isNull(type.getProperty("probation"))) {
            DynamicSimpleProperty probation = new DynamicSimpleProperty("probation", String.class, (Object)"");
            type.registerSimpleProperty(probation);
        }
    }
}

