/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web;

import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.hr.hdm.business.reg.domain.exteral.IRegConfigService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegUpgradeRecordService;

public class RegUpgradeNotifyPlugin
extends AbstractBillPlugIn {
    private static final String SYS_USER = "sysuser";

    public void beforeBindData(EventObject e) {
        boolean isNotified = this.isNotified();
        if (isNotified) {
            return;
        }
        boolean isAllowedNotify = this.isAllowedNotify();
        if (!isAllowedNotify) {
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hdm_regupgrade_tips");
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
        DynamicObject upgradeRecordDynamicObject = IRegUpgradeRecordService.getInstance().generateEmptyDynamicObject();
        upgradeRecordDynamicObject.set(SYS_USER, (Object)RequestContext.get().getCurrUserId());
        IRegUpgradeRecordService.getInstance().saveOne(upgradeRecordDynamicObject);
    }

    private boolean isAllowedNotify() {
        Map devConfigMap = IRegConfigService.getInstance().getDevConfig();
        Boolean isAllowedNotify = (Boolean)devConfigMap.get("hdm_reg_upgrade_notify");
        return isAllowedNotify != null && isAllowedNotify != false;
    }

    private boolean isNotified() {
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter qFilter = new QFilter(SYS_USER, "=", (Object)currUserId);
        DynamicObject[] dynamicObjects = IRegUpgradeRecordService.getInstance().query(SYS_USER, new QFilter[]{qFilter});
        return dynamicObjects != null && dynamicObjects.length > 0;
    }
}

