/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.applybill;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TipsListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.FormModel;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRShowPageUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.personnelchange.servicehelper.PersonnelChangeServiceHelper;
import kd.hr.hdm.business.reg.RegAskServiceHelper;
import kd.hr.hdm.business.reg.RegDetailInfoHelper;
import kd.hr.hdm.business.reg.RegExamServiceHelper;
import kd.hr.hdm.business.reg.RegPeronalBillHelper;
import kd.hr.hdm.business.reg.domain.repository.bill.HDMRegBaseBillRepository;
import kd.hr.hdm.business.reg.domain.service.bill.IPersonAboutService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegProbationService;
import kd.hr.hdm.business.reg.validator.RegApplyValidatorHelper;
import kd.hr.hdm.common.parttime.entity.DataValidate;
import kd.hr.hdm.common.parttime.enums.PosTypeEnum;
import kd.hr.hdm.common.parttime.enums.ValidateRangeEnum;
import kd.hr.hdm.common.reg.constants.RegBillTypeEnum;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.hdm.common.reg.enums.RegCategoryEnum;
import kd.hr.hdm.common.reg.enums.RegCommentEnum;
import kd.hr.hdm.common.reg.enums.RegDateUnitEnum;
import kd.hr.hdm.common.reg.enums.RegTypeEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.formplugin.reg.common.RegBillBasePlugin;
import kd.hr.hdm.formplugin.reg.web.applybill.RegPageUtils;
import kd.hr.hdm.formplugin.reg.web.applybill.RegularBaseUtils;
import kd.hr.hdm.formplugin.reg.web.tools.RegBillDrawLabelUtil;
import org.apache.commons.lang.StringUtils;

public class RegBaseBillPlugin
extends RegBillBasePlugin
implements BeforeF7SelectListener,
ItemClickListener,
TipsListener {
    private static final Log LOGGER = LogFactory.getLog(RegBaseBillPlugin.class);
    private static final String PANEL_KEYEVENT = "panelkeyevent";
    private static final String PANEL_ASK = "panelask";
    private static final String PANEL_EXAM = "panelexam";
    private static final String LBL_TITLE = "lbltitle";
    private static final String KEY_ATTACHMENTPANEL = "attachmentpanel";
    private static final String PANEL_MOBILEIMG = "panelmobileimg";
    private static final String DONOTHING_TERMINATE = "donothing_terminate";
    private static final String TRAIL_PERIOD_RESULT_IMAGE_KEY = "trialperiodimage";
    private static final String[] BUSINESS_CARD_ARR = new String[]{"superior", "charge"};

    public void preOpenForm(PreOpenFormEventArgs e) {
        DynamicObject bill;
        Object pkId;
        FormShowParameter formShowParameter = e.getFormShowParameter();
        if (formShowParameter instanceof BillShowParameter && !HRObjectUtils.isEmpty((Object)(pkId = ((BillShowParameter)formShowParameter).getPkId())) && !HRObjectUtils.isEmpty((Object)(bill = HDMRegBaseBillRepository.getInstance().queryOne(pkId)))) {
            String caption = ResManager.loadKDString((String)"\u8f6c\u6b63\u7533\u8bf7 - %s", (String)"RegBaseBillPlugin_2", (String)"hr-hdm-formplugin", (Object[])new Object[]{bill.getString("person.name")});
            formShowParameter.setCaption(caption);
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit laborrelstatus;
        BasedataEdit erManFile;
        super.registerListener(e);
        BasedataEdit regCateGory = (BasedataEdit)this.getView().getControl("regcategory");
        if (regCateGory != null) {
            regCateGory.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((erManFile = (BasedataEdit)this.getView().getControl("ermanfile")) != null) {
            erManFile.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((laborrelstatus = (BasedataEdit)this.getView().getControl("laborrelstatus")) != null) {
            laborrelstatus.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        Arrays.stream(BUSINESS_CARD_ARR).forEach(item -> this.addTipsListener((String)item));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW == status) {
            this.getModel().setDataChanged(false);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setErmanFileFromList();
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("hdm_regselfhelpbill".equals(formId)) {
            return;
        }
        this.setVisibleForAttachmentPanel();
        Object erManFile = this.getModel().getValue("ermanfile");
        if (!ObjectUtils.isEmpty((Object)erManFile)) {
            this.initShowPage(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
            this.getView().setVisible(Boolean.FALSE, new String[]{"rightmainpanel", "panelpersoninfo", "panelbarcode"});
            DynamicObject personOjb = (DynamicObject)this.getView().getModel().getValue("person");
            if (null != personOjb) {
                this.showPage();
            }
            this.buildProbationText();
        }
        this.setChargeAndSup();
        this.setDelayInfoOfRegCategory();
        this.setHeadPanelOfModify();
        this.setPlaceHoldPanel();
        this.setTrialPeriodResultImage();
        this.setOrg();
    }

    private void setOrg() {
        String sourceTag = (String)this.getView().getFormShowParameter().getCustomParam("reg_apply_source_other_tag");
        if (HRStringUtils.equals((String)sourceTag, (String)"reg_apply_source_other_tag")) {
            this.getModel().setValue("org", (Object)this.getModel().getDataEntity().getLong("ermanfile.org.id"));
            this.getView().setEnable(Boolean.FALSE, new String[]{"org"});
        }
    }

    private void setChargeAndSup() {
        String superiorStr = this.getPageCache().get("superior");
        String chargeStr = this.getPageCache().get("charge");
        if (superiorStr != null) {
            this.getModel().deleteEntryData("superiorentry");
            this.getModel().deleteEntryData("superiorentry1");
            this.getModel().batchCreateNewEntryRow("superiorentry", 1);
            this.getModel().batchCreateNewEntryRow("superiorentry1", 1);
            List superiorList = (List)JSONObject.parseObject((String)superiorStr, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
            RegBaseBillPlugin.setLeaderInfo(this.getView(), (Map)superiorList.get(0), "superiorimage");
            RegBaseBillPlugin.setLeaderInfo(this.getView(), (Map)superiorList.get(0), "superiorimage1");
        }
        if (chargeStr != null) {
            this.getModel().deleteEntryData("chargeentry");
            this.getModel().deleteEntryData("chargeentry1");
            this.getModel().batchCreateNewEntryRow("chargeentry", 1);
            this.getModel().batchCreateNewEntryRow("chargeentry1", 1);
            List chargeList = (List)JSONObject.parseObject((String)chargeStr, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
            RegBaseBillPlugin.setLeaderInfo(this.getView(), (Map)chargeList.get(0), "chargeimage");
            RegBaseBillPlugin.setLeaderInfo(this.getView(), (Map)chargeList.get(0), "chargeimage1");
        }
    }

    private void setDelayInfoOfRegCategory() {
        DynamicObject regBill = this.getModel().getDataEntity();
        DynamicObject regCategory = regBill.getDynamicObject("regcategory");
        if (regCategory == null || !RegCategoryEnum.POSTPHONE.getId().equals(regCategory.getLong("id"))) {
            return;
        }
        Map postponeInfoMap = IRegProbationService.getInstance().getPostponeInfoOfView(regBill);
        this.getModel().setValue("postponeprobationview", postponeInfoMap.get("postponeprobationview"));
        this.getModel().setValue("probationexview", postponeInfoMap.get("probationexview"));
    }

    private void setTrialPeriodResultImage() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String trialPeriodResultImageUrl = RegDetailInfoHelper.getInstance().getTrialPeriodResultImageWeb(dataEntity.getString("regstatus"));
        if (HRStringUtils.isEmpty((String)trialPeriodResultImageUrl)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TRAIL_PERIOD_RESULT_IMAGE_KEY});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{TRAIL_PERIOD_RESULT_IMAGE_KEY});
            Image image = (Image)this.getView().getControl(TRAIL_PERIOD_RESULT_IMAGE_KEY);
            image.setUrl(trialPeriodResultImageUrl);
        }
    }

    private void setPlaceHoldPanel() {
        Object ermanFile = this.getModel().getDataEntity().get("ermanfile");
        if (ermanFile != null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"placeholderflexpanelap"});
        }
    }

    private void validateBillStatus() {
        DynamicObject regBillDynamicObject = this.getModel().getDataEntity();
        String billStatus = regBillDynamicObject.getString("billstatus");
        String regBillType = regBillDynamicObject.getString("regbilltype");
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("hdm_regselfhelp_supply".equals(formId) && "G".equals(billStatus) && RegBillTypeEnum.EMP.getStatus().equals(regBillType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u662f\u901a\u8fc7\u201c\u5458\u5de5\u81ea\u52a9\u201d\u7533\u8bf7\uff0c\u9700\u7531\u5458\u5de5\u672c\u4eba\u6838\u5b9e\u540e\u91cd\u65b0\u63d0\u4ea4\u5355\u636e\u3002", (String)"RegBaseBillPlugin_15", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
    }

    private void buildProbationText() {
        Integer value = (Integer)this.getModel().getValue("probation");
        Object unit = this.getModel().getValue("probationunit");
        if (ObjectUtils.isEmpty((Object)unit)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"probationtext"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"fieldgrouppanelap"});
        } else {
            String name = RegDateUnitEnum.getName((String)((String)unit));
            this.getModel().setValue("probationtext", (Object)(value + name));
            this.getView().setVisible(Boolean.TRUE, new String[]{"probationtext"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"fieldgrouppanelap"});
        }
    }

    private void showPage() {
        DynamicObject personOjb = (DynamicObject)this.getView().getModel().getValue("person");
        Long personId = null == personOjb ? null : Long.valueOf(personOjb.getLong("id"));
        DynamicObject employeeOjb = (DynamicObject)this.getView().getModel().getValue("bemployee");
        Long employeeId = null == employeeOjb ? null : Long.valueOf(employeeOjb.getLong("id"));
        this.loadEmptutorInfo(employeeId);
        boolean isExistKeyEvent = new HRBaseServiceHelper("hdm_regevent").isExists(new QFilter("bemployee", "=", (Object)employeeId));
        if (isExistKeyEvent) {
            IListView view = RegularBaseUtils.listParameterShow((AbstractFormPlugin)this, PANEL_KEYEVENT, "hdm_regevent", null, new QFilter("bemployee", "=", (Object)employeeId));
            if (null != view) {
                view.setVisible(Boolean.FALSE, new String[]{"flexpanelap", "modify", "vectorap1", "bar_new"});
                this.getView().sendFormAction((IFormView)view);
            }
        } else {
            this.initShowPage(Boolean.TRUE, Boolean.FALSE, Boolean.FALSE);
        }
        DynamicObject resultObject = RegAskServiceHelper.RESULT_SERVICE_HELPER.queryOne("id", new QFilter("bemployee", "=", (Object)employeeId));
        if (resultObject != null) {
            IFormView view = RegularBaseUtils.showPage((AbstractFormPlugin)this, PANEL_ASK, "hdm_regaskfile", personId, employeeId);
            if (null != view) {
                view.setVisible(Boolean.FALSE, new String[]{"log", "toolbarap", "flexpanelap", "advcontoolbarap"});
                this.getView().sendFormAction(view);
            }
        } else {
            this.initShowPage(Boolean.FALSE, Boolean.TRUE, Boolean.FALSE);
        }
        DynamicObject resultExamObject = RegExamServiceHelper.RESULT_SERVICE_HELPER.queryOne("examresult", new QFilter("bemployee", "=", (Object)employeeId));
        if (resultExamObject != null) {
            IFormView view = RegularBaseUtils.showPage((AbstractFormPlugin)this, PANEL_EXAM, "hdm_regexamfile", personId, employeeId);
            if (null != view) {
                view.setVisible(Boolean.FALSE, new String[]{"advcontoolbarap"});
                this.getView().sendFormAction(view);
            }
        } else {
            this.initShowPage(Boolean.FALSE, Boolean.FALSE, Boolean.TRUE);
        }
    }

    private void initShowPage(Boolean isShowKeyEvent, Boolean isShowAsk, Boolean isShowExam) {
        if (isShowKeyEvent.booleanValue()) {
            FormModel formModelKeyEvent = new FormModel("hdm_regemptyinfokey", null, "1");
            formModelKeyEvent.setShowType(ShowType.InContainer);
            formModelKeyEvent.setTargetKey(PANEL_KEYEVENT);
            HRShowPageUtils.showPage((FormModel)formModelKeyEvent, (AbstractFormPlugin)this);
            IFormView keyEventPageView = this.getView().getView(HRShowPageUtils.showPage((FormModel)formModelKeyEvent, (AbstractFormPlugin)this));
            if (null != keyEventPageView) {
                keyEventPageView.setVisible(Boolean.FALSE, new String[]{LBL_TITLE});
                this.getView().sendFormAction(keyEventPageView);
            }
        }
        if (isShowAsk.booleanValue()) {
            FormModel formModel = new FormModel("hdm_regemptyinfo", null, "1");
            formModel.setShowType(ShowType.InContainer);
            formModel.setTargetKey(PANEL_ASK);
            String askPageId = HRShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
            IFormView askPageView = this.getView().getView(askPageId);
            if (null != askPageView) {
                this.getView().sendFormAction(askPageView);
            }
        }
        if (isShowExam.booleanValue()) {
            FormModel formModelOfExam = new FormModel("hdm_regemptyinfoexam", null, "1");
            formModelOfExam.setShowType(ShowType.InContainer);
            formModelOfExam.setTargetKey(PANEL_EXAM);
            String examPageId = HRShowPageUtils.showPage((FormModel)formModelOfExam, (AbstractFormPlugin)this);
            IFormView examPageView = this.getView().getView(examPageId);
            if (null != examPageView) {
                this.getView().sendFormAction(examPageView);
            }
        }
    }

    private void setVisibleForAttachmentPanel() {
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_ATTACHMENTPANEL, PANEL_MOBILEIMG, "worksum", "comment"});
        Boolean isMobile = (Boolean)this.getView().getModel().getValue("ismobile");
        if (isMobile.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"worksum", KEY_ATTACHMENTPANEL, "comment"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_ATTACHMENTPANEL, "comment"});
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("hdm_regselfhelpbill".equals(formId)) {
            return;
        }
        this.initPageInfo();
        this.getView().setVisible(Boolean.FALSE, new String[]{"personflex", "postypelabel", "postypelabel1", "commonpanel", "barcodeap", "panelbarcode1", "delayinfoflex"});
        this.validateBillStatus();
        IDataModel model = this.getModel();
        if (model.getValue("b_ermanfile") == null) {
            model.setValue("b_ermanfile", model.getValue("ermanfile"));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.executeInCreateNewData();
    }

    private void executeInCreateNewData() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"regcategory", "regcomment", "comment"});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_ATTACHMENTPANEL, PANEL_MOBILEIMG, "worksum", "comment", "personinfocard", "personflex", "effectdate", "headpanel", "postypelabel", "postypelabel1", "delaytime", "delayinfoflex", "commonpanel"});
        DateEdit effectDate = (DateEdit)this.getControl("effectdate");
        effectDate.setMustInput(false);
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_ATTACHMENTPANEL, "comment"});
        Object erManFile = this.getView().getFormShowParameter().getCustomParam("ermanfile");
        if (!ObjectUtils.isEmpty((Object)erManFile)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"panelbarcode"});
            this.getModel().setValue("ermanfile", erManFile);
            this.getView().setEnable(Boolean.FALSE, new String[]{"ermanfile", "org"});
            this.serviceForChangePerson();
        }
    }

    private void setErmanFileFromList() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object erManFile = formShowParameter.getCustomParam("ermanfile");
        if (!HRObjectUtils.isEmpty((Object)erManFile) && HRObjectUtils.isEmpty((Object)this.getModel().getValue("b_ermanfile"))) {
            this.getModel().setValue("b_ermanfile", erManFile);
        }
    }

    private void initPageInfo() {
        String formTitle = ResManager.loadKDString((String)"\u8f6c\u6b63\u7533\u8bf7 - %s", (String)"RegBaseBillPlugin_2", (String)"hr-hdm-formplugin", (Object[])new Object[]{this.getModel().getDataEntity().getString("person.name")});
        this.getView().setFormTitle(new LocaleString(formTitle));
        String openByList = (String)this.getView().getFormShowParameter().getCustomParam("list");
        String bizKey = (String)this.getView().getFormShowParameter().getCustomParam("businessKey");
        if (!HRStringUtils.isEmpty((String)bizKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"titlepanelflex"});
        } else if (!HRStringUtils.isEmpty((String)openByList)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"rightmainpanel"});
            this.getView().setStatus(OperationStatus.VIEW);
        }
        IPersonAboutService personAboutService = IPersonAboutService.getInstance();
        Map personAboutMaps = personAboutService.buildPersonChangeParams(this.getModel().getDataEntity().getDynamicObject("ermanfile"));
        this.initPersonCard(personAboutMaps);
        this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap"});
        this.executeRegComment(this.getModel().getDataEntity().getDynamicObject("regcomment"));
        this.executeBillHead();
        if (RegBillStatusEnum.TEMPSTORAGE.getCode().equals(this.getModel().getDataEntity().getString("billstatus"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"rightmainpanel"});
        }
    }

    private void executeBillHead() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Control headpanel = this.getView().getControl("headpanel");
        if (headpanel != null) {
            ((Label)this.getView().getControl("billnolabel")).setText(dataEntity.getString("billno"));
            ((Label)this.getView().getControl("lblorg")).setText(dataEntity.getString("org.name"));
            ((Label)this.getView().getControl("lblcreator")).setText(dataEntity.getString("creator.name"));
            Date date = dataEntity.getDate("createtime");
            String dateString = HRInteDateTimeUtil.formatDate((String)"hdm_regbasebill", (String)"createtime", (Date)date);
            ((Label)this.getView().getControl("lblcreatetime")).setText(dateString);
            this.setAuditStatusLabelWithColorful(dataEntity.getString("billstatus"));
            ((Label)this.getView().getControl("regtype")).setText(RegTypeEnum.getName((String)dataEntity.getString("regbilltype")));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String formId = formShowParameter.getFormId();
        String bizKey = (String)formShowParameter.getCustomParam("businessKey");
        if ("hdm_regselfhelp_supply".equals(formId) && !HRStringUtils.isEmpty((String)bizKey) || HRStringUtils.equals((String)"hrvalidate", (String)formOperate.getOperateKey())) {
            return;
        }
        DynamicObject bill = this.getModel().getDataEntity();
        switch (formOperate.getOperateKey()) {
            case "save": 
            case "submit": 
            case "submiteffect": {
                String errorMsg = IRegProbationService.getInstance().getMustInputErrorMsg(this.getModel().getDataEntity());
                if (errorMsg.length() > 0) {
                    this.getView().showErrorNotification(errorMsg);
                    args.setCancel(true);
                    return;
                }
                this.validateRegApplyBeforeSubmit(bill, formOperate, args);
                break;
            }
            case "unsubmit": {
                DataValidate dataValidate = RegApplyValidatorHelper.validateUnsubmit((DynamicObject)this.getBill());
                if (ValidateRangeEnum.VALIDATE_ERROR == dataValidate.getValidatorContext().getRange()) {
                    this.getView().showErrorNotification(dataValidate.getValidatorContext().map2String());
                    args.setCancel(true);
                    return;
                }
                RefObject afterConfirm = new RefObject();
                if (formOperate.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) break;
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("unsubmit", (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u8be5\u5355\u636e\u64a4\u9500\u540e\u6d41\u7a0b\u5c06\u56de\u5230\u201c\u6682\u5b58\u201d\u72b6\u6001\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"RegBaseBillPlugin_4", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                args.setCancel(true);
                break;
            }
            case "donothing_terminate": {
                DynamicObject regBill = this.getBill();
                boolean success = IRegBillService.getInstance().terminateValidate(regBill);
                if (!success) {
                    RegPageUtils.showTerminateMsg(this.getView(), regBill.getString("regstatus"));
                    args.setCancel(true);
                    return;
                }
                RegPageUtils.showTerminateConfirm((AbstractFormPlugin)this, DONOTHING_TERMINATE, regBill.getPkValue());
                args.setCancel(true);
                break;
            }
        }
    }

    private DynamicObject getBill() {
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        return HDMRegBaseBillRepository.getInstance().queryOne(pkValue);
    }

    private void validateRegApplyBeforeSubmit(DynamicObject billObj, FormOperate formOperate, BeforeDoOperationEventArgs args) {
        Map validateMap = RegApplyValidatorHelper.regApplyValidate(Collections.singletonList(billObj), (String)"operate_event", (boolean)false, (boolean)true, (boolean)false);
        RegPageUtils.validateShowConfirm((AbstractFormPlugin)this, formOperate, (Map)validateMap.get(billObj.getLong("id")), args);
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        OperateOption operateOption;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ((kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"save", (CharSequence)callBackId) || kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"submit", (CharSequence)callBackId) || kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"submiteffect", (CharSequence)callBackId)) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            operateOption = OperateOption.create();
            operateOption.setVariableValue(callBackId, "true");
            operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
            this.getView().invokeOperation(callBackId, operateOption);
        }
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"unsubmit", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
            this.getView().invokeOperation("unsubmit", operateOption);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        OperationResult operationResult = e.getOperationResult();
        if (null != operationResult && operationResult.isSuccess()) {
            switch (e.getOperateKey()) {
                case "save": {
                    this.showNewHeadAndChangePageName();
                    this.hidePanel();
                    this.getView().setStatus(OperationStatus.VIEW);
                    this.getView().invokeOperation("refresh");
                    LOGGER.info("RegBaseBillPlugin.afterDoOperation,set status end,status={}", (Object)this.getView().getFormShowParameter().getStatus());
                    break;
                }
                case "submit": {
                    this.setAuditStatusLabelWithColorful(RegBillStatusEnum.ALREADYSUBMIT.getCode());
                    this.showNewHeadAndChangePageName();
                    break;
                }
                case "submiteffect": {
                    this.changeLabel();
                    this.showNewHeadAndChangePageName();
                    this.getView().setStatus(OperationStatus.VIEW);
                    this.getView().invokeOperation("refresh");
                    break;
                }
                case "modify": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"panelbarcode"});
                    this.getView().setStatus(OperationStatus.EDIT);
                    this.setHeadPanelOfModify();
                    break;
                }
                case "unsubmit": {
                    this.setAuditStatusLabelWithColorful(RegBillStatusEnum.TEMPSTORAGE.getCode());
                    this.getView().setStatus(OperationStatus.VIEW);
                    this.getView().invokeOperation("refresh");
                    break;
                }
            }
            this.getView().updateView();
            this.getView().sendFormAction(this.getView());
        }
    }

    private void setHeadPanelOfModify() {
        OperationStatus operateStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT.equals((Object)operateStatus)) {
            String billStatus = this.getBill().getString("billstatus");
            if ("G".equals(billStatus)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap", "flexpanelap15", "personinfocard"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"headpanel"});
            }
        }
    }

    private void hidePanel() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"rightmainpanel", "barcodeap", "panelbarcode1"});
    }

    private void changeLabel() {
        ((Label)this.getView().getControl("regtype")).setText(RegTypeEnum.APPLY_QUICK.getName());
        this.setAuditStatusLabelWithColorful(RegBillStatusEnum.APPROVEPASSED.getCode());
    }

    private void showNewHeadAndChangePageName() {
        ((Label)this.getView().getControl("billnolabel")).setText(this.getModel().getDataEntity().getString("billno"));
        this.getView().setVisible(Boolean.TRUE, new String[]{"headpanel", "bar_modify", "bar_submit"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"barcodeap", "panelbarcode1"});
        String formTitle = ResManager.loadKDString((String)"\u8f6c\u6b63\u7533\u8bf7 - %s", (String)"RegBaseBillPlugin_2", (String)"hr-hdm-formplugin", (Object[])new Object[]{this.getModel().getDataEntity().getString("person.name")});
        this.getView().setFormTitle(new LocaleString(formTitle));
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        switch (e.getProperty().getName()) {
            case "ermanfile": {
                if (!ObjectUtils.isEmpty((Object)changeData.getNewValue())) {
                    this.serviceForChangePerson();
                } else {
                    this.executeCleanPersonInfo();
                }
                this.getModel().setValue("b_ermanfile", this.getModel().getValue("ermanfile"));
                break;
            }
            case "regcomment": {
                DynamicObject regComment = this.getModel().getDataEntity().getDynamicObject("regcomment");
                if (regComment == null || RegCommentEnum.DISAGREE.getId().equals(regComment.getLong("id"))) {
                    this.getModel().setValue("laborrelstatus", null);
                    break;
                }
                if (!RegCommentEnum.AGREE.getId().equals(regComment.getLong("id"))) break;
                DynamicObject affaction = this.getModel().getDataEntity().getDynamicObject("affaction");
                if (HRObjectUtils.isEmpty((Object)affaction)) {
                    return;
                }
                List laborrelStatusList = PersonnelChangeServiceHelper.getLaborrelstatusDyByAffaction((DynamicObject)affaction);
                if (!HRCollUtil.isNotEmpty((Collection)laborrelStatusList)) break;
                this.getModel().setValue("laborrelstatus", laborrelStatusList.get(0));
                break;
            }
        }
    }

    private void serviceForChangePerson() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"personinfocard"});
        this.showPersonByErManFile(true);
        this.getView().setEnable(Boolean.TRUE, new String[]{"regcategory", "regcomment", "comment"});
        this.showPage();
    }

    private void showPersonByErManFile(boolean forceRefresh) {
        IPersonAboutService personAboutService;
        Map personReturnMap;
        if (forceRefresh) {
            this.executeCleanPersonInfo();
        }
        if (!RegPageUtils.haveLicence((Long)(personReturnMap = (personAboutService = IPersonAboutService.getInstance()).buildPersonChangeParams(this.getModel().getDataEntity().getDynamicObject("ermanfile"))).get("person_id"), this.getView())) {
            this.getModel().setValue("ermanfile", null);
        } else {
            String formId = this.getView().getFormShowParameter().getFormId();
            if ("hdm_regselfhelpbill".equals(formId)) {
                return;
            }
            Map regReturnMap = personAboutService.buildRegInfo(this.getModel().getDataEntity().getDynamicObject("ermanfile"));
            this.initInformation(personReturnMap);
            this.initRegInformation(regReturnMap);
            this.initPersonCard(personReturnMap, forceRefresh);
            this.executeBillHead();
        }
    }

    private void initRegInformation(Map<String, Object> regReturnMap) {
        if (ObjectUtils.isEmpty(regReturnMap)) {
            return;
        }
        this.getModel().setValue("entrydate", regReturnMap.get("startdate"));
        this.getModel().setValue("probation", regReturnMap.get("probation"));
        this.getModel().setValue("probationunit", regReturnMap.get("probationunit"));
        this.getModel().setValue("preactualdate", regReturnMap.get("preregulardate"));
        this.buildProbationText();
    }

    private void executeCleanPersonInfo() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"personinfocard"});
        Arrays.asList("person", "bemployee", "bhrbu", "baffiliateadminorg", "bempgroup", "bposition", "standardpost", "entrydate", "probation", "probationunit", "regcomment", "regcategory", "preactualdate").forEach(temp -> this.getModel().setValue(temp, null));
        this.getView().setEnable(Boolean.FALSE, new String[]{"regcomment", "regcategory", "comment"});
    }

    private void initInformation(Map<String, Object> personReturnMap) {
        this.getModel().setValue("bhrbu", personReturnMap.get("org_id"));
        this.getModel().setValue("baffiliateadminorg", personReturnMap.get("affiliateadminorg_id"));
        this.getModel().setValue("bempgroup", personReturnMap.get("empgroup_id"));
        this.getModel().setValue("badminorg", personReturnMap.get("adminorg_id"));
        this.getModel().setValue("person", personReturnMap.get("person_id"));
        this.getModel().setValue("bemployee", personReturnMap.get("employee_id"));
        this.getModel().setValue("cmpemp", personReturnMap.get("managingscope_id"));
    }

    private void initPersonCard(Map<String, Object> personReturnMap) {
        this.initPersonCard(personReturnMap, false);
    }

    private void initPersonCard(Map<String, Object> personReturnMap, boolean forceRefresh) {
        int i;
        Object job;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (!forceRefresh && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)dataEntity.getString("name"))) {
            RegPageUtils.setBaseModel((AbstractFormPlugin)this, dataEntity.getString("name"), "name", "name1");
        } else {
            RegPageUtils.setBaseModel((AbstractFormPlugin)this, personReturnMap.get("name"), "name", "name1");
            this.getModel().setValue("name", personReturnMap.get("name"));
        }
        if (!forceRefresh && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)dataEntity.getString("number"))) {
            RegPageUtils.setBaseModel((AbstractFormPlugin)this, dataEntity.getString("number"), "number", "number1");
        } else {
            RegPageUtils.setBaseModel((AbstractFormPlugin)this, personReturnMap.get("number"), "number", "number1");
            this.getModel().setValue("number", personReturnMap.get("number"));
        }
        if (!forceRefresh && !ObjectUtils.isEmpty((Object)dataEntity.getDynamicObject("bdependencytype"))) {
            RegPageUtils.setBaseLabel((AbstractFormPlugin)this, dataEntity.getDynamicObject("bdependencytype").getString("name"), "locationtypelabel", "locationtypelabel1");
        } else {
            RegPageUtils.setBaseLabel((AbstractFormPlugin)this, personReturnMap.get("dependencytype"), "locationtypelabel", "locationtypelabel1");
            this.getModel().setValue("bdependencytype", personReturnMap.get("dependencytype_id"));
        }
        RegPageUtils.setBaseLabel((AbstractFormPlugin)this, personReturnMap.get("dependencytype"), "locationtypelabel", "locationtypelabel1");
        if (!forceRefresh && !ObjectUtils.isEmpty((Object)dataEntity.getDynamicObject("laborreltype"))) {
            RegPageUtils.setBaseLabel((AbstractFormPlugin)this, dataEntity.getDynamicObject("laborreltype").getString("name"), "laborreltypelabel", "laborreltypelabel1");
        } else {
            RegPageUtils.setBaseLabel((AbstractFormPlugin)this, personReturnMap.get("laborreltype"), "laborreltypelabel", "laborreltypelabel1");
            this.getModel().setValue("laborreltype", personReturnMap.get("laborreltype_id"));
        }
        RegPageUtils.setBaseLabel((AbstractFormPlugin)this, personReturnMap.get("laborrelstatus"), "laborrelstatuslabel", "laborrelstatuslabel1");
        RegPageUtils.setIconLabel((AbstractFormPlugin)this, personReturnMap.get("gender"), "genderlabel", "vgender");
        RegPageUtils.setIconLabel((AbstractFormPlugin)this, personReturnMap.get("gender"), "genderlabel1", "vgender1");
        RegPageUtils.setIconLabel((AbstractFormPlugin)this, personReturnMap.get("company"), "companylabel", "vpcompany");
        RegPageUtils.setIconLabel((AbstractFormPlugin)this, personReturnMap.get("company"), "companylabel1", "vpcompany1");
        RegPageUtils.setIconLabel((AbstractFormPlugin)this, personReturnMap.get("adminorg"), "orglabel", "vporg");
        RegPageUtils.setIconLabel((AbstractFormPlugin)this, personReturnMap.get("adminorg"), "orglabel1", "vporg1");
        String posType = (String)personReturnMap.get("apositiontype");
        this.showPosTypeLabel(posType);
        if (forceRefresh) {
            Object position = personReturnMap.get("position");
            Object stdposition = personReturnMap.get("stdposition");
            job = personReturnMap.get("job");
            RegPageUtils.setIconLabel((AbstractFormPlugin)this, position, "postlabel", "vppost");
            RegPageUtils.setIconLabel((AbstractFormPlugin)this, position, "postlabel1", "vppost1");
            this.getModel().setValue("bposition", personReturnMap.get("position_id"));
            RegPageUtils.setIconLabel((AbstractFormPlugin)this, stdposition, "stdpostlabel", "vpstdpost");
            RegPageUtils.setIconLabel((AbstractFormPlugin)this, stdposition, "stdpostlabel1", "vpstdpost1");
            this.getModel().setValue("standardpost", personReturnMap.get("stdposition_id"));
            RegPageUtils.setIconLabel((AbstractFormPlugin)this, job, "joblabel", "vpjob");
            RegPageUtils.setIconLabel((AbstractFormPlugin)this, job, "joblabel1", "vpjob1");
            this.getModel().setValue("bjob", personReturnMap.get("job_id"));
            this.getView().setVisible(Boolean.valueOf(!HRObjectUtils.isEmpty((Object)job)), new String[]{"flexjob", "flexjob1"});
        } else {
            DynamicObject pos = dataEntity.getDynamicObject("bposition");
            DynamicObject stdPos = dataEntity.getDynamicObject("standardpost");
            job = dataEntity.getDynamicObject("bjob");
            if (!ObjectUtils.isEmpty((Object)pos)) {
                RegPageUtils.setIconLabel((AbstractFormPlugin)this, pos.getString("name"), "postlabel", "vppost");
                RegPageUtils.setIconLabel((AbstractFormPlugin)this, pos.getString("name"), "postlabel1", "vppost1");
            }
            if (!ObjectUtils.isEmpty((Object)stdPos)) {
                RegPageUtils.setIconLabel((AbstractFormPlugin)this, stdPos.getString("name"), "stdpostlabel", "vpstdpost");
                RegPageUtils.setIconLabel((AbstractFormPlugin)this, stdPos.getString("name"), "stdpostlabel1", "vpstdpost1");
            }
            if (!ObjectUtils.isEmpty((Object)job)) {
                RegPageUtils.setIconLabel((AbstractFormPlugin)this, job.getString("name"), "joblabel", "vpjob");
                RegPageUtils.setIconLabel((AbstractFormPlugin)this, job.getString("name"), "joblabel1", "vpjob1");
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexjob", "flexjob1"});
            }
        }
        Object superiorInfo = personReturnMap.get("superiorinfo");
        Object chargeInfo = personReturnMap.get("chargeinfo");
        if (ObjectUtils.isEmpty((Object)superiorInfo) && ObjectUtils.isEmpty((Object)chargeInfo)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"superiorandcharge", "superiorandcharge1"});
        }
        if (ObjectUtils.isEmpty((Object)superiorInfo)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"superiorpanel", "superiorpanel1"});
        } else {
            List superiorinfoList = (List)personReturnMap.get("superiorinfo");
            if (CollectionUtils.isEmpty((Collection)superiorinfoList)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexsup"});
            } else {
                this.getModel().deleteEntryData("superiorentry");
                this.getModel().deleteEntryData("superiorentry1");
                this.getModel().batchCreateNewEntryRow("superiorentry", 1);
                this.getModel().batchCreateNewEntryRow("superiorentry1", 1);
                for (i = 0; i < 1; ++i) {
                    RegBaseBillPlugin.setLeaderInfo(this.getView(), (Map)superiorinfoList.get(i), "superiorimage");
                    RegBaseBillPlugin.setLeaderInfo(this.getView(), (Map)superiorinfoList.get(i), "superiorimage1");
                    this.getPageCache().put("superior", JSONObject.toJSONString((Object)superiorinfoList));
                }
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"superiorandcharge", "superiorandcharge1", "superiorpanel", "superiorpanel1"});
        }
        if (ObjectUtils.isEmpty((Object)chargeInfo)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"chargepanel", "chargepanel1"});
        } else {
            List chargeinfoList = (List)personReturnMap.get("chargeinfo");
            if (CollectionUtils.isEmpty((Collection)chargeinfoList)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexcharge"});
            } else {
                this.getModel().deleteEntryData("chargeentry");
                this.getModel().deleteEntryData("chargeentry1");
                this.getModel().batchCreateNewEntryRow("chargeentry", 1);
                this.getModel().batchCreateNewEntryRow("chargeentry1", 1);
                for (i = 0; i < 1; ++i) {
                    RegBaseBillPlugin.setLeaderInfo(this.getView(), (Map)chargeinfoList.get(i), "chargeimage");
                    RegBaseBillPlugin.setLeaderInfo(this.getView(), (Map)chargeinfoList.get(i), "chargeimage1");
                    LOGGER.info("RegBaseBillBlugin====chargge==={}", (Object)JSONObject.toJSONString((Object)chargeinfoList));
                    this.getPageCache().put("charge", JSONObject.toJSONString((Object)chargeinfoList));
                }
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"superiorandcharge", "superiorandcharge1", "chargepanel", "chargepanel1"});
        }
        RegPageUtils.setAvatar((AbstractFormPlugin)this, personReturnMap.get("headsculpture"), "avatar", "avatar1");
        RegPageUtils.setIconLabel((AbstractFormPlugin)this, personReturnMap.get("org"), "bhrbuvalue", "bhrbukey");
        RegPageUtils.setIconLabel((AbstractFormPlugin)this, personReturnMap.get("org"), "bhrbuvalue1", "bhrbukey1");
        RegPageUtils.setIconLabel((AbstractFormPlugin)this, personReturnMap.get("org"), "baffiliateadminorgvalue", "baffiliateadminorgkey");
        RegPageUtils.setIconLabel((AbstractFormPlugin)this, personReturnMap.get("org"), "baffiliateadminorgvalue1", "baffiliateadminorgkey1");
        RegPageUtils.setIconLabel((AbstractFormPlugin)this, personReturnMap.get("empgroup"), "bempgroupvalue", "bempgroupkey");
        RegPageUtils.setIconLabel((AbstractFormPlugin)this, personReturnMap.get("empgroup"), "bempgroupvalue1", "bempgroupkey1");
        this.getView().setVisible(Boolean.TRUE, new String[]{"personinfocard"});
    }

    private void showPosTypeLabel(String posType) {
        if (PosTypeEnum.STD_POS.getCode().equals(posType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexstdpos", "flexstdpos1", "flexjob", "flexjob1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpos", "flexpos1"});
        } else if (PosTypeEnum.POS.getCode().equals(posType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpos", "flexpos1", "flexjob", "flexjob1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexstdpos", "flexstdpos1"});
        } else if (PosTypeEnum.JOB.getCode().equals(posType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexjob", "flexjob1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexstdpos", "flexstdpos1", "flexpos", "flexpos1"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexstdpos", "flexstdpos1", "flexpos", "flexpos1", "flexjob", "flexjob1"});
            LOGGER.error("unexpect value of posType ... ");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name;
        switch (name = beforeF7SelectEvent.getProperty().getName()) {
            case "regcategory": {
                if (ObjectUtils.isEmpty((Object)this.getModel().getValue("regcomment"))) {
                    return;
                }
                Object regComment = ((DynamicObject)this.getModel().getValue("regcomment")).getPkValue();
                QFilter qFilter = new QFilter("group", "=", regComment);
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "ermanfile": {
                if (this.getModel().getValue("org") == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7\u201d\uff0c\u518d\u6dfb\u52a0\u4eba\u5458\u3002", (String)"ParttimeApplyBillEdit_30", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter filter = new QFilter("empentrel.laborrelstatus.labrelstatuscls", "=", (Object)1010L);
                QFilter orgFilter = new QFilter("org", "=", ((DynamicObject)this.getModel().getValue("org")).getPkValue());
                ListShowParameter showParameterErManFileList = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameterErManFileList.getListFilterParameter().setFilter(filter);
                showParameterErManFileList.getListFilterParameter().setFilter(orgFilter);
                break;
            }
            case "laborrelstatus": {
                DynamicObject affaction = this.getModel().getDataEntity().getDynamicObject("affaction");
                if (affaction == null) {
                    return;
                }
                List laborrelstatusList = PersonnelChangeServiceHelper.getLaborrelstatusByAffaction((DynamicObject)affaction);
                if (laborrelstatusList == null || laborrelstatusList.size() <= 0) break;
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "in", (Object)laborrelstatusList));
                break;
            }
        }
    }

    private void setAuditStatusLabelWithColorful(String labelValue) {
        labelValue = IRegProbationService.getInstance().covertRegBillStatusByPostponeAskResult(labelValue, this.getModel().getValue("postponeaskresult"));
        LabelAp statusLabel = RegBillDrawLabelUtil.setAuditStatusLabelWithColorful("lbregstatus", labelValue);
        this.getView().updateControlMetadata(statusLabel.getKey(), statusLabel.createControl());
        this.getView().setVisible(Boolean.TRUE, new String[]{"lbregstatus"});
    }

    private void loadEmptutorInfo(Long employeeId) {
        List tutorList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listEmployeeAttachs", (Object[])new Object[]{employeeId, "hrpi_emptutor"});
        if (!CollectionUtils.isEmpty((Collection)tutorList) && (Long)((Map)tutorList.get(0)).get("tutor_id") != 0L) {
            this.getPageCache().put("tutor", JSONObject.toJSONString((Object)tutorList));
            Map tutor = (Map)tutorList.get(0);
            this.getModel().setValue("tutor", tutor.get("tutor"));
            Long tutorId = (Long)tutor.get("tutor_id");
            DynamicObject ermanfile = (DynamicObject)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getPrimaryErmanfFile", (Object[])new Object[]{tutorId});
            if (!Objects.isNull(ermanfile)) {
                DynamicObject empposorgrel = (DynamicObject)ermanfile.get("empposrel");
                this.getModel().setValue("tutorenterprise", (Object)empposorgrel.getString("company.name"));
                this.getModel().setValue("tutoradminorg", (Object)empposorgrel.getString("adminorg.name"));
                String position = empposorgrel.getString("position.name");
                String stdposition = empposorgrel.getString("stdposition.name");
                this.getModel().setValue("tutorposition", (Object)(StringUtils.isNotEmpty((String)stdposition) ? stdposition : position));
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"paneltutor"});
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)DONOTHING_TERMINATE)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (HRObjectUtils.isEmpty((Object)returnData)) {
                return;
            }
            Map returnMap = (Map)returnData;
            if ("btnok".equals(returnMap.get("source"))) {
                this.getView().invokeOperation("refresh");
                if ("success".equals(returnMap.get("result"))) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u8f6c\u6b63\u6d41\u7a0b\u6210\u529f\u3002", (String)"RegularApplySourceList_13", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u8f6c\u6b63\u6d41\u7a0b\u5931\u8d25\u3002", (String)"RegTermPlugin_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private static void setLeaderInfo(IFormView view, Map<String, Object> leaderInfo, String chargeimage) {
        Image chargeImage = (Image)view.getControl(chargeimage);
        String personHeadImage = (String)leaderInfo.get("headsculpture");
        if (!HRStringUtils.isEmpty((String)personHeadImage) && !personHeadImage.contains("/images/pc/emotion/default_person_82_82.png")) {
            chargeImage.setUrl(HRImageUrlUtil.getImageFullUrl((String)personHeadImage));
        }
    }

    public void beforeShowTips(BeforeShowTipsEvent evt) {
        RegPeronalBillHelper.getInstance().beforeShowTips(evt, this.getView());
    }

    public void afterShowTips(AfterShowTipsEvent afterShowTipsEvent) {
    }

    private void addTipsListener(String key) {
        Image image1;
        IFormView formView = this.getView();
        Image image = (Image)formView.getControl(String.format("%simage", key));
        if (image != null) {
            image.addTipsListener((TipsListener)this);
        }
        if ((image1 = (Image)formView.getControl(String.format("%simage1", key))) != null) {
            image1.addTipsListener((TipsListener)this);
        }
    }
}

