/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.applybill;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.common.parttime.model.ValidateContentDTO;
import kd.hr.hdm.common.reg.enums.RegBillServiceEnum;
import kd.hr.hdm.common.reg.enums.RegBusinessStatusEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hpfs.business.service.cert.HRCertValidateServiceHelper;

public class RegPageUtils {
    public static void setAvatar(AbstractFormPlugin formPlugin, Object avatar, String ... avatarLabel) {
        if (!ObjectUtils.isEmpty((Object)avatar)) {
            for (String label : avatarLabel) {
                Image image = (Image)formPlugin.getControl(label);
                if (image == null) continue;
                image.setUrl(HRImageUrlUtil.getImageFullUrl((String)((String)avatar)));
            }
            formPlugin.getView().setVisible(Boolean.TRUE, avatarLabel);
        }
    }

    public static void setBaseModel(AbstractFormPlugin formPlugin, Object object, String ... names) {
        if (!ObjectUtils.isEmpty((Object)object)) {
            for (String name : names) {
                formPlugin.getView().getModel().setValue(name, object);
            }
            formPlugin.getView().setVisible(Boolean.TRUE, names);
        } else {
            formPlugin.getView().setVisible(Boolean.FALSE, names);
        }
    }

    public static boolean haveLicence(Long personId, IFormView view) {
        String businessMsg = ResManager.loadKDString((String)"\u8f6c\u6b63", (String)"RegPageUtils_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
        return RegPageUtils.haveLicence(personId, view, businessMsg);
    }

    public static boolean haveLicence(Long personId, IFormView view, String businessMsg) {
        String validateMsg = HRCertValidateServiceHelper.getValidataMsg((Long)personId, (String)businessMsg);
        if (StringUtils.isNotEmpty((CharSequence)validateMsg)) {
            view.showErrorNotification(validateMsg);
            return false;
        }
        return true;
    }

    public static void setIconLabel(AbstractFormPlugin formPlugin, Object labelValue, String labelName, String labelICon) {
        if (ObjectUtils.isEmpty((Object)labelValue)) {
            formPlugin.getView().setVisible(Boolean.FALSE, new String[]{labelName, labelICon});
        } else {
            Label label = (Label)formPlugin.getView().getControl(labelName);
            if (label != null) {
                label.setText((String)labelValue);
            }
            formPlugin.getView().setVisible(Boolean.TRUE, new String[]{labelName, labelICon});
        }
    }

    public static void setBaseLabel(AbstractFormPlugin formPlugin, Object object, String ... names) {
        if (!ObjectUtils.isEmpty((Object)object)) {
            for (String name : names) {
                Label label = (Label)formPlugin.getView().getControl(name);
                if (label == null) continue;
                label.setText((String)object);
            }
            formPlugin.getView().setVisible(Boolean.TRUE, names);
        } else {
            formPlugin.getView().setVisible(Boolean.FALSE, names);
        }
    }

    public static boolean showError(Map<String, List<String>> errorMap, BeforeDoOperationEventArgs args, IFormView view) {
        List<String> errList = errorMap.get(RegBillServiceEnum.ERROR.getCode());
        if (!ObjectUtils.isEmpty(errList)) {
            String errorMsg = RegPageUtils.deletePrefix(errList.get(0));
            view.showErrorNotification(errorMsg);
            args.setCancel(true);
            return true;
        }
        return false;
    }

    public static String deletePrefix(String errorMsg) {
        if (StringUtils.isNotEmpty((CharSequence)errorMsg) && errorMsg.length() > 19 && errorMsg.startsWith("REG-")) {
            return errorMsg.substring(19);
        }
        return errorMsg;
    }

    public static void showTerminateConfirm(AbstractFormPlugin plugin, String doNothingTerminate, Object billPkValue) {
        FormShowParameter ShowParameter = new FormShowParameter();
        ShowParameter.setFormId("hdm_regtermconfirm");
        ShowParameter.setCaption(ResManager.loadKDString((String)"\u7ec8\u6b62\u8f6c\u6b63\u6d41\u7a0b", (String)"RegPageUtils_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        ShowParameter.setCustomParam("id", billPkValue);
        ShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, doNothingTerminate));
        ShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        plugin.getView().showForm(ShowParameter);
    }

    public static void showTerminateMsg(IFormView view, String regStatus) {
        view.showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e1a\u52a1\u72b6\u6001\u4e3a\u201c%s\u201d\uff0c\u65e0\u6cd5\u7ec8\u6b62\u6d41\u7a0b\u3002", (String)"RegPageUtils_1", (String)"hr-hdm-formplugin", (Object[])new Object[]{RegBusinessStatusEnum.getName((String)regStatus)}));
    }

    public static boolean showMessageSingle(AbstractFormPlugin plugin, FormOperate operate, Map<String, List<ValidateContentDTO>> validateResultMap) {
        List<ValidateContentDTO> errorValidateContentDTOS = validateResultMap.get(RegBillServiceEnum.ERROR.getCode());
        List<ValidateContentDTO> warnValidateContentDTOS = validateResultMap.get(RegBillServiceEnum.WARNING.getCode());
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(operate.getOperateKey(), (IFormPlugin)plugin);
        if (HRCollUtil.isNotEmpty(errorValidateContentDTOS) && errorValidateContentDTOS.size() == 1) {
            ValidateContentDTO validateContentDTO = errorValidateContentDTOS.get(0);
            String errorMsg = RegPageUtils.deletePrefix(validateContentDTO.getTitle());
            if (HRStringUtils.isEmpty((String)validateContentDTO.getContent())) {
                plugin.getView().showErrorNotification(errorMsg);
            } else {
                plugin.getView().showConfirm(errorMsg, validateContentDTO.getContent(), MessageBoxOptions.OK, ConfirmTypes.Default, confirmCallBacks);
            }
            return false;
        }
        if (HRCollUtil.isNotEmpty(warnValidateContentDTOS) && warnValidateContentDTOS.size() == 1) {
            ValidateContentDTO validateContentDTO = warnValidateContentDTOS.get(0);
            String warnMsg = RegPageUtils.deletePrefix(validateContentDTO.getTitle());
            plugin.getView().showConfirm(warnMsg, validateContentDTO.getContent(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            return false;
        }
        return true;
    }

    public static void validateShowConfirm(AbstractFormPlugin plugin, FormOperate operate, Map<String, List<ValidateContentDTO>> validateResultMap, BeforeDoOperationEventArgs args) {
        if (validateResultMap == null || validateResultMap.size() < 1) {
            return;
        }
        RefObject afterConfirmObj = new RefObject();
        if (!operate.getOption().tryGetVariableValue(operate.getOperateKey(), afterConfirmObj)) {
            boolean isContinue = RegPageUtils.showMessageSingle(plugin, operate, validateResultMap);
            if (!isContinue) {
                args.setCancel(true);
                return;
            }
            List<ValidateContentDTO> errorValidateContentDTOS = validateResultMap.get(RegBillServiceEnum.ERROR.getCode());
            List<ValidateContentDTO> warnValidateContentDTOS = validateResultMap.get(RegBillServiceEnum.WARNING.getCode());
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(operate.getOperateKey(), (IFormPlugin)plugin);
            StringBuilder sb = new StringBuilder();
            if (HRCollUtil.isNotEmpty(errorValidateContentDTOS)) {
                errorValidateContentDTOS.forEach(validateContentDTO -> sb.append(validateContentDTO.getTitle()).append("\r\n"));
                plugin.getView().showConfirm(sb.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, confirmCallBacks);
                args.setCancel(true);
            } else if (HRCollUtil.isNotEmpty(warnValidateContentDTOS)) {
                warnValidateContentDTOS.forEach(validateContentDTO -> sb.append(validateContentDTO.getTitle()).append("\r\n"));
                plugin.getView().showConfirm(sb.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                args.setCancel(true);
            }
        }
    }
}

