/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.applybill;

import java.util.Collection;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.form.control.AttachmentPanel;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegProbationService;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.hdm.common.reg.enums.RegDateUnitEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class RegSelfHelpPlugin
extends AbstractBillPlugIn {
    public void afterLoadData(EventObject e) {
        IRegBillService.getInstance().setLaborrelStatusByRegComment(this.getModel().getDataEntity());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setDefaultProbationUnit();
        this.setVisibleOfButton();
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachment");
        if (attachmentPanel != null && CollectionUtils.isEmpty((Collection)attachmentPanel.getAttachmentData())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"attachment"});
        }
        this.setPostponeProbationVisible();
    }

    private void setPostponeProbationVisible() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"postponeprobation", "postponeprobationunit"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"postponeprobationview"});
        boolean fieldModified = IRegProbationService.getInstance().fieldModifiedOfWorkFlow(this.getView());
        if (fieldModified) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"postponeprobationview"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"postponeprobation", "postponeprobationunit"});
        }
    }

    private void setVisibleOfButton() {
        boolean ifDirect;
        String auditStatus = this.getModel().getDataEntity().getString("billstatus");
        if (!StringUtils.isEmpty((String)auditStatus) && RegBillStatusEnum.APPROVEREJECTED.getCode().equals(auditStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_viewflowchart"});
        }
        if (!(ifDirect = this.getModel().getDataEntity().getBoolean("isdirectregular")) && (RegBillStatusEnum.APPROVEPASSED.getCode().equals(auditStatus) || RegBillStatusEnum.APPROVING.getCode().equals(auditStatus))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_viewflowchart"});
        }
    }

    private void setDefaultProbationUnit() {
        Object value = this.getModel().getValue("probationunitex");
        if (null == value || StringUtils.isEmpty((String)((String)value))) {
            this.getModel().setValue("probationunitex", (Object)RegDateUnitEnum.MONTH.getCode());
        }
    }
}

