/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.applybill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hdm.business.reg.domain.repository.bill.HDMRegBaseBillRepository;
import kd.hr.hdm.business.reg.domain.service.bill.IPersonAboutService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;

public class RegTermPlugin
extends AbstractFormPlugin {
    private static final String KEY_OK = "btnok";
    private static final String KEY_CANCEL = "btncancel";
    private static final Log LOGGER = LogFactory.getLog(RegTermPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_OK});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_OK) && this.validateMustInputAndLength()) {
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("source", KEY_OK);
            Object ids = this.getView().getFormShowParameter().getCustomParams().get("id");
            List<Long> successPkIds = new ArrayList();
            if (ids instanceof List) {
                successPkIds = (List)ids;
            } else if (ids instanceof Long) {
                successPkIds.add((Long)ids);
            }
            ArrayList<Long> terminateWorkFlowId = new ArrayList<Long>();
            DynamicObject[] bills = this.getBillsByPks(successPkIds);
            if (bills == null || bills.length < 1) {
                return;
            }
            for (DynamicObject bill : bills) {
                if (RegBillStatusEnum.APPROVEPASSED.getCode().equals(bill.getString("billstatus")) || !IRegBillService.getInstance().terminateWorkFlow(bill)) continue;
                terminateWorkFlowId.add((Long)bill.getPkValue());
            }
            LOGGER.info("success terminate work flow bills:", terminateWorkFlowId);
            Map validatorMap = IRegBillService.getInstance().terminateBatchValidate(bills);
            if (!validatorMap.isEmpty()) {
                List failIds = validatorMap.entrySet().stream().map(entry -> (List)entry.getValue()).flatMap(Collection::stream).collect(Collectors.toList());
                successPkIds.removeAll(failIds);
                if (successPkIds.isEmpty()) {
                    returnMap.put("result", "fail");
                    LOGGER.error("\u786e\u8ba4\u7ec8\u6b62\u6d41\u7a0b\u4e4b\u540e\u6821\u9a8c\u4e0d\u901a\u8fc7\u7684pks:", failIds);
                    this.getView().returnDataToParent(returnMap);
                    this.getView().close();
                    return;
                }
            }
            String reason = (String)this.getModel().getValue("termreason");
            Date date = new Date();
            long currUserId = RequestContext.get().getCurrUserId();
            ArrayList<DynamicObject> successDys = new ArrayList<DynamicObject>(bills.length);
            for (DynamicObject bill : bills) {
                if (!successPkIds.contains((Long)bill.getPkValue())) continue;
                bill.set("termreason", (Object)reason);
                bill.set("termdate", (Object)date);
                bill.set("termuser", (Object)currUserId);
                bill.set("modifytime", (Object)date);
                successDys.add(bill);
            }
            IRegBillService.getInstance().doBatchTerminateProcess(successDys.toArray(new DynamicObject[successDys.size()]));
            successDys.forEach(dy -> IPersonAboutService.getInstance().syncHPFSAfterTerminate(dy));
            returnMap.put("result", "success");
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        }
    }

    private boolean validateMustInputAndLength() {
        String termReason = String.valueOf(this.getModel().getValue("termreason"));
        if (!StringUtils.isEmpty((CharSequence)termReason) && termReason.length() > 255) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u7ec8\u6b62\u6d41\u7a0b\u539f\u56e0\u201d\u8f93\u5165\u957f\u5ea6\u5e94\u5c0f\u4e8e255\u5b57\u7b26\u3002", (String)"RegTermPlugin_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private DynamicObject[] getBillsByPks(List<Long> successPkIds) {
        String selectProperties = "billstatus,person,org,billno,ermanfile,probation,affaction,probationunit,probationex,probationunitex,auditstatus,regbilltype,billstatus,regstatus,entrydate,effectdate,ismobile,bemployee,regcategory,termreason,termdate,termuser,modifytime,preactualdate,postponeprobation,regcomment";
        return HDMRegBaseBillRepository.getInstance().query(selectProperties, new QFilter[]{new QFilter("id", "in", successPkIds)});
    }
}

