/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.applybill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.PictureProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.EnableCustomSumEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.hr.hdm.business.reg.domain.repository.bill.HDMRegBaseBillRepository;
import kd.hr.hdm.business.reg.validator.RegApplyValidatorHelper;
import kd.hr.hdm.common.reg.constants.RegBillTypeEnum;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.hdm.common.reg.util.RegDirectUtil;
import kd.hr.hdm.formplugin.reg.web.applybill.RegPageUtils;

public class RegularApplySourceList
extends HRCoreBaseBillList {
    private static final Log LOGGER = LogFactory.getLog(RegularApplySourceList.class);

    public void setEnableCustomSum(EnableCustomSumEvent args) {
        super.setEnableCustomSum(args);
        args.setEnableCustomSum(false);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List<String> fixedColumnList = this.initDefaultFixedColumnList();
        fixedColumnList.forEach(column -> args.getListColumn(column).setFixed(true));
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter parameter = e.getParameter();
        DynamicObject bill = HDMRegBaseBillRepository.getInstance().queryOne("regbilltype", new QFilter[]{new QFilter("id", "=", parameter.getPkId())});
        if (bill != null && StringUtils.equals((CharSequence)RegBillTypeEnum.EMP.getStatus(), (CharSequence)bill.getString("regbilltype"))) {
            parameter.setFormId("hdm_regselfhelp_supply");
        }
        if (parameter.getStatus().equals((Object)OperationStatus.ADDNEW)) {
            parameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u8f6c\u6b63\u7533\u8bf7", (String)"RegularApplySourceList_10", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
    }

    protected List<String> initDefaultFixedColumnList() {
        ArrayList<String> fixedColumnList = new ArrayList<String>();
        fixedColumnList.add("person.headsculpture");
        fixedColumnList.add("person.name");
        return fixedColumnList;
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection collection = e.getPageData();
        collection.forEach(temp -> {
            DynamicObject person;
            if (temp.containsProperty("person") && (person = temp.getDynamicObject("person")) != null && StringUtils.isEmpty((CharSequence)person.getString("headsculpture"))) {
                RefEntityType type = (RefEntityType)person.getDataEntityType();
                PictureProp prop = (PictureProp)type.findProperty("headsculpture");
                person.set("headsculpture", (Object)prop.getDefaultImgKey());
            }
        });
    }

    public void packageData(PackageDataEvent event) {
        String key;
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)event.getSource();
        switch (key = columnDesc.getKey()) {
            case "probation": {
                String periodUnit = event.getRowData().getString("probationunit");
                String periodUnitName = RegDirectUtil.getProbationUnit((String)periodUnit);
                String probation = event.getRowData().getString("probation");
                event.setFormatValue((Object)(probation + periodUnitName));
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "unsubmit": {
                if (this.getSelectedRows().size() == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64a4\u9500\u7684\u5355\u636e\u3002", (String)"RegularApplySourceList_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DynamicObject[] bills = this.getBills();
                if (bills.length == 1) {
                    String billStatus = this.getBills()[0].getString("billstatus");
                    if (!RegBillStatusEnum.ALREADYSUBMIT.getCode().equals(billStatus) && !RegBillStatusEnum.APPROVING.getCode().equals(billStatus)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u64a4\u9500\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u63d0\u4ea4\u201d\u201c\u5ba1\u6279\u4e2d\u201d\u7684\u5355\u636e\uff0c\u5f53\u524d\u5355\u636e\u4e3a\u201c%s\u201d\uff0c\u4e0d\u80fd\u64a4\u9500\u3002", (String)"RegularApplySourceList_2", (String)"hr-hdm-formplugin", (Object[])new Object[]{RegBillStatusEnum.getName((String)billStatus)}));
                        args.setCancel(true);
                        return;
                    }
                    this.unSubmitConfirm(args, operate);
                    break;
                }
                if (this.allBillsAuditStatus(bills)) {
                    this.unSubmitConfirm(args, operate);
                    break;
                }
                if (!this.allBillsAuditStatusNotEqBD(bills)) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u64a4\u9500\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u63d0\u4ea4\u201d\u201c\u5ba1\u6279\u4e2d\u201d\u7684\u5355\u636e\u3002", (String)"RegularApplySourceList_4", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            case "submit": {
                this.doBatchValidateRegApplyBills(operate, args);
                break;
            }
            case "delete": {
                this.doBatchValidateDelete(args);
                break;
            }
            case "submiteffectlist": {
                this.checkBusiness(operate, args);
                break;
            }
        }
    }

    private void checkBusiness(FormOperate operate, BeforeDoOperationEventArgs args) {
        LOGGER.info("option is {}", (Object)operate.getOption());
        if (operate.getOption().containsVariable("batchop_completed")) {
            LOGGER.info("already process the data, then pass");
            return;
        }
        DynamicObject[] bills = this.getBills();
        if (bills.length == 0) {
            return;
        }
        List billStatusList = Arrays.stream(bills).map(dy -> dy.getString("billstatus")).filter(billstatus -> !RegBillStatusEnum.TEMPSTORAGE.getCode().equals(billstatus)).collect(Collectors.toList());
        if (billStatusList.size() == bills.length) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u63d0\u4ea4\u5e76\u751f\u6548\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u7684\u5355\u636e\u3002", (String)"RegularApplySourceList_14", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Map resultMap = RegApplyValidatorHelper.regApplyValidate(Arrays.asList(bills), (String)"operate_event", (boolean)true, (boolean)true, (boolean)true);
        if (resultMap.size() == 1) {
            resultMap.values().forEach(validateMap -> RegPageUtils.validateShowConfirm((AbstractFormPlugin)this, operate, validateMap, args));
        }
        if (resultMap.size() > 1) {
            operate.getOption().setVariableValue("regApplyList", "regApplyList");
        }
    }

    private void unSubmitConfirm(BeforeDoOperationEventArgs args, FormOperate operate) {
        RefObject afterConfirm = new RefObject();
        if (!operate.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("unsubmit", (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6570\u636e\u64a4\u9500\u540e\u6d41\u7a0b\u5c06\u56de\u5230\u201c\u6682\u5b58\u201d\u72b6\u6001\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"RegularApplySourceList_3", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            args.setCancel(true);
        }
    }

    private void doBatchValidateDelete(BeforeDoOperationEventArgs args) {
        DynamicObject[] bills = this.getBills();
        if (bills.length == 0) {
            return;
        }
        for (DynamicObject regBill : bills) {
            String billStatus = regBill.getString("billstatus");
            if (RegBillStatusEnum.TEMPSTORAGE.getCode().equals(billStatus)) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5220\u9664\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u7684\u5355\u636e\u3002", (String)"RegularApplySourceList_9", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    private void doBatchValidateRegApplyBills(FormOperate operate, BeforeDoOperationEventArgs args) {
        DynamicObject[] bills = this.getBills();
        if (bills.length == 0) {
            return;
        }
        Map resultMap = RegApplyValidatorHelper.regApplyValidate(Arrays.asList(bills), (String)"operate_event", (boolean)true, (boolean)true, (boolean)true);
        if (resultMap.size() == 1) {
            resultMap.values().forEach(validateMap -> RegPageUtils.validateShowConfirm((AbstractFormPlugin)this, operate, validateMap, args));
        }
        if (resultMap.size() > 1) {
            operate.getOption().setVariableValue("regApplyList", "regApplyList");
        }
    }

    private boolean allBillsAuditStatusNotEqBD(DynamicObject[] bills) {
        for (DynamicObject bill : bills) {
            if (!RegBillStatusEnum.ALREADYSUBMIT.getCode().equals(bill.getString("billstatus")) && !RegBillStatusEnum.APPROVING.getCode().equals(bill.getString("billstatus"))) continue;
            return false;
        }
        return true;
    }

    private boolean allBillsAuditStatus(DynamicObject[] bills) {
        for (DynamicObject bill : bills) {
            if (RegBillStatusEnum.ALREADYSUBMIT.getCode().equals(bill.getString("billstatus")) || RegBillStatusEnum.APPROVING.getCode().equals(bill.getString("billstatus"))) continue;
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (null == operationResult || !operationResult.isSuccess()) {
            return;
        }
        switch (args.getOperateKey()) {
            case "new": {
                this.showPage("hdm_regbasebill", ResManager.loadKDString((String)"\u65b0\u589e\u8f6c\u6b63\u7533\u8bf7", (String)"RegularApplySourceList_6", (String)"hr-hdm-formplugin", (Object[])new Object[0]), "2");
                break;
            }
            case "submit": {
                this.getView().invokeOperation("refresh");
                this.getView().sendFormAction(this.getView());
                break;
            }
        }
    }

    private DynamicObject[] getBills() {
        Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
        String selectProperties = "billstatus,person,org,billno,ermanfile,probation,affaction,probationunit,probationex,probationunitex,auditstatus,regbilltype,billstatus,regstatus,entrydate,effectdate,ismobile,bemployee,regcategory,termreason,termdate,termuser,modifytime,preactualdate,postponeprobation,regcomment";
        DynamicObject[] regBills = HDMRegBaseBillRepository.getInstance().query(selectProperties, new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
        return regBills;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"unsubmit", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
            this.getView().invokeOperation("unsubmit", operateOption);
        }
        if ((StringUtils.equals((CharSequence)"submit", (CharSequence)(callBackId = messageBoxClosedEvent.getCallBackId())) || StringUtils.equals((CharSequence)"submiteffectlist", (CharSequence)callBackId)) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(callBackId, "true");
            operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
            this.getView().invokeOperation(callBackId, operateOption);
        }
    }

    private void showPage(String pageKey, String caption, String billType) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId(pageKey);
        billShowParameter.setCaption(caption);
        billShowParameter.setCustomParam("regbilltype", (Object)billType);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        QFilter batchRegFilter = new QFilter("mid", "=", (Object)0L);
        setFilterEvent.getQFilters().add(batchRegFilter);
        setFilterEvent.setOrderBy("modifytime desc , regstatus asc , preactualdate desc");
    }

    public void afterExportFile(ExportFileEvent e) {
        String format = HRDateTimeUtils.format((Date)new Date(), (String)"MMdd");
        e.setFileName(ResManager.loadKDString((String)"\u5bfc\u51fa\u5217\u8868_\u8f6c\u6b63\u7533\u8bf7\u5355_%s", (String)"RegularApplySourceList_7", (String)"hr-hdm-formplugin", (Object[])new Object[]{format}));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        BillShowParameter billShowParameter = new BillShowParameter();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        ListSelectedRow listSelectedRow = selectedRows.get(0);
        Object primaryKey = listSelectedRow.getPrimaryKeyValue();
        DynamicObject currentBill = HDMRegBaseBillRepository.getInstance().queryOne(primaryKey);
        String billType = currentBill.getString("regbilltype");
        if (RegBillTypeEnum.EMP.getStatus().equals(billType)) {
            billShowParameter.setFormId("hdm_regselfhelp_supply");
        } else {
            billShowParameter.setFormId("hdm_regbasebill");
        }
        billShowParameter.setPkId(billList.getFocusRowPkId());
        billShowParameter.setCustomParam("list", (Object)"list");
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }
}

