/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.applybill;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.service.hrpi.IHRPIService;
import kd.hr.hdm.business.domain.transfer.entity.ValidateContext;
import kd.hr.hdm.business.reg.RegProcessServiceHelper;
import kd.hr.hdm.business.reg.domain.service.bill.IPersonAboutService;
import kd.hr.hdm.business.reg.domain.service.validate.IBatchRegApplyValidateService;
import kd.hr.hdm.business.reg.validator.BatchRegValidateWrapper;
import kd.hr.hdm.common.reg.constants.RegBillTypeEnum;
import kd.hr.hdm.common.reg.enums.RegDateUnitEnum;
import kd.hr.hdm.common.reg.util.RegStatusUtil;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;
import kd.hr.hdm.common.transfer.util.TransferPageUtil;
import kd.hr.hdm.formplugin.reg.web.applybill.RegPageUtils;
import kd.hr.hdm.formplugin.reg.web.applybill.RegularValidatUtils;
import kd.sdk.hr.hspm.common.utils.QFilterUtil;
import org.apache.commons.lang3.time.StopWatch;

public class RegularBaseUtils {
    private static final Log LOGGER = LogFactory.getLog(RegularBaseUtils.class);

    private RegularBaseUtils() {
    }

    public static Map<String, Object> getFocusRowId(Long rowId) {
        Map erManFile = (Map)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getErmanfile", (Object[])new Object[]{rowId});
        HashMap<String, Object> customParamMap = new HashMap<String, Object>(16);
        if (erManFile != null) {
            String regStatus = RegProcessServiceHelper.getRegStatusByEmployee((Long)((Long)erManFile.get("employee_id")));
            customParamMap.put("person", erManFile.get("person_id"));
            customParamMap.put("employee", erManFile.get("employee_id"));
            customParamMap.put("depemp", erManFile.get("depemp_id"));
            customParamMap.put("empposrel", erManFile.get("empposrel_id"));
            customParamMap.put("ermanfile", erManFile.get("id"));
            customParamMap.put("empentrelid", erManFile.get("empentrel_id"));
            customParamMap.put("person.number", erManFile.get("number"));
            customParamMap.put("person_name", erManFile.get("name"));
            customParamMap.put("regstatus", regStatus);
        }
        return customParamMap;
    }

    public static void btnRegApply(AbstractFormPlugin plugin, long ermanfileId) {
        String pageKey = "hdm_regbasebill";
        Map<String, Object> focusRowMap = RegularBaseUtils.getFocusRowId(ermanfileId);
        if (!RegPageUtils.haveLicence((Long)focusRowMap.get("person"), plugin.getView())) {
            return;
        }
        RegularValidatUtils.validatEmployeeForList(focusRowMap);
        RegularBaseUtils.showRegBillPage(focusRowMap, plugin, pageKey, RegBillTypeEnum.HR.getStatus());
    }

    public static void batchRegApply(AbstractFormPlugin plugin) {
        RegularValidatUtils.checkIsSelect(plugin);
        IListView listView = (IListView)plugin.getView();
        ListSelectedRowCollection listSelectedData = listView.getSelectedRows();
        if (listSelectedData.size() == 1) {
            String pageKey = "hdm_regbasebill";
            Map<String, Object> focusRowMap = RegularBaseUtils.getFocusRowId((Long)listView.getFocusRowPkId());
            if (!RegPageUtils.haveLicence((Long)focusRowMap.get("person"), plugin.getView())) {
                return;
            }
            RegularValidatUtils.validatEmployeeForList(focusRowMap);
            RegularBaseUtils.showRegBillPage(focusRowMap, plugin, pageKey, RegBillTypeEnum.HR.getStatus());
        } else {
            StopWatch stopWatch = new StopWatch("batchRegApply");
            stopWatch.start();
            Object[] primaryKeyValues = listSelectedData.getPrimaryKeyValues();
            List<Map<String, Object>> ermanFiles = RegularBaseUtils.buildErmanFileDTO(primaryKeyValues);
            List batchRegValidateWrappers = BatchRegValidateWrapper.genBatchRegValidateWrapper(ermanFiles);
            boolean orgIsSame = IBatchRegApplyValidateService.getInstance().validateMainOrg().test(batchRegValidateWrappers);
            if (!orgIsSame) {
                plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u60f3\u9009\u62e9\u540c\u4e00\u201c\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7\u201d\u7684\u4eba\u5458\u53d1\u8d77\u6279\u91cf\u8f6c\u6b63\u7533\u8bf7\u3002", (String)"RegularBaseUtils_10", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                return;
            }
            List employeeIds = batchRegValidateWrappers.stream().map(temp -> (Long)temp.getData().getErmanfileMap().get("employee_id")).collect(Collectors.toList());
            List employeeAttachInfo = IPersonAboutService.getInstance().batchBuildRegInfo(employeeIds);
            BatchRegValidateWrapper.matchEmployeeAttachInfo((List)employeeAttachInfo).accept(batchRegValidateWrappers);
            IBatchRegApplyValidateService.getInstance().batchRegValidate().test(batchRegValidateWrappers);
            RegularBaseUtils.showRegConfirm(plugin, batchRegValidateWrappers, "hdm_batchregmulconfirm");
            stopWatch.stop();
            LOGGER.info("batchRegApply validate finish ,cost time :{}", (Object)stopWatch.getNanoTime());
        }
    }

    private static List<Map<String, Object>> buildErmanFileDTO(Object[] ermanFileIds) {
        String properties = "id,name,org,affiliateadminorg,empgroup,empposrel,person,employee,cmpemp,dependencytype,empentrel";
        QFilter qFilter = new QFilter("id", "in", (Object)ermanFileIds);
        qFilter.and(QFilterUtil.getInitStatusFinish());
        DynamicObject[] ermanFiles = IHRPIService.getInstance().listFieldsFilterInfo(properties, qFilter, "hspm_ermanfile");
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(ermanFiles.length);
        for (DynamicObject ermanFile : ermanFiles) {
            HashMap<String, Object> map = new HashMap<String, Object>(32);
            map.put("id", ermanFile.getLong("id"));
            map.put("name", ermanFile.getString("name"));
            map.put("org_id", ermanFile.getLong("org.id"));
            map.put("affiliateadminorg_id", ermanFile.getLong("affiliateadminorg.id"));
            map.put("empgroup_id", ermanFile.getLong("empgroup.id"));
            map.put("adminorg_id", ermanFile.getLong("empposrel.adminorg.id"));
            map.put("person_id", ermanFile.getLong("person.id"));
            map.put("employee_id", ermanFile.getLong("employee.id"));
            map.put("managingscope_id", ermanFile.getLong("cmpemp.managingscope.id"));
            map.put("position_id", ermanFile.getLong("empposrel.position.id"));
            map.put("stdposition_id", ermanFile.getLong("empposrel.stdposition.id"));
            map.put("job_id", ermanFile.getLong("empposrel.job.id"));
            map.put("laborreltype_id", ermanFile.getLong("empentrel.laborreltype.id"));
            map.put("dependencytype_id", ermanFile.getLong("dependencytype.id"));
            result.add(map);
        }
        return result;
    }

    private static void showRegConfirm(AbstractFormPlugin plugin, List<BatchRegValidateWrapper> batchRegValidateWrappers, String confirmPageId) {
        ArrayList<BatchRegValidateWrapper> errors = new ArrayList<BatchRegValidateWrapper>(batchRegValidateWrappers.size());
        boolean index = false;
        for (BatchRegValidateWrapper batchRegValidateWrapper : batchRegValidateWrappers) {
            if (batchRegValidateWrapper.getValidateContext().getValidateResult().size() <= 0) continue;
            errors.add(batchRegValidateWrapper);
        }
        if (errors.size() == 0) {
            List leagal = batchRegValidateWrappers.stream().filter(temp -> temp.getValidateContext().getValidateResult().size() < 1).collect(Collectors.toList());
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("data", leagal);
            params.put("isAdd", false);
            String caption = ResManager.loadKDString((String)"\u65b0\u589e\u6279\u91cf\u8f6c\u6b63\u7533\u8bf7", (String)"BatchRegList_4", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
            TransferPageUtil.showBillPage((IFormView)plugin.getView(), (String)"hdm_batchregbill", params, (Object)"", (String)caption);
            return;
        }
        RegularBaseUtils.showMulCommitConfirmPage(plugin, batchRegValidateWrappers, confirmPageId, errors);
    }

    public static void showMulCommitConfirmPage(AbstractFormPlugin plugin, List<BatchRegValidateWrapper> batchRegValidateWrappers, String confirmPageId, List<BatchRegValidateWrapper> errorlog) {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("sumlabel", batchRegValidateWrappers.size());
        params.put("incongruentlabel", errorlog.size());
        params.put("coincidentlabel", batchRegValidateWrappers.size() - errorlog.size());
        params.put("filename", String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e_\u6279\u91cf\u8f6c\u6b63\u7533\u8bf7\u64cd\u4f5c\u53cd\u9988_%s", (String)"", (String)"hr-hdm-formplugin", (Object[])new Object[0]), TransferCommonUtil.formatDate1.apply(new Date())));
        params.put("headDataList", RegularBaseUtils.initCommitConfirmExcelHead());
        params.put("exportDataList", RegularBaseUtils.initCommitConfirmExportData(batchRegValidateWrappers, confirmPageId));
        List leagal = batchRegValidateWrappers.stream().filter(temp -> temp.getValidateContext().getValidateResult().size() < 1).collect(Collectors.toList());
        params.put("data", leagal);
        TransferPageUtil.showModalWithCloseCallback((AbstractFormPlugin)plugin, (String)confirmPageId, params, (String)"hdm_batchregmulconfirm");
    }

    public static List<HRExportHeadObject> initCommitConfirmExcelHead() {
        ArrayList<HRExportHeadObject> headObjectList = new ArrayList<HRExportHeadObject>();
        headObjectList.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"RegularBaseUtils_0", (String)"hr-hdm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("person.number", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"RegularBaseUtils_1", (String)"hr-hdm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("entrydate", ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f", (String)"RegularBaseUtils_2", (String)"hr-hdm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("probation", ResManager.loadKDString((String)"\u8bd5\u7528\u671f", (String)"RegularBaseUtils_3", (String)"hr-hdm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("preactualdate", ResManager.loadKDString((String)"\u9884\u8f6c\u6b63\u65e5\u671f", (String)"RegularBaseUtils_4", (String)"hr-hdm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("regstatus", ResManager.loadKDString((String)"\u8f6c\u6b63\u72b6\u6001", (String)"RegularBaseUtils_5", (String)"hr-hdm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("validateResult", ResManager.loadKDString((String)"\u6821\u9a8c\u7ed3\u679c", (String)"RegularBaseUtils_6", (String)"hr-hdm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("validateDescription", ResManager.loadKDString((String)"\u6821\u9a8c\u8bf4\u660e", (String)"RegularBaseUtils_7", (String)"hr-hdm-business", (Object[])new Object[0])));
        return headObjectList;
    }

    public static List<Map<String, Object>> initCommitConfirmExportData(List<BatchRegValidateWrapper> batchRegValidateWrappers, String confirmPageId) {
        ArrayList exportDataList = Lists.newArrayListWithExpectedSize((int)(batchRegValidateWrappers.size() << 1));
        for (int index = 0; index < batchRegValidateWrappers.size(); ++index) {
            HashMap exportData = Maps.newHashMapWithExpectedSize((int)16);
            Map ermanfileMap = batchRegValidateWrappers.get(index).getData().getErmanfileMap();
            Map employeeAttachInfo = batchRegValidateWrappers.get(index).getData().getEmployeeAttachInfo();
            exportData.put("name", ermanfileMap.get("name"));
            exportData.put("person.number", ermanfileMap.get("number"));
            exportData.put("entrydate", TransferCommonUtil.formatDate.apply((Date)employeeAttachInfo.get("startdate")));
            exportData.put("probation", (Integer)employeeAttachInfo.get("probation") + RegDateUnitEnum.getName((String)((String)employeeAttachInfo.get("probationunit"))));
            exportData.put("preactualdate", TransferCommonUtil.formatDate.apply((Date)employeeAttachInfo.get("preregulardate")));
            exportData.put("regstatus", employeeAttachInfo.get("regstatus").equals("") ? ResManager.loadKDString((String)"\u5f85\u8f6c\u6b63", (String)"RegularBaseUtils_11", (String)"hr-hdm-formplugin", (Object[])new Object[0]) : RegStatusUtil.getRegStatusDesc((String)((String)employeeAttachInfo.get("regstatus"))));
            ValidateContext validateContext = batchRegValidateWrappers.get(index).getValidateContext();
            String level = validateContext.getResultLevel();
            if ("1".equals(level)) {
                exportData.put("validateResult", ResManager.loadKDString((String)"\u5931\u8d25", (String)"RegularBaseUtils_13", (String)"hr-hdm-business", (Object[])new Object[0]));
                exportData.put("validateDescription", validateContext.map2String());
            } else {
                exportData.put("validateResult", ResManager.loadKDString((String)"\u6210\u529f", (String)"RegularBaseUtils_12", (String)"hr-hdm-business", (Object[])new Object[0]));
            }
            exportDataList.add(exportData);
        }
        return exportDataList;
    }

    public static List<Map<String, Object>> getProxyMap(List<Map<String, Object>> maps) {
        return maps;
    }

    public static IListView listParameterShow(AbstractFormPlugin plugin, String targetKey, String billFormId, String condition, QFilter qFilter) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.getOpenStyle().setTargetKey(targetKey);
        listShowParameter.setFormId("hdm_cardviewtpl");
        listShowParameter.setBillFormId(billFormId);
        if ("hdm_regevent".equals(billFormId)) {
            listShowParameter.setHasRight(true);
        }
        HashMap<String, String> paramMap = new HashMap<String, String>(16);
        paramMap.put("params", condition);
        listShowParameter.setCustomParams(paramMap);
        if (null != qFilter) {
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            listFilterParameter.setFilter(qFilter);
            listShowParameter.setListFilterParameter(listFilterParameter);
        }
        plugin.getView().showForm((FormShowParameter)listShowParameter);
        return (IListView)plugin.getView().getView(listShowParameter.getPageId());
    }

    public static IFormView showPage(AbstractFormPlugin plugin, String targetKey, String formId, Long personId, Long employeeId) {
        FormShowParameter showParameter = RegularBaseUtils.buildFormShowParameter(targetKey, formId, personId, employeeId);
        plugin.getView().showForm(showParameter);
        return plugin.getView().getView(showParameter.getPageId());
    }

    private static FormShowParameter buildFormShowParameter(String targetKey, String formId, Long personId, Long employeeId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setFormId(formId);
        showParameter.setCustomParam("person", (Object)personId);
        showParameter.setCustomParam("employee", (Object)employeeId);
        showParameter.setCustomParam("billlistap", (Object)"regApplyBill");
        return showParameter;
    }

    public static IFormView showPageNoAuth(AbstractFormPlugin plugin, String targetKey, String formId, Long personId, Long employeeId) {
        FormShowParameter showParameter = RegularBaseUtils.buildFormShowParameter(targetKey, formId, personId, employeeId);
        showParameter.setHasRight(true);
        plugin.getView().showForm(showParameter);
        return plugin.getView().getView(showParameter.getPageId());
    }

    public static void setAskOrExamHidden(AbstractFormPlugin plugin, String pageId) {
        IFormView view;
        String customParamStr = (String)plugin.getView().getFormShowParameter().getCustomParam("billlistap");
        if (!HRStringUtils.isEmpty((String)customParamStr) && HRStringUtils.equals((String)"regApplyBill", (String)customParamStr) && null != (view = plugin.getView().getView(pageId))) {
            view.setVisible(Boolean.FALSE, new String[]{"log", "flexpanelap"});
            plugin.getView().setVisible(Boolean.FALSE, new String[]{"btn_updateview"});
            plugin.getView().sendFormAction(view);
        }
    }

    public static void showRegBillPage(Map<String, Object> focusRowMap, AbstractFormPlugin plugin, String pageKey, String billType) {
        String name = (String)focusRowMap.get("person_name");
        String caption = null;
        if (RegBillTypeEnum.HR.getStatus().equals(billType)) {
            caption = ResManager.loadKDString((String)"\u8f6c\u6b63\u7533\u8bf7 - %s", (String)"RegularBaseUtils_8", (String)"hr-hdm-formplugin", (Object[])new Object[]{name});
        } else if (RegBillTypeEnum.QUICKSINGLE.getStatus().equals(billType)) {
            caption = ResManager.loadKDString((String)"\u5feb\u901f\u8f6c\u6b63 - %s", (String)"RegularBaseUtils_9", (String)"hr-hdm-formplugin", (Object[])new Object[]{name});
        }
        ArrayList<Long> personList = new ArrayList<Long>();
        ArrayList<Long> employeeList = new ArrayList<Long>();
        personList.add((Long)focusRowMap.get("person"));
        employeeList.add((Long)focusRowMap.get("employee"));
        HashMap<String, Object> customParamMap = new HashMap<String, Object>(16);
        customParamMap.put("person", personList);
        customParamMap.put("employee", employeeList);
        customParamMap.put("ermanfile", focusRowMap.get("ermanfile"));
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId(pageKey);
        billShowParameter.setCustomParams(customParamMap);
        billShowParameter.setCustomParam("regbilltype", (Object)billType);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setCaption(caption);
        billShowParameter.setCustomParam("reg_apply_source_other_tag", (Object)"reg_apply_source_other_tag");
        plugin.getView().showForm((FormShowParameter)billShowParameter);
    }
}

