/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.applybill;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.LabelAp;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.common.PermissionValidateUtil;
import kd.hr.hdm.business.reg.RegDetailInfoHelper;
import kd.hr.hdm.business.reg.RegPeronalBillHelper;
import kd.hr.hdm.business.reg.domain.exteral.IRegBillCodeService;
import kd.hr.hdm.business.reg.domain.service.bill.IPersonAboutService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegInitService;
import kd.hr.hdm.common.parttime.entity.DataValidate;
import kd.hr.hdm.common.parttime.entity.DataValidateBuilder;
import kd.hr.hdm.common.parttime.enums.ValidateRangeEnum;
import kd.hr.hdm.common.reg.constants.LabRelConstants;
import kd.hr.hdm.common.reg.constants.RegBillTypeEnum;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.hdm.common.reg.enums.RegBusinessStatusEnum;
import kd.hr.hdm.common.reg.enums.RegCategoryEnum;
import kd.hr.hdm.common.reg.enums.RegCommentEnum;
import kd.hr.hdm.common.reg.enums.RegDateUnitEnum;
import kd.hr.hdm.common.reg.enums.RegNewAuditStatusEnum;
import kd.hr.hdm.common.reg.enums.RegTypeEnum;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;
import kd.hr.hdm.formplugin.reg.common.ProbationKeyEventService;
import kd.hr.hdm.formplugin.reg.web.applybill.RegPageUtils;
import kd.hr.hdm.formplugin.reg.web.tools.RegBillDrawLabelUtil;

public class WebRegSelfHelpPlugin
extends AbstractBillPlugIn {
    private static final Log LOGGER = LogFactory.getLog(WebRegSelfHelpPlugin.class);
    private static final String IMAGE_KEY = "agreeregimage";
    private static final String REG_STATUS_REMARK = "lbregstatusremark";
    private static final String REG_UNIQUE_VALIDATE_ERROR_MSG = "errorMsg";
    private static final String REG_ON_THE_WAY = "on_the_way";
    private static final String REG_ON_THE_WAY_BY_HR = "on_the_way_by_hr";
    private static final String REG_ON_THE_WAY_BY_SELF = "on_the_way_by_self";
    private static final String REG_VALIDATE_CALL_BACK_ID = "reg_self_validate_bullet_frame";
    private static final String SELF_SUBMIT_TIP_CLOSE_BACK_ID = "self_submit_tip_close_back_id";
    private static final String HSSC_APP_ID = "hssc";
    private static final String CHECK_RIGHT_APP_ID = "checkRightAppId";
    private static final String REG_SELECT_FIELDS = "id,billno,auditstatus,billstatus,regbilltype,regcategory,isviewflow,regstatus";
    private static final String KEYEVENT_TAP = "keyeventap";
    private static final String LBL_ADD = "lbl_add";
    private static final String TOOLBARAP_KEYEVENT = "toolbarap_keyevent";
    private static final String BAR_ADDKEYEVENT = "bar_addkeyevent";
    private static final String REG_EVENT_ADD_CLOSE_BACK_ID = "reg_event_add_close_back_id";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBARAP_KEYEVENT});
        this.addClickListeners(new String[]{LBL_ADD});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (LBL_ADD.equals(key)) {
            this.openKeyEvent();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (BAR_ADDKEYEVENT.equals(itemKey)) {
            this.openKeyEvent();
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        BillShowParameter parameter = (BillShowParameter)e.getSource();
        parameter.setCustomParam(CHECK_RIGHT_APP_ID, (Object)HSSC_APP_ID);
        if (!"hdm_regselfhelpbill".equals(parameter.getFormId())) {
            return;
        }
        boolean isFromWorkFlow = this.isFromWorkFlow(parameter);
        if (isFromWorkFlow) {
            parameter.setCustomParam(REG_ON_THE_WAY_BY_HR, (Object)REG_ON_THE_WAY_BY_SELF);
            return;
        }
        DynamicObject ermanDynamicObject = IRegInitService.getInstance().getErmanFileBySysId();
        if (ermanDynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4eba\u5458\u6863\u6848\u4fe1\u606f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WebRegSelfHelpPlugin_8", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
        String title = ResManager.loadKDString((String)"\u65b0\u589e\u8f6c\u6b63\u7533\u8bf7", (String)"WebRegSelfHelpPlugin_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
        DataValidate<DynamicObject> dataValidate = this.validateBillInProcess(ermanDynamicObject);
        if (dataValidate != null) {
            parameter.setCustomParam(REG_ON_THE_WAY, (Object)REG_ON_THE_WAY);
            ValidateRangeEnum range = dataValidate.getValidatorContext().getRange();
            if (ValidateRangeEnum.VALIDATE_PASS == range) {
                parameter.setStatus(OperationStatus.VIEW);
                DynamicObject regBillDynamicObject = (DynamicObject)dataValidate.getData();
                parameter.setPkId((Object)regBillDynamicObject.getLong("id"));
                parameter.setCustomParam(REG_ON_THE_WAY_BY_HR, (Object)REG_ON_THE_WAY_BY_SELF);
                String regBillType = regBillDynamicObject.getString("regbilltype");
                if (!RegBillTypeEnum.EMP.getStatus().equals(regBillType)) {
                    parameter.setCustomParam(REG_ON_THE_WAY_BY_HR, (Object)REG_ON_THE_WAY_BY_HR);
                }
            } else {
                parameter.setStatus(OperationStatus.ADDNEW);
                parameter.setCustomParam(REG_UNIQUE_VALIDATE_ERROR_MSG, (Object)dataValidate.getValidatorContext().map2String());
            }
            title = ResManager.loadKDString((String)"\u8f6c\u6b63\u7533\u8bf7 - %s", (String)"WebRegSelfHelpPlugin_9", (String)"hr-hdm-formplugin", (Object[])new Object[]{ermanDynamicObject.getString("person.name")});
        }
        parameter.setCaption(title);
    }

    private boolean isFromWorkFlow(BillShowParameter parameter) {
        Object scene = parameter.getCustomParam("SCENE");
        return scene != null;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        OperationResult operationResult = e.getOperationResult();
        if (null != operationResult && operationResult.isSuccess() && ("save_self_pc".equals(operateKey = e.getOperateKey()) || "selfsubmit".equals(operateKey))) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
            this.getView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView());
            this.selfSubmitTip(operateKey, operationResult);
        }
    }

    private void selfSubmitTip(String operateKey, OperationResult operationResult) {
        if ("selfsubmit".equals(operateKey)) {
            operationResult.setShowMessage(false);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("hdm_reg_self_submited_pc");
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SELF_SUBMIT_TIP_CLOSE_BACK_ID));
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (SELF_SUBMIT_TIP_CLOSE_BACK_ID.equals(actionId)) {
            String personName = this.getModel().getDataEntity().getString("ermanfile.person.name");
            this.getView().setFormTitle(new LocaleString(ResManager.loadKDString((String)"\u8f6c\u6b63\u7533\u8bf7 - %s", (String)"WebRegSelfHelpPlugin_9", (String)"hr-hdm-formplugin", (Object[])new Object[]{personName})));
            this.getView().invokeOperation("refresh");
        }
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)REG_EVENT_ADD_CLOSE_BACK_ID)) {
            this.loadKeyEventPanel();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save_self_pc".equals(operateKey) || "selfsubmit".equals(operateKey)) {
            this.setRegInfoOfWaitRepeatSubmit();
        }
    }

    private void setRegInfoOfWaitRepeatSubmit() {
        DynamicObject regBillDynamicObject = this.getModel().getDataEntity();
        String billStatus = regBillDynamicObject.getString("billstatus");
        if (RegBillStatusEnum.WAITRESUBMIT.getCode().equals(billStatus)) {
            regBillDynamicObject.set("regcomment_id", (Object)RegCommentEnum.AGREE.getId());
            regBillDynamicObject.set("effectdate", (Object)regBillDynamicObject.getDate("preactualdate"));
            this.buildRegCategory(regBillDynamicObject);
            this.getModel().setDataChanged(false);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.changeMetaBillStatusFromMessageCenter();
        this.setVisibleControl();
        this.setImageRemark();
        this.setAuditStatusLabelWithColorful(this.getModel().getDataEntity().getString("billstatus"));
        this.buildProbationText();
        this.setTutor();
        this.loadKeyEventPanel();
        this.setBermanFile();
    }

    private void setBermanFile() {
        if (HRObjectUtils.isEmpty((Object)this.getModel().getValue("b_ermanfile"))) {
            this.getModel().setValue("b_ermanfile", this.getModel().getValue("ermanfile"));
        }
    }

    private void setTutor() {
        IDataModel model = this.getModel();
        long employeeId = this.getModel().getDataEntity().getLong("ermanfile.employee.id");
        List tutorList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listEmployeeAttachs", (Object[])new Object[]{employeeId, "hrpi_emptutor"});
        if (tutorList == null || tutorList.size() < 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"paneltutor"});
            return;
        }
        Long tutorId = (Long)((Map)tutorList.get(0)).get("tutor_id");
        DynamicObject ermanfile = (DynamicObject)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getPrimaryErmanfFile", (Object[])new Object[]{tutorId});
        if (ermanfile == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"paneltutor"});
            return;
        }
        DynamicObject person = ermanfile.getDynamicObject("person");
        DynamicObject empposorgrel = (DynamicObject)ermanfile.get("empposrel");
        String position = empposorgrel.getString("position.name");
        String stdPosition = empposorgrel.getString("stdposition.name");
        model.setValue("tutor", (Object)person.getString("name"));
        model.setValue("tutorenterprise", (Object)empposorgrel.getString("company.name"));
        model.setValue("tutoradminorg", (Object)empposorgrel.getString("adminorg.name"));
        model.setValue("tutorposition", (Object)(position == null ? stdPosition : position));
    }

    private void changeMetaBillStatusFromMessageCenter() {
        boolean auditView = TransferCommonUtil.isAuditView((IFormView)this.getView());
        if (auditView) {
            String billStatus = this.getModel().getDataEntity().getString("billstatus");
            String formId = this.getView().getFormShowParameter().getFormId();
            if (RegBillStatusEnum.WAITRESUBMIT.getCode().equals(billStatus) && "hdm_regselfhelpbill".equals(formId)) {
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
            }
        }
    }

    private void buildProbationText() {
        Integer value = (Integer)this.getModel().getValue("probation");
        Object unit = this.getModel().getValue("probationunit");
        if (unit != null) {
            String name = RegDateUnitEnum.getName((String)((String)unit));
            this.getModel().setValue("probationtext", (Object)(value + name));
        }
    }

    public void createNewData(BizDataEventArgs e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object regOnTheWay = parameter.getCustomParam(REG_ON_THE_WAY);
        if (regOnTheWay != null) {
            return;
        }
        BillEntityType type = (BillEntityType)this.getModel().getDataEntityType();
        DynamicObject newData = (DynamicObject)type.createInstance();
        e.setDataEntity((Object)newData);
        DynamicObject ermanDynamicObject = IRegInitService.getInstance().getErmanFileBySysId();
        IRegInitService.getInstance().initDynamicObjectByErmanFile(newData, ermanDynamicObject);
        this.setOtherField(newData);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (REG_VALIDATE_CALL_BACK_ID.equals(callBackId) && MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().close();
        }
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("hdm_regselfhelpbill".equals(formId)) {
            DynamicObject ermanFileDynamicObject = this.getModel().getDataEntity().getDynamicObject("ermanfile");
            this.setControlOfHRApply();
            this.validateRegSelfApply(ermanFileDynamicObject);
            boolean validated = this.regValidateTips();
            if (validated) {
                this.clearRegInfo();
            }
        }
    }

    private void clearRegInfo() {
        ((IBillView)this.getView()).setBillStatus(BillOperationStatus.ADDNEW);
        IDataModel model = this.getModel();
        model.setValue("id", null);
        model.setValue("billstatus", (Object)RegBillStatusEnum.TEMPSTORAGE.getCode());
        model.setValue("entrydate", null);
        model.setValue("probation", null);
        model.setValue("probationunit", null);
        model.setValue("preactualdate", null);
        model.setValue("worksum", null);
        model.setDataChanged(false);
    }

    private void setControlOfHRApply() {
        Object regOnWay = this.getView().getFormShowParameter().getCustomParam(REG_ON_THE_WAY_BY_HR);
        if (regOnWay == null || REG_ON_THE_WAY_BY_SELF.equals(regOnWay)) {
            return;
        }
        this.setDefaultControlByHRApply();
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if ("A".equals(billStatus)) {
            this.setControlOfStorage();
        }
    }

    private void setControlOfStorage() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String name = dataEntity.getDynamicObject("creator").getString("name");
        this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u5df2\u4e3a\u60a8\u53d1\u8d77\u8f6c\u6b63\u7533\u8bf7\uff0c\u60a8\u65e0\u9700\u91cd\u65b0\u53d1\u8d77\u3002", (String)"WebRegSelfHelpPlugin_7", (String)"hr-hdm-formplugin", (Object[])new Object[]{name}));
    }

    private void setDefaultControlByHRApply() {
        TextEdit fieldEdit = (TextEdit)this.getView().getControl("worksum");
        fieldEdit.setMustInput(false);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        ((Label)this.getView().getControl("regapplytype")).setText(RegTypeEnum.getName((String)dataEntity.getString("regbilltype")));
    }

    private boolean regValidateTips() {
        Object errorMsg = this.getView().getFormShowParameter().getCustomParam(REG_UNIQUE_VALIDATE_ERROR_MSG);
        if (errorMsg != null) {
            this.getView().showConfirm(errorMsg.toString(), MessageBoxOptions.OK, new ConfirmCallBackListener(REG_VALIDATE_CALL_BACK_ID));
            return true;
        }
        return false;
    }

    private void validateRegSelfApply(DynamicObject ermanFileDynamicObject) {
        Object regOnWay = this.getView().getFormShowParameter().getCustomParam(REG_ON_THE_WAY_BY_HR);
        Object errorMsg = this.getView().getFormShowParameter().getCustomParam(REG_UNIQUE_VALIDATE_ERROR_MSG);
        if (regOnWay != null || errorMsg != null) {
            return;
        }
        long personId = ermanFileDynamicObject.getLong("person_id");
        if (!RegPageUtils.haveLicence(personId, this.getView())) {
            errorMsg = ResManager.loadKDString((String)"\u60a8\u7684\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u65e0\u6cd5\u53d1\u8d77\u8f6c\u6b63\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"WebRegSelfHelpPlugin_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
            this.getView().getFormShowParameter().setCustomParam(REG_UNIQUE_VALIDATE_ERROR_MSG, errorMsg);
            return;
        }
        long employeeId = ermanFileDynamicObject.getLong("employee_id");
        Long laborrelStatus = RegPeronalBillHelper.getInstance().queryLabRelStatusCls(Long.valueOf(employeeId));
        if (!LabRelConstants.PROBATION.equals(laborrelStatus)) {
            errorMsg = LabRelConstants.ON_ZHT_JOB.equals(laborrelStatus) ? ResManager.loadKDString((String)"\u60a8\u5df2\u662f\u6b63\u5f0f\u5458\u5de5\uff0c\u65e0\u9700\u53d1\u8d77\u8f6c\u6b63\u7533\u8bf7\u3002", (String)"WebRegSelfHelpPlugin_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u975e\u8bd5\u7528\u72b6\u6001\u7684\u5458\u5de5\u4e0d\u5141\u8bb8\u53d1\u8d77\u8f6c\u6b63\u7533\u8bf7\u3002", (String)"WebRegSelfHelpPlugin_3", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
            this.getView().getFormShowParameter().setCustomParam(REG_UNIQUE_VALIDATE_ERROR_MSG, errorMsg);
            return;
        }
        try {
            DynamicObject ermanfile = (DynamicObject)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getPrimaryErmanfFile", (Object[])new Object[]{personId});
            if (IPersonAboutService.getInstance().isExistQuiting(ermanfile)) {
                errorMsg = ResManager.loadKDString((String)"\u79bb\u804c\u6d41\u7a0b\u4e2d\u7684\u5458\u5de5\u4e0d\u5141\u8bb8\u53d1\u8d77\u8f6c\u6b63\u7533\u8bf7\u3002", (String)"WebRegSelfHelpPlugin_4", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
                this.getView().getFormShowParameter().setCustomParam(REG_UNIQUE_VALIDATE_ERROR_MSG, errorMsg);
            }
        }
        catch (Exception exception) {
            LOGGER.error("WebRegSelfHelpPlugin.beforeBindData error: ", (Throwable)exception);
            errorMsg = ResManager.loadKDString((String)"\u83b7\u53d6\u8bd5\u7528\u671f\u4fe1\u606f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WebRegSelfHelpPlugin_5", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
            this.getView().getFormShowParameter().setCustomParam(REG_UNIQUE_VALIDATE_ERROR_MSG, errorMsg);
        }
    }

    private DataValidate<DynamicObject> validateBillInProcess(DynamicObject ermanDynamicObject) {
        long employeeId = ermanDynamicObject.getLong("employee.id");
        DynamicObject[] dynamicObjects = IRegBillService.getInstance().queryBillInProcess(Collections.singletonList(employeeId), REG_SELECT_FIELDS);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return null;
        }
        DynamicObject regBill = dynamicObjects[0];
        if (HRStringUtils.equals((String)RegBillStatusEnum.APPROVEPASSED.getCode(), (String)regBill.getString("billstatus")) && (HRStringUtils.equals((String)RegNewAuditStatusEnum.ABANDONED.getCode(), (String)regBill.getString("auditstatus")) || RegCategoryEnum.POSTPHONE.getId().equals(regBill.getLong("regcategory.id")))) {
            return null;
        }
        DataValidate dataValidate = DataValidateBuilder.builderSinge((Object)dynamicObjects[0]);
        String regBillType = regBill.getString("regbilltype");
        boolean isViewFlow = regBill.getBoolean("isviewflow");
        if (!isViewFlow && !RegBillTypeEnum.EMP.getStatus().equals(regBillType)) {
            String errorMsg = ResManager.loadKDString((String)"\u60a8\u5df2\u5b58\u5728\u4e00\u6761\u6d41\u7a0b\u4e2d\u7684\u8f6c\u6b63\u7533\u8bf7\uff0c\u65e0\u9700\u518d\u6b21\u53d1\u8d77\u8f6c\u6b63\u7533\u8bf7\u3002", (String)"WebRegSelfHelpPlugin_6", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
            if (RegBusinessStatusEnum.ALREADY_REGED.getCode().equals(regBill.getString("regstatus"))) {
                errorMsg = ResManager.loadKDString((String)"\u60a8\u5df2\u662f\u6b63\u5f0f\u5458\u5de5\uff0c\u65e0\u9700\u53d1\u8d77\u8f6c\u6b63\u7533\u8bf7\u3002", (String)"WebRegSelfHelpPlugin_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
            }
            dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", errorMsg);
        }
        return dataValidate;
    }

    private void setOtherField(DynamicObject newData) {
        String num = IRegBillCodeService.getInstance().getCodeByCodeRule("hdm_regbasebill", newData);
        newData.set("billno", (Object)num);
        newData.set("regbilltype", (Object)RegBillTypeEnum.EMP.getStatus());
        newData.set("isdirectregular", (Object)Boolean.FALSE);
        newData.set("regcomment_id", (Object)RegCommentEnum.AGREE.getId());
        newData.set("syncstatus", (Object)"-2");
        Long createId = RequestContext.get().getCurrUserId();
        newData.set("creator", (Object)createId);
        this.buildRegCategory(newData);
        newData.set("modifytime", (Object)new Date());
        newData.set("createtime", (Object)new Date());
    }

    private void setAuditStatusLabelWithColorful(String billStatus) {
        if (billStatus == null) {
            return;
        }
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        Control regStatusRemark = this.getView().getControl(REG_STATUS_REMARK);
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        boolean isFromWorkFlow = this.isFromWorkFlow(billShowParameter);
        if ((HRStringUtils.equals((String)status.name(), (String)OperationStatus.VIEW.name()) || isFromWorkFlow) && regStatusRemark != null) {
            LabelAp statusLabel = RegBillDrawLabelUtil.setAuditStatusLabelWithColorful(REG_STATUS_REMARK, billStatus);
            this.getView().updateControlMetadata(statusLabel.getKey(), statusLabel.createControl());
            this.getView().setVisible(Boolean.TRUE, new String[]{REG_STATUS_REMARK});
        }
    }

    private void setImageRemark() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("hdm_regselfhelpbill".equals(formId)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String trialPeriodResultImageUrl = RegDetailInfoHelper.getInstance().getTrialPeriodResultImageWeb(dataEntity.getString("regstatus"));
            if (HRStringUtils.isEmpty((String)trialPeriodResultImageUrl)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{IMAGE_KEY});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{IMAGE_KEY});
                Image image = (Image)this.getView().getControl(IMAGE_KEY);
                image.setUrl(trialPeriodResultImageUrl);
            }
        }
    }

    private void setVisibleControl() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"worksum", "probationtext"});
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("hdm_regselfhelpbill".equals(formId)) {
            DateEdit effectDate = (DateEdit)this.getControl("effectdate");
            effectDate.setMustInput(false);
        }
    }

    private void buildRegCategory(DynamicObject bill) {
        Date effectDate = bill.getDate("effectdate");
        Date pre = bill.getDate("preactualdate");
        if (effectDate == null || pre == null) {
            return;
        }
        if (effectDate.before(pre)) {
            bill.set("regcategory_id", (Object)RegCategoryEnum.INADVANCE.getId());
        } else if (effectDate.equals(pre)) {
            bill.set("regcategory_id", (Object)RegCategoryEnum.NOMAL.getId());
        }
    }

    private void openKeyEvent() {
        Map<String, Object> paramMap = ProbationKeyEventService.getInstance().buildParamMap(this.getView(), this.getModel().getDataEntity());
        ProbationKeyEventService.getInstance().openKeyEventByWeb((AbstractFormPlugin)this, this.getView(), paramMap, REG_EVENT_ADD_CLOSE_BACK_ID);
    }

    private void loadKeyEventPanel() {
        boolean isPermission = PermissionValidateUtil.checkPermission((String)HSSC_APP_ID, (String)"hdm_regevent", (String)"47150e89000000ac");
        if (isPermission) {
            Map<String, Object> paramMap = ProbationKeyEventService.getInstance().buildParamMap(this.getView(), this.getModel().getDataEntity());
            ProbationKeyEventService.getInstance().loadKeyEventPanel(this.getView(), "flexkeyeventmain", paramMap);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEYEVENT_TAP});
        }
    }
}

