/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.ask;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.TipsListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.EntityOperate;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hdm.business.personnelchange.servicehelper.PersonnelChangeServiceHelper;
import kd.hr.hdm.business.reg.RegAskServiceHelper;
import kd.hr.hdm.business.reg.RegPeronalBillHelper;
import kd.hr.hdm.business.reg.RegProcessServiceHelper;
import kd.hr.hdm.business.reg.validator.RegCommonValidatorHelper;
import kd.hr.hdm.formplugin.reg.web.RegAskAndExamCommon;

public class RegAskReplyEdit
extends HRDataBaseEdit
implements TipsListener {
    private RegAskAndExamCommon regAskAndExamCommon = new RegAskAndExamCommon();
    private static final String KEY_ASKPERSON = "askperson";
    private static final String KEY_ISQUIT = "key_isquit";
    private static final String[] BUSINESS_CARD_ARR = new String[]{"superior", "charge"};

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Arrays.stream(BUSINESS_CARD_ARR).forEach(item -> this.addTipsListener((String)item));
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        BillShowParameter parameter = (BillShowParameter)e.getFormShowParameter();
        String pageId = parameter.getPageId();
        PageCache cache = new PageCache(pageId);
        String pkId = (String)parameter.getCustomParam("detailId");
        QFilter employeeFilter = new QFilter("id", "=", (Object)Long.valueOf(pkId));
        QFilter isNewFilter = new QFilter("isnewest", "=", (Object)"1");
        DynamicObject askDetail = RegAskServiceHelper.DETAILS_SERVICE_HELPER.queryOne("person_id,bemployee,askperson_id", new QFilter[]{employeeFilter, isNewFilter});
        if (Objects.isNull(askDetail)) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u88ab\u64a4\u56de\uff0c\u65e0\u6cd5\u7ee7\u7eed\u63d0\u4ea4\u3002", (String)"RegAskReplyEdit_3", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        Long askPerson = askDetail.getLong("askperson_id");
        cache.put(KEY_ASKPERSON, String.valueOf(askPerson));
        long current = RequestContext.get().getCurrUserId();
        if (askPerson == 0L || current != askPerson) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u95ee\u8be2\u5904\u7406\u4eba\uff0c\u65e0\u6743\u5904\u7406\u3002", (String)"RegAskReplyEdit_5", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
        Long personId = askDetail.getLong("person_id");
        cache.put("person", String.valueOf(personId));
        cache.put("employee", String.valueOf(askDetail.getLong("bemployee")));
        HRBaseServiceHelper personService = new HRBaseServiceHelper("hrpi_person");
        DynamicObject personObject = personService.queryOne("name", (Object)askDetail.getLong("person_id"));
        String personName = personObject.getString("name");
        parameter.setHasRight(true);
        parameter.setCaption(ResManager.loadKDString((String)"\u8f6c\u6b63\u95ee\u8be2 - %s", (String)"RegAskReplyEdit_2", (String)"hr-hdm-formplugin", (Object[])new Object[]{personName}));
        parameter.setPkId((Object)Long.valueOf(pkId));
    }

    public void afterLoadData(EventObject e) {
        IFormView view = this.getView();
        Long employeeId = Long.valueOf(this.getPageCache().get("employee"));
        String regularStatus = RegProcessServiceHelper.getRegStatusByEmployee((Long)employeeId);
        this.getView().getPageCache().put("regstatus", regularStatus);
        Long erManFileId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("ermanfile"));
        ArrayList<Long> erManFileIdList = new ArrayList<Long>();
        erManFileIdList.add(erManFileId);
        List ermanfileList = (List)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getCardFields", (Object[])new Object[]{erManFileIdList});
        if (CollectionUtils.isEmpty((Collection)ermanfileList)) {
            throw new KDBizException(new ErrorCode("hr.hdm.loadermanfile.error", ResManager.loadKDString((String)"\u52a0\u8f7d\u4eba\u5458\u6863\u6848\u5f02\u5e38\u3002", (String)"RegAskReplyEdit_1", (String)"hr-hdm-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        RegPeronalBillHelper.getInstance().loadCommonPersonInfo((Map)ermanfileList.get(0), this.getView());
        RegPeronalBillHelper.getInstance().loadChargeInfoAndSup((Map)ermanfileList.get(0), this.getView());
        RegPeronalBillHelper.getInstance().loadRegularBaseInfo(employeeId, regularStatus, this.getModel().getDataEntity(), view);
        RegPeronalBillHelper.getInstance().loadAskOrExamHead(this.getView(), this.getModel());
        this.mySelfRegularAsk();
        String comment = (String)this.getModel().getValue("comment");
        if (!HRStringUtils.isEmpty((String)comment)) {
            this.getModel().setValue("commentshow", (Object)comment);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.viewControl();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        this.regAskAndExamCommon.propertyChanged(key, this.getView());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"submit")) {
            this.viewControl();
        }
    }

    private void mySelfRegularAsk() {
        Long personId = Long.valueOf(this.getView().getPageCache().get("person"));
        ArrayList<Long> personIdList = new ArrayList<Long>();
        personIdList.add(personId);
        Map userIdMap = RegPeronalBillHelper.getInstance().queryUserIdMap(personIdList);
        Long userId = (Long)userIdMap.get(personId);
        this.getView().getPageCache().put("user", String.valueOf(userId));
        String askPersonId = this.getView().getPageCache().get(KEY_ASKPERSON);
        if (HRObjectUtils.equals((Object)String.valueOf(userId), (Object)askPersonId)) {
            Label lblAskComment = (Label)this.getView().getControl("lblaskcomment");
            lblAskComment.setText(ResManager.loadKDString((String)"\u81ea\u6211\u8bc4\u4ef7\uff1a", (String)"RegAskReplyEdit_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
    }

    private void viewControl() {
        String status = (String)this.getModel().getValue("status");
        if (HRStringUtils.equals((String)status, (String)"1030")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"commentflex"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"commentflex"});
        }
        String employee = this.getPageCache().get("employee");
        String regStatus = this.getView().getPageCache().get("regstatus");
        boolean regComplete = HRStringUtils.equals((String)regStatus, (String)"1040") || HRStringUtils.equals((String)regStatus, (String)"1050");
        boolean isQuit = PersonnelChangeServiceHelper.isQuit((long)Long.parseLong(employee));
        if (regComplete || isQuit) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"commentflex", "opinionflex"});
        }
        this.getPageCache().put(KEY_ISQUIT, String.valueOf(isQuit));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        EntityOperate operate = (EntityOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"submit")) {
            BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
            Long pkId = (Long)parameter.getPkId();
            QFilter employeeFilter = new QFilter("id", "=", (Object)pkId);
            QFilter isNewFilter = new QFilter("isnewest", "=", (Object)"1");
            DynamicObject askDetail = RegAskServiceHelper.DETAILS_SERVICE_HELPER.queryOne("person_id,bemployee,askperson_id", new QFilter[]{employeeFilter, isNewFilter});
            if (Objects.isNull(askDetail)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u88ab\u64a4\u56de\uff0c\u65e0\u6cd5\u7ee7\u7eed\u63d0\u4ea4\u3002", (String)"RegAskReplyEdit_3", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Long employeeId = (Long)this.getModel().getValue("bemployee");
            Map result = RegCommonValidatorHelper.getInstance().validateAskRegStatus(employeeId, this.getView());
            Boolean flag = Boolean.parseBoolean((String)result.get("validateResult"));
            if (!flag.booleanValue()) {
                String msg = (String)result.get("msg");
                throw new KDBizException(msg);
            }
            this.getModel().setValue("ermanfile", parameter.getShowParameter().getCustomParam("ermanfile"));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void beforeShowTips(BeforeShowTipsEvent evt) {
        RegPeronalBillHelper.getInstance().beforeShowTips(evt, this.getView());
    }

    public void afterShowTips(AfterShowTipsEvent afterShowTipsEvent) {
    }

    private void addTipsListener(String key) {
        IFormView formView = this.getView();
        Image image = (Image)formView.getControl(String.format("%simage1", key));
        if (image != null) {
            image.addTipsListener((TipsListener)this);
        }
    }
}

