/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.batch;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hdm.business.common.HPFSTemplatePropertyHandler;
import kd.hr.hdm.business.personnelchange.servicehelper.PersonnelChangeServiceHelper;
import kd.hr.hdm.business.reg.domain.service.bill.IBatchRegBillService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.business.reg.domain.service.impl.proxy.BatchRegConfirmImpl;
import kd.hr.hdm.business.reg.validator.BatchRegValidateHelper;
import kd.hr.hdm.business.repository.RegEntryRepository;
import kd.hr.hdm.common.constants.AffactionConstants;
import kd.hr.hdm.common.parttime.entity.DataValidateBuilder;
import kd.hr.hdm.common.reg.enums.RegCategoryEnum;
import kd.hr.hdm.common.reg.enums.RegDateUnitEnum;
import kd.hr.hdm.common.transfer.enums.TransferOperateTypeEnum;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;
import kd.hr.hdm.common.transfer.util.TransferJudgementUtil;
import kd.hr.hdm.common.transfer.util.TransferPageUtil;
import kd.hr.hdm.common.util.EntityPropertyUtil;
import kd.hr.hdm.formplugin.reg.web.tools.RegBillDrawLabelUtil;
import kd.sdk.hr.hdm.business.batch.IBatchRegConfirmProxy;
import org.apache.commons.lang3.time.StopWatch;

public class BatchRegBillEdit
extends HRCoreBaseBillEdit
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(BatchRegBillEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit regcomment = (BasedataEdit)this.getView().getControl("regcomment");
        BasedataEdit regcategory = (BasedataEdit)this.getView().getControl("regcategory");
        BasedataEdit affaction = (BasedataEdit)this.getView().getControl("affaction");
        regcomment.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        regcategory.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        affaction.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit laborrelstatus = (BasedataEdit)this.getView().getControl("laborrelstatus");
        if (laborrelstatus != null) {
            laborrelstatus.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObjectCollection entry = (DynamicObjectCollection)this.getModel().getValue("entryentity");
        for (DynamicObject dynamicObject : entry) {
            int row = dynamicObject.getInt("seq") - 1;
            model.setValue("probationtext", (Object)(model.getValue("probation", row) + RegDateUnitEnum.getName((String)((String)model.getValue("probationunit", row)))), row);
            if (!TransferJudgementUtil.ADDNEW.test(view.getFormShowParameter().getStatus())) continue;
            view.setEnable(Boolean.FALSE, row, new String[]{"effectdate"});
        }
        this.setAuditStatusLabelWithColorful((String)this.getModel().getValue("billstatus"));
        this.setAuditPanelVisible(this.getModel(), this.getView());
        if (TransferJudgementUtil.VIEW.test(view.getFormShowParameter().getStatus())) {
            view.setVisible(Boolean.TRUE, new String[]{"regstatus"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"regstatus"});
            this.setRealityRegDateEnable();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName;
        ChangeData changeData = e.getChangeSet()[0];
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object newValue = changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        switch (fieldName = e.getProperty().getName()) {
            case "regcomment": {
                DynamicObject regcategory;
                DynamicObject dynamicObject = (DynamicObject)newValue;
                if (dynamicObject == null) {
                    view.setEnable(Boolean.FALSE, rowIndex, new String[]{"effectdate"});
                    model.setValue("laborrelstatus", null, rowIndex);
                    return;
                }
                long regCommentId = dynamicObject.getLong("id");
                if (regCommentId == 1010L) {
                    DynamicObject affaction;
                    view.setEnable(Boolean.TRUE, rowIndex, new String[]{"effectdate"});
                    regcategory = (DynamicObject)this.getModel().getValue("regcategory");
                    if (regcategory != null && dynamicObject.getLong("id") != regcategory.getDynamicObject("group").getLong("id")) {
                        model.setValue("regcategory", null, rowIndex);
                    }
                    if (regcategory == null) {
                        model.setValue("effectdate", model.getValue("preactualdate", rowIndex), rowIndex);
                        model.setValue("regcategory", (Object)RegCategoryEnum.NOMAL.getId(), rowIndex);
                    }
                    if ((affaction = (DynamicObject)model.getValue("affaction", rowIndex)) == null) {
                        return;
                    }
                    List laborrelStatusList = PersonnelChangeServiceHelper.getLaborrelstatusDyByAffaction((DynamicObject)affaction);
                    if (HRCollUtil.isNotEmpty((Collection)laborrelStatusList)) {
                        this.getModel().setValue("laborrelstatus", laborrelStatusList.get(0), rowIndex);
                    }
                }
                if (regCommentId != 1020L) break;
                model.setValue("effectdate", null, rowIndex);
                model.setValue("laborrelstatus", null, rowIndex);
                view.setEnable(Boolean.FALSE, rowIndex, new String[]{"effectdate"});
                regcategory = (DynamicObject)this.getModel().getValue("regcategory");
                if (regcategory == null || dynamicObject.getLong("id") == regcategory.getDynamicObject("group").getLong("id")) break;
                model.setValue("regcategory", null, rowIndex);
                break;
            }
            case "regcategory": {
                DynamicObject regCategory = (DynamicObject)newValue;
                if (newValue == null) {
                    return;
                }
                DynamicObject regComment = regCategory.getDynamicObject("group");
                if (model.getValue("regcomment", rowIndex) == null) {
                    model.setValue("regcomment", (Object)regComment, rowIndex);
                }
                if (!RegCategoryEnum.NOMAL.getId().equals(regCategory.getPkValue())) break;
                model.setValue("effectdate", model.getValue("preactualdate", rowIndex), rowIndex);
                break;
            }
            case "effectdate": {
                boolean equals;
                DynamicObject regcategoryDy = (DynamicObject)model.getValue("regcategory", rowIndex);
                Date preactualdate = (Date)model.getValue("preactualdate", rowIndex);
                Date actualDate = (Date)newValue;
                if (newValue == null) {
                    return;
                }
                DynamicObject regcommentDy = (DynamicObject)model.getValue("regcomment", rowIndex);
                if (regcommentDy != null && regcommentDy.getLong("id") == 1010L) {
                    if (actualDate.before((Date)model.getValue("entrydate", rowIndex))) {
                        model.setValue("effectdate", null, rowIndex);
                        view.showErrorNotification(ResManager.loadKDString((String)"\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u4e0d\u5f97\u65e9\u4e8e\u5165\u804c\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"", (String)"", (Object[])new Object[0]));
                        return;
                    }
                    if (regcategoryDy != null && regcategoryDy.getLong("id") == RegCategoryEnum.INADVANCE.getId().longValue() && actualDate.after(preactualdate)) {
                        model.setValue("effectdate", null, rowIndex);
                        view.showErrorNotification(ResManager.loadKDString((String)"\u63d0\u524d\u8f6c\u6b63\u4e0b\uff0c\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u9700\u65e9\u4e8e\u9884\u8f6c\u6b63\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"", (String)"", (Object[])new Object[0]));
                        return;
                    }
                }
                if (equals = ((String)TransferCommonUtil.formatDate.apply(preactualdate)).equals(TransferCommonUtil.formatDate.apply(actualDate))) {
                    model.setValue("regcategory", (Object)RegCategoryEnum.NOMAL.getId());
                    return;
                }
                if (!actualDate.before(preactualdate)) break;
                model.setValue("regcategory", (Object)RegCategoryEnum.INADVANCE.getId());
                return;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (HRCollUtil.isNotEmpty((Collection)entryEntity)) {
            entryEntity.forEach(dynamicObject -> EntityPropertyUtil.setBizChanged((DynamicObject)dynamicObject, (boolean)false, (String[])new String[]{"probationtext"}));
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"ebillno"});
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        Object isAdd = view.getFormShowParameter().getCustomParam("isAdd");
        if (isAdd != null && !((Boolean)isAdd).booleanValue()) {
            JSONArray data = (JSONArray)view.getFormShowParameter().getCustomParam("data");
            this.initEntryData(data);
            view.getFormShowParameter().setCustomParam("isAdd", (Object)true);
        }
        this.getView().updateView("entryentity");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
            this.getView().invokeOperation(callBackId, operateOption);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": {
                this.beforeSaveAndSubmitValidate(args, TransferOperateTypeEnum.SAVE);
                break;
            }
            case "submit": {
                if (!this.submitStatusValidate(args, this.getModel().getDataEntity())) {
                    return;
                }
                this.beforeSaveAndSubmitValidate(args, TransferOperateTypeEnum.SUBMIT);
                break;
            }
            case "submiteffect": {
                if (!this.submitEffectStatusValidate(args, this.getModel().getDataEntity())) {
                    return;
                }
                this.beforeSaveAndSubmitValidate(args, TransferOperateTypeEnum.SUBMITEFFECT);
                break;
            }
            case "unsubmit": {
                Object pkValue = this.getModel().getDataEntity().getPkValue();
                DynamicObject batchRegBill = IBatchRegBillService.getInstance().queryOne("billstatus", ((Long)pkValue).longValue());
                IRegBillService.getInstance().beforeValidateUnSubmit((AbstractFormPlugin)this, args, batchRegBill.getString("billstatus"));
                break;
            }
            case "import_entrydata_hr": {
                if (this.getModel().getValue("org") != null) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7\u201d\uff0c\u518d\u5bfc\u5165\u4eba\u5458\u3002", (String)"BatchPartTimeEntryImportEdit_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        long billId = (Long)this.getModel().getValue("id");
        if (HRStringUtils.equals((String)operateKey, (String)"save") || HRStringUtils.equals((String)operateKey, (String)"submit") || HRStringUtils.equals((String)operateKey, (String)"submiteffect")) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
        }
        if (HRStringUtils.equals((String)operateKey, (String)"unsubmit")) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
        }
        if ("donothing_terminate".equals(args.getOperateKey())) {
            TransferPageUtil.showFormViewOfModal((IFormView)this.getView(), (String)"hdm_regbatchtermconfirm", (Object)billId, (String)"batch");
        }
    }

    private void beforeSaveAndSubmitValidate(BeforeDoOperationEventArgs args, TransferOperateTypeEnum operateTypeEnum) {
        ArrayList entryData = Lists.newArrayList((Iterable)this.getModel().getEntryEntity("entryentity"));
        if (HRCollUtil.isEmpty((Collection)entryData)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f85\u8f6c\u6b63\u4eba\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u53d1\u8d77\u6279\u91cf\u8f6c\u6b63\u7533\u8bf7\u65f6\u81f3\u5c11\u5b58\u5728\u4e00\u884c\u5b8c\u6574\u7684\u5f85\u8f6c\u6b63\u4eba\u5458\u4fe1\u606f\u3002", (String)"BatchRegBillEdit_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        for (DynamicObject regBill : entryData) {
            Object regStatus = regBill.get("regcategory");
            if (regStatus != null) continue;
            this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5931\u8d25\uff1a\u5206\u5f55\u4e2d\u5b58\u5728\u5fc5\u586b\u5b57\u6bb5\u672a\u586b\u5199\u3002", (String)"BatchRegBillEdit_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]), operateTypeEnum.getName()));
            args.setCancel(true);
            return;
        }
        List dataValidates = DataValidateBuilder.builderCollection((List)entryData);
        BatchRegValidateHelper.saveAndSubmitValidate((DynamicObject)this.getModel().getDataEntity(), (List)entryData, (List)dataValidates);
        Map valResultInfo = BatchRegValidateHelper.buildOperateInfoByValResult((List)dataValidates, (TransferOperateTypeEnum)operateTypeEnum);
        if ((Integer)valResultInfo.get("failperson") != 0) {
            TransferPageUtil.showFormViewOfModal((IFormView)this.getView(), (String)"hdm_batchregoperateresult", (Map)valResultInfo);
            args.setCancel(true);
        }
    }

    private List<String> generateBillNo(JSONArray data) {
        StopWatch stopWatch = new StopWatch("generateBillNo");
        stopWatch.start();
        List entryRegBillList = data.stream().map(temp -> RegEntryRepository.getInstance().generateEmptyDynamicObject()).collect(Collectors.toList());
        List numbers = CodeRuleServiceHelper.getNumbers((String)"hdm_entryregbill", entryRegBillList);
        stopWatch.stop();
        LOGGER.info("generateBillNo cost time:{}", (Object)stopWatch.getNanoTime());
        return numbers;
    }

    private void initEntryData(JSONArray data) {
        IDataModel model = this.getModel();
        model.beginInit();
        List<String> billNoList = this.generateBillNo(data);
        StopWatch stopWatch = new StopWatch("BatchTegBillEdit_initEntryData");
        stopWatch.start();
        if (data.size() == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("entryentity", data.size());
        for (int row = 0; row < data.size(); ++row) {
            JSONObject returnData = (JSONObject)data.get(row);
            Map returnMap = (Map)returnData.get((Object)"data");
            JSONObject employeeAttachInfo = (JSONObject)returnMap.get("employeeAttachInfo");
            JSONObject ermanfileMap = (JSONObject)returnMap.get("ermanfileMap");
            ermanfileMap.put("row", (Object)row);
            model.setValue("org", ermanfileMap.get((Object)"org_id"));
            model.setValue("ebillno", (Object)billNoList.get(row), row);
            model.setValue("ename", ermanfileMap.get((Object)"name"), row);
            model.setValue("ermanfile", ermanfileMap.get((Object)"id"), row);
            model.setValue("entrydate", TransferCommonUtil.string2Date.apply((String)employeeAttachInfo.get((Object)"startdate")), row);
            model.setValue("probation", employeeAttachInfo.get((Object)"probation"), row);
            model.setValue("probationunit", employeeAttachInfo.get((Object)"probationunit"), row);
            model.setValue("probationtext", (Object)(employeeAttachInfo.get((Object)"probation") + RegDateUnitEnum.getName((String)((String)employeeAttachInfo.get((Object)"probationunit")))), row);
            model.setValue("preactualdate", TransferCommonUtil.string2Date.apply((String)employeeAttachInfo.get((Object)"preregulardate")), row);
            model.setValue("isviewflow", (Object)"0", row);
            if (HPFSTemplatePropertyHandler.isNewChgAction((String)"hdm_reg_hpfs_new")) {
                model.setValue("affaction", (Object)AffactionConstants.REG_AFFACTION_NEW, row);
            } else {
                model.setValue("affaction", (Object)AffactionConstants.REG_AFFACTION, row);
            }
            model.setValue("bhrbu", ermanfileMap.get((Object)"org_id"), row);
            model.setValue("baffiliateadminorg", ermanfileMap.get((Object)"affiliateadminorg_id"), row);
            model.setValue("bempgroup", ermanfileMap.get((Object)"empgroup_id"), row);
            model.setValue("badminorg", ermanfileMap.get((Object)"adminorg_id"), row);
            model.setValue("person", ermanfileMap.get((Object)"person_id"), row);
            model.setValue("laborreltype", ermanfileMap.get((Object)"laborreltype_id"), row);
            model.setValue("bdependencytype", ermanfileMap.get((Object)"dependencytype_id"), row);
            model.setValue("bemployee", ermanfileMap.get((Object)"employee_id"), row);
            model.setValue("cmpemp", ermanfileMap.get((Object)"managingscope_id"), row);
            model.setValue("bposition", ermanfileMap.get((Object)"position_id"), row);
            model.setValue("standardpost", ermanfileMap.get((Object)"stdposition_id"), row);
            model.setValue("bjob", ermanfileMap.get((Object)"job_id"), row);
            model.setValue("entryorg", model.getValue("org"), row);
            PluginProxy pluginProxy = PluginProxy.create((Object)new BatchRegConfirmImpl(), IBatchRegConfirmProxy.class, (String)"kd.sdk.hr.hdm.business.batch.IBatchRegConfirmProxy", null);
            pluginProxy.callReplaceIfPresent(service -> {
                service.postInitEntryData(returnData, this.getModel());
                return "";
            });
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        IDataModel model = this.getModel();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        listShowParameter.setMultiSelect(false);
        String fieldName = beforeF7SelectEvent.getProperty().getName();
        int row = beforeF7SelectEvent.getRow();
        if (fieldName.equals("regcategory")) {
            DynamicObject regcomment = (DynamicObject)model.getValue("regcomment", row);
            if (regcomment != null) {
                long id = regcomment.getLong("id");
                QFilter qFilter = new QFilter("group", "=", (Object)id);
                beforeF7SelectEvent.addCustomQFilter(qFilter);
            }
        } else if ("affaction".equals(fieldName)) {
            boolean isnewchgaction = HPFSTemplatePropertyHandler.isNewChgAction((String)"hdm_reg_hpfs_new");
            List affactionIds = PersonnelChangeServiceHelper.getAffactionMapByBusinessKey((String)"hdm_reg_hpfs_new", (String)"hdm_regbasebill");
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("businessvalue", (Object)(isnewchgaction ? "1" : "0"));
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "in", (Object)affactionIds));
        } else if ("laborrelstatus".equals(fieldName)) {
            DynamicObject affaction = (DynamicObject)model.getValue("affaction", row);
            if (affaction == null) {
                return;
            }
            List laborrelstatusList = PersonnelChangeServiceHelper.getLaborrelstatusByAffaction((DynamicObject)affaction);
            if (laborrelstatusList != null && laborrelstatusList.size() > 0) {
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "in", (Object)laborrelstatusList));
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    private void setRealityRegDateEnable() {
        DynamicObjectCollection value = (DynamicObjectCollection)this.getModel().getValue("entryentity");
        value.forEach(temp -> {
            int seq = temp.getInt("seq");
            if (temp.getLong("regcomment.id") == 1020L) {
                this.getView().setEnable(Boolean.FALSE, seq - 1, new String[]{"effectdate"});
            }
        });
    }

    private void setAuditStatusLabelWithColorful(String labelValue) {
        LabelAp statusLabel = RegBillDrawLabelUtil.setAuditStatusLabelWithColorful("lblbiillstatus", labelValue);
        this.getView().updateControlMetadata(statusLabel.getKey(), statusLabel.createControl());
        if (TransferJudgementUtil.VIEW.test(this.getView().getFormShowParameter().getStatus())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{statusLabel.getKey()});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{statusLabel.getKey()});
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"lbregstatus"});
    }

    private void setAuditPanelVisible(IDataModel model, IFormView view) {
        if (((Boolean)model.getValue("issubmit")).booleanValue() && !TransferCommonUtil.isAuditView((IFormView)this.getView())) {
            view.setVisible(Boolean.TRUE, new String[]{"rightmainpanel"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"rightmainpanel"});
        }
    }

    private boolean submitStatusValidate(BeforeDoOperationEventArgs args, DynamicObject batchRegBill) {
        String billStatus = batchRegBill.getString("billstatus");
        if ("A".equals(billStatus) || "G".equals(billStatus)) {
            return true;
        }
        String msg = ResManager.loadKDString((String)"\u53ea\u80fd\u63d0\u4ea4\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u201c\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u7684\u5355\u636e\u3002", (String)"BatchRegList_5", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
        this.getView().showErrorNotification(msg);
        args.setCancel(true);
        return false;
    }

    private boolean submitEffectStatusValidate(BeforeDoOperationEventArgs args, DynamicObject batchRegBill) {
        String billStatus = batchRegBill.getString("billstatus");
        if ("A".equals(billStatus)) {
            return true;
        }
        String msg = ResManager.loadKDString((String)"\u53ea\u80fd\u63d0\u4ea4\u5e76\u751f\u6548\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u7684\u5355\u636e\u3002", (String)"BatchRegList_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
        this.getView().showErrorNotification(msg);
        args.setCancel(true);
        return false;
    }
}

