/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.batch;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.hr.hdm.business.reg.domain.service.bill.IBatchRegBillService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.business.reg.validator.BatchRegValidateHelper;
import kd.hr.hdm.business.repository.BatchRegRepository;
import kd.hr.hdm.business.repository.RegApplyRepository;
import kd.hr.hdm.common.parttime.entity.DataValidateBuilder;
import kd.hr.hdm.common.transfer.enums.TransferOperateTypeEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.common.transfer.util.TransferPageUtil;
import kd.hr.hdm.formplugin.reg.web.batch.BatchRegListDataProvider;

public class BatchRegList
extends HRCoreBaseBillList {
    private static final Log LOGGER = LogFactory.getLog(BatchRegList.class);
    private static final Set<String> SELECT_ONE_ONLY_OP = Sets.newHashSet((Object[])new String[]{"submit", "submiteffect", "unsubmit", "delete", "donothing_terminate"});

    public void setFilter(SetFilterEvent arg) {
        String orderBy = "modifytime desc";
        arg.setOrderBy(orderBy);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
            this.getView().invokeOperation(callBackId, operateOption);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        Object[] rows = this.getSelectedRows().getPrimaryKeyValues();
        if (SELECT_ONE_ONLY_OP.contains(operateKey) && rows.length > 1) {
            if ("donothing_terminate".equals(operateKey)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u7ec8\u6b62\u4e00\u6761\u6d41\u7a0b\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u9700\u8981\u7ec8\u6b62\u6d41\u7a0b\u7684\u5355\u636e\u3002", (String)"BatchRegList_6", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u64cd\u4f5c\u4e00\u6761\u6570\u636e\u3002", (String)"BatchRegList_7", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            }
            args.setCancel(true);
            return;
        }
        DynamicObject batchRegBill = new DynamicObject();
        if (rows.length > 0) {
            batchRegBill = IBatchRegBillService.getInstance().queryOne("billstatus", ((Long)rows[0]).longValue());
        }
        switch (operateKey) {
            case "delete": {
                IRegBillService.getInstance().beforeValidateDelete((AbstractFormPlugin)this, args, batchRegBill.getString("billstatus"));
                break;
            }
            case "submiteffect": {
                if (!this.submitEffecStattusValidate(args, batchRegBill)) {
                    return;
                }
                this.beforeSubmitValidate(args, TransferOperateTypeEnum.SUBMITEFFECT);
                break;
            }
            case "submit": {
                if (!this.submitStatusValidate(args, batchRegBill)) {
                    return;
                }
                this.beforeSubmitValidate(args, TransferOperateTypeEnum.SUBMIT);
                break;
            }
            case "unsubmit": {
                if (batchRegBill == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"BatchRegList_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                IRegBillService.getInstance().beforeValidateUnSubmit((AbstractFormPlugin)this, args, batchRegBill.getString("billstatus"));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() != null && !args.getOperationResult().isSuccess()) {
            return;
        }
        Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
        String caption = ResManager.loadKDString((String)"\u65b0\u589e\u6279\u91cf\u8f6c\u6b63\u7533\u8bf7", (String)"BatchRegList_4", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
        if ("donothing_add".equals(args.getOperateKey())) {
            TransferPageUtil.showNewAddPage((IFormView)this.getView(), (String)"hdm_batchregbill", (String)caption);
        } else if ("donothing_terminate".equals(args.getOperateKey())) {
            TransferPageUtil.showFormViewOfModal((IFormView)this.getView(), (String)"hdm_regbatchtermconfirm", (Object)primaryKeyValues[0], (String)"batch");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        IListView listview = (IListView)this.getView();
        long transferBillId = (Long)listview.getFocusRowPkId();
        String billno = this.getBillNoByBillId(transferBillId);
        String caption = ResManager.loadKDString((String)"\u6279\u91cf\u8f6c\u6b63\u7533\u8bf7-%s", (String)"BatchRegList_3", (String)"hr-hdm-formplugin", (Object[])new Object[]{billno});
        TransferPageUtil.showPage((IFormView)this.getView(), (String)"hdm_batchregbill", (Object)transferBillId, (String)caption, null);
    }

    private String getBillNoByBillId(long billId) {
        String billno = "";
        DynamicObject query = BatchRegRepository.getInstance().queryOne("billno", (Object)billId);
        if (!ObjectUtils.isEmpty((Object)query) && !ObjectUtils.isEmpty((Object)query.getString("billno"))) {
            billno = query.getString("billno");
        }
        return billno;
    }

    private void beforeSubmitValidate(BeforeDoOperationEventArgs args, TransferOperateTypeEnum transferOperateTypeEnum) {
        Object[] rows = this.getSelectedRows().getPrimaryKeyValues();
        DynamicObject batchRegBill = BatchRegRepository.getInstance().queryOne("entryentity,org,affiliationord", rows[0]);
        DynamicObjectCollection batchTransferBillCollection = batchRegBill.getDynamicObjectCollection("entryentity");
        List regBillIds = batchTransferBillCollection.stream().map(transferBill -> transferBill.getLong("id")).collect(Collectors.toList());
        ArrayList entryRegBillList = new ArrayList(RegApplyRepository.getRepository().queryByIds("probationtext,billno,bemployee,affaction,preactualdate,effectdate,billstatus,entrydate,regcategory,bhrbu,badminorg,regcomment,ermanfile,person,regbilltype,laborrelstatus".split(","), regBillIds).values());
        List dataValidates = DataValidateBuilder.builderCollection(entryRegBillList);
        BatchRegValidateHelper.saveAndSubmitValidate((DynamicObject)batchRegBill, entryRegBillList, (List)dataValidates);
        Map valResultInfo = BatchRegValidateHelper.buildOperateInfoByValResult((List)dataValidates, (TransferOperateTypeEnum)transferOperateTypeEnum);
        if ((Integer)valResultInfo.get("failperson") != 0) {
            TransferPageUtil.showFormViewOfModal((IFormView)this.getView(), (String)"hdm_batchregoperateresult", (Map)valResultInfo);
            args.setCancel(true);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new BatchRegListDataProvider());
    }

    private boolean submitStatusValidate(BeforeDoOperationEventArgs args, DynamicObject batchRegBill) {
        String billStatus = batchRegBill.getString("billstatus");
        if ("A".equals(billStatus) || "G".equals(billStatus)) {
            return true;
        }
        String msg = ResManager.loadKDString((String)"\u53ea\u80fd\u63d0\u4ea4\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u201c\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u7684\u5355\u636e\u3002", (String)"BatchRegList_5", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
        this.getView().showErrorNotification(msg);
        args.setCancel(true);
        return false;
    }

    private boolean submitEffecStattusValidate(BeforeDoOperationEventArgs args, DynamicObject batchRegBill) {
        String billStatus = batchRegBill.getString("billstatus");
        if ("A".equals(billStatus)) {
            return true;
        }
        String msg = ResManager.loadKDString((String)"\u53ea\u80fd\u63d0\u4ea4\u5e76\u751f\u6548\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u7684\u5355\u636e\u3002", (String)"BatchRegList_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
        this.getView().showErrorNotification(msg);
        args.setCancel(true);
        return false;
    }
}

