/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.batch.importvalidator;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.parttime.PerChgBizUtils;
import kd.hr.hdm.business.reg.RegServiceHelper;
import kd.hr.hdm.business.repository.RegEntryRepository;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.enu.ValidatorOrderEnum;
import kd.hrmp.hies.entry.core.validate.AbstractEntryValidateHandler;

public class RegBatchCrossValidator
extends AbstractEntryValidateHandler {
    private static final Log LOGGER = LogFactory.getLog(RegBatchCrossValidator.class);

    public ValidatorOrderEnum setValidatorRole() {
        return ValidatorOrderEnum.BEFORE;
    }

    public void validate(List<ImportBillData> list, ImportLog importLog) {
        List entryRegBillList = list.stream().map(temp -> RegEntryRepository.getInstance().generateEmptyDynamicObject()).collect(Collectors.toList());
        List batchRegentryNumbers = CodeRuleServiceHelper.getNumbers((String)"hdm_entryregbill", entryRegBillList);
        HashMap<String, ImportBillData> entryMap = new HashMap<String, ImportBillData>(list.size());
        ArrayList params = new ArrayList(list.size());
        for (int i = 0; i < list.size(); ++i) {
            JSONObject ermanfile;
            ImportBillData importBillData = list.get(i);
            JSONObject entry = importBillData.getData().getJSONObject("entryentity");
            entry.put("ebillno", batchRegentryNumbers.get(i));
            if (entry.containsKey((Object)"MustInputPass") && !entry.getBoolean("MustInputPass").booleanValue() || entry.containsKey((Object)"validatorflag") && !entry.getBoolean("validatorflag").booleanValue() || !(ermanfile = entry.getJSONObject("ermanfile")).containsKey((Object)"id")) continue;
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("billNo", entry.getString("ebillno"));
            param.put("actionId", entry.getJSONObject("affaction").getString("id"));
            param.put("effectTime", entry.getDate("effectdate") == null ? ermanfile.getDate("preregulardate").getTime() : entry.getDate("effectdate").getTime());
            param.put("personId", ermanfile.getString("person_id"));
            param.put("employeeId", ermanfile.getString("employee_id"));
            param.put("managingScopeId", ermanfile.getString("cmpemp_id"));
            param.put("depEmpId", ermanfile.getString("depemp_id"));
            entryMap.put(entry.getString("ebillno"), importBillData);
            params.add(param);
        }
        Map batchCrossValidateResult = PerChgBizUtils.getBatchCrossValidateResult(params);
        for (Map.Entry result : batchCrossValidateResult.entrySet()) {
            if (ObjectUtils.isEmpty(result.getValue())) continue;
            List crossList = (List)result.getValue();
            Map<String, List<Map>> crossMap = crossList.stream().collect(Collectors.groupingBy(cross -> String.valueOf(cross.get("billNoSource"))));
            for (Map.Entry<String, List<Map>> cross2 : crossMap.entrySet()) {
                String ebillNo = cross2.getKey();
                List<Map<String, Object>> crossValidateList = cross2.getValue();
                if (ObjectUtils.isEmpty(crossValidateList) || !entryMap.containsKey(ebillNo)) continue;
                this.dealCrossValidate(crossValidateList, (ImportBillData)entryMap.get(ebillNo), importLog);
            }
        }
    }

    private void dealCrossValidate(List<Map<String, Object>> crossValidateList, ImportBillData importBillData, ImportLog importLog) {
        StringBuilder errorMsgSb = new StringBuilder();
        for (Map<String, Object> crossMap : crossValidateList) {
            String crossValidateRange = (String)crossMap.get("crossValidNoti");
            String actionName = (String)crossMap.get("actionName");
            String crossBillNo = (String)crossMap.get("billNo");
            StringBuilder sb = new StringBuilder().append(actionName).append("\uff08").append(crossBillNo).append("\uff09").append("\u3001");
            if (!HRStringUtils.equals((String)"3", (String)crossValidateRange)) continue;
            errorMsgSb.append((CharSequence)sb);
        }
        if (errorMsgSb.length() > 0) {
            String personName = importBillData.getData().getJSONObject("entryentity").getJSONObject("ermanfile").getString("ermanfileNameInDb");
            String errorMsg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u201c%1$s\u201d\u5df2\u53d1\u751f\u201c%2$s\u201d\uff0c\u4e0d\u53ef\u53d1\u8d77\u8f6c\u6b63\u3002", (String)"RegBatchCrossValidator_0", (String)"hr-hdm-formplugin", (Object[])new Object[]{personName, errorMsgSb.substring(0, errorMsgSb.length() - 1)});
            RegServiceHelper.writeErrorInfo((ImportBillData)importBillData, (ImportLog)importLog, (String)errorMsg);
        }
    }
}

