/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.batch.importvalidator;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hdm.business.reg.RegServiceHelper;
import kd.hr.hdm.business.repository.BatchRegRepository;
import kd.hr.hdm.business.repository.RegApplyRepository;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.enu.ValidatorOrderEnum;
import kd.hrmp.hies.entry.core.validate.AbstractEntryValidateHandler;

public class RegBillUniqueValidator
extends AbstractEntryValidateHandler {
    private static final Log LOGGER = LogFactory.getLog(RegBillUniqueValidator.class);
    private Object pkValue;

    public RegBillUniqueValidator(Object pkValue) {
        this.pkValue = pkValue;
    }

    public ValidatorOrderEnum setValidatorRole() {
        return ValidatorOrderEnum.BEFORE;
    }

    public void validate(List<ImportBillData> list, ImportLog importLog) {
        DynamicObject[] regbasebills;
        HashMap<Long, List> map = new HashMap<Long, List>();
        Map importDataMap = list.stream().filter(importBillData -> {
            JSONObject entry = importBillData.getData().getJSONObject("entryentity");
            if (entry.containsKey((Object)"MustInputPass") && !entry.getBoolean("MustInputPass").booleanValue()) {
                return false;
            }
            return !entry.containsKey((Object)"validatorflag") || entry.getBoolean("validatorflag") != false;
        }).collect(Collectors.toMap(importBillData -> importBillData.getData().getJSONObject("entryentity").getJSONObject("ermanfile").getLong("id"), Function.identity(), (oldV, newV) -> oldV));
        QFilter ermanfileFilter = new QFilter("ermanfile", "in", importDataMap.keySet());
        if (Long.parseLong(this.pkValue.toString()) > 0L) {
            ermanfileFilter.and(new QFilter("mid", "!=", this.pkValue));
        }
        QFilter billstatusFilter = new QFilter("billstatus", "not in", (Object)new String[]{RegBillStatusEnum.ABANDONED.getCode(), RegBillStatusEnum.DELETED.getCode(), RegBillStatusEnum.PENDING_PERSONNEL_CONFIRM.getCode()});
        for (DynamicObject regbasebill : regbasebills = RegApplyRepository.getRepository().query("ermanfile.id, regstatus,billstatus, auditstatus, billno, id, mid, regcategory,regcomment.id", new QFilter[]{ermanfileFilter, billstatusFilter})) {
            long ermanfileId;
            String regstatus = regbasebill.getString("regstatus");
            if ("1010".equals(regstatus) && RegBillStatusEnum.APPROVEPASSED.getCode().equals(regbasebill.getString("billstatus")) || "1010".equals(regstatus) && RegBillStatusEnum.APPROVEREJECTED.getCode().equals(regbasebill.getString("billstatus")) || !importDataMap.containsKey(ermanfileId = regbasebill.getLong("ermanfile.id"))) continue;
            ImportBillData importBillData2 = (ImportBillData)importDataMap.get(ermanfileId);
            long mid = regbasebill.getLong("mid");
            if (mid != 0L) {
                List ibds = map.getOrDefault(mid, new ArrayList());
                ibds.add(importBillData2);
                map.put(mid, ibds);
                continue;
            }
            RegServiceHelper.writeErrorInfo((ImportBillData)importBillData2, (ImportLog)importLog, (String)String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u201c%1$s\u201d\u5b58\u5728\u5176\u4ed6\u7684\u8f6c\u6b63\u4e8b\u52a1\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\u201c%2$s\u201d\uff0c\u4e0d\u53ef\u91cd\u590d\u53d1\u8d77\u3002", (String)"RegBillUniqueValidator_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]), importBillData2.getData().getJSONObject("entryentity").getJSONObject("ermanfile").getString("ermanfileNameInDb"), regbasebill.getString("billno")));
        }
        if (map.isEmpty()) {
            return;
        }
        DynamicObject[] batchRegs = BatchRegRepository.getInstance().queryByIds("billno, id", map.keySet());
        if (batchRegs == null || batchRegs.length == 0) {
            return;
        }
        for (DynamicObject batchReg : batchRegs) {
            long applyId = batchReg.getLong("id");
            List importBillDatas = (List)map.get(applyId);
            importBillDatas.forEach(importBillData -> RegServiceHelper.writeErrorInfo((ImportBillData)importBillData, (ImportLog)importLog, (String)String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u201c%1$s\u201d\u5b58\u5728\u5176\u4ed6\u7684\u8f6c\u6b63\u4e8b\u52a1\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\u201c%2$s\u201d\uff0c\u4e0d\u53ef\u91cd\u590d\u53d1\u8d77\u3002", (String)"RegBillUniqueValidator_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]), importBillData.getData().getJSONObject("entryentity").getJSONObject("ermanfile").getString("ermanfileNameInDb"), batchReg.getString("billno"))));
        }
    }
}

