/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.batch.importvalidator;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hdm.business.reg.RegServiceHelper;
import kd.hr.hpfs.business.service.cert.HRCertValidateServiceHelper;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.enu.ValidatorOrderEnum;
import kd.hrmp.hies.entry.core.validate.AbstractEntryValidateHandler;

public class RegLicenseValidator
extends AbstractEntryValidateHandler {
    private static final Log LOGGER = LogFactory.getLog(RegLicenseValidator.class);

    public ValidatorOrderEnum setValidatorRole() {
        return ValidatorOrderEnum.BEFORE;
    }

    public void validate(List<ImportBillData> list, ImportLog importLog) {
        HashMap<Long, ImportBillData> dataMap = new HashMap<Long, ImportBillData>(list.size());
        ArrayList personIdList = new ArrayList(list.size());
        list.forEach(importBillData -> {
            JSONObject entry = importBillData.getData().getJSONObject("entryentity");
            if (entry.containsKey((Object)"MustInputPass") && !entry.getBoolean("MustInputPass").booleanValue() || entry.containsKey((Object)"validatorflag") && !entry.getBoolean("validatorflag").booleanValue()) {
                return;
            }
            JSONObject ermanfile = entry.getJSONObject("ermanfile");
            Long personId = ermanfile.getLong("person_id");
            if (personId != null && personId != 0L) {
                personIdList.add(personId);
                dataMap.put(personId, (ImportBillData)importBillData);
            }
        });
        Map personLicenseMap = HRCertValidateServiceHelper.checkPersonLicenses(personIdList);
        dataMap.forEach((personId, importBillData) -> {
            if (personLicenseMap == null || !personLicenseMap.containsKey(personId)) {
                RegServiceHelper.writeErrorInfo((ImportBillData)importBillData, (ImportLog)importLog, (String)ResManager.loadKDString((String)"\u672a\u68c0\u67e5\u5230\u8bb8\u53ef\u4eba\u5458\u3002", (String)"RegLicenseValidator_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                return;
            }
            Map licenseMap = (Map)personLicenseMap.get(personId);
            if (licenseMap.size() > 0 && !((Boolean)licenseMap.get("status")).booleanValue()) {
                RegServiceHelper.writeErrorInfo((ImportBillData)importBillData, (ImportLog)importLog, (String)String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u65e0\u6cd5\u53d1\u8d77\u8f6c\u6b63\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"RegLicenseValidator_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]), licenseMap.get("name"), licenseMap.get("number")));
            }
        });
    }
}

