/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.exam;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TipsListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.EntityOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hdm.business.personnelchange.servicehelper.PersonnelChangeServiceHelper;
import kd.hr.hdm.business.reg.RegExamServiceHelper;
import kd.hr.hdm.business.reg.RegPeronalBillHelper;
import kd.hr.hdm.business.reg.RegProcessServiceHelper;
import kd.hr.hdm.business.reg.validator.RegCommonValidatorHelper;
import kd.hr.hdm.formplugin.reg.web.RegAskAndExamCommon;
import kd.hr.hdm.formplugin.reg.web.exam.RegExamCommon;
import kd.hr.hdm.formplugin.reg.web.exam.RegTestModelDynamicView;

public class RegExamReplyEdit
extends HRDataBaseEdit
implements TipsListener {
    private static final Log logger = LogFactory.getLog(RegExamReplyEdit.class);
    private RegAskAndExamCommon regAskAndExamCommon = new RegAskAndExamCommon();
    private static final String KEY_EXAMPERSON = "examperson";
    private static final String[] BUSINESS_CARD_ARR = new String[]{"superior", "charge"};
    private static final String FLEX_EVALUATE = "flexevaluate";
    private static final String FLEX_LISTITEM = "flexlistitem";
    private static final String FLEX_TESTITEM = "flextestitem";
    private static final String FLEX_TITLECONTAINER = "flextitlecontainer";
    private static final String LBL_TITLETEXT = "lbltitletext";
    private static final String LBL_ITEMNUMBER = "lblitemnumber";
    private static final String LBL_EXAMITEM = "lblexamitem";
    private static final String LBL_GRADE = "lblgrade";
    private static final String VECTOR_EVALUATE = "vecevaluate";
    private static final String KEY_TITLECONTAINER = "titlecontainer";
    private static final String FLAG_S = "s";
    private static final String PREFIX_0 = "0";
    private static final String FIELD_REGEXAMITEM = "examitem";
    private static final String FIELD_REGITEMSCORE = "entryscore";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Arrays.stream(BUSINESS_CARD_ARR).forEach(item -> this.addTipsListener((String)item));
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        BillShowParameter parameter = (BillShowParameter)e.getFormShowParameter();
        String pageId = parameter.getPageId();
        PageCache cache = new PageCache(pageId);
        String pkId = (String)parameter.getCustomParam("detailId");
        QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(pkId));
        QFilter isNewFilter = new QFilter("isnewest", "=", (Object)"1");
        DynamicObject examDetail = RegExamServiceHelper.DETAILS_SERVICE_HELPER.queryOne("person_id,bemployee,examperson_id", new QFilter[]{idFilter, isNewFilter});
        if (Objects.isNull(examDetail)) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u88ab\u64a4\u56de\uff0c\u65e0\u6cd5\u7ee7\u7eed\u63d0\u4ea4\u3002", (String)"RegExamReplyEdit_4", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        Long examPerson = examDetail.getLong("examperson_id");
        cache.put(KEY_EXAMPERSON, String.valueOf(examPerson));
        long current = RequestContext.get().getCurrUserId();
        if (examPerson == 0L || current != examPerson) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u8003\u8bc4\u5904\u7406\u4eba\uff0c\u65e0\u6743\u5904\u7406\u3002", (String)"RegExamReplyEdit_5", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
        Long personId = examDetail.getLong("person_id");
        cache.put("person", String.valueOf(personId));
        Long employeeId = examDetail.getLong("bemployee");
        cache.put("employee", String.valueOf(employeeId));
        parameter.setCustomParam("employee", (Object)employeeId);
        parameter.setHasRight(true);
        HRBaseServiceHelper personService = new HRBaseServiceHelper("hrpi_person");
        DynamicObject personObject = personService.queryOne("name", (Object)personId);
        String personName = personObject.getString("name");
        parameter.setCaption(ResManager.loadKDString((String)"\u8f6c\u6b63\u8003\u8bc4 - %s", (String)"RegExamReplyEdit_2", (String)"hr-hdm-formplugin", (Object[])new Object[]{personName}));
        parameter.setPkId((Object)Long.valueOf(pkId));
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (key.contains(VECTOR_EVALUATE)) {
            Vector evaluateVector = new Vector();
            evaluateVector.setKey(key);
            evaluateVector.setView(this.getView());
            evaluateVector.addClickListener((ClickListener)this);
            e.setControl((Control)evaluateVector);
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        BillShowParameter billShowParameter = (BillShowParameter)e.getSource();
        Long pkId = (Long)billShowParameter.getPkId();
        this.loadCustomPanel(e, pkId);
    }

    public void afterLoadData(EventObject e) {
        Long employee = Long.valueOf(this.getPageCache().get("employee"));
        String regStatus = RegProcessServiceHelper.getRegStatusByEmployee((Long)employee);
        this.getPageCache().put("regstatus", regStatus);
        IFormView view = this.getView();
        Long erManFileId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("ermanfile"));
        ArrayList<Long> erManFileIdList = new ArrayList<Long>();
        erManFileIdList.add(erManFileId);
        List ermanfileList = (List)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getCardFields", (Object[])new Object[]{erManFileIdList});
        if (CollectionUtils.isEmpty((Collection)ermanfileList)) {
            throw new KDBizException(new ErrorCode("hr.hdm.loadermanfile.error", ResManager.loadKDString((String)"\u52a0\u8f7d\u4eba\u5458\u6863\u6848\u5f02\u5e38\u3002", (String)"RegExamReplyEdit_1", (String)"hr-hdm-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        RegPeronalBillHelper.getInstance().loadCommonPersonInfo((Map)ermanfileList.get(0), this.getView());
        RegPeronalBillHelper.getInstance().loadChargeInfoAndSup((Map)ermanfileList.get(0), this.getView());
        RegPeronalBillHelper.getInstance().loadRegularBaseInfo(employee, regStatus, this.getModel().getDataEntity(), view);
        RegPeronalBillHelper.getInstance().loadAskOrExamHead(this.getView(), this.getModel());
        this.mySelfRegularExam();
        String comment = (String)this.getModel().getValue("comment");
        if (!HRStringUtils.isEmpty((String)comment)) {
            this.getModel().setValue("commentshow", (Object)comment);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String regStatus = this.getPageCache().get("regstatus");
        Long employee = Long.valueOf(this.getPageCache().get("employee"));
        boolean isQuit = PersonnelChangeServiceHelper.isQuit((long)employee);
        this.viewControl(regStatus, isQuit);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        this.regAskAndExamCommon.propertyChanged(key, this.getView());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.contains(VECTOR_EVALUATE)) {
            String subKey = key.substring(VECTOR_EVALUATE.length());
            Long examItemId = Long.valueOf(subKey.split(FLAG_S)[0]);
            int index = Integer.parseInt(subKey.split(FLAG_S)[1]);
            String grade = RegExamCommon.getGradeText(index + 1);
            this.updateExamScore(examItemId, index + 1);
            FlexPanelAp evaluatePanelAp = this.createEvaluatePanelAp(FLEX_EVALUATE + examItemId, examItemId, index + 1, grade, true);
            this.getView().updateControlMetadata(FLEX_EVALUATE + examItemId, evaluatePanelAp.createControl());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"submit")) {
            String regStatus = this.getPageCache().get("regstatus");
            Long employee = Long.valueOf(this.getPageCache().get("employee"));
            boolean isQuit = PersonnelChangeServiceHelper.isQuit((long)employee);
            this.viewControl(regStatus, isQuit);
            BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
            Long pkId = (Long)billShowParameter.getPkId();
            FlexPanelAp testModelPanelAp = this.buildStartComment(pkId, regStatus, isQuit);
            testModelPanelAp.setDirection("column");
            testModelPanelAp.setAlignItems("stretch");
            testModelPanelAp.setJustifyContent("flex-start");
            this.getView().updateControlMetadata("flextestmodel", testModelPanelAp.createControl());
        }
    }

    private void loadCustomPanel(LoadCustomControlMetasArgs e, Long pkId) {
        BillShowParameter billShowParameter = (BillShowParameter)e.getSource();
        Long employee = (Long)billShowParameter.getCustomParam("employee");
        DynamicObject processObject = RegProcessServiceHelper.PROCESS_SERVICE_HELPER.queryOne("regstatus", new QFilter("bemployee", "=", (Object)employee));
        String regStatus = processObject.getString("regstatus");
        boolean isQuit = PersonnelChangeServiceHelper.isQuit((long)employee);
        FlexPanelAp testModelPanelAp = this.buildStartComment(pkId, regStatus, isQuit);
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("id", "flextestmodel");
        paramsMap.put("items", (String)testModelPanelAp.createControl().get("items"));
        e.getItems().add(paramsMap);
    }

    private FlexPanelAp buildStartComment(Long pkId, String regStatus, boolean isQuit) {
        boolean regComplete = HRStringUtils.equals((String)regStatus, (String)"1040") || HRStringUtils.equals((String)regStatus, (String)"1050");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hdm_regexamreply");
        String select = "id,iscomment,entryentity.examtype,entryentity.examitem,entryentity.entryscore";
        DynamicObject detailsObj = serviceHelper.queryOne(select, (Object)pkId);
        DynamicObjectCollection entryEntity = detailsObj.getDynamicObjectCollection("entryentity");
        List<Map<String, Object>> examTypeList = RegExamCommon.parseEntryEntityData(entryEntity);
        Map<String, Object> examScoreMap = this.getExamScoreMap(entryEntity);
        boolean enable = !isQuit && !regComplete && !detailsObj.getBoolean("iscomment");
        return this.createTestPanelAp(examTypeList, examScoreMap, enable);
    }

    private Map<String, Object> getExamScoreMap(DynamicObjectCollection entryEntity) {
        HashMap<String, Object> examScoreMap = new HashMap<String, Object>();
        for (DynamicObject itemObject : entryEntity) {
            String itemId = itemObject.getDynamicObject(FIELD_REGEXAMITEM).getString("id");
            Integer score = itemObject.getInt(FIELD_REGITEMSCORE);
            examScoreMap.put(itemId, score);
        }
        return examScoreMap;
    }

    private FlexPanelAp createTestPanelAp(List<Map<String, Object>> examTypeList, Map<String, Object> examScoreMap, boolean enable) {
        FlexPanelAp testPanelAp = new FlexPanelAp();
        testPanelAp.setWrap(false);
        testPanelAp.setKey("flextestmodel");
        int size = examTypeList.size();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> examTypeMap = examTypeList.get(i);
            FlexPanelAp testItemAp = this.createTestItemPanelAp(examTypeMap, examScoreMap, i, enable);
            testPanelAp.getItems().add(testItemAp);
        }
        return testPanelAp;
    }

    private FlexPanelAp createTestItemPanelAp(Map<String, Object> examTypeMap, Map<String, Object> examScoreMap, int index, boolean enable) {
        String examTypeName = (String)examTypeMap.get("examtypename");
        List examItemList = (List)examTypeMap.get("examitemlist");
        RegTestModelDynamicView dynamicView = new RegTestModelDynamicView();
        FlexPanelAp testItemPanelAp = dynamicView.customExamItemListPanelAp(FLEX_TESTITEM + index);
        if (examItemList == null || examItemList.size() == 0) {
            return testItemPanelAp;
        }
        FlexPanelAp titleContainerAp = dynamicView.customTitleContainerAp(FLEX_TITLECONTAINER + index);
        LabelAp titleTextAp = dynamicView.customTitleTextAp(LBL_TITLETEXT + index, examTypeName);
        titleContainerAp.getItems().add(titleTextAp);
        Style itemStyle = new Style();
        Margin itemMargin = new Margin();
        itemMargin.setTop("15px");
        itemStyle.setMargin(itemMargin);
        Border border = new Border();
        String borderType = "1px_solid_#d9d9d9";
        border.setTop(borderType);
        border.setLeft(borderType);
        border.setRight(borderType);
        border.setBottom(borderType);
        itemStyle.setBorder(border);
        testItemPanelAp.setStyle(itemStyle);
        testItemPanelAp.getItems().add(titleContainerAp);
        int size = examItemList.size();
        for (int i = 0; i < size; ++i) {
            Map itemMap = (Map)examItemList.get(i);
            Long examItemId = Long.valueOf(itemMap.get("examitemid").toString());
            String examItemName = (String)itemMap.get("examitemname");
            FlexPanelAp itemContainerAp = dynamicView.customItemPanelAp(KEY_TITLECONTAINER + i + index);
            String numPrefix = PREFIX_0;
            if (i > 9) {
                numPrefix = "";
            }
            String numberColor = "#666666";
            String borderColor = "#d9d9d9";
            Integer score = (Integer)examScoreMap.get(examItemId.toString());
            if (score == null) {
                score = 0;
            }
            String grade = RegExamCommon.getGradeText(score);
            LabelAp itemNumLabelAp = dynamicView.customItemNumberAp(LBL_ITEMNUMBER + i, numPrefix + (i + 1), numberColor);
            FlexPanelAp listItemPanelAp = dynamicView.customListItemAp(FLEX_LISTITEM + i + index, borderColor);
            LabelAp examItemLabelAp = dynamicView.customExamItemLabelAp(LBL_EXAMITEM + i + index, examItemName);
            FlexPanelAp evaluatePanelAp = this.createEvaluatePanelAp(FLEX_EVALUATE + examItemId, examItemId, score, grade, enable);
            listItemPanelAp.getItems().add(examItemLabelAp);
            listItemPanelAp.getItems().add(evaluatePanelAp);
            itemContainerAp.getItems().add(itemNumLabelAp);
            itemContainerAp.getItems().add(listItemPanelAp);
            testItemPanelAp.getItems().add(itemContainerAp);
        }
        return testItemPanelAp;
    }

    private FlexPanelAp createEvaluatePanelAp(String apKey, Long examItemId, int clickIndex, String grade, boolean enable) {
        FlexPanelAp evaluatePanelAp = new FlexPanelAp();
        evaluatePanelAp.setKey(apKey);
        evaluatePanelAp.setGrow(0);
        RegTestModelDynamicView dynamicView = new RegTestModelDynamicView();
        FlexPanelAp evaluateStarAp = dynamicView.customEvaluateStarAp(examItemId, enable, enable, clickIndex);
        LabelAp gradeTextAp = dynamicView.customGradeTextAp(LBL_GRADE + examItemId, grade);
        evaluateStarAp.getItems().add(0, gradeTextAp);
        evaluatePanelAp.getItems().add(evaluateStarAp);
        return evaluatePanelAp;
    }

    private void updateExamScore(Long examItemId, int score) {
        String itemMapJson = this.getPageCache().get("examitemMap");
        try {
            HashMap<String, Integer> examItemMap;
            if (itemMapJson != null) {
                examItemMap = HRJSONUtils.convertJSONObjectToMap((Object)itemMapJson);
            } else {
                DynamicObjectCollection itemObjects = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                int size = itemObjects.size();
                examItemMap = new HashMap<String, Integer>(2 * size);
                for (int i = 0; i < size; ++i) {
                    String itemId = ((DynamicObject)itemObjects.get(i)).getDynamicObject(FIELD_REGEXAMITEM).getString("id");
                    examItemMap.put(itemId, i);
                }
                this.getPageCache().put("examitemMap", HRJSONUtils.toString(examItemMap));
            }
            int row = (Integer)examItemMap.get(examItemId + "");
            boolean isChanged = this.getModel().getDataChanged();
            this.getModel().setValue(FIELD_REGITEMSCORE, (Object)score, row);
            if (!isChanged) {
                this.getModel().setDataChanged(false);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private void mySelfRegularExam() {
        Long personId = Long.valueOf(this.getView().getPageCache().get("person"));
        ArrayList<Long> personIdList = new ArrayList<Long>();
        personIdList.add(personId);
        Map userIdMap = RegPeronalBillHelper.getInstance().queryUserIdMap(personIdList);
        Long userId = (Long)userIdMap.get(personId);
        this.getView().getPageCache().put("user", String.valueOf(userId));
        String examPersonId = this.getPageCache().get(KEY_EXAMPERSON);
        if (HRObjectUtils.equals((Object)String.valueOf(userId), (Object)examPersonId)) {
            Label lblAskComment = (Label)this.getView().getControl("lblexamcomment");
            lblAskComment.setText(ResManager.loadKDString((String)"\u81ea\u6211\u8bc4\u4ef7\uff1a", (String)"RegExamReplyEdit_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
    }

    private void viewControl(String regStatus, boolean isQuit) {
        boolean visible;
        String status = (String)this.getModel().getValue("status");
        if (HRStringUtils.equals((String)status, (String)"1030")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"commentflex", "opinionflex"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"commentflex", "opinionflex"});
        }
        boolean regComplete = HRStringUtils.equals((String)regStatus, (String)"1040") || HRStringUtils.equals((String)regStatus, (String)"1050");
        boolean bl = visible = regComplete || isQuit;
        if (visible) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"commentflex", "opinionflex"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        EntityOperate operate = (EntityOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"submit")) {
            BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
            Long pkId = (Long)parameter.getPkId();
            QFilter employeeFilter = new QFilter("id", "=", (Object)pkId);
            QFilter isNewFilter = new QFilter("isnewest", "=", (Object)"1");
            DynamicObject examDetail = RegExamServiceHelper.DETAILS_SERVICE_HELPER.queryOne("id", new QFilter[]{employeeFilter, isNewFilter});
            if (Objects.isNull(examDetail)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u88ab\u64a4\u56de\uff0c\u65e0\u6cd5\u7ee7\u7eed\u63d0\u4ea4\u3002", (String)"RegExamReplyEdit_4", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject item : collection) {
                int score = item.getInt(FIELD_REGITEMSCORE);
                if (score != 0) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff1a\u5b58\u5728\u5f85\u8bc4\u4ef7\u7684\u8003\u8bc4\u9898\u76ee\uff0c\u8bf7\u8bc4\u4ef7\u5b8c\u6210\u540e\u518d\u63d0\u4ea4\u3002", (String)"RegExamReplyEdit_3", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Long employeeId = (Long)this.getModel().getValue("bemployee");
            Map result = RegCommonValidatorHelper.getInstance().validateExamRegStatus(employeeId, this.getView());
            Boolean flag = Boolean.parseBoolean((String)result.get("validateResult"));
            if (!flag.booleanValue()) {
                String msg = (String)result.get("msg");
                this.getView().showErrorNotification(msg);
                args.setCancel(true);
                return;
            }
            this.getModel().setValue("ermanfile", parameter.getShowParameter().getCustomParam("ermanfile"));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void beforeShowTips(BeforeShowTipsEvent evt) {
        RegPeronalBillHelper.getInstance().beforeShowTips(evt, this.getView());
    }

    public void afterShowTips(AfterShowTipsEvent afterShowTipsEvent) {
    }

    private void addTipsListener(String key) {
        IFormView formView = this.getView();
        Image image = (Image)formView.getControl(String.format("%simage1", key));
        if (image != null) {
            image.addTipsListener((TipsListener)this);
        }
    }
}

