/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.workbench;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hdm.business.reg.domain.service.bill.IPersonAboutService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.business.reg.validator.RegApplyValidatorHelper;
import kd.hr.hdm.business.repository.RegApplyRepository;
import kd.hr.hdm.common.parttime.entity.DataValidate;
import kd.hr.hdm.common.parttime.enums.ValidateRangeEnum;
import kd.hr.hdm.common.reg.enums.RegBillServiceEnum;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.formplugin.reg.web.applybill.RegPageUtils;

public class RegApplyBillButtonListPlugin
extends AbstractListPlugin {
    private static final Log LOGGER = LogFactory.getLog(RegApplyBillButtonListPlugin.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        int selectedSize = selectedRows.size();
        Map<Long, Object> regBillMap = new HashMap<Long, DynamicObject>(selectedSize);
        List<Object> ids = new ArrayList(selectedSize);
        if (selectedSize > 0) {
            ids = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).map(Object::toString).map(Long::parseLong).collect(Collectors.toList());
            regBillMap = RegApplyRepository.getRepository().queryByIds(new String[]{"billstatus", "person", "org", "billno", "ermanfile", "probation", "affaction", "probationunit", "probationex", "probationunitex", "auditstatus", "regbilltype", "billstatus", "regstatus", "entrydate", "effectdate", "ismobile", "bemployee", "regcategory", "termreason", "termdate", "termuser", "modifytime", "preactualdate"}, ids);
        }
        switch (operateKey) {
            case "unsubmit": {
                if (selectedSize == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64a4\u9500\u7684\u5355\u636e\u3002", (String)"RegularApplySourceList_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (selectedSize == 1) {
                    DynamicObject regBill = (DynamicObject)regBillMap.get(ids.get(0));
                    String billStatus = regBill.getString("billstatus");
                    if (!RegBillStatusEnum.ALREADYSUBMIT.getCode().equals(billStatus) && !RegBillStatusEnum.APPROVING.getCode().equals(billStatus)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u64a4\u9500\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u63d0\u4ea4\u201d\u201c\u5ba1\u6279\u4e2d\u201d\u7684\u5355\u636e\uff0c\u5f53\u524d\u5355\u636e\u4e3a\u201c%s\u201d\uff0c\u4e0d\u80fd\u64a4\u9500\u3002", (String)"RegularApplySourceList_2", (String)"hr-hdm-formplugin", (Object[])new Object[]{RegBillStatusEnum.getName((String)billStatus)}));
                        args.setCancel(true);
                        return;
                    }
                    this.unSubmitConfirm(args, operate);
                    break;
                }
                ArrayList<DynamicObject> regBills = new ArrayList<DynamicObject>(regBillMap.values());
                if (this.allBillsAuditStatus(regBills)) {
                    this.unSubmitConfirm(args, operate);
                    break;
                }
                if (!this.allBillsAuditStatusNotEqBD(regBills)) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u64a4\u9500\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u63d0\u4ea4\u201d\u201c\u5ba1\u6279\u4e2d\u201d\u7684\u5355\u636e\u3002", (String)"RegularApplySourceList_4", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            case "submit": {
                this.doBatchValidateBills(operate, args, regBillMap);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (null == operationResult || !operationResult.isSuccess()) {
            return;
        }
        switch (args.getOperateKey()) {
            case "submit": {
                this.getView().invokeOperation("refresh");
                this.getView().sendFormAction(this.getView());
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"unsubmit", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
            this.getView().invokeOperation("unsubmit", operateOption);
        }
        if (StringUtils.equals((CharSequence)"submit", (CharSequence)(callBackId = messageBoxClosedEvent.getCallBackId())) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(callBackId, "true");
            operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
            this.getView().invokeOperation(callBackId, operateOption);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    private void unSubmitConfirm(BeforeDoOperationEventArgs args, FormOperate operate) {
        RefObject afterConfirm = new RefObject();
        if (!operate.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("unsubmit", (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6570\u636e\u64a4\u9500\u540e\u6d41\u7a0b\u5c06\u56de\u5230\u201c\u6682\u5b58\u201d\u72b6\u6001\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"RegularApplySourceList_3", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            args.setCancel(true);
        }
    }

    private boolean allBillsAuditStatus(List<DynamicObject> regBills) {
        for (DynamicObject regBill : regBills) {
            String billStatus = regBill.getString("billstatus");
            if (RegBillStatusEnum.ALREADYSUBMIT.getCode().equals(billStatus) || RegBillStatusEnum.APPROVING.getCode().equals(billStatus)) continue;
            return false;
        }
        return true;
    }

    private boolean allBillsAuditStatusNotEqBD(List<DynamicObject> regBills) {
        for (DynamicObject regBill : regBills) {
            String billStatus = regBill.getString("billstatus");
            if (!RegBillStatusEnum.ALREADYSUBMIT.getCode().equals(billStatus) && !RegBillStatusEnum.APPROVING.getCode().equals(billStatus)) continue;
            return false;
        }
        return true;
    }

    private void doBatchValidateBills(FormOperate operate, BeforeDoOperationEventArgs args, Map<Long, DynamicObject> regBillMap) {
        if (regBillMap.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> regBills = new ArrayList<DynamicObject>(regBillMap.values());
        DataValidate listDataValidate = RegApplyValidatorHelper.validateRegApplyBillStatus(regBills);
        ValidateRangeEnum range = listDataValidate.getValidatorContext().getRange();
        if (ValidateRangeEnum.VALIDATE_ERROR == range) {
            this.getView().showErrorNotification(listDataValidate.getValidatorContext().map2String());
            args.setCancel(true);
            return;
        }
        List empIds = regBillMap.values().stream().map(temp -> temp.getLong("bemployee.id")).collect(Collectors.toList());
        Map empIdsWithLabStatus = IPersonAboutService.getInstance().getLabStatusByEmpId(empIds);
        Map crossBatchMap = IPersonAboutService.getInstance().doPersonCrossValidateBatch(regBills);
        Boolean isSuccess = (Boolean)crossBatchMap.get("success");
        Map crossListMap = null;
        if (isSuccess.booleanValue()) {
            crossListMap = (Map)crossBatchMap.get("data");
        } else {
            LOGGER.error((String)crossBatchMap.get("errorMsg"));
        }
        Map finalCrossListMap = crossListMap;
        HashMap<String, List<String>> errorMap = new HashMap<String, List<String>>();
        errorMap.put(RegBillServiceEnum.WARNING.getCode(), new ArrayList());
        errorMap.put(RegBillServiceEnum.ERROR.getCode(), new ArrayList());
        regBills.forEach(bill -> {
            long empId = bill.getLong("bemployee.id");
            boolean hitErrorMsg = IRegBillService.getInstance().doValidateBillNotInTempStorage(bill, errorMap);
            if (!hitErrorMsg) {
                hitErrorMsg = IRegBillService.getInstance().doValidateIfSelfApply(bill, errorMap);
            }
            if (!hitErrorMsg) {
                hitErrorMsg = IPersonAboutService.getInstance().validateLabStatus(bill, errorMap, (DynamicObject)empIdsWithLabStatus.get(empId), Boolean.TRUE);
            }
            Long depEmpId = bill.getDynamicObject("ermanfile").getLong("depemp_id");
            if (!hitErrorMsg && isSuccess.booleanValue()) {
                hitErrorMsg = IPersonAboutService.getInstance().doPersonCrossValidateForBatch(bill, errorMap, (List)finalCrossListMap.get(depEmpId));
            }
            if (!hitErrorMsg) {
                IRegBillService.getInstance().doValidateEffectDateAndPreActualDate(bill, errorMap);
            }
        });
        if (regBills.size() == 1) {
            if (RegPageUtils.showError(errorMap, args, this.getView())) {
                return;
            }
            this.showConfirm(operate, errorMap, args);
        }
    }

    private void showConfirm(FormOperate operate, Map<String, List<String>> errorMap, BeforeDoOperationEventArgs args) {
        RefObject afterConfirmObj = new RefObject();
        if (!operate.getOption().tryGetVariableValue(operate.getOperateKey(), afterConfirmObj)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(operate.getOperateKey(), (IFormPlugin)this);
            List<String> warningList = errorMap.get(RegBillServiceEnum.WARNING.getCode());
            if (!ObjectUtils.isEmpty(warningList)) {
                StringBuilder sb = new StringBuilder();
                warningList.forEach(temp -> sb.append((String)temp).append("\r\n"));
                this.getView().showConfirm(sb.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                args.setCancel(true);
            }
        }
    }
}

