/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.workbench;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.repository.RegAskDetailsRepository;
import kd.hr.hdm.business.repository.RegProbationPersonQueryRepository;
import kd.hr.hdm.common.reg.util.RegCommonUtil;
import kd.hr.hdm.formplugin.reg.web.workbench.common.RegAskExamQueryListCommonPlugin;

public class RegAskQueryListPlugin
extends RegAskExamQueryListCommonPlugin {
    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        QFilter filter = RegProbationPersonQueryRepository.getInstance().getRegAskQFilters(null);
        event.getQFilters().add(filter);
    }

    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        super.listColumnCompareTypesSet(args);
        String listFieldKey = args.getListFieldKey();
        if (HRStringUtils.equals((String)listFieldKey, (String)"hrpi_trialperiod.askstatus")) {
            List comboItems = args.getComboItems();
            for (int i = comboItems.size() - 1; i >= 0; --i) {
                ValueMapItem valueMapItem = (ValueMapItem)comboItems.get(i);
                String value = valueMapItem.getValue();
                if (HRStringUtils.equals((String)value, (String)"1020") || HRStringUtils.equals((String)value, (String)"1030")) continue;
                comboItems.remove(valueMapItem);
            }
        }
    }

    public void afterExportFile(ExportFileEvent evt) {
        evt.setFileName(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5217\u8868_\u8f6c\u6b63\u95ee\u8be2_%1$s", (String)"RegAskQueryListPlugin_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]), HRDateTimeUtils.format((Date)new Date(), (String)"MMddHHmmss")));
    }

    @Override
    public void beforePackageData(BeforePackageDataEvent event) {
        super.beforePackageData(event);
        DynamicObjectCollection collection = event.getPageData();
        if (collection.isEmpty()) {
            return;
        }
        List employeeIds = collection.stream().map(dy -> dy.getLong("employee_id")).collect(Collectors.toList());
        Map askCompProgressMap = RegAskDetailsRepository.getRepository().getAskCompProgress(employeeIds);
        RegCommonUtil.registerCommonProp((DynamicObjectCollection)collection, (String[])new String[]{"preregdateremaindays", "askcompprogress"});
        collection.forEach(dy -> {
            Date preRegularDate = dy.getDate("hrpi_trialperiod.preregulardate");
            if (preRegularDate != null) {
                dy.set("preregdateremaindays", (Object)ResManager.loadKDString((String)"%s\u5929", (String)"RegAskQueryListPlugin_1", (String)"hr-hdm-formplugin", (Object[])new Object[]{HRDateTimeUtils.dateDiff((String)"d", (Date)RegCommonUtil.getNowDate(), (Date)preRegularDate)}));
            }
            Long employeeId = dy.getLong("employee_id");
            dy.set("askcompprogress", askCompProgressMap.get(employeeId));
        });
    }

    @Override
    public void packageData(PackageDataEvent event) {
        String key;
        super.packageData(event);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)event.getSource();
        switch (key = columnDesc.getKey()) {
            case "preregdateremaindays": 
            case "askcompprogress": {
                event.setFormatValue((Object)event.getRowData().getString(key));
                break;
            }
        }
    }
}

