/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.workbench;

import java.util.EventObject;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.hr.hdm.business.repository.RegNearPreDateRepository;
import kd.hr.hdm.business.repository.RegProbationPersonQueryRepository;
import kd.hr.hdm.formplugin.reg.web.workbench.common.RegWorkBenchCardPlugin;

public class RegWarningPlugin
extends RegWorkBenchCardPlugin {
    private static final String DUE_REG_COUNT = "dueregcount";
    private static final String RECENT_PRE_REG_COUNT = "recentpreregcount";

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{DUE_REG_COUNT, RECENT_PRE_REG_COUNT});
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "dueregcount": {
                this.openListPage("hdm_regduepersonquerylist");
                break;
            }
            case "recentpreregcount": {
                this.openListPage("hdm_regnearpredate");
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        QFilter filter = RegProbationPersonQueryRepository.getInstance().getOrgAndAffiliateAdminOrgFilter(this.getView(), "affiliateadminorg", "org");
        this.setDueRegCount(filter);
        this.setNearPreRegCount(filter);
    }

    private void setDueRegCount(QFilter filter) {
        Label label = (Label)this.getView().getControl(DUE_REG_COUNT);
        int dueRgeCount = RegProbationPersonQueryRepository.getInstance().dueRgeCount(filter);
        label.setText(this.getDisplayText(dueRgeCount));
    }

    private void setNearPreRegCount(QFilter filter) {
        Label label = (Label)this.getView().getControl(RECENT_PRE_REG_COUNT);
        int nearPreRgeCount = RegNearPreDateRepository.getRepository().nearPreRgeCount(filter);
        label.setText(this.getDisplayText(nearPreRgeCount));
    }
}

