/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.workbench;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.pluginnew.GridContainerPlugin;
import kd.hr.hdm.business.repository.RegProbationPersonQueryRepository;

public class RegWorkBenchPlugin
extends GridContainerPlugin
implements BeforeF7SelectListener {
    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        FormShowParameter formShowParameter = args.getFormShowParameter();
        formShowParameter.setCustomParam("customHREntityNumber", (Object)"hdm_probationquery");
        formShowParameter.setCustomParam("custom_parent_f7_prop", (Object)"affiliateadminorg");
        formShowParameter.setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        DynamicObjectCollection newOrgObjects = (DynamicObjectCollection)args.getChangeSet()[0].getNewValue();
        switch (propertyName) {
            case "borg": {
                this.changeOrg(newOrgObjects);
                super.refreshGridContainer();
                break;
            }
            case "baffiliateadminorg": {
                this.changeAdminOrg(newOrgObjects);
                super.refreshGridContainer();
                break;
            }
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("borg");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit adminOrgEdit = (BasedataEdit)this.getControl("baffiliateadminorg");
        adminOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propertyName = evt.getProperty().getName();
        RegProbationPersonQueryRepository instance = RegProbationPersonQueryRepository.getInstance();
        List customQFilters = evt.getCustomQFilters();
        switch (propertyName) {
            case "borg": {
                QFilter orgFilter = instance.getOrgPermissionFilter("id");
                if (orgFilter == null) break;
                customQFilters.add(orgFilter);
                break;
            }
            case "baffiliateadminorg": {
                QFilter adminOrgFilter = instance.getAdminOrgPermissionFilter("id");
                if (adminOrgFilter == null) break;
                QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
                customQFilters.add(adminOrgFilter.and(currentVersionFilter));
                break;
            }
        }
    }

    private void changeAdminOrg(DynamicObjectCollection newAdminOrgObjects) {
        IPageCache pageCache = this.getView().getPageCache();
        if (newAdminOrgObjects == null || newAdminOrgObjects.size() == 0) {
            pageCache.put("baffiliateadminorg", null);
            return;
        }
        List adminOrgIds = newAdminOrgObjects.stream().map(dy -> dy.getString("fbasedataid.id")).collect(Collectors.toList());
        pageCache.put("baffiliateadminorg", JSONObject.toJSONString(adminOrgIds));
    }

    private void changeOrg(DynamicObjectCollection newOrgObjects) {
        IPageCache pageCache = this.getView().getPageCache();
        if (newOrgObjects == null || newOrgObjects.size() == 0) {
            pageCache.put("borg", null);
            return;
        }
        List orgIds = newOrgObjects.stream().map(dy -> dy.getString("fbasedataid.id")).collect(Collectors.toList());
        pageCache.put("borg", JSONObject.toJSONString(orgIds));
    }
}

