/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.workbench.common;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.repository.RegAskDetailsRepository;
import kd.hr.hdm.business.repository.RegExamDetailsRepository;
import kd.hr.hdm.business.repository.RegProbationPersonQueryRepository;
import kd.hr.hdm.formplugin.reg.web.workbench.common.ProbationPersonCommonQueryListPlugin;

public class RegAskExamQueryListCommonPlugin
extends ProbationPersonCommonQueryListPlugin {
    private static final Log LOGGER = LogFactory.getLog(RegAskExamQueryListCommonPlugin.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        boolean regAskRemind = HRStringUtils.equals((String)operateKey, (String)"regaskremind");
        boolean regExamRemind = HRStringUtils.equals((String)operateKey, (String)"regexamremind");
        if (!regAskRemind && !regExamRemind) {
            return;
        }
        String entityName = regAskRemind ? "hdm_regaskdetails" : "hdm_regexamdetails";
        boolean permission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"hpb", (String)entityName, (String)"0=KX5+R0OZPJ");
        if (!permission) {
            this.getView().showErrorNotification(regAskRemind ? ResManager.loadKDString((String)"\u65e0\u201c\u8f6c\u6b63\u95ee\u8be2\u201d\u7684\u201c\u50ac\u529e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RegAskExamQueryListCommonPlugin_4", (String)"hr-hdm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u65e0\u201c\u8f6c\u6b63\u8003\u8bc4\u201d\u7684\u201c\u50ac\u529e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RegAskExamQueryListCommonPlugin_5", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        String operateKey = args.getOperateKey();
        if (result != null && result.isSuccess()) {
            boolean regAskRemind = HRStringUtils.equals((String)operateKey, (String)"regaskremind");
            boolean regExamRemind = HRStringUtils.equals((String)operateKey, (String)"regexamremind");
            if (!regAskRemind && !regExamRemind) {
                return;
            }
            List ids = Arrays.stream(this.getSelectedRows().getPrimaryKeyValues()).map(Object::toString).map(Long::valueOf).collect(Collectors.toList());
            Map regProEmployeeMap = RegProbationPersonQueryRepository.getInstance().queryByIds(ids, new String[]{"employee.id"});
            if (regProEmployeeMap.isEmpty()) {
                LOGGER.error("regProPersonMap is empty");
                return;
            }
            List employeeIds = regProEmployeeMap.values().stream().map(dy -> dy.getLong("employee.id")).collect(Collectors.toList());
            DynamicObject[] details = regAskRemind ? RegAskDetailsRepository.getRepository().queryNewestExamIngByPersonIds(employeeIds, new String[]{"id"}) : RegExamDetailsRepository.getRepository().queryNewestExamIngByPersonIds(employeeIds, new String[]{"id"});
            IFormView formView = this.getView();
            if (details.length == 0) {
                formView.showErrorNotification(regAskRemind ? ResManager.loadKDString((String)"\u9009\u4e2d\u4eba\u5458\u6682\u65e0\u672a\u53cd\u9988\u7684\u95ee\u8be2\u4eba\uff0c\u65e0\u6cd5\u6267\u884c\u50ac\u529e\u3002", (String)"RegAskExamQueryListCommonPlugin_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u9009\u4e2d\u4eba\u5458\u6682\u65e0\u672a\u53cd\u9988\u7684\u8003\u8bc4\u4eba\uff0c\u65e0\u6cd5\u6267\u884c\u50ac\u529e\u3002", (String)"RegAskExamQueryListCommonPlugin_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                formView.invokeOperation("refresh");
                return;
            }
            List<Long> detailIds = Arrays.stream(details).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("currbizappid", "hpb");
            String entityName = regAskRemind ? "hdm_regaskdetails" : "hdm_regexamdetails";
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)(regAskRemind ? "regaskremind" : "regexamremind"), (String)entityName, (Object[])detailIds.toArray(new Long[0]), (OperateOption)operateOption);
            if (!operationResult.isSuccess()) {
                formView.showOperationResult(operationResult);
            } else {
                formView.showSuccessNotification(regAskRemind ? ResManager.loadKDString((String)"\u5df2\u6210\u529f\u50ac\u529e\u9009\u4e2d\u4eba\u5458\u7684\u672a\u53cd\u9988\u7684\u95ee\u8be2\u4eba\u3002", (String)"RegAskExamQueryListCommonPlugin_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5df2\u6210\u529f\u50ac\u529e\u9009\u4e2d\u4eba\u5458\u7684\u672a\u53cd\u9988\u7684\u8003\u8bc4\u4eba\u3002", (String)"RegAskExamQueryListCommonPlugin_3", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            }
            formView.invokeOperation("refresh");
        }
    }
}

