/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.workbench.provider;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.util.CollectionUtils;
import kd.hr.hdm.business.domain.service.hspm.IHSPMService;
import kd.hr.hdm.business.repository.RegAskDetailsRepository;
import kd.hr.hdm.common.reg.util.RegCommonUtil;

public class RegAskItemsListDataProvider
extends ListDataProvider {
    private static final Log LOGGER = LogFactory.getLog(RegAskItemsListDataProvider.class);

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection rows = super.getData(start, limit);
        if (rows.isEmpty()) {
            return rows;
        }
        List ids = rows.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        Map regAskDetailMap = RegAskDetailsRepository.getRepository().queryByIds(ids, new String[]{"askperson.id", "initiatetime", "finshtime"});
        if (regAskDetailMap.isEmpty()) {
            LOGGER.warn("regAskDetailMap is empty");
            return rows;
        }
        List userIds = regAskDetailMap.values().stream().filter(dy -> dy.getLong("askperson.id") != 0L).map(dy -> dy.getLong("askperson.id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(userIds)) {
            LOGGER.warn("userIds is empty");
            return rows;
        }
        Map erManFileMap = IHSPMService.getInstance().getCardFieldByBosUserIds(userIds);
        if (erManFileMap.isEmpty()) {
            LOGGER.warn("erManFileMap is empty");
            return rows;
        }
        RegCommonUtil.addTextProps((DynamicObjectCollection)rows, (String[])new String[]{"askpersonadminorg", "askpersonposition", "askpersonstdposition", "askpersonjob", "handletime"});
        rows.forEach(row -> {
            DynamicObject regAskDetail = (DynamicObject)regAskDetailMap.get(row.getLong("id"));
            String askPersonNumber = regAskDetail.getString("askperson.number");
            Map erManFile = (Map)erManFileMap.get(askPersonNumber);
            if (erManFile != null) {
                row.set("askpersonadminorg", erManFile.get("adminorg"));
                row.set("askpersonposition", erManFile.get("position"));
                row.set("askpersonstdposition", erManFile.get("stdposition"));
                row.set("askpersonjob", erManFile.get("job"));
            }
            Date initiateTime = regAskDetail.getDate("initiatetime");
            Date finishTime = regAskDetail.getDate("finshtime");
            String handleTime = RegCommonUtil.getHandleTime((Date)initiateTime, (Date)(finishTime != null ? finishTime : new Date()));
            row.set("handletime", (Object)handleTime);
        });
        return rows;
    }
}

