/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.batch;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.hr.hdm.business.common.PermissionValidateUtil;
import kd.hr.hdm.business.domain.transfer.repository.TransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.IBatchTransferValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferBatchService;
import kd.hr.hdm.business.domain.transfer.service.external.TransferStaffService;
import kd.hr.hdm.common.transfer.enums.TransferOperateTypeEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.common.transfer.util.TransferPageUtil;
import kd.hr.hdm.common.util.HdmFormViewUtil;
import kd.hr.hdm.formplugin.transfer.web.batch.provider.BatchTransferListDataProvider;

public class BatchTransferList
extends HRCoreBaseBillList {
    private static final Log LOGGER = LogFactory.getLog(BatchTransferList.class);
    private static final Set<String> SELECT_ONE_ONLY_OP = Sets.newHashSet((Object[])new String[]{"donothing_deletelist", "submiteffect", "donothing_unsubmitlist", "donothing_termination"});

    public void setFilter(SetFilterEvent arg) {
        String orderBy = "modifytime desc";
        arg.setOrderBy(orderBy);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("callback_delete".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.excuteBatchTransferOperation("delete", ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002", (String)"TransferBatchList_6", (String)"hr-hdm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"TransferBatchList_7", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        } else if ("callback_unsubmit".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.excuteBatchTransferOperation("unsubmit", ResManager.loadKDString((String)"\u64a4\u9500\u5931\u8d25", (String)"TransferBatchList_12", (String)"hr-hdm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f", (String)"TransferBatchList_11", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        Object[] rows = this.getSelectedRows().getPrimaryKeyValues();
        if (SELECT_ONE_ONLY_OP.contains(operateKey) && rows.length > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u64cd\u4f5c\u4e00\u6761\u6570\u636e\u3002", (String)"TransferBatchList_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        switch (operateKey) {
            case "donothing_deletelist": {
                DynamicObject dy = ITransferBatchService.getInstance().queryOne("billstatus", ((Long)rows[0]).longValue());
                if (dy == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                if ("A".equals(dy.getString("billstatus"))) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5220\u9664\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u7684\u5355\u636e\u3002", (String)"TransferBatchList_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "submiteffect": {
                this.submitEffect(args);
                break;
            }
            case "submit": {
                if (rows.length > 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u64cd\u4f5c\u4e00\u6761\u6570\u636e\u3002", (String)"TransferBatchList_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.submit(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
        String caption = ResManager.loadKDString((String)"\u65b0\u589e\u6279\u91cf\u8c03\u52a8\u7533\u8bf7", (String)"TransferBatchList_3", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
        switch (args.getOperateKey()) {
            case "donothing_add": {
                TransferPageUtil.showNewAddPage((IFormView)this.getView(), (String)"hdm_transferbatch", (String)caption);
                break;
            }
            case "donothing_deletelist": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u8bb0\u5f55\u5220\u9664\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TransferBatchList_4", (String)"hr-hdm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("callback_delete", (IFormPlugin)this));
                break;
            }
            case "donothing_termination": {
                TransferPageUtil.showFormViewOfModal((IFormView)this.getView(), (String)"hdm_transferterminate", (Object)primaryKeyValues[0], (String)"batch");
                break;
            }
            case "donothing_unsubmitlist": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6570\u636e\u64a4\u9500\u540e\u6d41\u7a0b\u5c06\u56de\u5230\u201c\u6682\u5b58\u201d\u72b6\u6001\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TransferBatchList_10", (String)"hr-hdm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("callback_unsubmit", (IFormPlugin)this));
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        IListView listview = (IListView)this.getView();
        long transferBillId = (Long)listview.getFocusRowPkId();
        String billno = this.getBillNoByBillId(transferBillId);
        String caption = ResManager.loadKDString((String)"\u6279\u91cf\u8c03\u52a8\u7533\u8bf7-%s", (String)"TransferBatchList_5", (String)"hr-hdm-formplugin", (Object[])new Object[]{billno});
        TransferPageUtil.showPage((IFormView)this.getView(), (String)"hdm_transferbatch", (Object)transferBillId, (String)caption, null);
    }

    private String getBillNoByBillId(long billId) {
        String billno = "";
        DynamicObject query = ITransferBatchService.getInstance().queryOne("billno", billId);
        if (!ObjectUtils.isEmpty((Object)query) && !ObjectUtils.isEmpty((Object)query.getString("billno"))) {
            billno = query.getString("billno");
        }
        return billno;
    }

    private void excuteBatchTransferOperation(String operation, String failMsg, String successMsg) {
        OperationServiceImpl operationService = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
        OperationResult operationResult = operationService.localInvokeOperation(operation, "hdm_transferbatch", this.getSelectedRows().getPrimaryKeyValues(), operateOption);
        if (!operationResult.isSuccess()) {
            String message = failMsg;
            try {
                message = ((IOperateInfo)operationResult.getAllErrorOrValidateInfo().get(0)).getMessage();
            }
            catch (Exception exception) {
                LOGGER.error((Throwable)exception);
            }
            this.getView().showErrorNotification(message);
            return;
        }
        this.getView().showSuccessNotification(successMsg);
        this.getView().invokeOperation("refresh");
    }

    private void submitEffect(BeforeDoOperationEventArgs args) {
        Object[] rows = this.getSelectedRows().getPrimaryKeyValues();
        DynamicObject batchTransferBill = ITransferBatchService.getInstance().queryOne("entryentity,billstatus", ((Long)rows[0]).longValue());
        if (!"A".equals(batchTransferBill.getString("billstatus"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u53ef\u63d0\u4ea4\u5e76\u751f\u6548\u201c\u6682\u5b58\u201d\u7684\u6570\u636e\u3002", (String)"TransferBatchList_8", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObjectCollection batchTransferBillCollection = batchTransferBill.getDynamicObjectCollection("entryentity");
        List<DynamicObject> transferBillEntryList = Arrays.asList(TransferBillRepository.getInstance().query(TransferStaffService.getInstance().getSelectProperties(), batchTransferBillCollection.stream().map(transferBill -> transferBill.getLong("id")).collect(Collectors.toList())));
        List dataDivs = IBatchTransferValidatorService.getInstance().submitEffectValidate(PermissionValidateUtil.getPermissionAppId((IFormView)this.getView()), transferBillEntryList, HdmFormViewUtil.getMenuFlag((IFormView)this.getView()));
        Map valResultInfo = IBatchTransferValidatorService.getInstance().buildOperateInfoByValResult(dataDivs, TransferOperateTypeEnum.SUBMITEFFECT);
        if ((Integer)valResultInfo.get("failperson") != 0) {
            TransferPageUtil.showFormViewOfModal((IFormView)this.getView(), (String)"hdm_operateresult", (Map)valResultInfo);
            args.setCancel(true);
        }
    }

    private void submit(BeforeDoOperationEventArgs args) {
        Object[] rows = this.getSelectedRows().getPrimaryKeyValues();
        DynamicObject batchTransferBill = ITransferBatchService.getInstance().queryOne("entryentity,billstatus", ((Long)rows[0]).longValue());
        DynamicObjectCollection batchTransferBillCollection = batchTransferBill.getDynamicObjectCollection("entryentity");
        List<DynamicObject> transferBillEntryList = Arrays.asList(TransferBillRepository.getInstance().query(TransferStaffService.getInstance().getSelectProperties(), batchTransferBillCollection.stream().map(transferBill -> transferBill.getLong("id")).collect(Collectors.toList())));
        PermissionValidateUtil.setAppId((String)this.getView().getFormShowParameter().getAppId());
        List dataDivs = IBatchTransferValidatorService.getInstance().submitValidate(batchTransferBill, transferBillEntryList, HdmFormViewUtil.getMenuFlag((IFormView)this.getView()));
        Map valResultInfo = IBatchTransferValidatorService.getInstance().buildOperateInfoByValResult(dataDivs, TransferOperateTypeEnum.SUBMIT);
        if ((Integer)valResultInfo.get("failperson") != 0) {
            TransferPageUtil.showFormViewOfModal((IFormView)this.getView(), (String)"hdm_operateresult", (Map)valResultInfo);
            args.setCancel(true);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new BatchTransferListDataProvider());
    }
}

