/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.batch.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hdm.business.domain.transfer.service.ITransferBatchService;

public class BatchTransferListDataProvider
extends ListDataProvider {
    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection rows = super.getData(start, limit);
        if (rows.isEmpty()) {
            return rows;
        }
        this.addAndSetTransferStatisticsProperty(rows);
        return rows;
    }

    private void addAndSetTransferStatisticsProperty(DynamicObjectCollection rows) {
        DynamicSimpleProperty transferNumber = new DynamicSimpleProperty("transfernumber", Integer.class, (Object)0);
        DynamicSimpleProperty transferedNumber = new DynamicSimpleProperty("transferednumber", Integer.class, (Object)0);
        DynamicSimpleProperty transferperson = new DynamicSimpleProperty("transferperson", String.class, (Object)"");
        rows.getDynamicObjectType().addProperty((DynamicProperty)transferNumber);
        rows.getDynamicObjectType().addProperty((DynamicProperty)transferedNumber);
        rows.getDynamicObjectType().addProperty((DynamicProperty)transferperson);
        List ids = rows.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
        QFilter idsFilter = new QFilter("id", "in", ids);
        DynamicObject[] batchTransferList = ITransferBatchService.getInstance().query("id,entryentity.id,entryentity.transferstatus,entryentity.person", idsFilter.toArray());
        HashMap<Long, DynamicObjectCollection> entryDyCollectionMap = new HashMap<Long, DynamicObjectCollection>(rows.size());
        for (DynamicObject item2 : batchTransferList) {
            entryDyCollectionMap.put(item2.getLong("id"), item2.getDynamicObjectCollection("entryentity"));
        }
        for (DynamicObject row : rows) {
            DynamicObjectCollection entryDyCollection = (DynamicObjectCollection)entryDyCollectionMap.get(row.getLong("id"));
            Map<String, Object> statisticsMap = this.transferStatistics(entryDyCollection);
            row.set("transfernumber", statisticsMap.get("transfernumber"));
            row.set("transferednumber", statisticsMap.get("transferednumber"));
            row.set("transferperson", statisticsMap.get("transferperson"));
        }
    }

    private Map<String, Object> transferStatistics(DynamicObjectCollection entryDyCollection) {
        HashMap<String, Object> statisticsMap = new HashMap<String, Object>(2);
        int transferNumber = 0;
        int transferedNumber = 0;
        ArrayList<String> personNames = new ArrayList<String>();
        if (Objects.nonNull(entryDyCollection)) {
            for (DynamicObject item : entryDyCollection) {
                String transferStatus = item.getString("transferstatus");
                if ("2".equals(transferStatus)) {
                    ++transferedNumber;
                }
                ++transferNumber;
                personNames.add(item.getString("person.name"));
            }
        }
        statisticsMap.put("transfernumber", transferNumber);
        statisticsMap.put("transferednumber", transferedNumber);
        statisticsMap.put("transferperson", String.join((CharSequence)",", personNames));
        return statisticsMap;
    }
}

