/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.billin;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hdm.business.common.PermissionValidateUtil;
import kd.hr.hdm.business.domain.transfer.entity.DataDiv;
import kd.hr.hdm.business.domain.transfer.entity.ValidateContext;
import kd.hr.hdm.business.domain.transfer.repository.TransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.ITransferValidatorService;
import kd.hr.hdm.common.transfer.enums.TransferOriginatorEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;
import kd.hr.hdm.common.transfer.util.TransferJudgementUtil;
import kd.hr.hdm.common.transfer.util.TransferPageUtil;

public class TransferInBillEdit
extends HRCoreBaseBillEdit {
    private static final Log LOGGER = LogFactory.getLog(TransferInBillEdit.class);
    private static final String OPERATE_TERMINATION = "donothing_termination";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customParams = param.getCustomParams();
        String menuflag = (String)customParams.get("menuflag");
        if (ObjectUtils.isEmpty((Object)menuflag)) {
            menuflag = TransferCommonUtil.getMenuflagStr((IFormView)this.getView());
        }
        String originator = (String)this.getModel().getValue("originator");
        long pkid = (Long)this.getModel().getValue("id");
        DynamicObject dynamicObject = TransferBillRepository.getInstance().queryOne("auditstatus", (Object)pkid);
        String auditStatus = "";
        if (HRStringUtils.equals((String)operateKey, (String)"unsubmit")) {
            if (ObjectUtils.isEmpty((Object)dynamicObject)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"TransferInBillEdit_5", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            auditStatus = dynamicObject.getString("auditstatus");
            DynamicObject dataEntity = this.getModel().getDataEntity();
            List dataDivs = ITransferValidatorService.getInstance().batchUnsubmitValidate(Collections.singletonList(dataEntity), menuflag, PermissionValidateUtil.getPermissionAppId((IFormView)this.getView()));
            ValidateContext validatorContext = ((DataDiv)dataDivs.get(0)).getValidatorContext();
            if (validatorContext.getValidateResult().size() > 0) {
                this.getView().showErrorNotification(validatorContext.map2String());
                args.setCancel(true);
                return;
            }
            args.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u64a4\u9500\u540e\u6d41\u7a0b\u5c06\u56de\u5230\u201c\u5f85\u8c03\u5165\u90e8\u95e8\u63d0\u4ea4\u201d\u8282\u70b9\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"TransferInBillEdit_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("callback_unsubmit", (IFormPlugin)this));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        long billId = (Long)this.getModel().getValue("id");
        if (HRStringUtils.equals((String)operateKey, (String)OPERATE_TERMINATION)) {
            TransferPageUtil.showFormViewOfModal((IFormView)this.getView(), (String)"hdm_transferterminate", (Object)billId, (String)"in");
        } else if (HRStringUtils.equals((String)operateKey, (String)"save")) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("callback_unsubmit".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperationServiceImpl operationService = new OperationServiceImpl();
            Object[] objects = new Object[]{this.getModel().getValue("id")};
            LOGGER.info("unsubmit invoke start:[{}]", (Object)System.currentTimeMillis());
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
            OperationResult operationResult = operationService.localInvokeOperation("unsubmit", "hdm_transferinbill", objects, operateOption);
            LOGGER.info("unsubmit invoke end:[{}]", (Object)System.currentTimeMillis());
            if (operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f\u3002", (String)"TransferInBillEdit_4", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                LOGGER.info("transfer unsubmit success.");
            } else {
                String message = "";
                try {
                    LOGGER.error("transfer unsubmit fail1 \uff1a {}", (Object)operationResult.getAllErrorOrValidateInfo());
                    LOGGER.error("transfer unsubmit fail2 \uff1a {}", (Object)operationResult.getAllErrorInfo());
                    message = ((IOperateInfo)operationResult.getAllErrorOrValidateInfo().get(0)).getMessage();
                }
                catch (Exception exception) {
                    message = ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u64a4\u9500\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TransferInBillEdit_6", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
                    LOGGER.error("transfer unsubmit fail3 \uff1a {}", (Object)exception.getMessage());
                }
                this.getView().showErrorNotification(message);
            }
            this.getView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView());
            return;
        }
    }

    public void beforeBindData(EventObject arg) {
        super.beforeBindData(arg);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (TransferJudgementUtil.ADDNEW.test(status)) {
            this.getModel().setValue("originator", (Object)TransferOriginatorEnum.IN.getOriginator());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initAttachment(this.getModel().getDataEntity().getPkValue());
    }

    private void initAttachment(Object id) {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanel");
        List attachments = AttachmentServiceHelper.getAttachments((String)"hdm_transferoutbill", (Object)id, (String)"attachmentpanel");
        List attachmentData = attachmentPanel.getAttachmentData();
        attachmentData.addAll(attachments);
        attachmentPanel.bindData(attachmentData);
    }
}

