/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.billout;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.hr.hdm.business.domain.transfer.entity.DataDiv;
import kd.hr.hdm.business.domain.transfer.entity.ValidateContext;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.business.domain.transfer.service.ITransferValidatorService;
import kd.hr.hdm.common.transfer.enums.TransferOriginatorEnum;
import kd.hr.hdm.common.transfer.enums.TransferStageEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.common.transfer.util.TransferPageUtil;

public class TransferOutBillList
extends HRCoreBaseBillList {
    private static final String OP_DONOTHING_ADD = "donothing_add";

    public void setFilter(SetFilterEvent arg) {
        super.setFilter(arg);
        QFilter originatorFilter = new QFilter("originator", "=", (Object)TransferOriginatorEnum.OUT.getOriginator());
        QFilter transferstageFilter = new QFilter("transferstage", ">", (Object)TransferStageEnum.ONE.getName());
        QFilter and = originatorFilter.or(transferstageFilter);
        arg.getQFilters().add(and);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        QFilter qFilter = new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues());
        DynamicObject[] query = ITransferBillService.getInstance().query("originator,transferstatus,transferoutstatus,transfereffectstatus", qFilter.toArray());
        if (HRStringUtils.equals((String)operateKey, (String)"donothing_termination")) {
            if (selectedRows.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u7ec8\u6b62\u7684\u5355\u636e\u3002", (String)"TransferOutBillList_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (selectedRows.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u64cd\u4f5c\u4e00\u6761\u6570\u636e\u3002", (String)"TransferOutBillList_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (query.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"TransferOutBillList_3", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject dataEntity = query[0];
            String transferStatus = dataEntity.getString("transferstatus");
            String transferEffectStatus = dataEntity.getString("transfereffectstatus");
            DataDiv dataDiv = new DataDiv(dataEntity, new ValidateContext());
            boolean validate = ITransferValidatorService.getInstance().terminalValidate(transferStatus, transferEffectStatus).test(dataDiv);
            if (!validate) {
                this.getView().showErrorNotification(dataDiv.getValidatorContext().map2String());
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        String caption = ResManager.loadKDString((String)"\u65b0\u589e\u8c03\u51fa\u7533\u8bf7", (String)"TransferOutBillList_4", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
        switch (args.getOperateKey()) {
            case "donothing_add": {
                TransferPageUtil.showNewAddPage((IFormView)this.getView(), (String)"hdm_transferoutbill", (String)caption);
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        IListView listview = (IListView)this.getView();
        long transferBillId = (Long)listview.getFocusRowPkId();
        String name = this.getPersonNameByBillId(transferBillId);
        ListShowParameter param = (ListShowParameter)listview.getFormShowParameter();
        HashMap<String, String> customParams = new HashMap<String, String>();
        String type = (String)param.getCustomParam("menuflag");
        customParams.put("menuflag", type);
        String caption = ResManager.loadKDString((String)"\u8c03\u51fa\u7533\u8bf7-%s", (String)"TransferOutBillList_5", (String)"hr-hdm-formplugin", (Object[])new Object[]{name});
        TransferPageUtil.showPage((IFormView)this.getView(), (String)"hdm_transferoutbill", (Object)transferBillId, (String)caption, customParams);
    }

    private String getPersonNameByBillId(long billId) {
        String name = "";
        DynamicObject query = ITransferBillService.getInstance().queryOne("person", billId);
        if (!ObjectUtils.isEmpty((Object)query) && !ObjectUtils.isEmpty((Object)query.getString("person.name"))) {
            name = query.getString("person.name");
        }
        return name;
    }
}

