/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.billout;

import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hdm.business.domain.transfer.service.ITransferPostPatternService;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferPostPatternServiceImpl;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;
import org.apache.commons.lang3.StringUtils;

public class TransferOutViewEdit
extends HRCoreBaseBillEdit {
    public void beforeBindData(EventObject arg) {
        super.beforeBindData(arg);
        this.setLabelWhenOut();
        BillOperationStatus billStatus = ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus();
        if (billStatus.equals((Object)BillOperationStatus.VIEW)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"transferineditpanel", "transferouteditpanel"});
        }
    }

    private void setLabelWhenOut() {
        this.setOutAfterTransferInfo();
    }

    private void setOutAfterTransferInfo() {
        String value = (String)this.getModel().getValue("originator");
        if (value.equals("1")) {
            this.setActualTransferIn();
            return;
        }
        if (value.equals("2")) {
            this.setActualTransferIn();
            return;
        }
        this.setActualTransferIn();
    }

    private void setTransferIn() {
        this.setLabelText("lblcompanytarget", "acompany");
        this.setLabelText("lbladminorgtarget", "aorg");
        this.setLabelText("lblpositiontarget", "aposition");
        this.setLabelText("lblspositiontarget", "astposition");
        this.setLabelText("lbllocaltiontarget", "abaselocation");
        this.setLabelText("lblajobtarget", "ajob");
    }

    private void setProposedTransferIn() {
        this.setLabelText("lblcompanytarget", "aplancompany");
        this.setLabelText("lbladminorgtarget", "aplanorg");
        this.setLabelText("lblpositiontarget", "aplanposition");
        this.setLabelText("lblspositiontarget", "aplanstposition");
        this.setLabelText("lbllocaltiontarget", "aplanbaselocation");
        this.setLabelText("lblajobtarget", "aplanjob");
    }

    private void setActualTransferIn() {
        this.setLabelText("lblcompanytarget", "arealitycompany");
        this.setLabelText("lbladminorgtarget", "arealityorg");
        this.setLabelText("lblpositiontarget", "arealityposition");
        this.setLabelText("lblspositiontarget", "arealitystposition");
        this.setLabelText("lbllocaltiontarget", "arealitybaselocation");
        this.setLabelText("lblajobtarget", "arealityjob");
    }

    private void setLabelText(String labelName, String propertyName) {
        Label lblsource = (Label)this.getView().getControl(labelName);
        DynamicObject dy = (DynamicObject)this.getModel().getValue(propertyName);
        if (!ObjectUtils.isEmpty((Object)dy)) {
            if (StringUtils.isNotEmpty((CharSequence)dy.getString("name"))) {
                lblsource.setText(dy.getString("name"));
            }
        } else {
            lblsource.setText("-");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs arg) {
        super.afterDoOperation(arg);
        String operateKey = arg.getOperateKey();
        OperationResult operationResult = arg.getOperationResult();
        if (null != operationResult && operationResult.isSuccess()) {
            if ("modify".equals(operateKey)) {
                this.setEditPlaneVisible();
                this.getView().setStatus(OperationStatus.EDIT);
                this.getView().updateView();
                if (!this.isOriginator()) {
                    this.setEnable();
                }
            }
        } else {
            FormShowParameter param = this.getView().getFormShowParameter();
            OperationStatus status = param.getStatus();
            if ("refresh".equals(operateKey) && !OperationStatus.ADDNEW.equals((Object)status)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"transferineditpanel", "transferouteditpanel"});
            }
        }
    }

    private void setEditPlaneVisible() {
        String transferInStatus = (String)this.getModel().getValue("transferoutstatus");
        if ("A".equals(transferInStatus) || "G".equals(transferInStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"transferineditpanel", "transferouteditpanel"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"transferineditpanel", "transferouteditpanel"});
        }
    }

    private boolean isOriginator() {
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customParams = param.getCustomParams();
        String menuflag = (String)customParams.get("menuflag");
        if (ObjectUtils.isEmpty((Object)menuflag)) {
            menuflag = TransferCommonUtil.getMenuflagStr((IFormView)this.getView());
        }
        String originator = (String)this.getModel().getValue("originator");
        return TransferCommonUtil.isOrginator((String)menuflag, (String)originator);
    }

    private void setEnable() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"acompany", "aposition", "aorg", "astposition", "abaselocation", "postpattern", "ajob", "persongroupfield", "arealitysuperior", "amanagescope"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPositionMustInputByPostPattern();
    }

    private void setPositionMustInputByPostPattern() {
        TransferPostPatternServiceImpl transferPostPatternService = (TransferPostPatternServiceImpl)ITransferPostPatternService.getInstance();
        transferPostPatternService.setPositionMustInputByPostPattern(this.getModel().getDataEntity(), this.getModel(), this.getView());
    }
}

