/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.common;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Label;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.business.domain.transfer.service.external.JobExternalService;
import kd.hr.hdm.common.parttime.enums.PosTypeEnum;
import kd.hr.hdm.common.transfer.constants.TransferCharacterConstrats;
import kd.hr.hdm.common.transfer.enums.TransferOriginatorEnum;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;
import kd.hr.hdm.common.transfer.util.TransferJudgementUtil;

public class TransferBillViewEdit
extends HRCoreBaseBillEdit
implements BeforeF7SelectListener {
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit personFile = (BasedataEdit)this.getView().getControl("personfield");
        if (personFile == null) {
            return;
        }
        personFile.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        if ("personfield".equals(fieldKey)) {
            evt.getFormShowParameter().setCustomParam("showeffect", (Object)"0");
        }
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        IDataModel dataModel = this.getModel();
        IFormView formView = this.getView();
        DynamicObject dataEntity = dataModel.getDataEntity();
        String billStatus = dataEntity.getString("billstatus");
        OperationStatus status = formView.getFormShowParameter().getStatus();
        if (HRStringUtils.equals((String)billStatus, (String)"G") && OperationStatus.VIEW.equals((Object)status)) {
            ((IBillView)formView).setBillStatus(BillOperationStatus.VIEW);
        }
        if (TransferCommonUtil.isAuditView((IFormView)formView) || !dataEntity.getBoolean("isexistsworkflow")) {
            formView.setVisible(Boolean.FALSE, new String[]{"rightmainpanel"});
        } else {
            this.setAuditPanelVisible(dataModel, formView);
        }
        String postPattern = dataEntity.getString("postpattern");
        if (TransferJudgementUtil.VIEW.test(status)) {
            this.setViewData();
        } else if (TransferJudgementUtil.EDIT.test(status)) {
            formView.setEnable(Boolean.valueOf(!HRStringUtils.equals((String)postPattern, (String)PosTypeEnum.JOB.getCode())), new String[]{"ajob"});
            ITransferBillService.getInstance().setAJobInfoEnable(formView);
        }
        formView.setVisible(Boolean.FALSE, new String[]{"personalinfoprepanel"});
        this.setPostPatternView();
        this.setPersonPatternView();
        this.setBPostPatternView();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initAttachment(this.getModel().getDataEntity());
    }

    public void afterLoadData(EventObject event) {
        this.setPersonPattern();
        IDataModel model = this.getModel();
        if (model.getValue("b_ermanfile") == null) {
            model.setValue("b_ermanfile", model.getValue("ermanfile"));
        }
    }

    private void setPostPatternView() {
        String postPattern = this.getModel().getDataEntity().getString("postpattern");
        DynamicObject job = this.getModel().getDataEntity().getDynamicObject("ajob");
        IFormView formView = this.getView();
        if (HRStringUtils.equals((String)postPattern, (String)PosTypeEnum.POS.getCode())) {
            formView.setVisible(Boolean.FALSE, new String[]{"astposition"});
            formView.setVisible(Boolean.TRUE, new String[]{"aposition"});
            formView.setVisible(Boolean.valueOf(!HRObjectUtils.isEmpty((Object)job)), new String[]{"ajob"});
            formView.setEnable(Boolean.FALSE, new String[]{"ajob"});
            formView.setEnable(Boolean.TRUE, new String[]{"persongrouppanelap"});
        } else if (HRStringUtils.equals((String)postPattern, (String)PosTypeEnum.STD_POS.getCode())) {
            formView.setVisible(Boolean.TRUE, new String[]{"astposition"});
            formView.setVisible(Boolean.FALSE, new String[]{"aposition"});
            formView.setVisible(Boolean.valueOf(!HRObjectUtils.isEmpty((Object)job)), new String[]{"ajob"});
            formView.setEnable(Boolean.FALSE, new String[]{"ajob"});
            formView.setEnable(Boolean.FALSE, new String[]{"persongrouppanelap"});
        } else if (HRStringUtils.equals((String)postPattern, (String)PosTypeEnum.JOB.getCode())) {
            formView.setVisible(Boolean.FALSE, new String[]{"astposition"});
            formView.setVisible(Boolean.FALSE, new String[]{"aposition"});
            formView.setVisible(Boolean.TRUE, new String[]{"ajob"});
            formView.setEnable(Boolean.TRUE, new String[]{"ajob"});
        }
    }

    private void setBPostPatternView() {
        if (this.getModel().getValue("bpostpattern") == null) {
            return;
        }
        if ("1".equals(this.getModel().getValue("bpostpattern"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bposition"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bstposition"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bjob"});
        } else if ("0".equals((String)this.getModel().getValue("bpostpattern"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bstposition"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bposition"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bjob"});
        } else if ("2".equals((String)this.getModel().getValue("bpostpattern"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bjob"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bstposition"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bposition"});
        }
    }

    private void setPersonPattern() {
        if (HRStringUtils.equals((String)"0", (String)((String)this.getModel().getValue("superiorchannel")))) {
            this.getModel().setValue("persongroupfield", (Object)"0");
        } else {
            this.getModel().setValue("persongroupfield", (Object)"1");
        }
    }

    private void setPersonPatternView() {
        if ("0".equals((String)this.getModel().getValue("persongroupfield"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"arealitysuperior"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"arealitysuperior"});
        }
    }

    private void setViewData() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        this.setBillHead(model, view);
        this.setTransferInfo(model, view);
        this.setJobAllClass(model, view);
    }

    private void setJobAllClass(IDataModel model, IFormView view) {
        boolean ajobclasstextIsNull = TransferJudgementUtil.ormLocalValueIsNull((String)"ajobclasstext").test(model);
        boolean bjobclasstextIsNull = TransferJudgementUtil.ormLocalValueIsNull((String)"bjobclasstext").test(model);
        DynamicObject aevaluaJobDy = (DynamicObject)model.getValue("aevaluationjob");
        DynamicObject bevaluaJobDy = (DynamicObject)model.getValue("bevaluationjob");
        if (aevaluaJobDy == null && bevaluaJobDy == null) {
            return;
        }
        long ajobId = 0L;
        if (aevaluaJobDy != null) {
            ajobId = aevaluaJobDy.getLong("boid");
        }
        long bjobId = 0L;
        if (bevaluaJobDy != null) {
            bjobId = bevaluaJobDy.getLong("id");
        }
        Map jobClassInfoMap = JobExternalService.getInstance().invokeGetJobClassLongNameByJobAndBsed(Arrays.asList(ajobId, bjobId), new Date());
        if (ajobclasstextIsNull) {
            String ajobAllClass = jobClassInfoMap.getOrDefault(ajobId, "");
            model.setValue("ajobclasstext", (Object)ajobAllClass);
        }
        if (bjobclasstextIsNull) {
            String bjobAllClass = jobClassInfoMap.getOrDefault(bjobId, "");
            model.setValue("bjobclasstext", (Object)bjobAllClass);
        }
    }

    private void setAuditPanelVisible(IDataModel model, IFormView view) {
        String transferStatus = (String)model.getValue("transferstatus");
        if ("0".equals(transferStatus)) {
            view.setVisible(Boolean.FALSE, new String[]{"rightmainpanel"});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"rightmainpanel"});
        }
    }

    private void setBillHead(IDataModel model, IFormView view) {
        DynamicObject affaction = (DynamicObject)model.getValue("affaction");
        if (affaction == null) {
            return;
        }
        Long affactionId = affaction.getLong("id");
        String labelName = affactionId == 1050L ? TransferCharacterConstrats.getTransfein() : (affactionId == 1060L ? TransferCharacterConstrats.getTransfercross() : affaction.getString("name"));
        Label lbltransfertypeedit = (Label)view.getControl("lbltransfertypeedit");
        lbltransfertypeedit.setText(labelName);
    }

    private void setTransferInfo(IDataModel model, IFormView view) {
        TransferCommonUtil.setLblBaseDataText((IFormView)view, (IDataModel)model, (String)"lblappointtype", (String)"postype", (Boolean)Boolean.FALSE);
        TransferCommonUtil.setLblBaseDataText((IFormView)view, (IDataModel)model, (String)"llaborreltype", (String)"laborreltype", (Boolean)Boolean.FALSE);
        TransferCommonUtil.setLblBaseDataText((IFormView)view, (IDataModel)model, (String)"llaborrelstatus", (String)"laborrelstatus", (Boolean)Boolean.FALSE);
        TransferCommonUtil.setLblBaseDataText((IFormView)view, (IDataModel)model, (String)"lblcompany", (String)"bcompany", (Boolean)Boolean.TRUE);
        TransferCommonUtil.setLblBaseDataText((IFormView)view, (IDataModel)model, (String)"lbladmingorg", (String)"borg", (Boolean)Boolean.TRUE);
        TransferCommonUtil.setLblBaseDataText((IFormView)view, (IDataModel)model, (String)"lblcompanysource", (String)"bcompany", (Boolean)Boolean.TRUE);
        TransferCommonUtil.setLblBaseDataText((IFormView)view, (IDataModel)model, (String)"lbladminorgsource", (String)"borg", (Boolean)Boolean.TRUE);
        TransferCommonUtil.setLblBaseDataText((IFormView)view, (IDataModel)model, (String)"lblpositionsource", (String)"bposition", (Boolean)Boolean.TRUE);
        TransferCommonUtil.setLblBaseDataText((IFormView)view, (IDataModel)model, (String)"lbllocaltionsource", (String)"bbaselocation", (Boolean)Boolean.TRUE);
        TransferCommonUtil.setLblBaseDataText((IFormView)view, (IDataModel)model, (String)"lblspositionsource", (String)"bstposition", (Boolean)Boolean.TRUE);
        TransferCommonUtil.setLblBaseDataText((IFormView)view, (IDataModel)model, (String)"lblbjobsource", (String)"bjob", (Boolean)Boolean.TRUE);
        TransferCommonUtil.setLblBaseDataText((IFormView)view, (IDataModel)model, (String)"lbladminorgsource1", (String)"bmanagescope", (Boolean)Boolean.TRUE);
        TransferCommonUtil.setLblBaseDataText((IFormView)view, (IDataModel)model, (String)"lblpositiontarget1", (String)"amanagescope", (Boolean)Boolean.TRUE);
        TransferCommonUtil.setLblMultiBaseDataText((IFormView)view, (IDataModel)model, (String)"lblleaderbefore", (String)"borgleader", (Boolean)Boolean.TRUE);
        TransferCommonUtil.setLblMultiBaseDataText((IFormView)view, (IDataModel)model, (String)"lblleaderbefore11", (String)"bsuperior", (Boolean)Boolean.TRUE);
        TransferCommonUtil.setLblMultiBaseDataText((IFormView)view, (IDataModel)model, (String)"lblleaderafter", (String)"arealityorgleader", (Boolean)Boolean.TRUE);
        TransferCommonUtil.setLblMultiBaseDataText((IFormView)view, (IDataModel)model, (String)"lblhrbuafter2", (String)"arealitysuperior", (Boolean)Boolean.TRUE);
    }

    public void afterCreateNewData(EventObject arg) {
        this.getView().setEnable(Boolean.FALSE, new String[]{"aposition", "aorg", "astposition", "abaselocation", "persongrouppanelap", "arealitysuperior", "amanagescope", "postpattern", "workingplan", "ajob", "aevaluationjob", "ajobgradescm", "ajobgrade", "ajoblevelscm", "ajoblevel", "ajobscm", "ajobfamily", "ajobclass", "ajobseq", "ajobclasstext", "bjobclasstext"});
        this.getModel().setValue("postpattern", (Object)"1");
        this.getModel().setValue("superiorchannel", (Object)"0");
        if ("hdm_mytransferbill".equals(this.getView().getFormShowParameter().getFormId())) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"aposition", "aorg", "abaselocation"});
        }
    }

    private void initAttachment(DynamicObject transferBill) {
        if ("hdm_transferapply".equals(this.getView().getFormShowParameter().getFormId()) && TransferOriginatorEnum.MY.getOriginator().equals(transferBill.getString("originator"))) {
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanel");
            List attachments = AttachmentServiceHelper.getAttachments((String)"hdm_mytransferbill", (Object)transferBill.getPkValue(), (String)"attachmentpanel");
            List attachmentData = attachmentPanel.getAttachmentData();
            attachmentData.addAll(attachments);
            attachmentPanel.bindData(attachmentData);
        }
    }
}

