/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hdm.business.domain.transfer.entity.DataDiv;
import kd.hr.hdm.business.domain.transfer.entity.ValidateContext;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.business.domain.transfer.service.ITransferConfirmValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferPersonChangeService;
import kd.hr.hdm.business.domain.transfer.service.ITransferSaveValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferValidatorService;
import kd.hr.hdm.business.domain.transfer.service.external.TransferStaffService;
import kd.hr.hdm.business.domain.transfer.service.impl.TansferSaveExtendServiceImpl;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferSaveValidatorServiceImpl;
import kd.hr.hdm.common.transfer.enums.TransferCrossVerifyEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.common.transfer.util.TransferJudgementUtil;
import kd.hr.hdm.common.transfer.util.TransferPageUtil;
import kd.hr.hdm.common.util.HdmFormViewUtil;
import kd.sdk.hr.hdm.business.transfer.ITransferSaveService;
import org.apache.commons.lang3.StringUtils;

public class TransferDateEdit
extends HRCoreBaseBillEdit {
    private static final Log LOGGER = LogFactory.getLog(TransferDateEdit.class);

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        switch (closedCallBackEvent.getActionId()) {
            case "closeCallBackSave": {
                String opType;
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                Set returnSet = returnData == null ? null : (Set)returnData.get("data");
                String string = opType = returnData == null ? null : (String)returnData.get("opType");
                if (returnSet != null && "op_cancel".equals(opType)) {
                    this.handleCrossDateCancel(returnSet);
                    break;
                }
                if (returnSet != null && returnSet.contains("callback_jobvalidate")) {
                    this.handleJobValidate();
                }
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("isValidateTips", "false");
                operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
                this.getView().invokeOperation("save", operateOption);
                break;
            }
        }
    }

    public void afterBindData(EventObject arg) {
        super.beforeBindData(arg);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (TransferJudgementUtil.EDIT.test(status)) {
            ITransferBillService.getInstance().setTransferBillDateRange().accept((Object)this.getView(), (Object)this.getModel(), (Object)0);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (!this.validateSave(operate)) {
            args.setCancel(true);
        }
    }

    private boolean needSecondConfirm(String billStatus) {
        return billStatus.equals("A") || billStatus.equals("G");
    }

    private boolean validateSave(FormOperate operate) {
        boolean billstatsuValidateBoolean;
        String operateKey = operate.getOperateKey();
        if (!HRStringUtils.equals((String)operateKey, (String)"save")) {
            return true;
        }
        DynamicObject dy = this.getModel().getDataEntity();
        DataDiv dataDiv = new DataDiv(dy, new ValidateContext());
        if ("save".equals(operateKey) || "submit".equals(operateKey) || "submiteffect".equals(operateKey)) {
            Object dispatchNum = this.getModel().getValue("appdispatchnum");
            Object appRemoveRel = this.getModel().getValue("appremoverel");
            LOGGER.info("appDispatchNum val: {}, appRemoveRel val: {}", dispatchNum, appRemoveRel);
            String appNumChange = this.getPageCache().get("prop_change_save");
            if (StringUtils.isNotBlank((CharSequence)appNumChange)) {
                this.getPageCache().remove("prop_change_save");
                return false;
            }
        }
        TransferSaveValidatorServiceImpl transferValidatorService = (TransferSaveValidatorServiceImpl)ITransferSaveValidatorService.getInstance();
        DynamicObject transferbill = ITransferBillService.getInstance().queryOne(TransferStaffService.getInstance().getSelectProperties(), dy.getLong("id"));
        PluginProxy pluginProxy = PluginProxy.create((Object)new TansferSaveExtendServiceImpl(), ITransferSaveService.class, (String)"kd.sdk.hr.hdm.business.transfer.ITransferSaveService", null);
        List extendValidateResult = pluginProxy.callReplaceIfPresent(service -> service.affactionSaveValidate(transferbill, this.getModel(), this.getView()));
        if (!((Boolean)extendValidateResult.get(0)).booleanValue()) {
            return false;
        }
        if (!ObjectUtils.isEmpty((Object)transferbill) && !(billstatsuValidateBoolean = transferValidatorService.validateBillStatus().test(dataDiv))) {
            this.getView().showErrorNotification(dataDiv.getValidatorContext().map2String());
            return false;
        }
        transferValidatorService.validateSavePostpatternEffctDate("0", HdmFormViewUtil.getMenuFlag((IFormView)this.getView()), "hdm_transfer_org_createdate_savevalidate", "hdm_transfer_company_createdate_savevalidate").test(Collections.singletonList(dataDiv));
        if (dataDiv.getValidatorContext().getValidateResult().size() > 0) {
            this.getView().showErrorNotification(dataDiv.getValidatorContext().map2String());
            return false;
        }
        ITransferValidatorService.getInstance().validateExteranlProfileAndChgRecord(Collections.singletonList(dy.getLong("bemployee.id"))).test(Collections.singletonList(dataDiv));
        ITransferValidatorService.getInstance().validateBaseDataEnable(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"", (String)"", (Object[])new Object[0])).test(Collections.singletonList(dataDiv));
        if (dataDiv.getValidatorContext().getValidateResult().size() > 0) {
            this.getView().showErrorNotification(dataDiv.getValidatorContext().map2String());
            return false;
        }
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        Map crossResultMap = TransferJudgementUtil.EDIT.test(status) ? ITransferPersonChangeService.getInstance().excutePerChgCrossValidate(dy, TransferCrossVerifyEnum.CROSS_TRANSFERBILL_SAVE_EDIT) : ITransferPersonChangeService.getInstance().excutePerChgCrossValidate(dy, TransferCrossVerifyEnum.CROSS_TRANSFERBILL_SAVE_NEW);
        LinkedHashMap<String, String> validateTips = new LinkedHashMap<String, String>();
        switch ((String)crossResultMap.get("key")) {
            case "999": 
            case "1": {
                Arrays.asList("plandate", "realitydate", "transferoutlastdate").forEach(temp -> this.getModel().setValue(temp, null));
                this.getView().showErrorNotification((String)crossResultMap.get("info"));
                return false;
            }
            case "0": {
                validateTips.put("callback_crossdate", (String)crossResultMap.get("info"));
                break;
            }
        }
        if (operate.getOption().containsVariable("isValidateTips") && "false".equals(operate.getOption().getVariableValue("isValidateTips"))) {
            return true;
        }
        Boolean staffInfoValidateBoolean = transferValidatorService.validateStaffInfo(transferbill).test(dataDiv);
        if (!staffInfoValidateBoolean.booleanValue()) {
            validateTips.put("callback_staffvalidate", dataDiv.getValidatorContext().map2String());
        }
        Map devConfigFields = ITransferConfirmValidatorService.getInstance().getDevConfigFields("out");
        IDataModel model = this.getModel();
        String billstatus = (String)model.getValue("billstatus");
        DynamicObject aEvealuationJob = (DynamicObject)model.getValue("aevaluationjob");
        DynamicObject aJobGrade = (DynamicObject)model.getValue("ajobgrade");
        DynamicObject aJobLevel = (DynamicObject)model.getValue("ajoblevel");
        if (aEvealuationJob == null && aJobGrade == null && aJobLevel == null && this.needSecondConfirm(billstatus) && devConfigFields.get("ajobgrade") != null && ((Boolean)devConfigFields.get("ajobgrade")).booleanValue()) {
            validateTips.put("callback_jobvalidate", ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u201c\u8bc4\u5b9a\u804c\u4f4d\u201d\u3001\u201c\u804c\u7ea7\u201d\u3001\u201c\u804c\u7b49\u201d \u5b57\u6bb5\u503c\u5747\u4e3a\u7a7a\uff0c\u7cfb\u7edf\u5c06\u9ed8\u8ba4\u8c03\u52a8\u540e\u4e0d\u8fdb\u884c\u804c\u4f4d\u3001\u804c\u7ea7\u3001\u804c\u7b49\u8c03\u6574\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TransferDateEdit_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
        if (validateTips.size() > 0) {
            HashMap<String, LinkedHashMap<String, String>> params = new HashMap<String, LinkedHashMap<String, String>>(2);
            params.put("message", validateTips);
            TransferPageUtil.showModalWithCloseCallback((AbstractFormPlugin)this, (String)"hdm_tipsconfirm", params, (String)"closeCallBackSave");
            return false;
        }
        return true;
    }

    private void handleCrossDateCancel(Set<String> returnSet) {
        if (returnSet.contains("callback_crossdate")) {
            Arrays.asList("plandate", "realitydate", "transferoutlastdate").forEach(temp -> this.getModel().setValue(temp, null));
        }
    }

    private void handleJobValidate() {
        IDataModel model = this.getModel();
        model.setValue("ajoborg", model.getValue("bjoborg"));
        model.setValue("aevaluationjob", model.getValue("bevaluationjob"));
        model.setValue("ajobgradescm", model.getValue("bjobgradescm"));
        model.setValue("ajobgrade", model.getValue("bjobgrade"));
        model.setValue("ajoblevelscm", model.getValue("bjoblevelscm"));
        model.setValue("ajoblevel", model.getValue("bjoblevel"));
        DynamicObject bevaluationjob = (DynamicObject)model.getValue("bevaluationjob");
        if (null != bevaluationjob) {
            model.setValue("ajobscm", bevaluationjob.get("jobscm"));
            model.setValue("ajobfamily", bevaluationjob.get("jobfamily"));
            model.setValue("ajobclass", bevaluationjob.get("jobclass"));
            model.setValue("ajobseq", bevaluationjob.get("jobseq"));
        }
    }
}

