/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.common;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hdm.business.common.PermissionValidateUtil;
import kd.hr.hdm.business.domain.transfer.entity.DataDiv;
import kd.hr.hdm.business.domain.transfer.entity.StaffIsUpdateJudgementVO;
import kd.hr.hdm.business.domain.transfer.entity.ValidateContext;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.business.domain.transfer.service.ITransferInfoChangeDialogValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferPersonChangeService;
import kd.hr.hdm.business.domain.transfer.service.ITransferPostPatternService;
import kd.hr.hdm.business.domain.transfer.service.ITransferValidatorService;
import kd.hr.hdm.business.domain.transfer.service.external.TransferStaffService;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferInfoChangeDialogValidatorServiceImpl;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferPostPatternServiceImpl;
import kd.hr.hdm.common.transfer.enums.PersonChangeOperateTypeEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;
import kd.hr.hdm.common.util.HdmFormViewUtil;
import kd.hr.hdm.formplugin.transfer.web.common.TransferBeforeF7SelectService;
import kd.hr.hdm.formplugin.transfer.web.common.TransferSingleNotarIzeEdit;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.EntryPropertyChangedHandler;
import kd.sdk.hr.hpfs.business.config.repository.DevParamConfigRepository;

public class TransferInfoChangeEdit
extends HRCoreBaseBillEdit
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(TransferSingleNotarIzeEdit.class);
    private static final ThreadLocal<StaffIsUpdateJudgementVO> cache = new ThreadLocal();

    public void registerListener(EventObject arg) {
        super.registerListener(arg);
        Button buttonOk = (Button)this.getControl("btnok");
        buttonOk.addClickListener((ClickListener)this);
        IFormView formView = this.getView();
        ArrayList baseDataFields = Lists.newArrayList((Object[])new String[]{"aposition", "aorg", "abaselocation", "ajob", "astposition", "acompany", "aevaluationjob", "ajoborg", "ajobgrade", "ajoblevel"});
        baseDataFields.forEach(baseDataField -> {
            BasedataEdit baseData = (BasedataEdit)formView.getControl(baseDataField);
            baseData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        });
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        IDataModel dataModel = this.getModel();
        if ("callback_crossdate".equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Cancel) {
            dataModel.setValue("realitydate", null);
        } else if ("callback_crossdate".equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
            DynamicObject data = this.getData(id);
            this.setInfoChange(data, dataModel);
            this.changerTransferInfo(data);
            IFormView parentView = this.getView().getParentView();
            parentView.showSuccessNotification(ResManager.loadKDString((String)"\u4fe1\u606f\u53d8\u66f4\u6210\u529f", (String)"TransferInfoChangeEdit_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
    }

    public void beforeBindData(EventObject arg) {
        super.beforeBindData(arg);
        long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        DynamicObject transferBill = this.getData(id);
        if (Objects.isNull(transferBill)) {
            return;
        }
        this.initInfoChangeData(transferBill);
        this.setMinRealityDate(transferBill);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        TransferInfoChangeDialogValidatorServiceImpl transferValidatorService = (TransferInfoChangeDialogValidatorServiceImpl)ITransferInfoChangeDialogValidatorService.getInstance();
        long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        DynamicObject transferBill = this.getData(id);
        DynamicObject transferBillForValidate = this.getData(id);
        this.updateTransferBillForValidate(transferBillForValidate, this.getModel());
        DataDiv dataDiv = new DataDiv(transferBillForValidate, new ValidateContext());
        long employeeId = transferBill.getLong("bemployee.id");
        transferValidatorService.validateAuth(PermissionValidateUtil.getPermissionAppId((IFormView)this.getView()), (String)this.getView().getFormShowParameter().getCustomParam("page")).and(transferValidatorService.validateBillStatus()).and(transferValidatorService.validateStaff(transferBill, this.getModel(), cache)).and(transferValidatorService.validateExteranlProfileAndChgRecord(Long.valueOf(employeeId))).and(transferValidatorService.perChgCrossValidate(transferBillForValidate, this.getModel())).and(transferValidatorService.validateSavePostpatternEffctDate("2", HdmFormViewUtil.getMenuFlag((IFormView)this.getView()), "default", "default")).test(dataDiv);
        ITransferValidatorService.getInstance().validateBaseDataEnable(ResManager.loadKDString((String)"\u4fe1\u606f\u53d8\u66f4", (String)"TransferInfoChangeEdit_2", (String)"hr-hdm-formplugin", (Object[])new Object[0])).test(Collections.singletonList(dataDiv));
        if (dataDiv.getValidatorContext().getValidateResult().size() > 0) {
            String perChgCrossValidate = (String)dataDiv.getValidatorContext().getValidateResult().get("perChgCrossValidate_callBack");
            if (perChgCrossValidate != null) {
                this.getView().showConfirm(perChgCrossValidate, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("callback_crossdate", (IFormPlugin)this));
                evt.setCancel(true);
                return;
            }
            this.getView().showErrorNotification(dataDiv.getValidatorContext().map2String());
            evt.setCancel(true);
        }
    }

    private void updateTransferBillForValidate(DynamicObject transferBill, IDataModel model) {
        transferBill.set("realitydate", model.getValue("realitydate"));
        transferBill.set("ajob", model.getValue("ajob"));
        transferBill.set("arealityjob", model.getValue("arealityjob"));
        transferBill.set("aposition", model.getValue("aposition"));
        transferBill.set("arealityposition", model.getValue("arealityposition"));
        transferBill.set("astposition", model.getValue("astposition"));
        transferBill.set("arealitystposition", model.getValue("arealitystposition"));
        transferBill.set("postpattern", model.getValue("postpattern"));
        transferBill.set("aorg", model.getValue("aorg"));
        transferBill.set("arealityorg", model.getValue("arealityorg"));
        transferBill.set("acompany", model.getValue("acompany"));
        transferBill.set("arealitycompany", model.getValue("arealitycompany"));
        transferBill.set("aevaluationjob", model.getValue("aevaluationjob"));
    }

    public void click(EventObject evt) {
        super.click(evt);
        long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        IFormView view = this.getView();
        DynamicObject data = this.getData(id);
        IDataModel model = this.getModel();
        DynamicObject transferBill = model.getDataEntity();
        StaffIsUpdateJudgementVO staffIsUpdateJudgementVO = cache.get();
        if (staffIsUpdateJudgementVO == null) {
            staffIsUpdateJudgementVO = new StaffIsUpdateJudgementVO(data, this.getModel());
        }
        boolean update = staffIsUpdateJudgementVO.isUpdate();
        TXHandle txHandle = TX.required();
        IFormView parentView = view.getParentView();
        try {
            boolean versionValid = ITransferInfoChangeDialogValidatorService.getInstance().checkVersion(data, model);
            if (!versionValid) {
                String errorMsg = this.compareVersionDetail(data);
                this.initInfoChangeData(data);
                parentView.showErrorNotification(ResManager.loadKDString((String)errorMsg, (String)"TransferInfoChangeEdit_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                view.sendFormAction(this.getView().getParentView());
                return;
            }
            this.setInfoChange(data, model);
            if (update) {
                TransferStaffService.getInstance().occupyStaff(Collections.singletonList(data), update);
            }
            if (!ObjectUtils.isEmpty((Object)transferBill)) {
                data.set("realitydate", (Object)transferBill.getDate("realitydate"));
            }
            this.changerTransferInfo(data);
            ITransferPersonChangeService.getInstance().excutePersonChangeNotice(transferBill, PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_MODIFY);
            txHandle.commit();
        }
        catch (KDBizException exception) {
            txHandle.setRollback(true);
            throw exception;
        }
        finally {
            txHandle.close();
            cache.remove();
        }
        parentView.showSuccessNotification(ResManager.loadKDString((String)"\u4fe1\u606f\u53d8\u66f4\u6210\u529f", (String)"TransferInfoChangeEdit_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        view.close();
        parentView.invokeOperation("refresh");
        view.sendFormAction(parentView);
    }

    private void initInfoChangeData(DynamicObject transferBill) {
        String adminkey;
        IFormView formView = this.getView();
        IDataModel model = this.getModel();
        model.setValue("acompany", (Object)transferBill.getDynamicObject("arealitycompany"));
        model.setValue("aorg", (Object)transferBill.getDynamicObject("arealityorg"));
        model.setValue("aposition", (Object)transferBill.getDynamicObject("arealityposition"));
        model.setValue("astposition", (Object)transferBill.getDynamicObject("arealitystposition"));
        model.setValue("abaselocation", (Object)transferBill.getDynamicObject("arealitybaselocation"));
        model.setValue("realitydate", (Object)transferBill.getDate("realitydate"));
        model.setValue("amanagescope", (Object)transferBill.getDynamicObject("amanagescope"));
        model.setValue("arealitysuperior", (Object)transferBill.getDynamicObjectCollection("arealitysuperior").stream().map(temp -> ((DynamicObject)temp.get("fbasedataid")).getLong("id")).toArray());
        model.setValue("arealityorgleader", (Object)transferBill.getDynamicObjectCollection("arealityorgleader").stream().map(temp -> ((DynamicObject)temp.get("fbasedataid")).getLong("id")).toArray());
        model.setValue("id", transferBill.get("id"));
        model.setValue("workingplan", (Object)transferBill.getDynamicObject("workingplan"));
        model.setValue("ajob", (Object)transferBill.getDynamicObject("arealityjob"));
        model.setValue("arealityjob", (Object)transferBill.getDynamicObject("arealityjob"));
        model.setValue("originator", (Object)transferBill.getString("originator"));
        model.setValue("arealitycompany", (Object)transferBill.getDynamicObject("arealitycompany"));
        model.setValue("transferstatus", (Object)transferBill.getString("transferstatus"));
        model.setValue("bcompany", (Object)transferBill.getDynamicObject("bcompany"));
        model.setValue("arealityorg", (Object)transferBill.getDynamicObject("arealityorg"));
        model.setValue("aaffiliateorg", (Object)transferBill.getDynamicObject("aaffiliateorg"));
        model.setValue("arealityposition", (Object)transferBill.getDynamicObject("arealityposition"));
        model.setValue("affaction", (Object)transferBill.getDynamicObject("affaction"));
        model.setValue("bposition", (Object)transferBill.getDynamicObject("bposition"));
        model.setValue("bstposition", (Object)transferBill.getDynamicObject("bstposition"));
        model.setValue("bjob", (Object)transferBill.getDynamicObject("bjob"));
        model.setValue("borg", (Object)transferBill.getDynamicObject("borg"));
        model.setValue("postpattern", (Object)transferBill.getString("postpattern"));
        model.setValue("bpostpattern", (Object)transferBill.getString("bpostpattern"));
        model.setValue("arealitystposition", (Object)transferBill.getDynamicObject("arealitystposition"));
        model.setValue("billno", (Object)transferBill.getString("billno"));
        model.setValue("modifytime", (Object)transferBill.getDate("modifytime"));
        model.setValue("aevaluationjob", (Object)transferBill.getDynamicObject("aevaluationjob"));
        model.setValue("ajoborg", (Object)transferBill.getDynamicObject("ajoborg"));
        model.setValue("ajobgradescm", (Object)transferBill.getDynamicObject("ajobgradescm"));
        model.setValue("ajobgrade", (Object)transferBill.getDynamicObject("ajobgrade"));
        model.setValue("ajoblevelscm", (Object)transferBill.getDynamicObject("ajoblevelscm"));
        model.setValue("ajoblevel", (Object)transferBill.getDynamicObject("ajoblevel"));
        model.setValue("ajobscm", (Object)transferBill.getDynamicObject("ajobscm"));
        model.setValue("ajobfamily", (Object)transferBill.getDynamicObject("ajobfamily"));
        model.setValue("ajobseq", (Object)transferBill.getDynamicObject("ajobseq"));
        model.setValue("ajobclass", (Object)transferBill.getDynamicObject("ajobclass"));
        model.setValue("ajobclasstext", transferBill.get("ajobclasstext"));
        model.setValue("bjoborg", transferBill.get("bjoborg"));
        model.setValue("bevaluationjob", transferBill.get("bevaluationjob"));
        model.setValue("bjobgradescm", transferBill.get("bjobgradescm"));
        model.setValue("bjobgrade", transferBill.get("bjobgrade"));
        model.setValue("bjoblevelscm", transferBill.get("bjoblevelscm"));
        model.setValue("bjoblevel", transferBill.get("bjoblevel"));
        model.setValue("bjobclasstext", transferBill.get("bjobclasstext"));
        this.setPostPostPattern(transferBill.getString("postpattern"));
        this.setPositionMustInputByPostPattern(transferBill);
        ITransferBillService.getInstance().setAJobInfoEnable(formView);
        formView.setEnable(Boolean.FALSE, new String[]{"arealitycompany"});
        DynamicObject adminKeyDy = DevParamConfigRepository.queryConfigByBusinessKey((String)"staff_adminorg");
        String string = adminkey = adminKeyDy != null ? adminKeyDy.getString("businessvalue") : null;
        if (HRStringUtils.isNotEmpty((String)adminkey) && transferBill.containsProperty(adminkey) && model.getDataEntity().containsProperty(adminkey)) {
            model.setValue(adminkey, transferBill.get(adminkey));
        }
    }

    private void setMinRealityDate(DynamicObject transferBill) {
        DynamicObject depEmpDy = transferBill.getDynamicObject("bdepemp");
        if (!ObjectUtils.isEmpty((Object)depEmpDy)) {
            Map map = ITransferBillService.getInstance().getEmpOrgrel(Long.valueOf(depEmpDy.getLong("id")));
            DateTimeEdit planDate = (DateTimeEdit)this.getView().getControl("realitydate");
            LOGGER.info("TransferInfoChangeEdit setdate  date: {} ", (Object)planDate);
            Date tempDate = (Date)map.get("startdate");
            LOGGER.info("TransferInfoChangeEdit setdate  date + 1: {} ", (Object)tempDate);
            if (tempDate != null) {
                planDate.setMinDate(tempDate);
            }
        }
    }

    private void setPostPostPattern(String postpattern) {
        IFormView view = this.getView();
        IDataModel model = this.getView().getModel();
        Object aRealityJob = model.getValue("ajob");
        if (null == aRealityJob) {
            view.setVisible(Boolean.FALSE, new String[]{"ajob"});
        }
        switch (postpattern) {
            case "0": {
                view.setVisible(Boolean.TRUE, new String[]{"astposition"});
                view.setVisible(Boolean.FALSE, new String[]{"aposition", "ajob"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"persongrouppanelap"});
                model.setValue("persongroupfield", (Object)"1");
                model.setValue("arealityposition", null);
                break;
            }
            case "1": {
                view.setVisible(Boolean.FALSE, new String[]{"astposition", "ajob"});
                view.setVisible(Boolean.TRUE, new String[]{"aposition"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"persongrouppanelap"});
                model.setValue("persongroupfield", (Object)"0");
                model.setValue("arealitystposition", null);
                break;
            }
            case "2": {
                view.setVisible(Boolean.FALSE, new String[]{"astposition", "aposition"});
                view.setVisible(Boolean.TRUE, new String[]{"ajob"});
                view.setEnable(Boolean.FALSE, new String[]{"persongrouppanelap"});
                break;
            }
        }
    }

    private void changerTransferInfo(DynamicObject data) {
        ITransferBillService.getInstance().update(Collections.singletonList(data));
        this.getView().close();
    }

    private void setInfoChange(DynamicObject data, IDataModel model) {
        String adminkey;
        ITransferBillService.getInstance().setDefaultAEvaluationJobInfo(model);
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObject aRealityCompany = dataEntity.getDynamicObject("acompany");
        DynamicObject aRealityOrg = dataEntity.getDynamicObject("aorg");
        DynamicObject aRealityPosition = dataEntity.getDynamicObject("aposition");
        DynamicObject aRealityStPosition = dataEntity.getDynamicObject("astposition");
        DynamicObject aRealityBaseLocation = dataEntity.getDynamicObject("abaselocation");
        Date realityDate = dataEntity.getDate("realitydate");
        DynamicObject aManageScope = dataEntity.getDynamicObject("amanagescope");
        DynamicObject workingPlan = dataEntity.getDynamicObject("workingplan");
        DynamicObject aJob = dataEntity.getDynamicObject("ajob");
        DynamicObjectCollection aRealitySuperior = (DynamicObjectCollection)model.getValue("arealitysuperior");
        DynamicObjectCollection aRealityOrgLeader = (DynamicObjectCollection)model.getValue("arealityorgleader");
        data.set("arealitycompany", (Object)aRealityCompany);
        data.set("arealityorg", (Object)aRealityOrg);
        data.set("arealityposition", (Object)aRealityPosition);
        data.set("arealitystposition", (Object)aRealityStPosition);
        data.set("arealitybaselocation", (Object)aRealityBaseLocation);
        data.set("realitydate", (Object)realityDate);
        data.set("amanagescope", (Object)aManageScope);
        data.set("arealitysuperior", (Object)aRealitySuperior);
        data.set("arealityorgleader", (Object)aRealityOrgLeader);
        data.set("aaffiliateorg", (Object)aRealityOrg);
        data.set("workingplan", (Object)workingPlan);
        data.set("arealityjob", (Object)aJob);
        data.set("postpattern", model.getValue("postpattern"));
        data.set("ajoborg", model.getValue("ajoborg"));
        data.set("aevaluationjob", model.getValue("aevaluationjob"));
        data.set("ajobgradescm", model.getValue("ajobgradescm"));
        data.set("ajobgrade", model.getValue("ajobgrade"));
        data.set("ajoblevelscm", model.getValue("ajoblevelscm"));
        data.set("ajoblevel", model.getValue("ajoblevel"));
        data.set("ajobscm", model.getValue("ajobscm"));
        data.set("ajobfamily", model.getValue("ajobfamily"));
        data.set("ajobseq", model.getValue("ajobseq"));
        data.set("ajobclass", model.getValue("ajobclass"));
        data.set("ajobclasstext", model.getValue("ajobclasstext"));
        DynamicObject adminKeyDy = DevParamConfigRepository.queryConfigByBusinessKey((String)"staff_adminorg");
        String string = adminkey = adminKeyDy != null ? adminKeyDy.getString("businessvalue") : null;
        if (HRStringUtils.isNotEmpty((String)adminkey) && data.containsProperty(adminkey) && dataEntity.containsProperty(adminkey)) {
            data.set(adminkey, dataEntity.get(adminkey));
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        try {
            EntryPropertyChangedHandler.getInstance().propertyChange(args).accept(view, model);
        }
        catch (Exception exception) {
            LOGGER.error(exception.getMessage());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        TransferBeforeF7SelectService.getInstance().beforeF7SelectEventHandler(this.getModel(), this.getView(), beforeF7SelectEvent);
    }

    private DynamicObject getData(long id) {
        return ITransferBillService.getInstance().queryOne(TransferStaffService.getInstance().getSelectProperties(), id);
    }

    private void setPositionMustInputByPostPattern(DynamicObject transferBill) {
        TransferPostPatternServiceImpl transferPostPatternService = (TransferPostPatternServiceImpl)ITransferPostPatternService.getInstance();
        transferPostPatternService.setPositionMustInputByPostPattern(transferBill, this.getModel(), this.getView());
    }

    private String compareVersionDetail(DynamicObject latestTransferBill) {
        String value;
        String latestPostPattern;
        boolean postPatternEquals;
        IDataModel model = this.getModel();
        StringBuilder errorMsg = new StringBuilder();
        ArrayList<String> field = new ArrayList<String>();
        Date latestDate = latestTransferBill.getDate("realitydate");
        Date realityDate = (Date)model.getValue("realitydate");
        boolean equals = ((String)TransferCommonUtil.formatDate.apply(latestDate)).equals(TransferCommonUtil.formatDate.apply(realityDate));
        if (!equals) {
            field.add(ResManager.loadKDString((String)"\u8c03\u52a8\u65e5\u671f", (String)"TransferInfoChangeEdit_5", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
        if (!(postPatternEquals = (latestPostPattern = latestTransferBill.getString("postpattern")).equals(value = (String)model.getValue("postpattern"))) && field.size() < 3) {
            field.add(ResManager.loadKDString((String)"\u4efb\u5c97\u6a21\u5f0f", (String)"TransferInfoChangeEdit_6", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject latestCompany = latestTransferBill.getDynamicObject("arealitycompany");
        DynamicObject aCompany = (DynamicObject)model.getValue("acompany");
        if (!latestCompany.get("id").equals(aCompany.get("id")) && field.size() < 3) {
            field.add(ResManager.loadKDString((String)"\u8c03\u5165\u516c\u53f8", (String)"TransferInfoChangeEdit_7", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject latestOrg = latestTransferBill.getDynamicObject("arealityorg");
        DynamicObject aOrg = (DynamicObject)model.getValue("aorg");
        if (!latestOrg.get("id").equals(aOrg.get("id")) && field.size() < 3) {
            field.add(ResManager.loadKDString((String)"\u8c03\u5165\u90e8\u95e8", (String)"TransferInfoChangeEdit_8", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
        if (postPatternEquals) {
            switch (latestPostPattern) {
                case "0": {
                    DynamicObject latestStPosition = latestTransferBill.getDynamicObject("arealitystposition");
                    DynamicObject aStPosition = (DynamicObject)model.getValue("astposition");
                    if (latestStPosition == null && aStPosition == null) break;
                    if (latestStPosition == null || aStPosition == null) {
                        field.add(ResManager.loadKDString((String)"\u8c03\u5165\u6807\u51c6\u5c97\u4f4d", (String)"TransferInfoChangeEdit_9", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    if (latestStPosition.get("id").equals(aStPosition.get("id")) || field.size() >= 3) break;
                    field.add(ResManager.loadKDString((String)"\u8c03\u5165\u6807\u51c6\u5c97\u4f4d", (String)"TransferInfoChangeEdit_9", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "1": {
                    DynamicObject latestPosition = latestTransferBill.getDynamicObject("arealityposition");
                    DynamicObject aPosition = (DynamicObject)model.getValue("aposition");
                    if (latestPosition == null && aPosition == null) break;
                    if (latestPosition == null || aPosition == null) {
                        field.add(ResManager.loadKDString((String)"\u8c03\u5165\u5c97\u4f4d", (String)"TransferInfoChangeEdit_10", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    if (latestPosition.get("id").equals(aPosition.get("id")) || field.size() >= 3) break;
                    field.add(ResManager.loadKDString((String)"\u8c03\u5165\u5c97\u4f4d", (String)"TransferInfoChangeEdit_10", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "2": {
                    DynamicObject latestJob = latestTransferBill.getDynamicObject("arealityjob");
                    DynamicObject aJob = (DynamicObject)model.getValue("ajob");
                    if (latestJob == null && aJob == null) break;
                    if (latestJob == null || aJob == null) {
                        field.add(ResManager.loadKDString((String)"\u8c03\u5165\u4efb\u804c\u804c\u4f4d", (String)"TransferInfoChangeEdit_11", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    if (latestJob.get("id").equals(aJob.get("id")) || field.size() >= 3) break;
                    field.add(ResManager.loadKDString((String)"\u8c03\u5165\u4efb\u804c\u804c\u4f4d", (String)"TransferInfoChangeEdit_11", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                    break;
                }
                default: {
                    throw new RuntimeException("no match postpattern");
                }
            }
        }
        DynamicObject latestAMangeScope = latestTransferBill.getDynamicObject("amanagescope");
        DynamicObject aMangeScope = (DynamicObject)model.getValue("amanagescope");
        if (!latestAMangeScope.get("id").equals(aMangeScope.get("id")) && field.size() < 3) {
            field.add(ResManager.loadKDString((String)"\u6240\u5c5e\u8c03\u5165\u7ba1\u7406\u8303\u56f4", (String)"TransferInfoChangeEdit_12", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject latestBaseLocation = latestTransferBill.getDynamicObject("arealitybaselocation");
        DynamicObject aBaseLocation = (DynamicObject)model.getValue("abaselocation");
        if (!latestBaseLocation.get("id").equals(aBaseLocation.get("id")) && field.size() < 3) {
            field.add(ResManager.loadKDString((String)"\u8c03\u5165\u5e38\u9a7b\u5de5\u4f5c\u5730", (String)"TransferInfoChangeEdit_13", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
        field.forEach(temp -> {
            errorMsg.append((String)temp);
            errorMsg.append(",");
        });
        errorMsg.append(ResManager.loadKDString((String)"\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u518d\u6b21\u786e\u8ba4\u3002", (String)"TransferInfoChangeEdit_14", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        return errorMsg.toString();
    }
}

