/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hdm.business.common.PermissionValidateUtil;
import kd.hr.hdm.business.domain.transfer.entity.DataDiv;
import kd.hr.hdm.business.domain.transfer.entity.ValidateContext;
import kd.hr.hdm.business.domain.transfer.service.IEffectTransferService;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.business.domain.transfer.service.ITransferConfirmDialogValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferConfirmValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferEffectForSecondDevelopService;
import kd.hr.hdm.business.domain.transfer.service.ITransferInfoChangeDialogValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferPersonChangeService;
import kd.hr.hdm.business.domain.transfer.service.ITransferValidatorService;
import kd.hr.hdm.business.domain.transfer.service.external.TransferStaffService;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferConfirmDialogValidatorServiceImpl;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferConfirmValidatorServiceImpl;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferEffectForSecondDevelopServiceImpl;
import kd.hr.hdm.common.transfer.enums.PersonChangeOperateTypeEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;
import kd.hr.hdm.common.util.HdmFormViewUtil;

public class TransferSingleNotarIzeEdit
extends HRCoreBaseBillEdit {
    private static final Log LOGGER = LogFactory.getLog(TransferSingleNotarIzeEdit.class);
    private static final String FLAG_FAIL = "fail";
    private static final String FLAG_SUCCESS = "success";
    private static final ThreadLocal<Boolean> SINGLE_FLAG = new ThreadLocal();

    public void registerListener(EventObject arg) {
        super.registerListener(arg);
        Button buttonap = (Button)this.getControl("btnok");
        buttonap.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject arg) {
        super.beforeBindData(arg);
        long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        DynamicObject transferbill = this.getData(id);
        if (Objects.isNull(transferbill)) {
            return;
        }
        this.initConfirmData(transferbill);
        this.setDateRange(transferbill);
    }

    private void setFieldsMustInput(DynamicObject data, IFormView view) {
        BasedataEdit arealityCompany = (BasedataEdit)view.getControl("arealitycompany");
        BasedataEdit arealityOrg = (BasedataEdit)view.getControl("arealityorg");
        arealityCompany.setMustInput(true);
        arealityOrg.setMustInput(true);
        String postPattern = data.getString("postpattern");
        if ("0".equals(postPattern)) {
            BasedataEdit arealityStPosition = (BasedataEdit)view.getControl("arealitystposition");
            arealityStPosition.setMustInput(true);
        }
        if ("1".equals(postPattern)) {
            BasedataEdit arealityPosition = (BasedataEdit)view.getControl("arealityposition");
            arealityPosition.setMustInput(true);
        }
        if ("2".equals(postPattern)) {
            BasedataEdit aJob = (BasedataEdit)view.getControl("ajob");
            aJob.setMustInput(true);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("entityNum");
        long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        DynamicObject transferbill = this.getData(id);
        DataDiv dataDiv = new DataDiv(transferbill, new ValidateContext());
        TransferConfirmValidatorServiceImpl confirmValidatorService = (TransferConfirmValidatorServiceImpl)ITransferConfirmValidatorService.getInstance();
        TransferConfirmDialogValidatorServiceImpl transferValidatorService = (TransferConfirmDialogValidatorServiceImpl)ITransferConfirmDialogValidatorService.getInstance();
        transferValidatorService.validateAuth(PermissionValidateUtil.getPermissionAppId((IFormView)this.getView()), formId).and(IEffectTransferService.getInstance().validateMustInputFields()).and(transferValidatorService.validateBillStatus()).and(confirmValidatorService.quitValidate()).and(transferValidatorService.perChgCrossValidate(transferbill, this.getModel())).and(transferValidatorService.validateStaff(transferbill, this.getModel())).and(transferValidatorService.validateReality(transferbill, this.getModel())).and(transferValidatorService.validateEmpOrgel(transferbill, this.getModel())).and(transferValidatorService.validateSavePostpatternEffctDate("3", HdmFormViewUtil.getMenuFlag((IFormView)this.getView()), "default", "default")).test(dataDiv);
        ITransferValidatorService.getInstance().validateBaseDataEnable(ResManager.loadKDString((String)"\u786e\u8ba4\u5230\u5c97", (String)"", (String)"", (Object[])new Object[0])).test(Collections.singletonList(dataDiv));
        if (dataDiv.getValidatorContext().getValidateResult().size() > 0) {
            String perChgCrossValidate = (String)dataDiv.getValidatorContext().getValidateResult().get("perChgCrossValidate_callBack");
            if (perChgCrossValidate != null) {
                this.getView().showConfirm(perChgCrossValidate, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("callback_crossdate", (IFormPlugin)this));
                evt.setCancel(true);
                return;
            }
            this.getView().showErrorNotification(dataDiv.getValidatorContext().map2String());
            evt.setCancel(true);
            return;
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("callback_crossdate".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Cancel) {
            this.getModel().setValue("realitydate", null);
        } else if ("callback_crossdate".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
            DynamicObject data = this.getData(id);
            IDataModel model = this.getView().getModel();
            this.changerTransferInfo(data, model);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        IFormView view = this.getView();
        DynamicObject data = this.getData(id);
        IDataModel model = this.getView().getModel();
        DynamicObject transferbill = model.getDataEntity();
        Date beforeDate = data.getDate("realitydate");
        Date afterDate = (Date)this.getModel().getValue("realitydate");
        boolean isUpdate = !((String)TransferCommonUtil.formatDate.apply(beforeDate)).equals(TransferCommonUtil.formatDate.apply(afterDate));
        try (TXHandle txHandle = TX.required();){
            boolean versionValid = ITransferInfoChangeDialogValidatorService.getInstance().checkVersion(data, model);
            if (!versionValid) {
                String errormsg = this.compareVersionDetail(data);
                this.initConfirmData(data);
                view.getParentView().showErrorNotification(ResManager.loadKDString((String)errormsg, (String)"TransferInfoChangeEdit_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                view.sendFormAction(this.getView().getParentView());
                return;
            }
            if (isUpdate) {
                TransferStaffService.getInstance().occupyStaff(Collections.singletonList(data), true);
            }
            if (!ObjectUtils.isEmpty((Object)transferbill)) {
                data.set("realitydate", (Object)transferbill.getDate("realitydate"));
            }
            ITransferPersonChangeService.getInstance().excutePersonChangeNotice(transferbill, PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_MODIFY);
            this.changerTransferInfo(data, model);
            txHandle.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changerTransferInfo(DynamicObject data, IDataModel model) {
        Date realityDate = (Date)model.getValue("realitydate");
        IFormView view = this.getView();
        data.set("realitydate", (Object)realityDate);
        try (TXHandle txHandle = TX.required();){
            ITransferBillService.getInstance().update(Collections.singletonList(data));
            TransferEffectForSecondDevelopServiceImpl effectForSecondDevelopService = (TransferEffectForSecondDevelopServiceImpl)ITransferEffectForSecondDevelopService.getInstance();
            effectForSecondDevelopService.excutePersonChangeEffect(Long.valueOf(data.getLong("id")), PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_EFFECT);
            txHandle.commit();
            view.getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff0c\u8c03\u52a8\u7ed3\u679c\u540c\u6b65\u4e2d\u3002", (String)"TransferSingleNotarIzeEdit_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
        view.close();
        view.getParentView().invokeOperation("refresh");
        view.sendFormAction(this.getView().getParentView());
    }

    private DynamicObject getData(long datas) {
        DynamicObject query = ITransferBillService.getInstance().queryOne(TransferStaffService.getInstance().getSelectProperties(), datas);
        return query;
    }

    private void initConfirmData(DynamicObject transferbill) {
        IFormView view = this.getView();
        IDataModel model = this.getView().getModel();
        DynamicObject arealitycompany = transferbill.getDynamicObject("arealitycompany");
        DynamicObject arealityorg = transferbill.getDynamicObject("arealityorg");
        DynamicObject arealityposition = transferbill.getDynamicObject("arealityposition");
        DynamicObject arealitystposition = transferbill.getDynamicObject("arealitystposition");
        DynamicObject arealitybaselocation = transferbill.getDynamicObject("arealitybaselocation");
        DynamicObject amanagescope = transferbill.getDynamicObject("amanagescope");
        DynamicObject workingplan = transferbill.getDynamicObject("workingplan");
        DynamicObject arealityJob = transferbill.getDynamicObject("arealityjob");
        DynamicObject eavluationJob = transferbill.getDynamicObject("aevaluationjob");
        Date realitydate = transferbill.getDate("realitydate");
        Date modifyTime = transferbill.getDate("modifytime");
        DynamicObjectCollection arealitysuperior = transferbill.getDynamicObjectCollection("arealitysuperior");
        List arealitysuperiorIds = arealitysuperior.stream().map(temp -> ((DynamicObject)temp.get("fbasedataid")).getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection arealityorgleader = transferbill.getDynamicObjectCollection("arealityorgleader");
        List orgleaderids = arealityorgleader.stream().map(temp -> ((DynamicObject)temp.get("fbasedataid")).getLong("id")).collect(Collectors.toList());
        String postpattern = transferbill.getString("postpattern");
        if (null == arealityJob) {
            view.setVisible(Boolean.FALSE, new String[]{"ajob"});
        }
        switch (postpattern) {
            case "0": {
                view.setVisible(Boolean.TRUE, new String[]{"arealitystposition"});
                view.setVisible(Boolean.FALSE, new String[]{"arealityposition"});
                view.setEnable(Boolean.FALSE, new String[]{"persongrouppanelap"});
                model.setValue("persongroupfield", (Object)"1");
                model.setValue("superiorchannel", (Object)"1");
                break;
            }
            case "1": {
                view.setVisible(Boolean.FALSE, new String[]{"arealitystposition"});
                view.setVisible(Boolean.TRUE, new String[]{"arealityposition"});
                view.setEnable(Boolean.TRUE, new String[]{"persongrouppanelap"});
                model.setValue("persongroupfield", (Object)"0");
                model.setValue("superiorchannel", (Object)"0");
                break;
            }
            case "2": {
                view.setVisible(Boolean.FALSE, new String[]{"arealitystposition"});
                view.setVisible(Boolean.FALSE, new String[]{"arealityposition"});
                view.setVisible(Boolean.TRUE, new String[]{"ajob"});
                view.setEnable(Boolean.TRUE, new String[]{"ajob"});
                view.setEnable(Boolean.FALSE, new String[]{"persongrouppanelap"});
                break;
            }
        }
        model.setValue("arealitycompany", (Object)arealitycompany);
        model.setValue("arealityorg", (Object)arealityorg);
        model.setValue("arealityposition", (Object)arealityposition);
        model.setValue("arealitystposition", (Object)arealitystposition);
        model.setValue("arealitybaselocation", (Object)arealitybaselocation);
        model.setValue("realitydate", (Object)realitydate);
        model.setValue("amanagescope", (Object)amanagescope);
        model.setValue("arealitysuperior", (Object)arealitysuperiorIds.toArray());
        model.setValue("arealityorgleader", (Object)orgleaderids.toArray());
        model.setValue("id", transferbill.get("id"));
        model.setValue("workingplan", (Object)workingplan);
        model.setValue("ajob", (Object)arealityJob);
        model.setValue("modifytime", (Object)modifyTime);
        model.setValue("postpattern", (Object)postpattern);
        model.setValue("aevaluationjob", (Object)eavluationJob);
        view.setEnable(Boolean.FALSE, new String[]{"arealitycompany"});
        this.setFieldsMustInput(transferbill, this.getView());
    }

    private void setDateRange(DynamicObject transferbill) {
        DateTimeEdit planDate = (DateTimeEdit)this.getView().getControl("realitydate");
        planDate.setMaxDate(new Date());
        DynamicObject depempDy = transferbill.getDynamicObject("bdepemp");
        if (!ObjectUtils.isEmpty((Object)depempDy)) {
            Map map = ITransferBillService.getInstance().getEmpOrgrel(Long.valueOf(depempDy.getLong("id")));
            Date tempDate = (Date)map.get("startdate");
            LOGGER.info("Invoke person interface return date : {}", (Object)tempDate);
            if (tempDate != null) {
                planDate.setMinDate(tempDate);
            }
        }
    }

    private String compareVersionDetail(DynamicObject latestTransferBill) {
        String value;
        String latestPostpattern;
        boolean postPatternEquals;
        IDataModel model = this.getModel();
        StringBuilder errorMsg = new StringBuilder();
        ArrayList<String> field = new ArrayList<String>();
        Date latestDate = latestTransferBill.getDate("realitydate");
        Date realitydate = (Date)model.getValue("realitydate");
        boolean equals = ((String)TransferCommonUtil.formatDate.apply(latestDate)).equals(TransferCommonUtil.formatDate.apply(realitydate));
        if (!equals && field.size() < 3) {
            field.add(ResManager.loadKDString((String)"\u8c03\u52a8\u65e5\u671f", (String)"", (String)"", (Object[])new Object[0]));
        }
        if (!(postPatternEquals = (latestPostpattern = latestTransferBill.getString("postpattern")).equals(value = (String)model.getValue("postpattern"))) && field.size() < 3) {
            field.add(ResManager.loadKDString((String)"\u4efb\u5c97\u6a21\u5f0f", (String)"", (String)"", (Object[])new Object[0]));
        }
        DynamicObject latestCompany = latestTransferBill.getDynamicObject("arealitycompany");
        DynamicObject acompany = (DynamicObject)model.getValue("arealitycompany");
        if (!latestCompany.get("id").equals(acompany.get("id")) && field.size() < 3) {
            field.add(ResManager.loadKDString((String)"\u8c03\u5165\u516c\u53f8", (String)"", (String)"", (Object[])new Object[0]));
        }
        DynamicObject latestOrg = latestTransferBill.getDynamicObject("arealityorg");
        DynamicObject aorg = (DynamicObject)model.getValue("arealityorg");
        if (!latestOrg.get("id").equals(aorg.get("id")) && field.size() < 3) {
            field.add(ResManager.loadKDString((String)"\u8c03\u5165\u90e8\u95e8", (String)"", (String)"", (Object[])new Object[0]));
        }
        if (postPatternEquals) {
            switch (latestPostpattern) {
                case "0": {
                    DynamicObject lastestStPosition = latestTransferBill.getDynamicObject("arealitystposition");
                    DynamicObject astpostion = (DynamicObject)model.getValue("arealitystposition");
                    if (lastestStPosition.get("id").equals(astpostion.get("id")) || field.size() >= 3) break;
                    field.add(ResManager.loadKDString((String)"\u8c03\u5165\u6807\u51c6\u5c97\u4f4d", (String)"", (String)"", (Object[])new Object[0]));
                    break;
                }
                case "1": {
                    DynamicObject latestPostiion = latestTransferBill.getDynamicObject("arealityposition");
                    DynamicObject aposition = (DynamicObject)model.getValue("arealityposition");
                    if (latestPostiion.get("id").equals(aposition.get("id")) || field.size() >= 3) break;
                    field.add(ResManager.loadKDString((String)"\u8c03\u5165\u5c97\u4f4d", (String)"", (String)"", (Object[])new Object[0]));
                    break;
                }
                case "2": {
                    DynamicObject latestJob = latestTransferBill.getDynamicObject("arealityjob");
                    DynamicObject ajob = (DynamicObject)model.getValue("ajob");
                    if (latestJob.get("id").equals(ajob.get("id")) || field.size() >= 3) break;
                    field.add(ResManager.loadKDString((String)"\u8c03\u5165\u4efb\u804c\u804c\u4f4d", (String)"", (String)"", (Object[])new Object[0]));
                    break;
                }
                default: {
                    throw new RuntimeException("no match postpattern");
                }
            }
        }
        DynamicObject latestAmangeScope = latestTransferBill.getDynamicObject("amanagescope");
        DynamicObject amangeScope = (DynamicObject)model.getValue("amanagescope");
        if (!latestAmangeScope.get("id").equals(amangeScope.get("id")) && field.size() < 3) {
            field.add(ResManager.loadKDString((String)"\u6240\u5c5e\u8c03\u5165\u7ba1\u7406\u8303\u56f4", (String)"", (String)"", (Object[])new Object[0]));
        }
        DynamicObject latestBaseLoacation = latestTransferBill.getDynamicObject("arealitybaselocation");
        DynamicObject abseLocation = (DynamicObject)model.getValue("arealitybaselocation");
        if (!latestBaseLoacation.get("id").equals(abseLocation.get("id")) && field.size() < 3) {
            field.add(ResManager.loadKDString((String)"\u8c03\u5165\u5e38\u9a7b\u5de5\u4f5c\u5730", (String)"", (String)"", (Object[])new Object[0]));
        }
        field.forEach(temp -> {
            errorMsg.append((String)temp);
            errorMsg.append(",");
        });
        errorMsg.append(ResManager.loadKDString((String)"\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u518d\u6b21\u786e\u8ba4", (String)"", (String)"", (Object[])new Object[0]));
        return errorMsg.toString();
    }
}

