/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.common;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hdm.business.common.PermissionValidateUtil;
import kd.hr.hdm.business.domain.transfer.entity.DataDiv;
import kd.hr.hdm.business.domain.transfer.entity.ValidateContext;
import kd.hr.hdm.business.domain.transfer.repository.PermissionRepository;
import kd.hr.hdm.business.domain.transfer.repository.TransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.ITransferBatchService;
import kd.hr.hdm.business.domain.transfer.service.ITransferOperationService;
import kd.hr.hdm.business.domain.transfer.service.ITransferValidatorService;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferOperationServiceImpl;
import kd.hr.hdm.common.transfer.enums.TransferPermItermIdEnum;
import kd.hr.hdm.common.transfer.util.TransferPageHelperUtil;

public class TransferTerminateEdit
extends HRCoreBaseBillEdit {
    private static final Log logger = LogFactory.getLog(TransferTerminateEdit.class);
    private static final String BTN_OK = "btnok";

    public void registerListener(EventObject arg) {
        super.registerListener(arg);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (HRStringUtils.equals((String)BTN_OK, (String)key)) {
            this.checkTermination(evt);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (HRStringUtils.equals((String)BTN_OK, (String)key)) {
            TransferOperationServiceImpl transferValidatorService = (TransferOperationServiceImpl)ITransferOperationService.getInstance();
            Long billId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
            String menuflag = (String)this.getView().getFormShowParameter().getCustomParam("menuflag");
            logger.info("Transferbill terminate exec start.");
            Tuple termResult = HRStringUtils.equals((String)"batch", (String)menuflag) ? transferValidatorService.batchHandleTermination(billId, this.getModel()) : transferValidatorService.handleTermination(billId, this.getModel());
            logger.info("Transferbill terminate exec end.");
            if (!((Boolean)termResult.item1).booleanValue()) {
                this.getView().showErrorNotification((String)termResult.item2);
                return;
            }
            IFormView view = this.getView();
            IFormView parentView = view.getParentView();
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u6210\u529f\u3002", (String)"TransferTerminateEdit_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            parentView.invokeOperation("refresh");
            view.sendFormAction(parentView);
            this.getView().close();
        }
    }

    private void checkTermination(BeforeClickEvent evt) {
        String msg;
        boolean statusValidate;
        String entityNumber = "";
        Long billId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        String menuflag = (String)this.getView().getFormShowParameter().getCustomParam("menuflag");
        if (HRStringUtils.equals((String)menuflag, (String)"batch")) {
            DynamicObject dy = ITransferBatchService.getInstance().queryOne(TransferPageHelperUtil.BATCHQUERYFIELD, billId.longValue());
            DataDiv dataDiv = new DataDiv(dy, new ValidateContext());
            statusValidate = ITransferValidatorService.getInstance().batchTransferTerminalValidate().test(dataDiv);
            msg = dataDiv.getValidatorContext().map2String();
        } else {
            DynamicObject dy = TransferBillRepository.getInstance().queryOne(TransferPageHelperUtil.QUERYFIELD, (Object)billId);
            String transferStatus = dy.getString("transferstatus");
            String transferEffectStatus = dy.getString("transfereffectstatus");
            DataDiv dataDiv = new DataDiv(dy, new ValidateContext());
            statusValidate = ITransferValidatorService.getInstance().terminalValidate(transferStatus, transferEffectStatus).test(dataDiv);
            msg = dataDiv.getValidatorContext().map2String();
        }
        if (!statusValidate) {
            this.getView().showErrorNotification(msg);
            evt.setCancel(true);
            return;
        }
        switch (menuflag) {
            case "in": {
                entityNumber = "hdm_transferinbill";
                break;
            }
            case "out": {
                entityNumber = "hdm_transferoutbill";
                break;
            }
            case "apply": {
                entityNumber = "hdm_transferapply";
                break;
            }
            case "batch": {
                entityNumber = "hdm_transferbatch";
                break;
            }
        }
        if (!this.terminateDataRule(entityNumber, billId).booleanValue()) {
            this.getView().showErrorNotification(TransferPermItermIdEnum.getTerminateMsg((String)menuflag));
            evt.setCancel(true);
            return;
        }
        if (!PermissionRepository.getInstance().checkOperatePermission(entityNumber, "HRQXX0135", PermissionValidateUtil.getPermissionAppId((IFormView)this.getView()))) {
            this.getView().showErrorNotification(TransferPermItermIdEnum.getTerminateOperatePermMsg((String)menuflag));
            evt.setCancel(true);
        }
    }

    private Boolean terminateDataRule(String entityNumber, Long billId) {
        QFilter[] ids = new QFilter("id", "in", (Object)billId).toArray();
        Map dataRuleMap = PermissionRepository.getInstance().checkDataRule(PermissionValidateUtil.getPermissionAppId((IFormView)this.getView()), entityNumber, TransferPermItermIdEnum.TERMINATE.itermId, ids);
        return (Boolean)dataRuleMap.get(billId);
    }
}

