/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.common.propertychange;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.service.hbpm.IHBPMService;
import kd.hr.hdm.business.domain.transfer.service.HdmConsumer;
import kd.hr.hdm.business.domain.transfer.service.HdmFunction;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.business.domain.transfer.service.ITransferPropertyChangeValidatorService;
import kd.hr.hdm.business.domain.transfer.service.external.AdminOrgExternalService;
import kd.hr.hdm.business.domain.transfer.service.external.JobExternalService;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferPropertyChangeValidatorServiceImpl;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;
import kd.hr.hdm.common.util.HdmAppConfigUtil;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler.AEvaluationJobHandler;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler.AJobGradeScmHandler;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler.AJobHandler;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler.AJobLevelScmHandler;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler.AJobOrgHandler;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler.AbaseLocationHandler;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler.AcompanyHandler;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler.AcounytryHandler;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler.AffactionHandler;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler.AorgHandler;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler.ApoistionHandler;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler.AppDispatchNumHandler;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler.ArealitysuperiorHandler;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler.AstpositionHandler;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler.BPostpartternHandler;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler.ErmanFileHandler;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler.PersonFieldHandler;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler.PlandateHandler;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler.PostpatternHandler;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler.TransferdateHandler;

public class EntryPropertyChangedHandler {
    private static final EntryPropertyChangedHandler entryPropertyChangedHandler = new EntryPropertyChangedHandler();
    private static final Log LOGGER = LogFactory.getLog(EntryPropertyChangedHandler.class);
    private static final String[] enableFields = new String[]{"acompany", "aposition", "aorg", "astposition", "abaselocation", "transferreason", "plandate", "description", "persongrouppanelap", "amanagescope", "postpattern", "workingplan", "affaction", "ajoborg"};
    private Function<String, EntryPropertyChangedHandler> getHandLer = propertyName -> {
        switch (propertyName) {
            case "personfield": {
                return PersonFieldHandler.getInstance();
            }
            case "ermanfile": {
                return ErmanFileHandler.getInstance();
            }
            case "abaselocation": {
                return AbaseLocationHandler.getInstance();
            }
            case "acountry": {
                return AcounytryHandler.getInstance();
            }
            case "acompany": {
                return AcompanyHandler.getInstance();
            }
            case "aposition": {
                return ApoistionHandler.getInstance();
            }
            case "aorg": {
                return AorgHandler.getInstance();
            }
            case "astposition": {
                return AstpositionHandler.getInstance();
            }
            case "plandate": {
                return PlandateHandler.getInstance();
            }
            case "transferdate": {
                return TransferdateHandler.getInstance();
            }
            case "postpattern": {
                return PostpatternHandler.getInstance();
            }
            case "arealitysuperior": {
                return ArealitysuperiorHandler.getInstance();
            }
            case "affaction": {
                return AffactionHandler.getInstance();
            }
            case "aevaluationjob": {
                return AEvaluationJobHandler.getInstance();
            }
            case "ajobgradescm": {
                return AJobGradeScmHandler.getInstance();
            }
            case "ajoblevelscm": {
                return AJobLevelScmHandler.getInstance();
            }
            case "ajoborg": {
                return AJobOrgHandler.getInstance();
            }
            case "bpostpattern": {
                return BPostpartternHandler.getInstance();
            }
            case "ajob": {
                return AJobHandler.getInstance();
            }
            case "appdispatchnum": {
                return AppDispatchNumHandler.getInstance();
            }
        }
        return null;
    };

    public static EntryPropertyChangedHandler getInstance() {
        return entryPropertyChangedHandler;
    }

    public BiConsumer<IFormView, IDataModel> propertyChange(PropertyChangedArgs e) {
        return (view, model) -> {
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            Object newValue = changeData.getNewValue();
            String propertyName = e.getProperty().getName();
            EntryPropertyChangedHandler handler = this.getHandLer.apply(propertyName);
            if (handler == null) {
                return;
            }
            handler.propertyChange(newValue, propertyName).accept(view, model, (Object)rowIndex);
        };
    }

    protected HdmConsumer<IFormView, IDataModel, Integer> propertyChange(Object newValue, String propertyName) {
        return null;
    }

    protected HdmConsumer<IFormView, IDataModel, Integer> setSuperior() {
        return (view, model, rowIndex) -> {
            List superiorPersonIdList = ITransferBillService.getInstance().invokeGetSuperiorByRule(model.getDataEntity());
            Object[] objects = superiorPersonIdList.toArray();
            model.setValue("arealitysuperior", (Object)objects, rowIndex.intValue());
        };
    }

    protected HdmConsumer<IFormView, IDataModel, Integer> setAcompany(Object aCompany) {
        return (view, model, rowIndex) -> {
            model.setValue("acompany", aCompany, rowIndex.intValue());
            DynamicObject affactionDy = (DynamicObject)model.getValue("affaction", rowIndex.intValue());
            long affactionId = affactionDy == null ? 0L : affactionDy.getLong("id");
            TransferPropertyChangeValidatorServiceImpl transferValidatorService = (TransferPropertyChangeValidatorServiceImpl)ITransferPropertyChangeValidatorService.getInstance();
            Boolean isCompanyBoolean = (Boolean)transferValidatorService.isCompanyRemained("bcompany", "acompany", affactionId).apply(view, model, rowIndex);
            if (isCompanyBoolean.booleanValue()) {
                model.setValue("arealitycompany", aCompany, rowIndex.intValue());
                if (((Boolean)this.whetherWritrePlan().apply(view, model, rowIndex)).booleanValue()) {
                    model.setValue("aplancompany", aCompany, rowIndex.intValue());
                }
            }
            view.updateView("transferouteditpanel");
            view.sendFormAction(view);
        };
    }

    protected HdmFunction<IFormView, IDataModel, Integer, String> getMenuFlag() {
        return (view, model, rowIndex) -> {
            FormShowParameter param = view.getFormShowParameter();
            Map customParams = param.getCustomParams();
            String menuflag = (String)customParams.get("menuflag");
            if (ObjectUtils.isEmpty((Object)menuflag)) {
                menuflag = TransferCommonUtil.getMenuflagStr((IFormView)view);
            }
            return menuflag;
        };
    }

    protected HdmConsumer<IFormView, IDataModel, Integer> setEnable() {
        return (view, model, rowIndex) -> {
            if (rowIndex == -1 || rowIndex == 0) {
                view.setEnable(Boolean.TRUE, enableFields);
                if (null != model.getValue("ajoborg")) {
                    view.setEnable(Boolean.TRUE, new String[]{"ajoborg", "aevaluationjob"});
                }
                Object value = model.getValue("affaction", rowIndex.intValue());
                Object ajobOrg = model.getValue("ajoborg", rowIndex.intValue());
                if (null != model.getValue("aevaluationjob")) {
                    DynamicObject evaluationJob = (DynamicObject)model.getValue("aevaluationjob");
                    long jobId = evaluationJob.getLong("id");
                    List<Long> jobIds = Collections.singletonList(jobId);
                    JobExternalService jobExternalService = JobExternalService.getInstance();
                    Map gradeResult = jobExternalService.getJobGradeRangeByJobId(jobIds, new Date());
                    Map gradeInfoMap = (Map)gradeResult.get(jobId);
                    Object gradeScmId = gradeInfoMap.get("jobGradeScmId");
                    Map levelResult = jobExternalService.getJobLevelRangeByJobId(jobIds, new Date());
                    Map levelInfoMap = (Map)levelResult.get(jobId);
                    Object levelScmId = levelInfoMap.get("jobLevelScmId");
                    if (gradeScmId == null || (Long)gradeScmId == 0L) {
                        view.setEnable(Boolean.FALSE, new String[]{"ajobgradescm", "ajobgrade"});
                    } else {
                        view.setEnable(Boolean.FALSE, new String[]{"ajobgradescm"});
                        view.setEnable(Boolean.TRUE, new String[]{"ajobgrade"});
                    }
                    if (levelScmId == null || (Long)levelScmId == 0L) {
                        view.setEnable(Boolean.FALSE, new String[]{"ajoblevelscm", "ajoblevel"});
                    } else {
                        view.setEnable(Boolean.FALSE, new String[]{"ajoblevelscm"});
                        view.setEnable(Boolean.TRUE, new String[]{"ajoblevel"});
                    }
                } else {
                    if (null != ajobOrg) {
                        view.setEnable(Boolean.TRUE, new String[]{"ajobgradescm", "ajoblevelscm"});
                    }
                    if (null != model.getValue("ajobgradescm") && null != value && null != ajobOrg) {
                        view.setEnable(Boolean.TRUE, new String[]{"ajobgrade"});
                    }
                    if (null != model.getValue("ajoblevelscm") && null != value && null != ajobOrg) {
                        view.setEnable(Boolean.TRUE, new String[]{"ajoblevel"});
                    }
                }
            } else {
                view.setEnable(Boolean.TRUE, rowIndex.intValue(), enableFields);
            }
        };
    }

    protected HdmFunction<IFormView, IDataModel, Integer, Boolean> whetherWritrePlan() {
        return (view, model, rowIndex) -> {
            try {
                String menuFlag = (String)this.getMenuFlag().apply(view, model, rowIndex);
                String originator = (String)model.getValue("originator", rowIndex.intValue());
                String transferStatus = (String)model.getValue("transferstatus", rowIndex.intValue());
                if (!"4".equals(transferStatus) && (-1 == rowIndex || 0 == rowIndex) && "out".equals(menuFlag) && "1".equals(originator)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        };
    }

    protected HdmConsumer<IFormView, IDataModel, Integer> setStPositionJob(String stdField, String stdJobField) {
        return (view, model, rowIndex) -> {
            DynamicObject stdPosition = (DynamicObject)model.getValue(stdField, rowIndex.intValue());
            if (HRObjectUtils.isEmpty((Object)stdPosition)) {
                model.setValue(stdJobField, null, rowIndex.intValue());
                view.setVisible(Boolean.FALSE, new String[]{stdJobField});
                boolean evaluationJobIsCtr = HdmAppConfigUtil.getEvaluationJobIsCtr();
                if (evaluationJobIsCtr) {
                    model.setValue("ajoborg", null);
                    view.setEnable(Boolean.TRUE, new String[]{"ajoborg"});
                }
            } else {
                long stdPositionId = stdPosition.getLong("id");
                Map stdPositionResult = AdminOrgExternalService.getInstance().invokeQueryStandardPosition(Collections.singletonList(stdPositionId));
                Object stdPositionData = stdPositionResult.get("data");
                if (null == stdPositionData) {
                    view.setVisible(Boolean.FALSE, new String[]{stdJobField});
                    LOGGER.warn("stdPositionData is null stdPositionId:{}", (Object)stdPositionId);
                    return;
                }
                List stdPositionList = (List)stdPositionData;
                Map stdPositionMap = (Map)stdPositionList.get(0);
                Long jobId = (Long)stdPositionMap.get("job.id");
                this.jobEmptyHandle((IFormView)view, (IDataModel)model, stdPosition, jobId, stdJobField, (Integer)rowIndex);
            }
        };
    }

    protected HdmConsumer<IFormView, IDataModel, Integer> setPositionJob(String field, String jobField) {
        return (view, model, rowIndex) -> {
            DynamicObject position = (DynamicObject)model.getValue(field, rowIndex.intValue());
            if (HRObjectUtils.isEmpty((Object)position)) {
                model.setValue(jobField, null, rowIndex.intValue());
                view.setVisible(Boolean.FALSE, new String[]{jobField});
                boolean evaluationJobIsCtr = HdmAppConfigUtil.getEvaluationJobIsCtr();
                if (evaluationJobIsCtr) {
                    model.setValue("ajoborg", null);
                    view.setEnable(Boolean.TRUE, new String[]{"ajoborg"});
                }
            } else {
                long positionId = position.getLong("id");
                Map positionHisMap = AdminOrgExternalService.getInstance().invokeQueryPositionHis(Collections.singletonList(positionId), new Date());
                LOGGER.info("invokeQueryPositionHis result:{}", (Object)positionHisMap);
                Map positionHisData = (Map)positionHisMap.get("data");
                if (null == positionHisData) {
                    LOGGER.warn("positionHisData is null ");
                    view.setVisible(Boolean.FALSE, new String[]{jobField});
                    return;
                }
                List hisData = (List)positionHisData.get("hisdata");
                if (null == hisData) {
                    LOGGER.warn("hisData is null ");
                    view.setVisible(Boolean.FALSE, new String[]{jobField});
                    return;
                }
                Map positionMap = (Map)hisData.get(0);
                Long job = (Long)positionMap.get("job");
                this.jobEmptyHandle((IFormView)view, (IDataModel)model, position, job, jobField, (Integer)rowIndex);
            }
        };
    }

    private void jobEmptyHandle(IFormView view, IDataModel model, DynamicObject dy, Long jobId, String jobField, Integer rowIndex) {
        long dyId = dy.getLong("id");
        if (null == jobId || 0L == jobId) {
            view.setVisible(Boolean.FALSE, new String[]{jobField});
            model.setValue(jobField, null, rowIndex.intValue());
            boolean evaluationJobIsCtr = HdmAppConfigUtil.getEvaluationJobIsCtr();
            if (evaluationJobIsCtr) {
                Map map;
                Map data;
                model.setValue("ajoborg", null);
                view.setEnable(Boolean.TRUE, new String[]{"ajoborg"});
                String postPattern = (String)model.getValue("postpattern", rowIndex.intValue());
                if (HRStringUtils.equals((String)postPattern, (String)"1")) {
                    data = IHBPMService.getInstance().queryJobLevelGradeRangeAndScmByPositionVersion(Collections.singletonList(dyId), null);
                } else if (HRStringUtils.equals((String)postPattern, (String)"0")) {
                    data = IHBPMService.getInstance().queryJobLevelGradeRangeAndScmByStdPositionVersion(Collections.singletonList(dyId), null);
                } else {
                    return;
                }
                if (data != null && (map = (Map)data.get(dyId)) != null) {
                    Map jobLevelData;
                    Map jobGradeData = (Map)map.get("jobGradeData");
                    if (jobGradeData != null) {
                        Long jobGradeScmId = (Long)jobGradeData.get("id");
                        model.setValue("ajoborg", dy.get("org"), rowIndex.intValue());
                        model.setValue("ajobgradescm", (Object)jobGradeScmId, rowIndex.intValue());
                    }
                    if ((jobLevelData = (Map)map.get("jobLevelData")) != null) {
                        Long jobLevelScmId = (Long)jobLevelData.get("id");
                        model.setValue("ajoborg", dy.get("org"), rowIndex.intValue());
                        model.setValue("ajoblevelscm", (Object)jobLevelScmId, rowIndex.intValue());
                    }
                    if (jobGradeData != null || jobLevelData != null) {
                        view.setEnable(Boolean.FALSE, new String[]{"ajoborg", "aevaluationjob", "ajobgradescm", "ajoblevelscm"});
                    }
                }
            }
        } else {
            model.setValue(jobField, (Object)jobId, rowIndex.intValue());
            view.setVisible(Boolean.TRUE, new String[]{jobField});
        }
    }
}

