/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hdm.business.domain.transfer.service.HdmConsumer;
import kd.hr.hdm.business.domain.transfer.service.external.JobExternalService;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.EntryPropertyChangedHandler;

public class AEvaluationJobHandler
extends EntryPropertyChangedHandler {
    private static final Log LOGGER = LogFactory.getLog(AEvaluationJobHandler.class);
    private static final AEvaluationJobHandler aCounytryHandler = new AEvaluationJobHandler();
    private static final String[] CLEAN_FIELD_LIST = new String[]{"ajobgradescm", "ajobgrade", "ajoblevelscm", "ajoblevel", "ajobscm", "ajobfamily", "ajobclass", "ajobseq", "ajobclasstext"};

    public static AEvaluationJobHandler getInstance() {
        return aCounytryHandler;
    }

    @Override
    protected HdmConsumer<IFormView, IDataModel, Integer> propertyChange(Object newValue, String propertyName) {
        return (view, model, rowIndex) -> {
            LOGGER.info("AEvaluationJobHandler.propertyChange start,newValue:{}", newValue);
            try {
                boolean noLevelScmInfo;
                if (null == newValue) {
                    this.cleanData().accept(view, model, rowIndex);
                    return;
                }
                DynamicObject evaluationJob = (DynamicObject)newValue;
                long jobId = evaluationJob.getLong("id");
                List<Long> jobIds = Collections.singletonList(jobId);
                Map gradeResult = JobExternalService.getInstance().getJobGradeRangeByJobId(jobIds, new Date());
                Map gradeInfoMap = (Map)gradeResult.get(jobId);
                Object gradeScmId = gradeInfoMap.get("jobGradeScmId");
                Map levelResult = JobExternalService.getInstance().getJobLevelRangeByJobId(jobIds, new Date());
                Map levelInfoMap = (Map)levelResult.get(jobId);
                Object levelScmId = levelInfoMap.get("jobLevelScmId");
                model.setValue("ajobgrade", null);
                model.setValue("ajoblevel", null);
                model.setValue("ajobgradescm", gradeScmId);
                model.setValue("ajoblevelscm", levelScmId);
                view.setEnable(Boolean.FALSE, new String[]{"ajobgradescm", "ajoblevelscm"});
                boolean noGradeScmInfo = gradeScmId == null || (Long)gradeScmId == 0L;
                boolean bl = noLevelScmInfo = levelScmId == null || (Long)levelScmId == 0L;
                if (noGradeScmInfo && noLevelScmInfo) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5efa\u8bae\u524d\u5f80\u201c\u7ec4\u7ec7\u53d1\u5c55\u4e91>\u804c\u4f4d\u7ba1\u7406\u201d\u7ef4\u62a4\u804c\u7ea7\u804c\u7b49\u4fe1\u606f\u3002", (String)"AEvaluationJobHandler_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                }
                model.setValue("ajobclass", evaluationJob.get("jobclass"));
                model.setValue("ajobscm", evaluationJob.get("jobscm"));
                model.setValue("ajobseq", evaluationJob.get("jobseq"));
                model.setValue("ajobfamily", evaluationJob.get("jobfamily"));
                Map jobClassInfoMap = JobExternalService.getInstance().invokeGetJobClassLongNameByJobAndBsed(jobIds, new Date());
                String jobAllClass = jobClassInfoMap.getOrDefault(jobId, "");
                model.setValue("ajobclasstext", (Object)jobAllClass);
            }
            catch (Exception e) {
                LOGGER.error("AEvaluationJobHandler.propertyChange get jobgrade & joblevel info error error:", (Throwable)e);
                view.setEnable(Boolean.TRUE, new String[]{"ajobgradescm"});
                view.setEnable(Boolean.TRUE, new String[]{"ajoblevelscm"});
                view.showTipNotification(ResManager.loadKDString((String)"\u804c\u7b49\u65b9\u6848\u3001\u804c\u7ea7\u65b9\u6848\u83b7\u53d6\u5f02\u5e38\u3002", (String)"AEvaluationJobHandler_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            }
        };
    }

    private HdmConsumer<IFormView, IDataModel, Integer> cleanData() {
        return (view, model, rowIndex) -> {
            Stream.of(CLEAN_FIELD_LIST).forEach(cleanField -> model.setValue(cleanField, null));
            view.setEnable(Boolean.FALSE, new String[]{"ajobgrade", "ajoblevel", "ajobscm", "ajobfamily", "ajobclass", "ajobseq"});
            if (null != model.getValue("ajoborg")) {
                view.setEnable(Boolean.TRUE, new String[]{"ajobgradescm", "ajoblevelscm"});
            }
        };
    }
}

