/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.transfer.service.HdmConsumer;
import kd.hr.hdm.business.domain.transfer.service.HdmFunction;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.business.domain.transfer.service.external.AdminOrgExternalService;
import kd.hr.hdm.common.transfer.enums.TransferOriginatorEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.EntryPropertyChangedHandler;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler.AcompanyHandler;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler.ApoistionHandler;

public class AorgHandler
extends EntryPropertyChangedHandler {
    private static final AorgHandler aorgHandler = new AorgHandler();
    private static final Log LOGGER = LogFactory.getLog(AorgHandler.class);

    public static final EntryPropertyChangedHandler getInstance() {
        return aorgHandler;
    }

    @Override
    protected HdmConsumer<IFormView, IDataModel, Integer> propertyChange(Object newValue, String propertyName) {
        return (view, model, rowIndex) -> this.setAOrg(newValue).accept(view, model, rowIndex);
    }

    private HdmConsumer<IFormView, IDataModel, Integer> setAOrg(Object newValue) {
        return (view, model, rowIndex) -> {
            DynamicObject affActionDy = (DynamicObject)model.getValue("affaction", rowIndex.intValue());
            String originator = model.getDataEntity().getString("originator");
            long affActionId = 0L;
            if (!ObjectUtils.isEmpty((Object)affActionDy) || !HRStringUtils.equals((String)TransferOriginatorEnum.MY.getOriginator(), (String)originator)) {
                affActionId = affActionDy.getLong("id");
            }
            if (null == newValue) {
                model.setValue("aposition", null, rowIndex.intValue());
                model.setValue("astposition", null, rowIndex.intValue());
                model.setValue("arealityorg", null);
                if (HRStringUtils.equals((String)TransferOriginatorEnum.MY.getOriginator(), (String)originator)) {
                    model.setValue("acompany", null, rowIndex.intValue());
                    model.setValue("arealitycompany", null, rowIndex.intValue());
                }
                model.setValue("arealityorgleader", null, rowIndex.intValue());
                if ("0".equals(model.getValue("postpattern", rowIndex.intValue()))) {
                    model.setValue("arealitysuperior", null, rowIndex.intValue());
                }
                if (affActionId == 1060L || affActionId == 201060L) {
                    model.setValue("acompany", null, rowIndex.intValue());
                    model.setValue("arealitycompany", null, rowIndex.intValue());
                }
                return;
            }
            model.setValue("arealityorg", newValue, rowIndex.intValue());
            if (((Boolean)this.whetherWritrePlan().apply(view, model, rowIndex)).booleanValue()) {
                model.setValue("aplanorg", newValue, rowIndex.intValue());
            }
            model.setValue("aaffiliateorg", newValue, rowIndex.intValue());
            try {
                Boolean needSetNull = ApoistionHandler.FLAG.get();
                if (needSetNull == null || !needSetNull.booleanValue()) {
                    model.setValue("aposition", null, rowIndex.intValue());
                    model.setValue("astposition", null, rowIndex.intValue());
                }
            }
            catch (Exception e) {
                LOGGER.error("set apostion error info:{}", (Object)e.getMessage());
            }
            finally {
                ApoistionHandler.FLAG.remove();
            }
            long id = ((DynamicObject)newValue).getLong("id");
            List orgChargers = ITransferBillService.getInstance().getOrgChargers(Collections.singletonList(id));
            Object[] objects = orgChargers.toArray();
            model.setValue("arealityorgleader", (Object)objects, rowIndex.intValue());
            if (!"1".equals(model.getValue("postpattern", rowIndex.intValue()))) {
                List superiorPersonIdList = ITransferBillService.getInstance().invokeGetSuperiorByRule(model.getDataEntity());
                model.setValue("arealitysuperior", (Object)superiorPersonIdList.toArray(), rowIndex.intValue());
            }
            if (model.getValue("acompany") == null) {
                AcompanyHandler.FLAG.set(Boolean.TRUE);
            }
            this.getOrgBelongCompany((DynamicObject)newValue).accept(view, model, rowIndex);
        };
    }

    private HdmConsumer<IFormView, IDataModel, Integer> getOrgBelongCompany(DynamicObject dynamicObject) {
        return (view, model, rowIndex) -> {
            if (null == dynamicObject) {
                return;
            }
            long orgId = Optional.ofNullable(dynamicObject.getLong("id")).orElseGet(() -> 0L);
            Map adminOrgInfoQuery = AdminOrgExternalService.getInstance().invokeAdminOrgInfoQuery(Collections.singletonList(orgId));
            if (null == adminOrgInfoQuery) {
                view.showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u90e8\u95e8\u201c%s\u201d\u65e0\u6240\u5c5e\u516c\u53f8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8c03\u5165\u90e8\u95e8\u3002", (String)"TransferBillPropChangedEdit_9", (String)"hr-hdm-formplugin", (Object[])new Object[0]), dynamicObject.getString("name")));
                this.setAcompany(null).accept(view, model, rowIndex);
            } else {
                LOGGER.info("TransferBillPropChangeEdit get belong companyInfo : {}", (Object)adminOrgInfoQuery.toString());
                Map companyInfo = (Map)adminOrgInfoQuery.get(String.valueOf(orgId));
                if (null == companyInfo) {
                    view.showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u90e8\u95e8\u201c%s\u201d\u65e0\u6240\u5c5e\u516c\u53f8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8c03\u5165\u90e8\u95e8\u3002", (String)"TransferBillPropChangedEdit_9", (String)"hr-hdm-formplugin", (Object[])new Object[0]), dynamicObject.getString("name")));
                    this.setAcompany(null).accept(view, model, rowIndex);
                } else {
                    Object belongCompany = companyInfo.get("belongcompany");
                    if (null == belongCompany || (Long)belongCompany == 0L) {
                        view.showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u90e8\u95e8\u201c%s\u201d\u65e0\u6240\u5c5e\u516c\u53f8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8c03\u5165\u90e8\u95e8\u3002", (String)"TransferBillPropChangedEdit_9", (String)"hr-hdm-formplugin", (Object[])new Object[0]), dynamicObject.getString("name")));
                        this.setAcompany(null).accept(view, model, rowIndex);
                    } else {
                        this.setAcompany(belongCompany).accept(view, model, rowIndex);
                    }
                }
            }
        };
    }

    private HdmFunction<IFormView, IDataModel, Integer, Boolean> validateOrg(long affctionId) {
        return (view, model, rowIndex) -> {
            Object borg;
            boolean result = true;
            Object aorg = model.getValue("aorg", rowIndex.intValue());
            boolean comRemained = Objects.equals(aorg, borg = model.getValue("borg", rowIndex.intValue()));
            if (comRemained && (affctionId == 1050L || affctionId == 201050L)) {
                model.setValue("aorg", null, rowIndex.intValue());
                view.showErrorNotification(ResManager.loadKDString((String)"\u8c03\u52a8\u4f1a\u4f7f\u90e8\u95e8\u53d1\u751f\u53d8\u52a8\uff0c\u68c0\u6d4b\u5230\u60a8\u6240\u9009\u62e9\u7684\u8c03\u5165\u90e8\u95e8\u4e0e\u8c03\u51fa\u90e8\u95e8\u662f\u540c\u4e00\u4e2a\u90e8\u95e8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8c03\u5165\u90e8\u95e8\u3002", (String)"TransferBillPropChangedEdit_7", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                result = false;
            }
            return result;
        };
    }
}

