/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hdm.business.application.transfer.service.ITransferBillApplicationService;
import kd.hr.hdm.business.common.SihcConfigUtil;
import kd.hr.hdm.business.domain.transfer.service.HdmConsumer;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.EntryPropertyChangedHandler;
import org.apache.commons.lang3.StringUtils;

public class AppDispatchNumHandler
extends EntryPropertyChangedHandler {
    public static EntryPropertyChangedHandler getInstance() {
        return new AppDispatchNumHandler();
    }

    @Override
    protected HdmConsumer<IFormView, IDataModel, Integer> propertyChange(Object newValue, String propertyName) {
        return (view, model, rowIndex) -> {
            String newDispatchNum = (String)newValue;
            model.setValue("appremoverel", null);
            if (StringUtils.isNotBlank((CharSequence)newDispatchNum)) {
                Boolean enableSihc = SihcConfigUtil.enableSihc();
                if (!enableSihc.booleanValue()) {
                    return;
                }
                DynamicObject dataEntity = model.getDataEntity();
                long employeeId = dataEntity.getLong("ermanfile.employee_id");
                String appDispatchNum = dataEntity.getString("appdispatchnum");
                DynamicObject appointRemoveRelObj = ITransferBillApplicationService.getInstance().getAppointRemoveRelObj(appDispatchNum, employeeId);
                if (!HRObjectUtils.isEmpty((Object)appointRemoveRelObj)) {
                    long appRemRelId = appointRemoveRelObj.getLong("id");
                    String formId = view.getFormShowParameter().getFormId();
                    if (ITransferBillApplicationService.getInstance().needConfirmAppointmentWritten() && !"hdm_mytrans_hr_layout".equals(formId)) {
                        view.getPageCache().put("prop_change_save", "1");
                        view.getPageCache().put("appremoverel", String.valueOf(appRemRelId));
                        String tipContent = this.getAppDispatchNumChangeTip(appointRemoveRelObj, dataEntity);
                        ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("appdispatchnum");
                        view.showConfirm(tipContent, MessageBoxOptions.OKCancel, confirmCallBack);
                    } else {
                        model.setValue("appremoverel", (Object)appRemRelId);
                    }
                }
            }
        };
    }

    private String getAppDispatchNumChangeTip(DynamicObject appointRemoveRelObj, DynamicObject dataEntity) {
        String positionName;
        String adminOrgName;
        StringBuilder tipContent = new StringBuilder();
        String personName = dataEntity.getString("person.name");
        String appDispatchNum = dataEntity.getString("appdispatchnum");
        tipContent.append(ResManager.loadKDString((String)"\u7cfb\u7edf\u68c0\u6d4b\u5230\u5458\u5de5\u201c{0}\u201d\u5df2\u6709\u57fa\u4e8e\u53d1\u6587\u6587\u53f7\u201c{1}\u201d\u4efb\u547d\u4fe1\u606f\uff0c\u786e\u8ba4\u6839\u636e\u8be5\u4efb\u547d\u4fe1\u606f\u8fdb\u884c\u8c03\u52a8\u7533\u8bf7\uff1f", (String)"AppDispatchNumHandler_0", (String)"hr-hdm-formplugin", (Object[])new Object[]{personName, appDispatchNum}));
        tipContent.append("\r\n");
        tipContent.append(ResManager.loadKDString((String)"\u4efb\u547d\u4fe1\u606f\uff1a", (String)"ParttimeApplyBillEdit_19", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        ArrayList appointRemoveInfoList = Lists.newArrayListWithExpectedSize((int)3);
        String companyName = appointRemoveRelObj.getString("company.name");
        if (StringUtils.isNotBlank((CharSequence)companyName)) {
            appointRemoveInfoList.add(companyName);
        }
        if (StringUtils.isNotBlank((CharSequence)(adminOrgName = appointRemoveRelObj.getString("adminorgvid.name")))) {
            appointRemoveInfoList.add(adminOrgName);
        }
        if (StringUtils.isNotBlank((CharSequence)(positionName = appointRemoveRelObj.getString("positionvid.name")))) {
            appointRemoveInfoList.add(positionName);
        }
        tipContent.append(String.join((CharSequence)"/", appointRemoveInfoList));
        return tipContent.toString();
    }
}

