/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.mytransfer;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hdm.business.domain.transfer.repository.TransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.common.util.EntityPropertyUtil;
import kd.hr.hdm.common.util.HRServiceUtil;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler.ErmanFileHandler;

public class MyTransferApplyBillEdit
extends HRCoreBaseBillEdit
implements BeforeF7SelectListener {
    private static final String SAVE_BUTTON = "mysave";
    private static final String HISTORY_LIST_BUTTON = "showhistorybill";
    private static final String MY_WF_AGREE_VALIDATE = "my_wf_agree_validate";
    private static final String FLEX_PANEL_TEMINATE = "teminateflexpanel";
    private static final String[] DATA_CHANGED_ARR = new String[]{"transferdate", "realitydate", "aaffiliateorg", "arealitycompany", "arealityorg", "arealityposition", "arealitybaselocation", "ajob", "arealityjob"};

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        String billStatus = (String)this.getModel().getValue("billstatus");
        if ("F".equals(billStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_PANEL_TEMINATE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_PANEL_TEMINATE});
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit aPosition;
        super.registerListener(e);
        BasedataEdit aOrg = (BasedataEdit)this.getView().getControl("aorg");
        if (aOrg != null) {
            aOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((aPosition = (BasedataEdit)this.getView().getControl("aposition")) != null) {
            aPosition.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name;
        switch (name = beforeF7SelectEvent.getProperty().getName()) {
            case "aorg": {
                beforeF7SelectEvent.getCustomQFilters().removeIf(qFilter -> qFilter.getProperty().equals("company.id"));
                break;
            }
            case "aposition": {
                this.validatePositionBeforeF7Select(beforeF7SelectEvent);
                break;
            }
        }
    }

    private void validatePositionBeforeF7Select(BeforeF7SelectEvent evt) {
        Object value = this.getModel().getValue("aorg");
        if (value == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u90e8\u95e8", (String)"MyTransferApplyBillEdit_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void afterBindData(EventObject arg) {
        super.afterBindData(arg);
        IFormView formView = this.getView();
        BasedataEdit aPositionTextEdit = (BasedataEdit)formView.getControl("aposition");
        aPositionTextEdit.setMustInput(false);
        DynamicObject erManFileDy = this.getModel().getDataEntity().getDynamicObject("ermanfile");
        Date fileStartDate = erManFileDy.getDate("bsed");
        DateTimeEdit planDateControl = (DateTimeEdit)formView.getControl("plandate");
        planDateControl.setMinDate(fileStartDate);
        DateTimeEdit lastDateControl = (DateTimeEdit)formView.getControl("transferoutlastdate");
        lastDateControl.setMinDate(fileStartDate);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "mysave": 
            case "submit": {
                DynamicObject transferDy = this.getModel().getDataEntity();
                DynamicObject ermanFile = HRServiceUtil.getPrimaryErmanFile((Long)transferDy.getLong("person.id"));
                if (ermanFile == null || ermanFile.getLong("id") == transferDy.getLong("ermanfile.id")) break;
                ErmanFileHandler.getInstance().setDataAfterErmanfile(ermanFile.getLong("id"));
                break;
            }
            case "unsubmit": {
                DynamicObject transferBill = TransferBillRepository.getInstance().queryOne("billstatus", this.getModel().getDataEntity().getPkValue());
                if ("B".equals(transferBill.getString("billstatus"))) break;
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u53ef\u64a4\u9500\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u63d0\u4ea4\u201d\u7684\u5355\u636e\u3002", (String)"MyTransferApplyBillEdit_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "showhistorybill": {
                this.showHistoryListPage();
                break;
            }
            case "my_wf_agree_validate": {
                ITransferBillService.getInstance().setDefaultAEvaluationJobInfo(this.getModel());
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "mysave": 
            case "submit": 
            case "unsubmit": {
                this.getView().setStatus(OperationStatus.VIEW);
                this.getView().invokeOperation("refresh");
                break;
            }
            case "delete": {
                IFormView parentView = this.getView().getParentView();
                if (parentView == null) break;
                this.getView().getParentView().invokeOperation("refresh");
                this.getView().sendFormAction(parentView);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT == status || OperationStatus.ADDNEW == status) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Arrays.stream(DATA_CHANGED_ARR).forEach(property -> EntityPropertyUtil.setBizChanged((DynamicObject)dataEntity, (boolean)false, (String[])new String[]{property}));
        }
    }

    private void showHistoryListPage() {
        String billFormId;
        IFormView parentView = this.getView().getParentView();
        if (parentView instanceof ListView && "hdm_mytransferbill".equals(billFormId = ((ListView)parentView).getBillFormId())) {
            parentView.invokeOperation("refresh");
            parentView.activate();
            this.getView().sendFormAction(parentView);
            return;
        }
        IPageCache pageCache = this.getView().getPageCache();
        String targetPageId = pageCache.get(HISTORY_LIST_BUTTON);
        IFormView targetView = this.getView().getView(targetPageId);
        if (targetView != null) {
            targetView.invokeOperation("refresh");
            targetView.activate();
            this.getView().sendFormAction(targetView);
            return;
        }
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("hdm_mytransferbill");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)listShowParameter);
        String pageId = listShowParameter.getPageId();
        pageCache.put(HISTORY_LIST_BUTTON, pageId);
    }
}

