/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.mytransfer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.hr.hdm.business.domain.transfer.service.IMyTransferNewValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.common.transfer.util.TransferPageUtil;
import kd.hr.hdm.formplugin.transfer.web.provider.MyTransferListProvider;

public class MyTransferBillListPlugin
extends HRCoreBaseBillList {
    private static final String SUBMITLIST = "submitlist";
    private static final String UNSUBMITLIST = "unsubmitlist";
    private static final String NEW = "new";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        long currUserId = RequestContext.get().getCurrUserId();
        if (ObjectUtils.isNotEmpty((Object)currUserId)) {
            QFilter personFilter = new QFilter("creator", "=", (Object)currUserId);
            QFilter originatorFilter = new QFilter("originator", "=", (Object)"4");
            e.getQFilters().add(personFilter);
            e.getQFilters().add(originatorFilter);
        }
        e.setOrderBy("createtime desc,transferdate desc");
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new MyTransferListProvider());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        if (!HRStringUtils.equals((String)NEW, (String)operateKey) && selectedRows.getPrimaryKeyValues().length == 0) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues());
        DynamicObject[] dys = ITransferBillService.getInstance().query("billstatus", qFilter.toArray());
        if (!HRStringUtils.equals((String)"refresh", (String)operateKey) && !HRStringUtils.equals((String)NEW, (String)operateKey) && dys.length != selectedRows.getPrimaryKeyValues().length) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"MyTransferBillListPlugin_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        switch (operateKey) {
            case "new": {
                DynamicObject ermanFile = IMyTransferNewValidatorService.getInstance().primaryErmanFileValidate();
                DynamicObject[] myTransferBills = ITransferBillService.getInstance().getMyTransferBills(ermanFile.getLong("employee_id"));
                if (myTransferBills != null) {
                    for (DynamicObject myTransferBill : myTransferBills) {
                        String billStatus = myTransferBill.getString("billstatus");
                        String transferStatus = myTransferBill.getString("transferstatus");
                        if (!"A".equals(billStatus) && !"B".equals(billStatus) && !"D".equals(billStatus) && !"G".equals(billStatus) && !"transferstatus".equals(transferStatus)) continue;
                        String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5458\u5de5\u5df2\u5904\u4e8e\u8c03\u52a8\u6d41\u7a0b\u201c%1$s\u201d\u4e2d\uff0c\u65e0\u6cd5\u65b0\u589e\u8c03\u52a8\u7533\u8bf7\u3002", (String)"MyTransferBillListPlugin_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]), myTransferBill.getString("billno"));
                        this.getView().showErrorNotification(msg);
                        args.setCancel(true);
                        return;
                    }
                }
                IMyTransferNewValidatorService.getInstance().inProcessByHrValidate().test(ermanFile.getLong("employee_id"));
                break;
            }
            case "submitlist": {
                if (selectedRows.size() <= 1) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u64cd\u4f5c\u4e00\u6761\u6570\u636e\u3002", (String)"MyTransferBillListPlugin_6", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            case "unsubmitlist": {
                Arrays.stream(dys).forEach(dy -> {
                    if (!"B".equals(dy.getString("billstatus"))) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u53ef\u64a4\u9500\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u63d0\u4ea4\u201d\u7684\u5355\u636e\u3002", (String)"MyTransferBillListPlugin_5", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                    }
                });
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        IListView listview = (IListView)this.getView();
        long transferBillId = (Long)listview.getFocusRowPkId();
        String name = this.getPersonNameByBillId(transferBillId);
        HashMap customParams = new HashMap(16);
        String caption = ResManager.loadKDString((String)"%s\u7684\u8c03\u52a8\u7533\u8bf7", (String)"MyTransferBillListPlugin_1", (String)"hr-hdm-formplugin", (Object[])new Object[]{name});
        TransferPageUtil.showPage((IFormView)this.getView(), (String)"hdm_mytransferbill", (Object)transferBillId, (String)caption, customParams);
    }

    private String getPersonNameByBillId(long billId) {
        DynamicObject dy = ITransferBillService.getInstance().queryOne("person", billId);
        if (HRObjectUtils.isEmpty((Object)dy)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"MyTransferBillListPlugin_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
        return dy.getString("person.name");
    }
}

