/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.mytransfer;

import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hdm.business.common.PermissionValidateUtil;
import kd.hr.hdm.business.domain.transfer.service.IMyTransferNewValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;

public class MyTransferJumpPlugin
extends AbstractFormPlugin {
    private static final Log LOG = LogFactory.getLog(MyTransferJumpPlugin.class);
    private static final String HSSC_APP_ID = "hssc";
    private static final String CHECK_RIGHT_APP_ID = "checkRightAppId";
    public static final String OPEN_TYPE = "openType";
    public static final String PK_ID = "pkId";
    public static final String LIST = "list";
    public static final String CONTENT = "content";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        DynamicObject ermanFile = IMyTransferNewValidatorService.getInstance().primaryErmanFileValidate();
        long employeeId = ermanFile.getLong("employee_id");
        DynamicObject[] myTransferBills = ITransferBillService.getInstance().getMyTransferBills(employeeId);
        HashMap<String, Object> customParam = new HashMap<String, Object>(16);
        String caption = ResManager.loadKDString((String)"\u65b0\u589e\u8c03\u52a8\u7533\u8bf7", (String)"MyTransferJumpPlugin_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
        if (myTransferBills == null || myTransferBills.length < 1) {
            this.checkPermission("47156aff000000ac");
            IMyTransferNewValidatorService.getInstance().inProcessByHrValidate().test(employeeId);
            customParam.put(OPEN_TYPE, OperationStatus.ADDNEW);
        } else {
            this.checkPermission("47150e89000000ac");
            DynamicObject bill = Arrays.stream(myTransferBills).max(Comparator.comparing(dynamicObject -> dynamicObject.getString("createtime"))).get();
            String billStatus = bill.getString("billstatus");
            if ("A".equals(billStatus) || "G".equals(billStatus) || "B".equals(billStatus) || "D".equals(billStatus) || "C".equals(billStatus) && "4".equals(bill.getString("transferstatus"))) {
                customParam.put(PK_ID, bill.getPkValue());
                customParam.put(OPEN_TYPE, OperationStatus.VIEW);
                caption = String.format(ResManager.loadKDString((String)"%s\u7684\u8c03\u52a8\u7533\u8bf7", (String)"MyTransferJumpPlugin_4", (String)"hr-hdm-formplugin", (Object[])new Object[0]), ermanFile.getString("name"));
            } else {
                caption = ResManager.loadKDString((String)"\u6211\u7684\u8c03\u52a8\u7533\u8bf7\u5217\u8868", (String)"MyTransferJumpPlugin_3", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
                customParam.put(OPEN_TYPE, LIST);
            }
        }
        customParam.put("person", ermanFile.getLong("person_id"));
        customParam.put("employee", employeeId);
        e.getFormShowParameter().setCaption(caption);
        e.getFormShowParameter().setCustomParams(customParam);
    }

    private void checkPermission(String permItemId) {
        boolean isPermission = PermissionValidateUtil.checkPermission((String)HSSC_APP_ID, (String)"hdm_mytransferbill", (String)permItemId);
        if (!isPermission) {
            if ("47156aff000000ac".equals(permItemId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u201c\u6211\u8981\u8c03\u52a8\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MyTransferJumpPlugin_9", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            }
            if ("47150e89000000ac".equals(permItemId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u201c\u6211\u8981\u8c03\u52a8\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MyTransferJumpPlugin_8", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object openType = customParams.get(OPEN_TYPE);
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("hdm_mytransferbill");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParams(customParams);
        showParameter.setCustomParam(CHECK_RIGHT_APP_ID, (Object)HSSC_APP_ID);
        showParameter.setCaption(formShowParameter.getCaption());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hdm_mytransferbill"));
        if (Objects.equals(openType, OperationStatus.VIEW.name())) {
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setPkId(customParams.get(PK_ID));
        } else if (Objects.equals(openType, LIST)) {
            this.switchToBillList(customParams);
            return;
        }
        this.getView().showForm((FormShowParameter)showParameter);
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("hdm_mytransferbill".equals(actionId)) {
            this.getView().close();
        }
    }

    private void switchToBillList(Map<String, Object> customParam) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("hdm_mytransferbill");
        listShowParameter.setFormId("bos_list");
        listShowParameter.setClientParam("requestBeforeClose", (Object)Boolean.TRUE);
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.getCustomParams().putAll(customParam);
        listShowParameter.getOpenStyle().setTargetKey(CONTENT);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hdm_mytransferbill"));
        IFormView formView = this.getView();
        formView.showForm((FormShowParameter)listShowParameter);
        formView.close();
    }
}

