/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.api.BizProcessStatus;

public class MyTransferListProvider
extends ListDataProvider {
    private static final Log LOGGER = LogFactory.getLog(MyTransferListProvider.class);
    public static final String APPROVER = "approver";

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection rows = super.getData(start, limit);
        if (rows.isEmpty()) {
            return rows;
        }
        this.addMyTransferDynamicProperty(rows);
        return rows;
    }

    private void addMyTransferDynamicProperty(DynamicObjectCollection collection) {
        String pkIdStr;
        DynamicSimpleProperty approver = new DynamicSimpleProperty(APPROVER, String.class, null);
        collection.getDynamicObjectType().addProperty((DynamicProperty)approver);
        if (collection.isEmpty()) {
            return;
        }
        ArrayList<String> pkIds = new ArrayList<String>();
        for (DynamicObject dynObj : collection) {
            if (null == dynObj || null == (pkIdStr = String.valueOf(dynObj.getPkValue())) || pkIdStr.trim().isEmpty()) continue;
            pkIds.add(pkIdStr);
        }
        if (pkIds.isEmpty()) {
            return;
        }
        long t1 = System.currentTimeMillis();
        Map<Object, Object> customColumnDataMap = new HashMap();
        try {
            customColumnDataMap = this.getCustomColumnData(pkIds);
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
        }
        long t2 = System.currentTimeMillis();
        LOGGER.info("customColumn calculate costs: " + (t2 - t1) + " ms");
        if (null == customColumnDataMap || customColumnDataMap.isEmpty()) {
            return;
        }
        for (DynamicObject dynObj : collection) {
            String customColumnValue;
            if (null == dynObj || null == (pkIdStr = String.valueOf(dynObj.getPkValue())) || pkIdStr.trim().isEmpty() || null == (customColumnValue = (String)customColumnDataMap.get(pkIdStr)) || customColumnValue.isEmpty()) continue;
            dynObj.set(APPROVER, (Object)customColumnValue);
        }
        long t3 = System.currentTimeMillis();
        LOGGER.info("customColumn setData costs: " + (t3 - t2) + " ms");
    }

    private Map<String, String> getCustomColumnData(List<String> pkIds) {
        if (null == pkIds || pkIds.isEmpty()) {
            return null;
        }
        HashMap<String, String> auditorsMap = new HashMap<String, String>(pkIds.size());
        String[] ids = new String[pkIds.size()];
        pkIds.toArray(ids);
        Map allPro = new HashMap();
        try {
            allPro = WorkflowServiceHelper.getBizProcessStatus((String[])ids);
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
        }
        if (allPro.isEmpty()) {
            return auditorsMap;
        }
        Set entrySet = allPro.entrySet();
        for (Map.Entry entry : entrySet) {
            List node;
            if (null == entry || null == (node = (List)entry.getValue()) || node.isEmpty()) continue;
            int count = 0;
            String nodeName = "";
            StringBuilder participantName = new StringBuilder();
            StringBuilder msg = new StringBuilder();
            try {
                for (BizProcessStatus e : node) {
                    String auditor;
                    if (null == e || (auditor = e.getParticipantName()) == null || auditor.trim().isEmpty()) continue;
                    participantName.append(",").append(auditor);
                    nodeName = e.getCurrentNodeName();
                    if (++count != 3) continue;
                    participantName.append("...");
                    break;
                }
                if (null == nodeName || nodeName.isEmpty()) continue;
                msg.append(nodeName);
                if (participantName.toString().isEmpty()) continue;
                msg.append('/');
                msg.append(participantName.toString().replaceFirst(",", ""));
            }
            catch (Exception e) {
                LOGGER.info(e.getMessage());
            }
            auditorsMap.put((String)entry.getKey(), msg.toString());
        }
        return auditorsMap;
    }
}

