/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.workflow;

import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.common.transfer.util.TransferPageHelperUtil;

public abstract class AbstractTransferWorkflowPlugin
implements IWorkflowPlugin {
    private static final Log LOGGER = LogFactory.getLog(AbstractTransferWorkflowPlugin.class);
    private static final String TERMINAL = "3";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(AgentExecution execution) {
        try (TXHandle txHandle = TX.required();){
            String businessKey = execution.getBusinessKey();
            ITransferBillService transferBillService = ITransferBillService.getInstance();
            DynamicObject transferBill = transferBillService.queryOne(TransferPageHelperUtil.QUERYFIELD, Long.parseLong(businessKey));
            String transferStatus = transferBill.getString("transferstatus");
            if (TERMINAL.equals(transferStatus)) {
                return;
            }
            this.ownExecute(transferBill);
            transferBillService.update(Collections.singletonList(transferBill));
            this.ownEndExecute(transferBill);
        }
    }

    protected abstract void ownExecute(DynamicObject var1);

    protected void ownEndExecute(DynamicObject dynamicObject) {
    }
}

