/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.workflow.batch;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;
import kd.hr.hdm.business.domain.transfer.service.ITransferBatchService;
import kd.hr.hdm.common.transfer.util.TransferPageHelperUtil;

public abstract class AbstractBatchTransferWorkflowPlugin
implements IWorkflowPlugin {
    private static final Log LOGGER = LogFactory.getLog(AbstractBatchTransferWorkflowPlugin.class);

    public void notify(AgentExecution execution) {
        String businessKey = execution.getBusinessKey();
        LOGGER.info("AbstractBatchTransferWorkflowPlugin notify businessKey:{}", (Object)businessKey);
        ITransferBatchService transferBatchService = ITransferBatchService.getInstance();
        DynamicObject transferBatchBill = transferBatchService.queryOne(TransferPageHelperUtil.BATCHQUERYFIELD, Long.parseLong(businessKey));
        String billStatus = transferBatchBill.getString("billstatus");
        if ("F".equals(billStatus)) {
            LOGGER.info("billStatus is abandon");
            return;
        }
        this.ownExecute(transferBatchBill);
        transferBatchService.update(transferBatchBill);
        this.ownEndExecute(transferBatchBill);
        LOGGER.info("AbstractBatchTransferWorkflowPlugin notify end businessKey:{}", (Object)businessKey);
    }

    protected abstract void ownExecute(DynamicObject var1);

    protected void ownEndExecute(DynamicObject dynamicObject) {
    }
}

